/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.rewriter.subquery.rewriter;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLInSubQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import org.opensearch.sql.legacy.rewriter.subquery.RewriterContext;
import org.opensearch.sql.legacy.rewriter.subquery.rewriter.Rewriter;

public class InRewriter
implements Rewriter {
    private final SQLInSubQueryExpr inExpr;
    private final RewriterContext ctx;
    private final MySqlSelectQueryBlock queryBlock;

    public InRewriter(SQLInSubQueryExpr inExpr, RewriterContext ctx) {
        this.inExpr = inExpr;
        this.ctx = ctx;
        this.queryBlock = (MySqlSelectQueryBlock)inExpr.getSubQuery().getQuery();
    }

    @Override
    public boolean canRewrite() {
        return !this.inExpr.isNot();
    }

    @Override
    public void rewrite() {
        SQLTableSource from = this.queryBlock.getFrom();
        this.addJoinTable(from);
        SQLExpr where = this.queryBlock.getWhere();
        if (null == where) {
            this.ctx.addWhere((SQLExpr)this.generateNullOp());
        } else if (where instanceof SQLBinaryOpExpr) {
            this.ctx.addWhere((SQLExpr)this.and(this.generateNullOp(), (SQLBinaryOpExpr)where));
        } else {
            throw new IllegalStateException("unsupported where class type " + String.valueOf(where.getClass()));
        }
    }

    private SQLBinaryOpExpr generateNullOp() {
        SQLBinaryOpExpr binaryOpExpr = new SQLBinaryOpExpr();
        binaryOpExpr.setLeft(this.fetchJoinExpr());
        binaryOpExpr.setRight((SQLExpr)new SQLNullExpr());
        binaryOpExpr.setOperator(SQLBinaryOperator.IsNot);
        return binaryOpExpr;
    }

    private void addJoinTable(SQLTableSource right) {
        SQLBinaryOpExpr binaryOpExpr = new SQLBinaryOpExpr(this.inExpr.getExpr(), SQLBinaryOperator.Equality, this.fetchJoinExpr());
        this.ctx.addJoin(right, SQLJoinTableSource.JoinType.JOIN, binaryOpExpr);
    }

    private SQLExpr fetchJoinExpr() {
        if (this.queryBlock.getSelectList().size() > 1) {
            throw new IllegalStateException("Unsupported subquery with multiple select " + String.valueOf(this.queryBlock.getSelectList()));
        }
        return ((SQLSelectItem)this.queryBlock.getSelectList().get(0)).getExpr();
    }
}

