/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.rest;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.flowframework.common.FlowFrameworkSettings;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.transport.GetWorkflowStepAction;
import org.opensearch.flowframework.transport.WorkflowRequest;
import org.opensearch.flowframework.util.TenantAwareHelper;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.transport.client.node.NodeClient;

public class RestGetWorkflowStepAction
extends BaseRestHandler {
    private static final String GET_WORKFLOW_STEP_ACTION = "get_workflow_step";
    private static final Logger logger = LogManager.getLogger(RestGetWorkflowStepAction.class);
    private FlowFrameworkSettings flowFrameworkSettings;

    public RestGetWorkflowStepAction(FlowFrameworkSettings flowFrameworkSettings) {
        this.flowFrameworkSettings = flowFrameworkSettings;
    }

    public String getName() {
        return GET_WORKFLOW_STEP_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/%s", "/_plugins/_flow_framework/workflow", "_steps")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        try {
            if (!this.flowFrameworkSettings.isFlowFrameworkEnabled()) {
                throw new FlowFrameworkException("This API is disabled. To enable it, update the setting [" + FlowFrameworkSettings.FLOW_FRAMEWORK_ENABLED.getKey() + "] to true.", RestStatus.FORBIDDEN);
            }
            String tenantId = TenantAwareHelper.getTenantID(this.flowFrameworkSettings.isMultiTenancyEnabled(), request);
            request.content();
            Map<String, String> params = request.hasParam("workflow_step") ? Map.of("workflow_step", request.param("workflow_step")) : Collections.emptyMap();
            WorkflowRequest workflowRequest = new WorkflowRequest(null, null, params);
            return channel -> client.execute((ActionType)GetWorkflowStepAction.INSTANCE, (ActionRequest)workflowRequest, ActionListener.wrap(response -> {
                XContentBuilder builder = response.toXContent(channel.newBuilder(), ToXContent.EMPTY_PARAMS);
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, builder));
            }, exception -> {
                try {
                    FlowFrameworkException ex = exception instanceof FlowFrameworkException ? (FlowFrameworkException)((Object)((Object)((Object)exception))) : new FlowFrameworkException("Failed to get workflow.", ExceptionsHelper.status((Throwable)exception));
                    XContentBuilder exceptionBuilder = ex.toXContent(channel.newErrorBuilder(), ToXContent.EMPTY_PARAMS);
                    channel.sendResponse((RestResponse)new BytesRestResponse(ex.getRestStatus(), exceptionBuilder));
                }
                catch (IOException e) {
                    String errorMessage = "IOException: Failed to send back get workflow step exception";
                    logger.error(errorMessage, (Throwable)e);
                    channel.sendResponse((RestResponse)new BytesRestResponse(ExceptionsHelper.status((Throwable)e), errorMessage));
                }
            }));
        }
        catch (FlowFrameworkException ex) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(ex.getRestStatus(), ex.toXContent(channel.newErrorBuilder(), ToXContent.EMPTY_PARAMS)));
        }
    }
}

