/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.resthandler;

import java.io.IOException;
import java.time.DateTimeException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.commons.alerting.model.Table;
import org.opensearch.core.action.ActionListener;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.securityanalytics.action.GetFindingsAction;
import org.opensearch.securityanalytics.action.GetFindingsRequest;
import org.opensearch.transport.client.node.NodeClient;

public class RestGetFindingsAction
extends BaseRestHandler {
    public String getName() {
        return "get_findings_action_sa";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String detectorId = request.param("detector_id", null);
        String detectorType = request.param("detectorType", null);
        String sortString = request.param("sortString", "timestamp");
        String sortOrder = request.param("sortOrder", "asc");
        String missing = request.param("missing");
        int size = request.paramAsInt("size", 20);
        int startIndex = request.paramAsInt("startIndex", 0);
        String searchString = request.param("searchString", "");
        String severity = request.param("severity", null);
        String detectionType = request.param("detectionType", null);
        List<String> findingIds = null;
        if (request.param("findingIds") != null) {
            findingIds = Arrays.asList(request.param("findingIds").split(","));
        }
        Instant startTime = null;
        String startTimeParam = request.param("startTime");
        if (startTimeParam != null && !startTimeParam.isEmpty()) {
            try {
                startTime = Instant.ofEpochMilli(Long.parseLong(startTimeParam));
            }
            catch (NullPointerException | NumberFormatException | DateTimeException e) {
                startTime = Instant.now();
            }
        }
        Instant endTime = null;
        String endTimeParam = request.param("endTime");
        if (endTimeParam != null && !endTimeParam.isEmpty()) {
            try {
                endTime = Instant.ofEpochMilli(Long.parseLong(endTimeParam));
            }
            catch (NullPointerException | NumberFormatException | DateTimeException e) {
                endTime = Instant.now();
            }
        }
        Table table = new Table(sortOrder, sortString, missing, size, startIndex, searchString);
        GetFindingsRequest req = new GetFindingsRequest(detectorId, detectorType, table, severity, detectionType, findingIds, startTime, endTime);
        return channel -> client.execute((ActionType)GetFindingsAction.INSTANCE, (ActionRequest)req, (ActionListener)new RestToXContentListener(channel));
    }

    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_security_analytics/findings/_search"));
    }
}

