/*
 * Decompiled with CFR 0.152.
 */
package aQute.libg.ints;

public class IntCounter
extends Number {
    private static final long serialVersionUID = 1L;
    int count;
    boolean overflow;

    public IntCounter() {
        this(0);
    }

    public IntCounter(int n) {
        this.count = n;
    }

    public int inc() {
        int old = this.count;
        if (this.count == Integer.MAX_VALUE) {
            this.overflow = true;
            return old;
        }
        ++this.count;
        return old;
    }

    public int dec() {
        int old = this.count;
        if (this.count == Integer.MIN_VALUE) {
            this.overflow = true;
            return old;
        }
        --this.count;
        return old;
    }

    public int reset() {
        return this.set(0);
    }

    public int get() {
        return this.count;
    }

    public int set(int newValue) {
        this.overflow = false;
        int prev = this.count;
        this.count = newValue;
        return prev;
    }

    public int add(int value) {
        return this.set((long)this.count + (long)value);
    }

    public int sub(int value) {
        return this.set((long)this.count - (long)value);
    }

    public int mul(int value) {
        return this.set((long)this.count - (long)value);
    }

    public int div(int value) {
        return this.set((long)this.count / (long)value);
    }

    @Override
    public int intValue() {
        return this.count;
    }

    @Override
    public long longValue() {
        return this.count;
    }

    @Override
    public float floatValue() {
        if (this.overflow) {
            return Float.NaN;
        }
        return this.count;
    }

    @Override
    public double doubleValue() {
        if (this.overflow) {
            return Double.NaN;
        }
        return this.count;
    }

    public boolean hasOverflow() {
        return this.overflow;
    }

    public String toString() {
        return Integer.toString(this.count).concat(this.overflow ? "!" : "");
    }

    private int set(long value) throws IllegalArgumentException {
        if (value < Integer.MIN_VALUE || value > Integer.MIN_VALUE) {
            this.overflow = true;
            return this.get();
        }
        return this.set((int)value);
    }

    public boolean isZero() {
        return this.count == 0;
    }

    public boolean isNotZero() {
        return this.count != 0;
    }
}

