/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.panel;

import ch.qos.logback.classic.Level;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.dialog.LogViewerDialog;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import jadx.gui.utils.logs.LogCollector;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class IssuesPanel
extends JPanel {
    private static final long serialVersionUID = -7720576036668459218L;
    private static final ImageIcon ERROR_ICON = UiUtils.openSvgIcon("ui/error");
    private static final ImageIcon WARN_ICON = UiUtils.openSvgIcon("ui/warning");
    private final MainWindow mainWindow;
    private JLabel errorLabel;
    private JLabel warnLabel;

    public IssuesPanel(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        this.initUI();
        LogCollector.getInstance().registerIssueListener((error, warnings) -> SwingUtilities.invokeLater(() -> this.onUpdate(error, warnings)));
    }

    private void initUI() {
        JLabel label = new JLabel(NLS.str("issues_panel.label"));
        this.errorLabel = new JLabel(ERROR_ICON);
        this.warnLabel = new JLabel(WARN_ICON);
        String toolTipText = NLS.str("issues_panel.tooltip");
        this.errorLabel.setToolTipText(toolTipText);
        this.warnLabel.setToolTipText(toolTipText);
        this.errorLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LogViewerDialog.openWithLevel(IssuesPanel.this.mainWindow, Level.ERROR);
            }
        });
        this.warnLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LogViewerDialog.openWithLevel(IssuesPanel.this.mainWindow, Level.WARN);
            }
        });
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BoxLayout(this, 0));
        this.setVisible(false);
        this.add(label);
        this.add(Box.createHorizontalGlue());
        this.add(this.errorLabel);
        this.add(Box.createHorizontalGlue());
        this.add(this.warnLabel);
    }

    private void onUpdate(int error, int warnings) {
        if (error == 0 && warnings == 0) {
            this.setVisible(false);
            return;
        }
        this.setVisible(true);
        this.errorLabel.setText(NLS.str("issues_panel.errors", error));
        this.errorLabel.setVisible(error != 0);
        this.warnLabel.setText(NLS.str("issues_panel.warnings", warnings));
        this.warnLabel.setVisible(warnings != 0);
    }
}

