/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.dex.sections;

import jadx.api.plugins.input.data.IFieldData;
import jadx.api.plugins.input.data.annotations.EncodedValue;
import jadx.api.plugins.input.data.annotations.IAnnotation;
import jadx.api.plugins.input.data.attributes.IJadxAttribute;
import jadx.api.plugins.utils.Utils;
import jadx.plugins.input.dex.sections.DexAnnotationsConvert;
import jadx.plugins.input.dex.sections.annotations.AnnotationsParser;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class DexFieldData
implements IFieldData {
    @Nullable
    private final AnnotationsParser annotationsParser;
    private String parentClassType;
    private String type;
    private String name;
    private int accessFlags;
    private int annotationsOffset;
    private EncodedValue constValue;

    public DexFieldData(@Nullable AnnotationsParser parser) {
        this.annotationsParser = parser;
    }

    public String getParentClassType() {
        return this.parentClassType;
    }

    public void setParentClassType(String parentClassType) {
        this.parentClassType = parentClassType;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public void setAccessFlags(int accessFlags) {
        this.accessFlags = accessFlags;
    }

    public void setAnnotationsOffset(int annotationsOffset) {
        this.annotationsOffset = annotationsOffset;
    }

    public void setConstValue(EncodedValue constValue) {
        this.constValue = constValue;
    }

    private List<IAnnotation> getAnnotations() {
        if (this.annotationsParser == null) {
            throw new NullPointerException("Annotation parser not initialized");
        }
        return this.annotationsParser.readAnnotationList(this.annotationsOffset);
    }

    public List<IJadxAttribute> getAttributes() {
        ArrayList<IJadxAttribute> list = new ArrayList<IJadxAttribute>(2);
        Utils.addToList(list, (Object)this.constValue);
        DexAnnotationsConvert.forField(list, this.getAnnotations());
        return list;
    }

    public String toString() {
        return this.getParentClassType() + "->" + this.getName() + ":" + this.getType();
    }
}

