/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.resource;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.util.Objects;
import org.eclipse.jetty.http.HttpContent;
import org.eclipse.jetty.server.resource.ByteBufferRangeWriter;
import org.eclipse.jetty.server.resource.InputStreamRangeWriter;
import org.eclipse.jetty.server.resource.RangeWriter;
import org.eclipse.jetty.server.resource.SeekableByteChannelRangeWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpContentRangeWriter {
    private static final Logger LOG = LoggerFactory.getLogger(HttpContentRangeWriter.class);

    public static RangeWriter newRangeWriter(HttpContent content2) {
        block7: {
            Objects.requireNonNull(content2, "HttpContent");
            ByteBuffer buffer = content2.getDirectBuffer();
            if (buffer == null) {
                buffer = content2.getIndirectBuffer();
            }
            if (buffer != null) {
                return new ByteBufferRangeWriter(buffer);
            }
            try {
                ReadableByteChannel channel = content2.getReadableByteChannel();
                if (channel != null) {
                    if (channel instanceof SeekableByteChannel) {
                        SeekableByteChannel seekableByteChannel = (SeekableByteChannel)channel;
                        return new SeekableByteChannelRangeWriter(seekableByteChannel, () -> (SeekableByteChannel)content2.getReadableByteChannel());
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Skipping non-SeekableByteChannel option {} from content {}", (Object)channel, (Object)content2);
                    }
                    channel.close();
                }
            }
            catch (IOException e) {
                if (!LOG.isDebugEnabled()) break block7;
                LOG.debug("Skipping ReadableByteChannel option", e);
            }
        }
        return new InputStreamRangeWriter(() -> content2.getInputStream());
    }
}

