/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.types.Field;
import sun.jvm.hotspot.types.JIntField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class OSThread
extends VMObject {
    private static JIntField interruptedField;
    private static Field threadIdField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("OSThread");
        interruptedField = type.getJIntField("_interrupted");
        threadIdField = type.getField("_thread_id");
    }

    public OSThread(Address addr) {
        super(addr);
    }

    public boolean interrupted() {
        return interruptedField.getValue(this.addr) != 0;
    }

    public int threadId() {
        return threadIdField.getJInt(this.addr);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                OSThread.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

