/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.generic;

import com.github.cliftonlabs.json_simple.JsonArray;
import com.github.cliftonlabs.json_simple.JsonObject;
import com.github.cliftonlabs.json_simple.Jsoner;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Set;
import org.apache.velocity.tools.config.DefaultKey;
import org.apache.velocity.tools.config.InvalidScope;
import org.apache.velocity.tools.generic.ImportSupport;
import org.apache.velocity.tools.generic.JsonContent;
import org.apache.velocity.tools.generic.ValueParser;

@DefaultKey(value="json")
@InvalidScope(value={"session"})
public class JsonTool
extends ImportSupport
implements Iterable,
Serializable {
    private static final long serialVersionUID = -6239459645862004347L;
    protected transient ImportSupport importSupport = null;
    private JsonContent root = null;

    protected synchronized void initializeImportSupport(ValueParser config) {
        if (this.importSupport == null) {
            this.importSupport = new ImportSupport();
            this.importSupport.configure(config);
        }
    }

    @Override
    protected void configure(ValueParser values) {
        super.configure(values);
        this.initializeImportSupport(values);
        String resource = values.getString("resource");
        if (resource != null) {
            this.read(resource);
        } else {
            String url = values.getString("url");
            if (url != null) {
                boolean safeMode = this.importSupport.isSafeMode();
                this.importSupport.setSafeMode(false);
                this.fetch(url);
                this.importSupport.setSafeMode(safeMode);
            }
        }
    }

    protected void initJSON(String json) {
        if (json != null) {
            this.initJSON(new StringReader(json));
        }
    }

    protected void initJSON(Reader reader) {
        block4: {
            try {
                Object result = Jsoner.deserialize((Reader)reader);
                if (result instanceof JsonObject) {
                    this.root = new JsonContent((JsonObject)result);
                    break block4;
                }
                if (result instanceof JsonArray) {
                    this.root = new JsonContent((JsonArray)result);
                    break block4;
                }
                throw new Exception("Expecting JSON array or object");
            }
            catch (Exception e) {
                this.getLog().error("error while setting up JSON source", (Throwable)e);
                this.root = null;
            }
        }
    }

    public JsonTool parse(String json) {
        if (json != null) {
            try {
                this.initJSON(json);
            }
            catch (Exception e) {
                this.getLog().error("could not parse given JSON string", (Throwable)e);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonTool read(String resource) {
        if (resource != null) {
            Reader reader = null;
            try {
                if (this.importSupport == null) {
                    this.initializeImportSupport(new ValueParser());
                }
                if ((reader = this.importSupport.getResourceReader(resource)) != null) {
                    this.initJSON(reader);
                }
            }
            catch (Exception e) {
                this.getLog().error("could not read JSON resource {}", (Object)resource, (Object)e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonTool fetch(String url) {
        if (url != null) {
            Reader reader = null;
            try {
                if (this.importSupport == null) {
                    this.initializeImportSupport(new ValueParser());
                }
                if ((reader = this.importSupport.acquireReader(url)) != null) {
                    this.initJSON(reader);
                }
            }
            catch (Exception e) {
                this.getLog().error("could not fetch JSON content from URL {}", (Object)url, (Object)e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return this;
    }

    public Object root() {
        return this.root;
    }

    public Object get(int index) {
        return this.root == null ? null : this.root.get(index);
    }

    public Object get(String key) {
        return this.root == null ? null : this.root.get(key);
    }

    public Iterator<String> keys() {
        return this.root == null ? null : this.root.keys();
    }

    public Set<String> keySet() {
        return this.root == null ? null : this.root.keySet();
    }

    public Iterator iterator() {
        return this.root == null ? null : this.root.iterator();
    }

    public int size() {
        return this.root == null ? null : Integer.valueOf(this.root.size());
    }

    public String toString() {
        return this.root == null ? null : this.root.toString();
    }
}

