/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.ClientHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.HelloMessageParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientHelloParser
extends HelloMessageParser<ClientHelloMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public ClientHelloParser(int pointer, byte[] array, ProtocolVersion version, Config config) {
        super(pointer, array, HandshakeMessageType.CLIENT_HELLO, version, config);
    }

    @Override
    protected void parseHandshakeMessageContent(ClientHelloMessage msg) {
        LOGGER.debug("Parsing ClientHelloMessage");
        this.parseProtocolVersion(msg);
        this.parseRandom(msg);
        this.parseSessionIDLength(msg);
        this.parseSessionID(msg);
        if (this.getVersion().isDTLS()) {
            msg.setCookieLength(this.parseByteField(1));
            msg.setCookie(this.parseByteArrayField(((Byte)msg.getCookieLength().getValue()).byteValue()));
            if ((Byte)msg.getCookieLength().getValue() == 0) {
                msg.setIncludeInDigest(false);
            }
        }
        this.parseCipherSuiteLength(msg);
        this.parseCipherSuites(msg);
        this.parseCompressionLength(msg);
        this.parseCompressions(msg);
        if (this.hasExtensionLengthField(msg)) {
            this.parseExtensionLength(msg);
            if (this.hasExtensions(msg)) {
                this.parseExtensionBytes(msg);
            }
        }
    }

    @Override
    protected ClientHelloMessage createHandshakeMessage() {
        return new ClientHelloMessage();
    }

    private void parseCipherSuiteLength(ClientHelloMessage msg) {
        msg.setCipherSuiteLength(this.parseIntField(2));
        LOGGER.debug("CipherSuiteLength: " + msg.getCipherSuiteLength().getValue());
    }

    private void parseCipherSuites(ClientHelloMessage msg) {
        msg.setCipherSuites(this.parseByteArrayField((Integer)msg.getCipherSuiteLength().getValue()));
        LOGGER.debug("CipherSuites: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getCipherSuites().getValue())));
    }

    private void parseCompressionLength(ClientHelloMessage msg) {
        msg.setCompressionLength(this.parseIntField(1));
        LOGGER.debug("CompressionLength: " + msg.getCompressionLength().getValue());
    }

    private void parseCompressions(ClientHelloMessage msg) {
        msg.setCompressions(this.parseByteArrayField((Integer)msg.getCompressionLength().getValue()));
        LOGGER.debug("Compressions: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getCompressions().getValue())));
    }
}

