/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.rules.model.healthStats;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.Version;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.plugin.insights.rules.model.MetricType;
import org.opensearch.plugin.insights.rules.model.healthStats.TopQueriesHealthStats;
import org.opensearch.threadpool.ThreadPool;

public class QueryInsightsHealthStats
implements ToXContentFragment,
Writeable {
    private final ThreadPool.Info threadPoolInfo;
    private final int queryRecordsQueueSize;
    private final Map<MetricType, TopQueriesHealthStats> topQueriesHealthStats;
    private Map<String, Long> fieldTypeCacheStats;
    private static final String THREAD_POOL_INFO = "ThreadPoolInfo";
    private static final String QUERY_RECORDS_QUEUE_SIZE = "QueryRecordsQueueSize";
    private static final String TOP_QUERIES_HEALTH_STATS = "TopQueriesHealthStats";
    private static final String FIELD_TYPE_CACHE_STATS = "FieldTypeCacheStats";

    public QueryInsightsHealthStats(StreamInput in) throws IOException {
        this.threadPoolInfo = new ThreadPool.Info(in);
        this.queryRecordsQueueSize = in.readInt();
        this.topQueriesHealthStats = in.readMap(MetricType::readFromStream, TopQueriesHealthStats::new);
        if (in.getVersion().onOrAfter(Version.V_2_19_0)) {
            this.fieldTypeCacheStats = in.readMap(StreamInput::readString, StreamInput::readLong);
        }
    }

    public QueryInsightsHealthStats(ThreadPool.Info threadPoolInfo, int queryRecordsQueueSize, Map<MetricType, TopQueriesHealthStats> topQueriesHealthStats, Map<String, Long> fieldTypeCacheStats) {
        if (threadPoolInfo == null || topQueriesHealthStats == null) {
            throw new IllegalArgumentException("Parameters cannot be null");
        }
        this.threadPoolInfo = threadPoolInfo;
        this.queryRecordsQueueSize = queryRecordsQueueSize;
        this.topQueriesHealthStats = topQueriesHealthStats;
        this.fieldTypeCacheStats = Objects.requireNonNull(fieldTypeCacheStats, "fieldTypeCacheStats cannot be null");
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(THREAD_POOL_INFO);
        this.threadPoolInfo.toXContent(builder, params);
        builder.endObject();
        builder.field(QUERY_RECORDS_QUEUE_SIZE, this.queryRecordsQueueSize);
        builder.startObject(TOP_QUERIES_HEALTH_STATS);
        for (Map.Entry<MetricType, TopQueriesHealthStats> entry : this.topQueriesHealthStats.entrySet()) {
            builder.startObject(entry.getKey().toString());
            entry.getValue().toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        builder.startObject(FIELD_TYPE_CACHE_STATS);
        for (String key : List.of("size_in_bytes", "entry_count", "evictions", "hit_count", "miss_count")) {
            builder.field(key, this.fieldTypeCacheStats.getOrDefault(key, 0L));
        }
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.threadPoolInfo.writeTo(out);
        out.writeInt(this.queryRecordsQueueSize);
        out.writeMap(this.topQueriesHealthStats, MetricType::writeTo, (streamOutput, topQueriesHealthStats) -> topQueriesHealthStats.writeTo(out));
        if (out.getVersion().onOrAfter(Version.V_2_19_0)) {
            out.writeMap(this.fieldTypeCacheStats, StreamOutput::writeString, StreamOutput::writeLong);
        }
    }

    public ThreadPool.Info getThreadPoolInfo() {
        return this.threadPoolInfo;
    }

    public int getQueryRecordsQueueSize() {
        return this.queryRecordsQueueSize;
    }

    public Map<MetricType, TopQueriesHealthStats> getTopQueriesHealthStats() {
        return this.topQueriesHealthStats;
    }

    public Map<String, Long> getFieldTypeCacheStats() {
        return this.fieldTypeCacheStats;
    }
}

