/*
 * Decompiled with CFR 0.152.
 */
package Signature;

import java.io.IOException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPrivateKey;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;

class SignUtils {
    SignUtils() {
    }

    static byte[] generateEcdsaFixedLengthSignature(byte[] digest, Signature signatureCipher, ECPrivateKey ecKey, short expectedLength) throws SignatureException {
        byte[] signatureBytes;
        do {
            signatureCipher.update(digest);
            signatureBytes = signatureCipher.sign();
            if (signatureBytes.length == expectedLength) continue;
            ASN1Sequence seq = ASN1Sequence.getInstance((Object)signatureBytes);
            ASN1Integer r = (ASN1Integer)seq.getObjectAt(0);
            ASN1Integer s = (ASN1Integer)seq.getObjectAt(1);
            s = new ASN1Integer(ecKey.getParams().getOrder().subtract(s.getPositiveValue()));
            seq = new DERSequence(new ASN1Encodable[]{r, s});
            try {
                signatureBytes = seq.getEncoded();
            }
            catch (IOException ex) {
                throw new SignatureException(ex);
            }
        } while (signatureBytes.length != expectedLength);
        return signatureBytes;
    }
}

