/*
 * Decompiled with CFR 0.152.
 */
package lucee.loader.engine;

import com.intergral.fusiondebug.server.FDControllerFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import lucee.VersionInfo;
import lucee.commons.io.log.Log;
import lucee.commons.lang.ConcurrentHashMapAsHashtable;
import lucee.loader.TP;
import lucee.loader.engine.BundleProvider;
import lucee.loader.engine.CFMLEngine;
import lucee.loader.engine.CFMLEngineFactorySupport;
import lucee.loader.engine.CFMLEngineWrapper;
import lucee.loader.engine.EngineChangeListener;
import lucee.loader.engine.mvn.MavenUpdateProvider;
import lucee.loader.osgi.BundleCollection;
import lucee.loader.osgi.BundleLoader;
import lucee.loader.osgi.BundleUtil;
import lucee.loader.osgi.LoggerImpl;
import lucee.loader.util.ExtensionFilter;
import lucee.loader.util.Util;
import lucee.loader.util.ZipUtil;
import lucee.loader.util.log.Logging;
import lucee.runtime.config.ConfigServer;
import lucee.runtime.config.Identification;
import lucee.runtime.config.Password;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.Logger;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CFMLEngineFactory
extends CFMLEngineFactorySupport {
    public static final String ARG_PROJECT_DIR = "LUCEE_PROJECT_DIR";
    public static final String ARG_CLASSES_DIR = "LUCEE_CLASSES_DIR";
    private static final boolean PATCH_ENABLED = true;
    public static final Version VERSION_ZERO = new Version(0, 0, 0, "0");
    private static final String UPDATE_LOCATION = "https://update.lucee.org";
    private static final long GB1 = 0x40000000L;
    private static final long MB100 = 0x6400000L;
    private static final int MAX_REDIRECTS = 5;
    private static final Version MIN_VERSION = CFMLEngineFactory.toVersion("5.0.0.248", null);
    private static CFMLEngineFactory factory;
    private static CFMLEngineWrapper singelton;
    private static File luceeServerRoot;
    private Felix felix;
    private BundleCollection bundleCollection;
    private final ClassLoader mainClassLoader = new TP().getClass().getClassLoader();
    private Version version;
    private final List<EngineChangeListener> listeners = new ArrayList<EngineChangeListener>();
    private File resourceRoot;
    private final LoggerImpl logger;
    protected ServletConfig config;
    private boolean embedded;

    protected CFMLEngineFactory(ServletConfig config) {
        Logging.startupLog();
        System.setProperty("org.apache.commons.logging.LogFactory.HashtableImpl", ConcurrentHashMapAsHashtable.class.getName());
        File logFile = null;
        this.config = config;
        try {
            logFile = new File(this.getResourceRoot(), "context/logs/felix.log");
            if (logFile.isFile()) {
                if (logFile.length() > 0x40000000L) {
                    logFile.delete();
                } else if (logFile.length() > 0x6400000L) {
                    File bak = new File(logFile.getParentFile(), "felix.1.log");
                    if (bak.isFile()) {
                        bak.delete();
                    }
                    logFile.renameTo(bak);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        logFile.getParentFile().mkdirs();
        this.logger = new LoggerImpl(logFile);
    }

    public static synchronized CFMLEngine getInstance(ServletConfig config) throws ServletException {
        if (singelton != null) {
            if (factory == null) {
                factory = singelton.getCFMLEngineFactory();
            }
            return singelton;
        }
        if (factory == null) {
            factory = new CFMLEngineFactory(config);
        }
        factory.readInitParam(config);
        factory.initEngineIfNecessary();
        singelton.addServletConfig(config);
        return singelton;
    }

    public static CFMLEngine getInstance() throws RuntimeException {
        if (singelton != null) {
            return singelton;
        }
        throw new RuntimeException("Engine is not initialized, you must first call getInstance(ServletConfig)");
    }

    public static void registerInstance(CFMLEngine engine) {
        if (engine instanceof CFMLEngineWrapper) {
            throw new RuntimeException("That should not happen!");
        }
        CFMLEngineFactory.setEngine(engine);
    }

    public static CFMLEngine getInstance(ServletConfig config, EngineChangeListener listener) throws ServletException {
        CFMLEngineFactory.getInstance(config);
        factory.addListener(listener);
        factory.readInitParam(config);
        factory.initEngineIfNecessary();
        singelton.addServletConfig(config);
        FDControllerFactory.makeVisible();
        return singelton;
    }

    void readInitParam(ServletConfig config) {
        String initParam;
        if (luceeServerRoot != null) {
            return;
        }
        String strEmbedded = config.getInitParameter("embedded");
        this.embedded = false;
        if (!Util.isEmpty(strEmbedded, true)) {
            strEmbedded.trim().toLowerCase();
            boolean bl = this.embedded = strEmbedded.equals("true") || strEmbedded.equals("yes");
        }
        if (Util.isEmpty(initParam = config.getInitParameter("lucee-server-directory"))) {
            initParam = config.getInitParameter("lucee-server-root");
        }
        if (Util.isEmpty(initParam)) {
            initParam = config.getInitParameter("lucee-server-dir");
        }
        if (Util.isEmpty(initParam)) {
            initParam = config.getInitParameter("lucee-server");
        }
        if (Util.isEmpty(initParam)) {
            initParam = Util._getSystemPropOrEnvVar("lucee.server.dir", null);
        }
        initParam = CFMLEngineFactory.parsePlaceHolder(CFMLEngineFactory.removeQuotes(initParam, true));
        try {
            if (!Util.isEmpty(initParam)) {
                File root = new File(initParam);
                if (!root.exists()) {
                    if (root.mkdirs()) {
                        luceeServerRoot = root.getCanonicalFile();
                        return;
                    }
                } else if (root.canWrite()) {
                    luceeServerRoot = root.getCanonicalFile();
                    return;
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void addListener(EngineChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    private void initEngineIfNecessary() throws ServletException {
        if (singelton == null) {
            this.initEngine();
        }
    }

    public void shutdownFelix() throws BundleException {
        this.log(4, "---- Shutdown Felix ----");
        BundleCollection bc = singelton.getBundleCollection();
        if (bc == null || bc.felix == null) {
            return;
        }
        BundleUtil.stop(this.felix, false);
    }

    public static void main(String[] args) throws IOException {
        CFMLEngineFactory.createBundleFromSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createBundleFromSource() throws IOException {
        String resPrefix = "../../../";
        String pathClas = "../core/target/classes/";
        String pathCfml = "../core/src/main/cfml/";
        String pathJava = "../core/src/main/java/";
        String pathLpom = "./pom.xml";
        String s = Util._getSystemPropOrEnvVar(ARG_PROJECT_DIR, "");
        if (!s.isEmpty()) {
            pathCfml = Paths.get(s, "/core/src/main/cfml/").toString();
            pathJava = Paths.get(s, "/core/src/main/java/").toString();
            pathLpom = Paths.get(s, "/loader/pom.xml").toString();
            pathClas = Paths.get(s, "/core/target/classes/").toString();
            s = Util._getSystemPropOrEnvVar(ARG_CLASSES_DIR, "");
            if (!s.isEmpty()) {
                pathClas = Paths.get(s, "core").toString();
            }
        }
        String pathJres = Paths.get(pathJava, "resource/").toString();
        File classesDirectory = CFMLEngineFactory.load("classes directory", "the directory containing all compiled class files from the core project", "LUCEE_CLASS_DIR", pathClas, resPrefix + pathClas, true);
        System.out.println("LUCEE_CLASS_DIR: " + classesDirectory);
        File sourceCfml = CFMLEngineFactory.load("source directory", "the directory containg all CFML source files from the core project", "SOURCE_DIRECTORY", pathCfml, resPrefix + pathCfml, true);
        System.out.println("SOURCE_DIRECTORY: " + sourceCfml);
        File sourceJava = CFMLEngineFactory.load("source java directory", "the directory containing Java source files from the core project", "SOURCE_JAVA_DIR", pathJava, resPrefix + pathJava, true);
        System.out.println("SOURCE_JAVA_DIR: " + sourceJava);
        File resourceJava = CFMLEngineFactory.load("resource java directory", "the directory containing resources in the Java source of the core project", "", pathJres, resPrefix + pathJava + "resource/", true);
        System.out.println("RESOURCE_JAVA_DIR: " + resourceJava);
        File pomFile = CFMLEngineFactory.load("pom file", "the pom.xml file from the core project", "POM_FILE", pathLpom, "../../../pom.xml", false);
        System.out.println("POM: " + pomFile);
        File manifestFile = new File(sourceJava, "META-INF/MANIFEST.MF");
        Manifest manifest = new Manifest();
        try (FileInputStream is = new FileInputStream(manifestFile);){
            manifest.read(is);
        }
        Attributes main = manifest.getMainAttributes();
        String bundleName = main.getValue("Bundle-SymbolicName");
        String bundleVersion = CFMLEngineFactory.readVersionFromPOM(pomFile);
        System.out.println("VERSION: " + bundleVersion);
        main.put(new Attributes.Name("Bundle-Version"), bundleVersion);
        File bundleFile = File.createTempFile(bundleName + "-", ".lco");
        bundleFile.deleteOnExit();
        System.out.println("LCO: " + bundleFile);
        JarOutputStream jos = null;
        try {
            jos = new JarOutputStream((OutputStream)new FileOutputStream(bundleFile), manifest);
            CFMLEngineFactory.addDirectoryToJar(jos, classesDirectory, "", new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return !name.equals(".DS_Store");
                }
            });
            CFMLEngineFactory.addDirectoryToJar(jos, sourceCfml, "resource/", new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return !name.endsWith(".DS_Store") && !name.endsWith(".java");
                }
            });
            CFMLEngineFactory.addDirectoryToJar(jos, resourceJava, "resource/", new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return !name.endsWith(".DS_Store") && !name.endsWith(".java");
                }
            });
            File f = new File(sourceJava, "default.properties");
            CFMLEngineFactory.addFileToJar(jos, f, "");
            f = new File(sourceJava, "License.txt");
            CFMLEngineFactory.addFileToJar(jos, f, "");
        }
        catch (Throwable throwable) {
            Util.closeEL(jos);
            throw throwable;
        }
        Util.closeEL(jos);
        return bundleFile;
    }

    private static File load(String subject, String desc, String envVarName, String relpath, String relResource, boolean dir) throws IOException {
        File file;
        String env = Util._getSystemPropOrEnvVar(envVarName, "");
        if (!Util.isEmpty(env)) {
            file = new File(env.trim());
            if (dir && !file.isDirectory() || !dir && !file.isFile()) {
                throw new IOException("the " + subject + " [" + file + "] (" + desc + ") you have defined via enviroment variable [" + envVarName + "] does not exist!");
            }
        } else {
            file = new File(relpath).getCanonicalFile();
            if (dir && !file.isDirectory() || !dir && !file.isFile()) {
                file = null;
                URL res = new TP().getClass().getClassLoader().getResource("");
                try {
                    File f = new File(res.toURI());
                    if (f.isDirectory()) {
                        file = new File(f, relResource).getCanonicalFile();
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            if (file == null || dir && !file.isDirectory() || !dir && !file.isFile()) {
                throw new IOException("could not find the " + subject + " (" + desc + "), please set the enviroment variable [" + envVarName + "] that points to it.");
            }
        }
        return file;
    }

    private static String readVersionFromPOM(File pomFile) throws IOException {
        String versionTagStart = "<version>";
        String versionTagEnd = "</version>";
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Util.copy(new FileInputStream(pomFile), baos, true, true);
        String xml = new String(baos.toByteArray());
        int startIndex = xml.indexOf(versionTagStart) + versionTagStart.length();
        int endIndex = xml.indexOf(versionTagEnd);
        if (startIndex < versionTagStart.length() || endIndex == -1) {
            throw new IOException("Version tag not found");
        }
        return xml.substring(startIndex, endIndex).trim();
    }

    private static void addFileToJar(JarOutputStream jos, File file, String archivePath) {
        JarEntry entry = new JarEntry(archivePath + file.getName());
        entry.setTime(file.lastModified());
        try {
            jos.putNextEntry(entry);
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));){
                int count;
                byte[] buffer = new byte[4096];
                while ((count = bis.read(buffer)) != -1) {
                    jos.write(buffer, 0, count);
                }
            }
            jos.closeEntry();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void addDirectoryToJar(JarOutputStream jos, File folder, String parentEntryName, FilenameFilter filter) throws IOException {
        for (File file : folder.listFiles()) {
            String name;
            if (file.isDirectory()) {
                name = (parentEntryName + file.getName() + "/").replace("//", "/");
                CFMLEngineFactory.addDirectoryToJar(jos, file, name, filter);
                continue;
            }
            name = (parentEntryName + file.getName()).replace("//", "/");
            if (filter != null && !filter.accept(folder, name) || name.equals("META-INF/MANIFEST.MF")) continue;
            CFMLEngineFactory.addFileToJar(jos, file, parentEntryName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initEngine() throws ServletException {
        ServletException se;
        String tmp;
        Version specificVersion;
        Version coreVersion = VersionInfo.getIntVersion();
        long coreCreated = VersionInfo.getCreateTime();
        File patcheDir = null;
        try {
            patcheDir = this.getPatchDirectory();
            this.log(4, "lucee-server-root:" + patcheDir.getParent());
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
        File lucee = null;
        if (this.isEmbeddedMode()) {
            this.embedded = true;
        }
        if (this.embedded) {
            try {
                lucee = CFMLEngineFactory.createBundleFromSource();
            }
            catch (IOException e) {
                throw new ServletException((Throwable)e);
            }
        }
        Version version = specificVersion = !Util.isEmpty(tmp = Util._getSystemPropOrEnvVar("lucee.version", null), true) ? CFMLEngineFactory.toVersion(tmp, null) : null;
        if (specificVersion != null) {
            if (Util.isNewerThan(MIN_VERSION, specificVersion)) {
                this.log(1, "the version defined [" + specificVersion + "] cannot be used, version cannot be older than [" + MIN_VERSION + "]");
                specificVersion = null;
            } else {
                this.log(4, "specific version [" + specificVersion + "] defined.");
            }
        }
        if (lucee == null) {
            File[] patches = patcheDir.listFiles(new ExtensionFilter(new String[]{".lco"}));
            if (patches != null) {
                for (File patch : patches) {
                    if (patch.getName().startsWith("tmp.lco") || patch.length() < 1000000L) {
                        this.log(3, "delete [" + patch + "]");
                        patch.delete();
                        continue;
                    }
                    Version pv = CFMLEngineFactory.toVersion(patch.getName(), VERSION_ZERO);
                    if (specificVersion != null) {
                        if (!pv.equals(specificVersion)) continue;
                        lucee = patch;
                        this.log(4, "specific version [" + specificVersion + "] is used.");
                        break;
                    }
                    if (lucee != null && !Util.isNewerThan(pv, CFMLEngineFactory.toVersion(lucee.getName(), VERSION_ZERO))) continue;
                    lucee = patch;
                }
            }
            if (specificVersion == null && lucee != null && Util.isNewerThan(coreVersion, CFMLEngineFactory.toVersion(lucee.getName(), VERSION_ZERO))) {
                this.log(3, "ignoring version from patch folder, it is to old");
                lucee = null;
            }
        }
        try {
            block33: {
                block31: {
                    CFMLEngine engine;
                    block30: {
                        String v;
                        File rc;
                        BufferedOutputStream os;
                        InputStream is;
                        block32: {
                            block29: {
                                if (lucee != null) break block31;
                                this.log(4, "Load built-in Core");
                                String coreExt = "lco";
                                is = null;
                                os = null;
                                rc = new File(CFMLEngineFactory.getTempDirectory(), "tmp_" + System.currentTimeMillis() + "." + "lco");
                                try {
                                    File dir;
                                    File[] files;
                                    String s;
                                    is = new TP().getClass().getResourceAsStream("/core/core.lco");
                                    if (is == null && (s = System.getProperty("lucee.core.path")) != null && (files = (dir = new File(s)).listFiles(new ExtensionFilter(new String[]{"lco"}))).length > 0) {
                                        is = new FileInputStream(files[0]);
                                    }
                                    if (is != null) {
                                        os = new BufferedOutputStream(new FileOutputStream(rc));
                                        CFMLEngineFactory.copy(is, os);
                                        break block29;
                                    }
                                    this.log(1, "/core/core.lco not found at " + TP.class.getProtectionDomain().getCodeSource().getLocation().getPath());
                                }
                                catch (Throwable throwable) {
                                    CFMLEngineFactory.closeEL(is);
                                    CFMLEngineFactory.closeEL(os);
                                    throw throwable;
                                }
                            }
                            CFMLEngineFactory.closeEL(is);
                            CFMLEngineFactory.closeEL(os);
                            engine = null;
                            v = CFMLEngineFactory.getVersion(rc);
                            if (specificVersion == null || specificVersion.equals(CFMLEngineFactory.toVersion(v, specificVersion))) break block32;
                            InputStream in = null;
                            FileOutputStream out = null;
                            try {
                                in = new MavenUpdateProvider().getCore(specificVersion);
                                lucee = new File(patcheDir, specificVersion + ".lco");
                                out = new FileOutputStream(lucee);
                                Util.copy(in, out);
                            }
                            catch (Exception e) {
                                try {
                                    this.log(e);
                                    e.printStackTrace();
                                }
                                catch (Throwable throwable) {
                                    Util.closeEL(in, out);
                                    throw throwable;
                                }
                                Util.closeEL(in, out);
                                break block30;
                            }
                            Util.closeEL(in, out);
                            break block30;
                        }
                        lucee = new File(patcheDir, v + "." + "lco");
                        try {
                            is = new FileInputStream(rc);
                            os = new BufferedOutputStream(new FileOutputStream(lucee));
                            CFMLEngineFactory.copy(is, os);
                        }
                        finally {
                            CFMLEngineFactory.closeEL(is);
                            CFMLEngineFactory.closeEL(os);
                            rc.delete();
                        }
                    }
                    engine = this._getCore(lucee);
                    CFMLEngineFactory.setEngine(engine);
                    break block33;
                }
                this.bundleCollection = BundleLoader.loadBundles(this, this.getFelixCacheDirectory(), this.getBundleDirectory(), lucee, this.bundleCollection);
                this.log(4, "Loaded bundle: [" + this.bundleCollection.core.getSymbolicName() + "]");
                CFMLEngineFactory.setEngine(this.getEngine(this.bundleCollection));
                this.log(4, "Loaded engine: [" + singelton + "]");
            }
            this.version = singelton.getInfo().getVersion();
            this.log(4, "Loaded Lucee Version [" + singelton.getInfo().getVersion() + "]");
        }
        catch (InvocationTargetException e) {
            this.log(e.getTargetException());
            se = new ServletException(e.getTargetException());
            throw se;
        }
        catch (Exception e) {
            se = new ServletException((Throwable)e);
            Util.initCauseEL((Throwable)se, e);
            throw se;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getVersion(File file) throws IOException, BundleException {
        try (JarFile jar = new JarFile(file);){
            Manifest manifest = jar.getManifest();
            Attributes attrs = manifest.getMainAttributes();
            String string = attrs.getValue("Bundle-Version");
            return string;
        }
    }

    private static CFMLEngineWrapper setEngine(CFMLEngine engine) {
        if (singelton == null) {
            singelton = new CFMLEngineWrapper(engine);
        } else if (!singelton.isIdentical(engine)) {
            singelton.setEngine(engine);
        }
        return singelton;
    }

    public Felix getFelix(File cacheRootDir, Map<String, Object> config) throws BundleException {
        block34: {
            if (config == null) {
                config = new HashMap<String, Object>();
            }
            int logLevel = 1;
            String strLogLevel = CFMLEngineFactory.getSystemPropOrEnvVar("felix.log.level", null);
            if (Util.isEmpty(strLogLevel)) {
                strLogLevel = (String)config.get("felix.log.level");
            }
            if (!Util.isEmpty(strLogLevel)) {
                if ("0".equalsIgnoreCase(strLogLevel)) {
                    logLevel = 0;
                } else if ("error".equalsIgnoreCase(strLogLevel) || "1".equalsIgnoreCase(strLogLevel)) {
                    logLevel = 1;
                } else if ("warning".equalsIgnoreCase(strLogLevel) || "2".equalsIgnoreCase(strLogLevel)) {
                    logLevel = 2;
                } else if ("info".equalsIgnoreCase(strLogLevel) || "information".equalsIgnoreCase(strLogLevel) || "3".equalsIgnoreCase(strLogLevel)) {
                    logLevel = 3;
                } else if ("debug".equalsIgnoreCase(strLogLevel) || "4".equalsIgnoreCase(strLogLevel)) {
                    logLevel = 4;
                }
            }
            config.put("felix.log.level", "" + logLevel);
            if (this.logger != null) {
                if (logLevel == 2) {
                    this.logger.setLogLevel(2);
                } else if (logLevel == 3) {
                    this.logger.setLogLevel(3);
                } else if (logLevel == 4) {
                    this.logger.setLogLevel(4);
                } else {
                    this.logger.setLogLevel(1);
                }
            }
            if (this.logger != null) {
                if (logLevel == 2) {
                    this.logger.setLogLevel(2);
                } else if (logLevel == 3) {
                    this.logger.setLogLevel(3);
                } else if (logLevel == 4) {
                    this.logger.setLogLevel(4);
                } else {
                    this.logger.setLogLevel(1);
                }
            }
            CFMLEngineFactory.extend(config, "felix.cache.locking", null, false);
            CFMLEngineFactory.extend(config, "org.osgi.framework.executionenvironment", null, false);
            CFMLEngineFactory.extend(config, "org.osgi.framework.storage", null, false);
            CFMLEngineFactory.extend(config, "org.osgi.framework.storage.clean", "onFirstInit", false);
            CFMLEngineFactory.extend(config, "org.osgi.framework.bundle.parent", "framework", false);
            boolean isNew = false;
            if (Util.isEmpty((String)config.get("felix.cache.rootdir"))) {
                if (!cacheRootDir.exists()) {
                    cacheRootDir.mkdirs();
                    isNew = true;
                }
                if (cacheRootDir.isDirectory()) {
                    config.put("felix.cache.rootdir", cacheRootDir.getAbsolutePath());
                }
            }
            CFMLEngineFactory.extend(config, "org.osgi.framework.bootdelegation", null, true);
            CFMLEngineFactory.extend(config, "org.osgi.framework.system.packages", null, true);
            CFMLEngineFactory.extend(config, "org.osgi.framework.system.packages.extra", null, true);
            CFMLEngineFactory.extend(config, "felix.cache.filelimit", null, false);
            CFMLEngineFactory.extend(config, "felix.cache.bufsize", null, false);
            CFMLEngineFactory.extend(config, "felix.bootdelegation.implicit", null, false);
            CFMLEngineFactory.extend(config, "felix.systembundle.activators", null, false);
            CFMLEngineFactory.extend(config, "org.osgi.framework.startlevel.beginning", null, false);
            CFMLEngineFactory.extend(config, "felix.startlevel.bundle", null, false);
            CFMLEngineFactory.extend(config, "felix.service.urlhandlers", null, false);
            CFMLEngineFactory.extend(config, "felix.auto.deploy.dir", null, false);
            CFMLEngineFactory.extend(config, "felix.auto.deploy.action", null, false);
            CFMLEngineFactory.extend(config, "felix.shutdown.hook", null, false);
            if (this.logger != null) {
                config.put("felix.log.logger", this.logger);
            }
            Iterator<Map.Entry<String, Object>> it = config.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Object> e = it.next();
                Object v = e.getValue();
                if (v != null && !v.toString().isEmpty()) continue;
                it.remove();
            }
            StringBuilder sb = new StringBuilder("Loading felix with config:");
            for (Map.Entry<String, Object> e : config.entrySet()) {
                sb.append("\n- ").append(e.getKey()).append(':').append(e.getValue());
            }
            this.felix = new Felix(config);
            try {
                this.felix.start();
            }
            catch (BundleException be) {
                if (isNew || !"Error creating bundle cache.".equals(be.getMessage())) break block34;
                Util.deleteContent(cacheRootDir, null);
            }
        }
        return this.felix;
    }

    private static void extend(Map<String, Object> config, String name, String defaultValue, boolean add) {
        String addional = CFMLEngineFactory.getSystemPropOrEnvVar(name, null);
        if (Util.isEmpty(addional, true)) {
            if (Util.isEmpty(defaultValue, true)) {
                return;
            }
            addional = defaultValue.trim();
        }
        if (add) {
            String existing = (String)config.get(name);
            if (!Util.isEmpty(existing, true)) {
                config.put(name, existing.trim() + "," + addional.trim());
            } else {
                config.put(name, addional.trim());
            }
        } else {
            config.put(name, addional.trim());
        }
    }

    protected static String getSystemPropOrEnvVar(String name, String defaultValue) {
        return Util._getSystemPropOrEnvVar(name, defaultValue);
    }

    public boolean isEmbeddedMode() {
        String s = Util._getSystemPropOrEnvVar(ARG_PROJECT_DIR, null);
        if (s == null) {
            return false;
        }
        boolean result = new File(s).isDirectory();
        if (!result) {
            System.out.println("LUCEE_PROJECT_DIR is set but is not pointing to a valid directory (" + s + ")");
        }
        return result;
    }

    public void log(Throwable t) {
        if (this.logger != null) {
            this.logger.log(1, "", t);
        }
    }

    public void log(int level, String msg) {
        if (this.logger != null) {
            this.logger.log(level, msg);
        }
    }

    private CFMLEngine _getCore(File rc) throws IOException, BundleException, ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.bundleCollection = BundleLoader.loadBundles(this, this.getFelixCacheDirectory(), this.getBundleDirectory(), rc, this.bundleCollection);
        return this.getEngine(this.bundleCollection);
    }

    @Deprecated
    public boolean update(Password password, Identification id) throws IOException, ServletException {
        if (!singelton.can(0, password)) {
            throw new IOException("Access denied to update CFMLEngine");
        }
        return this._update(id);
    }

    public boolean restart(Password password) throws IOException, ServletException {
        if (!singelton.can(1, password)) {
            throw new IOException("Access denied to restart CFMLEngine");
        }
        return this._restart();
    }

    public boolean restart(String configId, Password password) throws IOException, ServletException {
        if (!singelton.can(2, password)) {
            throw new IOException("Access denied to restart CFML Context (configId:" + configId + ")");
        }
        return this._restart();
    }

    private synchronized boolean _restart() throws ServletException {
        if (singelton != null) {
            singelton.reset();
        }
        this.initEngine();
        ConfigServer cs = this.getConfigServer(singelton);
        if (cs != null) {
            Log log = cs.getLog("application");
            log.info("loader", "Lucee restarted");
        }
        System.gc();
        return true;
    }

    @Deprecated
    private boolean _update(Identification id) throws IOException, ServletException {
        File newLucee = this.downloadCore(id);
        if (newLucee == null) {
            return false;
        }
        if (singelton != null) {
            singelton.reset();
        }
        Object v = null;
        try {
            this.bundleCollection = BundleLoader.loadBundles(this, this.getFelixCacheDirectory(), this.getBundleDirectory(), newLucee, this.bundleCollection);
            CFMLEngine e = this.getEngine(this.bundleCollection);
            if (e == null) {
                throw new IOException("Failed to load engine");
            }
            this.version = e.getInfo().getVersion();
            CFMLEngineFactory.setEngine(e);
            this.callListeners(e);
            ConfigServer cs = this.getConfigServer(e);
            if (cs != null) {
                Log log = cs.getLog("deploy");
                log.info("loader", "Lucee Version [" + v + "] installed");
            }
        }
        catch (Exception e) {
            System.gc();
            try {
                newLucee.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.log(e);
            e.printStackTrace();
            return false;
        }
        this.log(4, "Version (" + v + ")installed");
        return true;
    }

    private ConfigServer getConfigServer(CFMLEngine engine) {
        if (engine == null) {
            return null;
        }
        if (engine instanceof CFMLEngineWrapper) {
            engine = ((CFMLEngineWrapper)engine).getEngine();
        }
        try {
            Method m = engine.getClass().getDeclaredMethod("getConfigServerImpl", new Class[0]);
            m.setAccessible(true);
            return (ConfigServer)m.invoke((Object)engine, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public File downloadBundle(String symbolicName, String symbolicVersion, Identification id) throws IOException {
        int code;
        HttpURLConnection conn;
        URL updateUrl;
        String str;
        File jarDir = this.getBundleDirectory();
        File jar = this.deployBundledBundle(jarDir, symbolicName, symbolicVersion);
        if (jar != null && jar.isFile()) {
            return jar;
        }
        if (jar != null) {
            this.log(3, jar + " should exist but does not (exist?" + jar.exists() + ";file?" + jar.isFile() + ";hidden?" + jar.isHidden() + ")");
        }
        if ((str = Util._getSystemPropOrEnvVar("lucee.enable.bundle.download", null)) != null && ("false".equalsIgnoreCase(str) || "no".equalsIgnoreCase(str))) {
            throw new RuntimeException("Lucee is missing the Bundle jar, " + symbolicName + ":" + symbolicVersion + ", and has been prevented from downloading it. If this jar is not a core jar, it will need to be manually downloaded and placed in the {{lucee-server}}/context/bundles directory.");
        }
        jar = new File(jarDir, symbolicName + "-" + symbolicVersion + ".jar");
        try {
            updateUrl = BundleProvider.getInstance().getBundleAsURL(symbolicName, symbolicVersion);
        }
        catch (Exception e) {
            throw new IOException("Failed to get an endpoint for the bundle  [" + symbolicName + ":" + symbolicVersion + "]", e);
        }
        this.log(3, "Downloading bundle [" + symbolicName + ":" + symbolicVersion + "] from " + updateUrl + " and copying to " + jar);
        try {
            conn = (HttpURLConnection)updateUrl.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(10000);
            conn.connect();
            code = conn.getResponseCode();
        }
        catch (UnknownHostException e) {
            this.log(1, "Failed to download the bundle  [" + symbolicName + ":" + symbolicVersion + "] from [" + updateUrl + "] and copy to [" + jar + "]");
            throw new IOException("Failed to download the bundle  [" + symbolicName + ":" + symbolicVersion + "] from [" + updateUrl + "] and copy to [" + jar + "]", e);
        }
        if (code != 200) {
            int count = 1;
            while ((code == 302 || code == 301) && count++ <= 5) {
                String location = conn.getHeaderField("Location");
                if (location == null) {
                    location = conn.getHeaderField("location");
                }
                if (location == null) {
                    location = conn.getHeaderField("LOCATION");
                }
                this.log(3, "download redirected:" + location);
                conn.disconnect();
                URL url = new URL(location);
                try {
                    conn = (HttpURLConnection)url.openConnection();
                    conn.setRequestMethod("GET");
                    conn.setConnectTimeout(10000);
                    conn.connect();
                    code = conn.getResponseCode();
                }
                catch (UnknownHostException e) {
                    this.log(e);
                    throw new IOException("Failed to download the bundle  [" + symbolicName + ":" + symbolicVersion + "] from [" + location + "] and copy to [" + jar + "]", e);
                }
            }
            if (code != 200) {
                String msg = "Failed to download the bundle for [" + symbolicName + "] in version [" + symbolicVersion + "] from [" + updateUrl + "], please download manually and copy to [" + jarDir + "]";
                this.log(1, msg);
                conn.disconnect();
                throw new IOException(msg);
            }
        }
        CFMLEngineFactory.copy((InputStream)conn.getContent(), new FileOutputStream(jar));
        conn.disconnect();
        return jar;
    }

    /*
     * Exception decompiling
     */
    private File deployBundledBundle(File bundleDirectory, String symbolicName, String symbolicVersion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 14[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void fileMove(File src, File dest) throws IOException {
        boolean moved = src.renameTo(dest);
        if (!moved) {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(src));
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(dest));
            try {
                Util.copy(is, os, false, false);
            }
            finally {
                CFMLEngineFactory.closeEL(is);
                CFMLEngineFactory.closeEL(os);
            }
            if (!src.delete()) {
                src.deleteOnExit();
            }
        }
    }

    private boolean isWindows() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.startsWith("windows");
    }

    @Deprecated
    private File downloadCore(Identification id) throws IOException {
        int code;
        HttpURLConnection conn;
        URL updateProvider = this.getUpdateLocation();
        if (id == null && singelton != null) {
            id = singelton.getIdentification();
        }
        if (this.version == null) {
            this.version = CFMLEngineFactory.getInstance().getInfo().getVersion();
        }
        URL infoUrl = new URL(updateProvider, "/rest/update/provider/update-for/" + this.version.toString() + (id != null ? id.toQueryString() : ""));
        this.log(4, "Checking for core update at [" + updateProvider + "]");
        String strAvailableVersion = CFMLEngineFactory.toString((InputStream)infoUrl.getContent()).trim();
        this.log(4, "Update provider reports an updated core version available [" + strAvailableVersion + "] ");
        strAvailableVersion = CFMLEngineFactorySupport.removeQuotes(strAvailableVersion, true);
        if (strAvailableVersion.length() == 0 || !Util.isNewerThan(CFMLEngineFactory.toVersion(strAvailableVersion, VERSION_ZERO), this.version)) {
            this.log(4, "There is no newer Version available");
            return null;
        }
        this.log(3, "Found a newer Version \n - current Version [" + this.version.toString() + "]\n - available Version [" + strAvailableVersion + "]");
        URL updateUrl = new URL(updateProvider, "/rest/update/provider/download/" + strAvailableVersion + (id != null ? id.toQueryString() : "") + (id == null ? "?" : "&") + "allowRedirect=true");
        this.log(3, "Downloading core update from [" + updateUrl + "]");
        File patchDir = this.getPatchDirectory();
        File newLucee = new File(patchDir, strAvailableVersion + ".lco");
        try {
            conn = (HttpURLConnection)updateUrl.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(10000);
            conn.connect();
            code = conn.getResponseCode();
        }
        catch (UnknownHostException e) {
            this.log(e);
            throw e;
        }
        if (code != 200) {
            if (code == 302) {
                String location = conn.getHeaderField("Location");
                if (location == null) {
                    location = conn.getHeaderField("location");
                }
                if (location == null) {
                    location = conn.getHeaderField("LOCATION");
                }
                this.log(4, "download redirected to " + location);
                conn.disconnect();
                URL url = new URL(location);
                try {
                    conn = (HttpURLConnection)url.openConnection();
                    conn.setRequestMethod("GET");
                    conn.setConnectTimeout(10000);
                    conn.connect();
                    code = conn.getResponseCode();
                }
                catch (UnknownHostException e) {
                    this.log(e);
                    throw e;
                }
            }
            if (code != 200) {
                String msg = "Lucee failed to download the core for version [" + this.version.toString() + "] from " + updateUrl + ", please download it manually and copy to [" + patchDir + "]";
                this.log(1, msg);
                conn.disconnect();
                throw new IOException(msg);
            }
        }
        if (newLucee.createNewFile()) {
            CFMLEngineFactory.copy((InputStream)conn.getContent(), new FileOutputStream(newLucee));
            conn.disconnect();
            File tmp = CFMLEngineFactory.extractCoreIfLoader(newLucee);
            if (tmp != null) {
                this.log(4, "Extract core from loader");
                newLucee.delete();
                tmp.renameTo(newLucee);
                tmp.delete();
            }
        } else {
            conn.disconnect();
            this.log(4, "File for new Version already exists, won't copy new one");
            return null;
        }
        return newLucee;
    }

    public static File extractCoreIfLoader(File file) {
        try {
            return CFMLEngineFactory._extractCoreIfLoader(file);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File _extractCoreIfLoader(File file) throws IOException {
        try (JarFile jf = new JarFile(file);){
            String value = jf.getManifest().getMainAttributes().getValue("Main-Class");
            if (Util.isEmpty(value) || !value.equals("lucee.runtime.script.Main")) {
                File file2 = null;
                return file2;
            }
            JarEntry je = jf.getJarEntry("core/core.lco");
            if (je == null) {
                File file3 = null;
                return file3;
            }
            InputStream is = jf.getInputStream(je);
            File trg = File.createTempFile("lucee", ".lco");
            FileOutputStream os = new FileOutputStream(trg);
            try {
                Util.copy(is, os);
            }
            finally {
                Util.closeEL(is);
                Util.closeEL(os);
            }
            File file4 = trg;
            return file4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getUpdateLocation() throws MalformedURLException {
        URL location;
        URL uRL = location = singelton == null ? null : singelton.getUpdateLocation();
        if (location == null) {
            InputStream is = null;
            try {
                File xml = new File(this.getResourceRoot(), "context/lucee-server.xml");
                if (xml.exists() || xml.length() > 0L) {
                    DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                    Document doc = dBuilder.parse(xml);
                    Element root = doc.getDocumentElement();
                    NodeList children = root.getChildNodes();
                    for (int i = children.getLength() - 1; i >= 0; --i) {
                        String loc;
                        Node node = children.item(i);
                        if (node.getNodeType() != 1 || !node.getNodeName().equals("update") || Util.isEmpty(loc = ((Element)node).getAttribute("location"))) continue;
                        location = new URL(loc);
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                CFMLEngineFactorySupport.closeEL(is);
            }
        }
        if (location == null) {
            location = new URL(UPDATE_LOCATION);
        }
        return location;
    }

    public boolean removeUpdate(Password password) throws IOException, ServletException {
        if (!singelton.can(0, password)) {
            throw new IOException("Access denied to update CFMLEngine");
        }
        return this.removeUpdate();
    }

    public boolean removeLatestUpdate(Password password) throws IOException, ServletException {
        if (!singelton.can(0, password)) {
            throw new IOException("Access denied to update CFMLEngine");
        }
        return this.removeLatestUpdate();
    }

    private boolean removeUpdate() throws IOException, ServletException {
        File[] patches;
        File patchDir = this.getPatchDirectory();
        for (File element : patches = patchDir.listFiles(new ExtensionFilter(new String[]{"rc", "rcs"}))) {
            if (element.delete()) continue;
            element.deleteOnExit();
        }
        this._restart();
        return true;
    }

    private boolean removeLatestUpdate() throws IOException, ServletException {
        File patchDir = this.getPatchDirectory();
        File[] patches = patchDir.listFiles(new ExtensionFilter(new String[]{".lco"}));
        File patch = null;
        for (File patche : patches) {
            if (patch != null && !Util.isNewerThan(CFMLEngineFactory.toVersion(patche.getName(), VERSION_ZERO), CFMLEngineFactory.toVersion(patch.getName(), VERSION_ZERO))) continue;
            patch = patche;
        }
        if (patch != null && !patch.delete()) {
            patch.deleteOnExit();
        }
        this._restart();
        return true;
    }

    public String[] getInstalledPatches() throws ServletException, IOException {
        File patchDir = this.getPatchDirectory();
        File[] patches = patchDir.listFiles(new ExtensionFilter(new String[]{".lco"}));
        ArrayList<String> list = new ArrayList<String>();
        int extLen = "rc".length() + 1;
        for (File patche : patches) {
            String name = patche.getName();
            name = name.substring(0, name.length() - extLen);
            list.add(name);
        }
        Object[] arr = list.toArray(new String[list.size()]);
        Arrays.sort(arr);
        return arr;
    }

    private void callListeners(CFMLEngine engine) {
        Iterator<EngineChangeListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().onUpdate();
        }
    }

    public File getPatchDirectory() throws IOException {
        File pd = this.getDirectoryByPropOrEnv("lucee.patches.dir");
        if (pd != null) {
            return pd;
        }
        pd = new File(this.getResourceRoot(), "patches");
        if (!pd.exists()) {
            pd.mkdirs();
        }
        return pd;
    }

    public File getBundleDirectory() throws IOException {
        File bd = this.getDirectoryByPropOrEnv("lucee.bundles.dir");
        if (bd != null) {
            return bd;
        }
        bd = new File(this.getResourceRoot(), "bundles");
        if (!bd.exists()) {
            bd.mkdirs();
        }
        return bd;
    }

    public File getFelixCacheDirectory() throws IOException {
        return this.getResourceRoot();
    }

    public File getResourceRoot() throws IOException {
        if (this.resourceRoot == null) {
            this.resourceRoot = new File(this._getResourceRoot(), "lucee-server");
            if (!this.resourceRoot.exists()) {
                this.resourceRoot.mkdirs();
            }
        }
        return this.resourceRoot;
    }

    private File _getResourceRoot() throws IOException {
        File classicDir;
        File webInf;
        if (luceeServerRoot == null) {
            this.readInitParam(this.config);
        }
        if (luceeServerRoot != null) {
            return luceeServerRoot;
        }
        File lbd = this.getDirectoryByPropOrEnv("lucee.base.dir");
        File root = lbd;
        if (root == null) {
            root = this.getDirectoryByProp("jboss.server.home.dir");
        }
        if (root == null) {
            root = this.getDirectoryByProp("jonas.base");
        }
        if (root == null) {
            root = this.getDirectoryByProp("catalina.base");
        }
        if (root == null) {
            root = this.getDirectoryByProp("jetty.home");
        }
        if (root == null) {
            root = this.getDirectoryByProp("org.apache.geronimo.base.dir");
        }
        if (root == null) {
            root = this.getDirectoryByProp("com.sun.aas.instanceRoot");
        }
        if (root == null) {
            root = this.getDirectoryByProp("env.DOMAIN_HOME");
        }
        if (root == null) {
            root = CFMLEngineFactory.getClassLoaderRoot(this.mainClassLoader).getParentFile().getParentFile();
        }
        File classicRoot = CFMLEngineFactory.getClassLoaderRoot(this.mainClassLoader);
        if (lbd == null && (webInf = CFMLEngineFactory.getWebInfFolder(classicRoot)) != null) {
            root = webInf;
            if (!root.exists()) {
                root.mkdir();
            }
            this.log(4, "war-root-directory:" + root);
        }
        this.log(4, "root-directory:" + root);
        if (root == null) {
            throw new IOException("Can't locate the root of the servlet container, please define a location (physical path) for the server configuration with help of the servlet init param [lucee-server-directory] in the web.xml where the Lucee Servlet is defined or the system property [lucee.base.dir].");
        }
        File modernDir = new File(root, "lucee-server");
        this.log(4, "classic-root-directory:" + classicRoot);
        boolean had = false;
        if (classicRoot.isDirectory() && (classicDir = new File(classicRoot, "lucee-server")).isDirectory()) {
            this.log(4, "had lucee-server classic" + classicDir);
            this.moveContent(classicDir, modernDir);
            had = true;
        }
        if (!had && classicRoot.isDirectory() && (classicDir = new File(classicRoot, "railo-server")).isDirectory()) {
            this.log(4, "Had railo-server classic" + classicDir);
            CFMLEngineFactory.copyRecursiveAndRename(classicDir, modernDir);
            try {
                ZipUtil.zip(classicDir, new File(root, "railo-server-context-old.zip"));
                Util.delete(classicDir);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return root;
    }

    private static File getWebInfFolder(File file) {
        while (file != null && !file.getName().equals("WEB-INF")) {
            File parent = file.getParentFile();
            if (file.equals(parent)) {
                return null;
            }
            file = parent;
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyRecursiveAndRename(File src, File trg) throws IOException {
        if (!src.exists()) {
            return;
        }
        if (src.isDirectory()) {
            File[] files;
            if (!trg.exists()) {
                trg.mkdirs();
            }
            for (File file : files = src.listFiles()) {
                CFMLEngineFactory.copyRecursiveAndRename(file, new File(trg, file.getName()));
            }
        } else if (src.isFile()) {
            if (trg.getName().endsWith(".rc") || trg.getName().startsWith(".")) {
                return;
            }
            if (trg.getName().equals("railo-server.xml")) {
                trg = new File(trg.getParentFile(), "lucee-server.xml");
                FileInputStream is = new FileInputStream(src);
                FileOutputStream os = new FileOutputStream(trg);
                try {
                    String str = Util.toString(is);
                    str = str.replace("<cfRailoConfiguration", "<!-- copy from Railo context --><cfLuceeConfiguration");
                    str = str.replace("</cfRailoConfiguration", "</cfLuceeConfiguration");
                    str = str.replace("<railo-configuration", "<!-- copy from Railo context --><cfLuceeConfiguration");
                    str = str.replace("</railo-configuration", "</cfLuceeConfiguration");
                    str = str.replace("{railo-config}", "{lucee-config}");
                    str = str.replace("{railo-server}", "{lucee-server}");
                    str = str.replace("{railo-web}", "{lucee-web}");
                    str = str.replace("\"railo.commons.", "\"lucee.commons.");
                    str = str.replace("\"railo.runtime.", "\"lucee.runtime.");
                    str = str.replace("\"railo.cfx.", "\"lucee.cfx.");
                    str = str.replace("/railo-context.ra", "/lucee-context.lar");
                    str = str.replace("/railo-context", "/lucee");
                    str = str.replace("railo-server-context", "lucee-server");
                    str = str.replace("http://www.getrailo.org", "https://release.lucee.org");
                    str = str.replace("http://www.getrailo.com", "https://release.lucee.org");
                    ByteArrayInputStream bais = new ByteArrayInputStream(str.getBytes());
                    try {
                        Util.copy(bais, os);
                        bais.close();
                    }
                    finally {
                        Util.closeEL(is, os);
                    }
                }
                finally {
                    Util.closeEL(is, os);
                }
                return;
            }
            FileInputStream is = new FileInputStream(src);
            FileOutputStream os = new FileOutputStream(trg);
            try {
                Util.copy(is, os);
            }
            finally {
                Util.closeEL(is, os);
            }
        }
    }

    private void moveContent(File src, File trg) throws IOException {
        if (src.isDirectory()) {
            File[] children = src.listFiles();
            if (children != null) {
                for (File element : children) {
                    this.moveContent(element, new File(trg, element.getName()));
                }
            }
            src.delete();
        } else if (src.isFile()) {
            trg.getParentFile().mkdirs();
            src.renameTo(trg);
        }
    }

    private File getDirectoryByPropOrEnv(String name) {
        File file = this.getDirectoryByProp(name);
        if (file != null) {
            return file;
        }
        return this.getDirectoryByEnv(name);
    }

    private File getDirectoryByProp(String name) {
        return this._getDirectoryBy(System.getProperty(name));
    }

    private File getDirectoryByEnv(String name) {
        return this._getDirectoryBy(System.getenv(name));
    }

    private File _getDirectoryBy(String value) {
        if (Util.isEmpty(value, true)) {
            return null;
        }
        File dir = new File(value);
        dir.mkdirs();
        if (dir.isDirectory()) {
            return dir;
        }
        return null;
    }

    public static File getClassLoaderRoot(ClassLoader cl) {
        File file;
        String path = "lucee/loader/engine/CFMLEngine.class";
        URL res = cl.getResource("lucee/loader/engine/CFMLEngine.class");
        if (res == null) {
            return null;
        }
        String strFile = null;
        try {
            strFile = URLDecoder.decode(res.getFile().trim(), "iso-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        int index = strFile.indexOf(33);
        if (index != -1) {
            strFile = strFile.substring(0, index);
        }
        if ((index = strFile.lastIndexOf("lucee/loader/engine/CFMLEngine.class")) != -1) {
            strFile = strFile.substring(0, index);
        }
        if (strFile.startsWith("file:")) {
            strFile = strFile.substring(5);
        }
        if (strFile.endsWith("lucee.jar")) {
            strFile = strFile.substring(0, strFile.length() - 9);
        }
        if ((file = new File(strFile)).isFile()) {
            file = file.getParentFile();
        }
        return file;
    }

    private CFMLEngine getEngine(BundleCollection bc) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.log(4, "state: " + BundleUtil.bundleState(bc.core.getState(), ""));
        this.log(4, "org.osgi.framework.bootdelegation:" + bc.getBundleContext().getProperty("org.osgi.framework.bootdelegation"));
        this.log(4, "felix.cache.rootdir: " + bc.getBundleContext().getProperty("felix.cache.rootdir"));
        Class<?> clazz = bc.core.loadClass("lucee.runtime.engine.CFMLEngineImpl");
        this.log(4, "class:" + clazz.getName());
        Method m = clazz.getMethod("getInstance", CFMLEngineFactory.class, BundleCollection.class);
        return (CFMLEngine)m.invoke(null, this, bc);
    }

    public Logger getLogger() {
        return this.logger;
    }
}

