/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.cpu;

import org.graalvm.visualvm.lib.jfluid.results.cpu.CPUResultsDiff;
import org.graalvm.visualvm.lib.jfluid.utils.StringUtils;
import org.graalvm.visualvm.lib.ui.components.table.DiffBarCellRenderer;
import org.graalvm.visualvm.lib.ui.components.table.LabelTableCellRenderer;
import org.graalvm.visualvm.lib.ui.cpu.CCTDisplay;
import org.graalvm.visualvm.lib.ui.cpu.CPUResUserActionsHandler;

public class DiffCCTDisplay
extends CCTDisplay {
    public DiffCCTDisplay(CPUResUserActionsHandler actionsHandler, Boolean sampling) {
        super(actionsHandler, sampling);
    }

    @Override
    protected boolean supportsReverseCallGraph() {
        return false;
    }

    @Override
    protected boolean supportsSubtreeCallGraph() {
        return false;
    }

    @Override
    protected Float getNodeTimeRel(long time, float percent) {
        return new Float(time);
    }

    @Override
    protected String getNodeTime(long time, float percent) {
        return this.getNodeSecondaryTime(time);
    }

    @Override
    protected String getNodeSecondaryTime(long time) {
        return (time > 0L ? "+" : "") + StringUtils.mcsTimeToString((long)time) + " ms";
    }

    @Override
    protected String getNodeInvocations(int nCalls) {
        return (nCalls > 0 ? "+" : "") + Integer.toString(nCalls);
    }

    @Override
    protected void initColumnsData() {
        super.initColumnsData();
        this.columnRenderers[1] = new DiffBarCellRenderer(0L, 0L);
        this.columnRenderers[2] = new LabelTableCellRenderer(11);
    }

    @Override
    public void prepareResults() {
        super.prepareResults();
        DiffBarCellRenderer renderer = (DiffBarCellRenderer)this.columnRenderers[1];
        long bound = ((CPUResultsDiff)this.snapshot).getBound(this.currentView);
        renderer.setMinimum(-bound);
        renderer.setMaximum(bound);
    }
}

