/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ltr.transport;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.opensearch.action.support.nodes.BaseNodesRequest;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

public class LTRStatsRequest
extends BaseNodesRequest<LTRStatsRequest> {
    public static final String ALL_STATS_KEY = "_all";
    private final Set<String> statsToBeRetrieved;

    public LTRStatsRequest(StreamInput in) throws IOException {
        super(in);
        this.statsToBeRetrieved = in.readSet(StreamInput::readString);
    }

    public LTRStatsRequest(String ... nodeIds) {
        super(nodeIds);
        this.statsToBeRetrieved = new HashSet<String>();
    }

    public void addStat(String stat) {
        this.statsToBeRetrieved.add(stat);
    }

    public void addAll(Set<String> statsToBeAdded) {
        this.statsToBeRetrieved.addAll(statsToBeAdded);
    }

    public void clear() {
        this.statsToBeRetrieved.clear();
    }

    public Set<String> getStatsToBeRetrieved() {
        return this.statsToBeRetrieved;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringCollection(this.statsToBeRetrieved);
    }
}

