/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.feature.store;

import com.o19s.es.ltr.feature.FeatureSet;
import com.o19s.es.ltr.feature.store.CompiledLtrModel;
import com.o19s.es.ltr.feature.store.FeatureNormDefinition;
import com.o19s.es.ltr.feature.store.StorableElement;
import com.o19s.es.ltr.feature.store.StoredFeatureNormalizers;
import com.o19s.es.ltr.feature.store.StoredFeatureSet;
import com.o19s.es.ltr.ranker.LtrRanker;
import com.o19s.es.ltr.ranker.normalizer.FeatureNormalizingRanker;
import com.o19s.es.ltr.ranker.normalizer.Normalizer;
import com.o19s.es.ltr.ranker.parser.LtrRankerParser;
import com.o19s.es.ltr.ranker.parser.LtrRankerParserFactory;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class StoredLtrModel
implements StorableElement {
    public static final String TYPE = "model";
    private static final ObjectParser<ParsingState, Void> PARSER;
    private static final ParseField NAME;
    private static final ParseField FEATURE_SET;
    private static final ParseField MODEL;
    private final String name;
    private final StoredFeatureSet featureSet;
    private final String rankingModelType;
    private final String rankingModel;
    private final boolean modelAsString;
    private final StoredFeatureNormalizers parsedFtrNorms;

    public StoredLtrModel(String name, StoredFeatureSet featureSet, LtrModelDefinition definition) {
        this(name, featureSet, definition.type, definition.definition, definition.modelAsString, definition.featureNormalizers);
    }

    public StoredLtrModel(String name, StoredFeatureSet featureSet, String rankingModelType, String rankingModel, boolean modelAsString, StoredFeatureNormalizers featureNormalizerSet) {
        this.name = Objects.requireNonNull(name);
        this.featureSet = Objects.requireNonNull(featureSet);
        this.rankingModelType = Objects.requireNonNull(rankingModelType);
        this.rankingModel = Objects.requireNonNull(rankingModel);
        this.modelAsString = modelAsString;
        this.parsedFtrNorms = featureNormalizerSet;
    }

    public StoredLtrModel(StreamInput input) throws IOException {
        this.name = input.readString();
        this.featureSet = new StoredFeatureSet(input);
        this.rankingModelType = input.readString();
        this.rankingModel = input.readString();
        this.modelAsString = input.readBoolean();
        this.parsedFtrNorms = new StoredFeatureNormalizers(input);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        this.featureSet.writeTo(out);
        out.writeString(this.rankingModelType);
        out.writeString(this.rankingModel);
        out.writeBoolean(this.modelAsString);
        this.parsedFtrNorms.writeTo(out);
    }

    public static StoredLtrModel parse(XContentParser parser) {
        return StoredLtrModel.parse(parser, null);
    }

    public static StoredLtrModel parse(XContentParser parser, String name) {
        try {
            ParsingState state = (ParsingState)PARSER.apply(parser, null);
            state.resolveName(parser, name);
            if (state.featureSet == null) {
                throw new ParsingException(parser.getTokenLocation(), "Field [feature_set] is mandatory", new Object[0]);
            }
            if (state.rankingModel == null) {
                throw new ParsingException(parser.getTokenLocation(), "Field [model] is mandatory", new Object[0]);
            }
            return new StoredLtrModel(state.getName(), state.featureSet, state.rankingModel);
        }
        catch (IllegalArgumentException iae) {
            throw new ParsingException(parser.getTokenLocation(), iae.getMessage(), (Throwable)iae, new Object[0]);
        }
    }

    public CompiledLtrModel compile(LtrRankerParserFactory factory) throws IOException {
        LtrRankerParser modelParser = factory.getParser(this.rankingModelType);
        FeatureSet optimized = this.featureSet.optimize();
        LtrRanker ranker = modelParser.parse(optimized, this.rankingModel);
        Map<Integer, Normalizer> ordToNorms = this.parsedFtrNorms.compileOrdToNorms(optimized);
        if (ordToNorms.size() > 0) {
            ranker = new FeatureNormalizingRanker(ranker, ordToNorms);
        }
        return new CompiledLtrModel(this.name, optimized, ranker);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public boolean updatable() {
        return false;
    }

    public StoredFeatureSet featureSet() {
        return this.featureSet;
    }

    public String rankingModelType() {
        return this.rankingModelType;
    }

    public String rankingModel() {
        return this.rankingModel;
    }

    public StoredFeatureNormalizers getFeatureNormalizers() {
        return this.parsedFtrNorms;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NAME.getPreferredName(), this.name);
        builder.field(FEATURE_SET.getPreferredName());
        this.featureSet.toXContent(builder, params);
        builder.startObject(MODEL.getPreferredName());
        builder.field(LtrModelDefinition.MODEL_TYPE.getPreferredName(), this.rankingModelType);
        builder.field(LtrModelDefinition.MODEL_DEFINITION.getPreferredName());
        if (this.modelAsString) {
            builder.value(this.rankingModel);
        } else {
            try (XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, this.rankingModel);){
                builder.copyCurrentStructure(parser);
            }
        }
        builder.field(LtrModelDefinition.FEATURE_NORMALIZERS.getPreferredName());
        this.parsedFtrNorms.toXContent(builder, params);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StoredLtrModel)) {
            return false;
        }
        StoredLtrModel that = (StoredLtrModel)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.featureSet.equals(that.featureSet)) {
            return false;
        }
        if (!this.rankingModelType.equals(that.rankingModelType)) {
            return false;
        }
        if (!this.parsedFtrNorms.equals(that.parsedFtrNorms)) {
            return false;
        }
        return this.rankingModel.equals(that.rankingModel);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.featureSet.hashCode();
        result = 31 * result + this.rankingModelType.hashCode();
        result = 31 * result + this.rankingModel.hashCode();
        result = 31 * result + this.parsedFtrNorms.hashCode();
        return result;
    }

    static {
        NAME = new ParseField("name", new String[0]);
        FEATURE_SET = new ParseField("feature_set", new String[0]);
        MODEL = new ParseField(TYPE, new String[0]);
        PARSER = new ObjectParser(TYPE, () -> new ParsingState());
        PARSER.declareString(StorableElement.StorableElementParserState::setName, NAME);
        PARSER.declareObject(ParsingState::setFeatureSet, (parser, ctx) -> StoredFeatureSet.parse(parser), FEATURE_SET);
        PARSER.declareObject(ParsingState::setRankingModel, LtrModelDefinition.PARSER, MODEL);
    }

    public static class LtrModelDefinition
    implements Writeable {
        private String type;
        private String definition;
        private StoredFeatureNormalizers featureNormalizers;
        private boolean modelAsString;
        public static final ObjectParser<LtrModelDefinition, Void> PARSER;
        private static final ParseField MODEL_TYPE;
        private static final ParseField MODEL_DEFINITION;
        private static final ParseField FEATURE_NORMALIZERS;

        private LtrModelDefinition() {
            this.featureNormalizers = new StoredFeatureNormalizers();
        }

        public LtrModelDefinition(String type, String definition, boolean modelAsString) {
            this.type = type;
            this.definition = definition;
            this.modelAsString = modelAsString;
            this.featureNormalizers = new StoredFeatureNormalizers();
        }

        public LtrModelDefinition(StreamInput in) throws IOException {
            this.type = in.readString();
            this.definition = in.readString();
            this.modelAsString = in.readBoolean();
            this.featureNormalizers = new StoredFeatureNormalizers(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.type);
            out.writeString(this.definition);
            out.writeBoolean(this.modelAsString);
            this.featureNormalizers.writeTo(out);
        }

        private void setType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public void setNamedFeatureNormalizers(List<FeatureNormDefinition> featureNormalizers) {
            this.featureNormalizers = new StoredFeatureNormalizers(featureNormalizers);
        }

        public String getDefinition() {
            return this.definition;
        }

        public boolean isModelAsString() {
            return this.modelAsString;
        }

        public StoredFeatureNormalizers getFtrNorms() {
            return this.featureNormalizers;
        }

        public static LtrModelDefinition parse(XContentParser parser, Void ctx) throws IOException {
            LtrModelDefinition def = (LtrModelDefinition)PARSER.parse(parser, (Object)ctx);
            if (def.type == null) {
                throw new ParsingException(parser.getTokenLocation(), "Field [model.type] is mandatory", new Object[0]);
            }
            if (def.definition == null) {
                throw new ParsingException(parser.getTokenLocation(), "Field [model.definition] is mandatory", new Object[0]);
            }
            return def;
        }

        private void parseModel(XContentParser parser) throws IOException {
            if (parser.currentToken() == XContentParser.Token.VALUE_STRING) {
                this.modelAsString = true;
                this.definition = parser.text();
            } else {
                try (XContentBuilder builder = JsonXContent.contentBuilder();){
                    builder.copyCurrentStructure(parser);
                    this.modelAsString = false;
                    this.definition = builder.toString();
                }
            }
        }

        static {
            MODEL_TYPE = new ParseField("type", new String[0]);
            MODEL_DEFINITION = new ParseField("definition", new String[0]);
            FEATURE_NORMALIZERS = new ParseField("feature_normalizers", new String[0]);
            PARSER = new ObjectParser(StoredLtrModel.TYPE, LtrModelDefinition::new);
            PARSER.declareString(LtrModelDefinition::setType, MODEL_TYPE);
            PARSER.declareField((p, d, c) -> d.parseModel(p), MODEL_DEFINITION, ObjectParser.ValueType.OBJECT_ARRAY_OR_STRING);
            PARSER.declareNamedObjects(LtrModelDefinition::setNamedFeatureNormalizers, StoredFeatureNormalizers.PARSER, FEATURE_NORMALIZERS);
        }
    }

    private static class ParsingState
    extends StorableElement.StorableElementParserState {
        StoredFeatureSet featureSet;
        LtrModelDefinition rankingModel;

        private ParsingState() {
        }

        void setFeatureSet(StoredFeatureSet featureSet) {
            this.featureSet = featureSet;
        }

        void setRankingModel(LtrModelDefinition rankingModel) {
            this.rankingModel = rankingModel;
        }
    }
}

