/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.plugin;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.client.Client;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.FeatureFlags;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.env.Environment;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.ingest.Processor;
import org.opensearch.ml.client.MachineLearningNodeClient;
import org.opensearch.neuralsearch.executors.HybridQueryExecutor;
import org.opensearch.neuralsearch.ml.MLCommonsClientAccessor;
import org.opensearch.neuralsearch.processor.NeuralQueryEnricherProcessor;
import org.opensearch.neuralsearch.processor.NeuralSparseTwoPhaseProcessor;
import org.opensearch.neuralsearch.processor.NormalizationProcessorWorkflow;
import org.opensearch.neuralsearch.processor.combination.ScoreCombinationFactory;
import org.opensearch.neuralsearch.processor.combination.ScoreCombiner;
import org.opensearch.neuralsearch.processor.factory.ExplanationResponseProcessorFactory;
import org.opensearch.neuralsearch.processor.factory.NormalizationProcessorFactory;
import org.opensearch.neuralsearch.processor.factory.RRFProcessorFactory;
import org.opensearch.neuralsearch.processor.factory.RerankProcessorFactory;
import org.opensearch.neuralsearch.processor.factory.SparseEncodingProcessorFactory;
import org.opensearch.neuralsearch.processor.factory.TextChunkingProcessorFactory;
import org.opensearch.neuralsearch.processor.factory.TextEmbeddingProcessorFactory;
import org.opensearch.neuralsearch.processor.factory.TextImageEmbeddingProcessorFactory;
import org.opensearch.neuralsearch.processor.normalization.ScoreNormalizationFactory;
import org.opensearch.neuralsearch.processor.normalization.ScoreNormalizer;
import org.opensearch.neuralsearch.query.HybridQueryBuilder;
import org.opensearch.neuralsearch.query.NeuralQueryBuilder;
import org.opensearch.neuralsearch.query.NeuralSparseQueryBuilder;
import org.opensearch.neuralsearch.query.ext.RerankSearchExtBuilder;
import org.opensearch.neuralsearch.search.query.HybridQueryPhaseSearcher;
import org.opensearch.neuralsearch.settings.NeuralSearchSettings;
import org.opensearch.neuralsearch.util.NeuralSearchClusterUtil;
import org.opensearch.plugins.ActionPlugin;
import org.opensearch.plugins.ExtensiblePlugin;
import org.opensearch.plugins.IngestPlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.plugins.SearchPipelinePlugin;
import org.opensearch.plugins.SearchPlugin;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.script.ScriptService;
import org.opensearch.search.pipeline.Processor;
import org.opensearch.search.pipeline.SearchPhaseResultsProcessor;
import org.opensearch.search.pipeline.SearchRequestProcessor;
import org.opensearch.search.pipeline.SearchResponseProcessor;
import org.opensearch.search.query.QueryPhaseSearcher;
import org.opensearch.threadpool.ExecutorBuilder;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.watcher.ResourceWatcherService;

public class NeuralSearch
extends Plugin
implements ActionPlugin,
SearchPlugin,
IngestPlugin,
ExtensiblePlugin,
SearchPipelinePlugin {
    @Generated
    private static final Logger log = LogManager.getLogger(NeuralSearch.class);
    private MLCommonsClientAccessor clientAccessor;
    private NormalizationProcessorWorkflow normalizationProcessorWorkflow;
    private final ScoreNormalizationFactory scoreNormalizationFactory = new ScoreNormalizationFactory();
    private final ScoreCombinationFactory scoreCombinationFactory = new ScoreCombinationFactory();
    public static final String EXPLANATION_RESPONSE_KEY = "explanation_response";

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        NeuralSearchClusterUtil.instance().initialize(clusterService);
        NeuralQueryBuilder.initialize(this.clientAccessor);
        NeuralSparseQueryBuilder.initialize(this.clientAccessor);
        HybridQueryExecutor.initialize(threadPool);
        this.normalizationProcessorWorkflow = new NormalizationProcessorWorkflow(new ScoreNormalizer(), new ScoreCombiner());
        return List.of(this.clientAccessor);
    }

    public List<SearchPlugin.QuerySpec<?>> getQueries() {
        return Arrays.asList(new SearchPlugin.QuerySpec("neural", NeuralQueryBuilder::new, NeuralQueryBuilder::fromXContent), new SearchPlugin.QuerySpec("hybrid", HybridQueryBuilder::new, HybridQueryBuilder::fromXContent), new SearchPlugin.QuerySpec("neural_sparse", NeuralSparseQueryBuilder::new, NeuralSparseQueryBuilder::fromXContent));
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        return List.of(HybridQueryExecutor.getExecutorBuilder(settings));
    }

    public Map<String, Processor.Factory> getProcessors(Processor.Parameters parameters) {
        this.clientAccessor = new MLCommonsClientAccessor(new MachineLearningNodeClient(parameters.client));
        return Map.of("text_embedding", new TextEmbeddingProcessorFactory(this.clientAccessor, parameters.env, parameters.ingestService.getClusterService()), "sparse_encoding", new SparseEncodingProcessorFactory(this.clientAccessor, parameters.env, parameters.ingestService.getClusterService()), "text_image_embedding", new TextImageEmbeddingProcessorFactory(this.clientAccessor, parameters.env, parameters.ingestService.getClusterService()), "text_chunking", new TextChunkingProcessorFactory(parameters.env, parameters.ingestService.getClusterService(), parameters.analysisRegistry));
    }

    public Optional<QueryPhaseSearcher> getQueryPhaseSearcher() {
        if (FeatureFlags.isEnabled((String)NeuralSearchSettings.NEURAL_SEARCH_HYBRID_SEARCH_DISABLED.getKey())) {
            log.info("Not registering hybrid query phase searcher because feature flag [{}] is disabled", (Object)NeuralSearchSettings.NEURAL_SEARCH_HYBRID_SEARCH_DISABLED.getKey());
            return Optional.empty();
        }
        log.info("Registering hybrid query phase searcher with feature flag [{}]", (Object)NeuralSearchSettings.NEURAL_SEARCH_HYBRID_SEARCH_DISABLED.getKey());
        return Optional.of(new HybridQueryPhaseSearcher());
    }

    public Map<String, Processor.Factory<SearchPhaseResultsProcessor>> getSearchPhaseResultsProcessors(SearchPipelinePlugin.Parameters parameters) {
        return Map.of("normalization-processor", new NormalizationProcessorFactory(this.normalizationProcessorWorkflow, this.scoreNormalizationFactory, this.scoreCombinationFactory), "score-ranker-processor", new RRFProcessorFactory(this.normalizationProcessorWorkflow, this.scoreNormalizationFactory, this.scoreCombinationFactory));
    }

    public List<Setting<?>> getSettings() {
        return List.of(NeuralSearchSettings.NEURAL_SEARCH_HYBRID_SEARCH_DISABLED, NeuralSearchSettings.RERANKER_MAX_DOC_FIELDS);
    }

    public Map<String, Processor.Factory<SearchRequestProcessor>> getRequestProcessors(SearchPipelinePlugin.Parameters parameters) {
        return Map.of("neural_query_enricher", new NeuralQueryEnricherProcessor.Factory(), "neural_sparse_two_phase_processor", new NeuralSparseTwoPhaseProcessor.Factory());
    }

    public Map<String, Processor.Factory<SearchResponseProcessor>> getResponseProcessors(SearchPipelinePlugin.Parameters parameters) {
        return Map.of("rerank", new RerankProcessorFactory(this.clientAccessor, parameters.searchPipelineService.getClusterService()), "hybrid_score_explanation", new ExplanationResponseProcessorFactory());
    }

    public List<SearchPlugin.SearchExtSpec<?>> getSearchExts() {
        return List.of(new SearchPlugin.SearchExtSpec("rerank", in -> new RerankSearchExtBuilder(in), parser -> RerankSearchExtBuilder.parse(parser)));
    }
}

