/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dlic.auth.http.saml;

import com.amazon.dlic.auth.http.jwt.AbstractHTTPJwtAuthenticator;
import com.amazon.dlic.auth.http.jwt.keybyoidc.AuthenticatorUnavailableException;
import com.amazon.dlic.auth.http.jwt.keybyoidc.BadCredentialsException;
import com.amazon.dlic.auth.http.jwt.keybyoidc.KeyProvider;
import com.amazon.dlic.auth.http.saml.AuthTokenProcessorHandler;
import com.amazon.dlic.auth.http.saml.Saml2SettingsProvider;
import com.amazon.dlic.auth.http.saml.SamlFilesystemMetadataResolver;
import com.amazon.dlic.auth.http.saml.SamlHTTPMetadataResolver;
import com.amazon.dlic.auth.http.saml.SamlNameIdFormat;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.nimbusds.jose.jwk.JWK;
import com.onelogin.saml2.authn.AuthnRequest;
import com.onelogin.saml2.logout.LogoutRequest;
import com.onelogin.saml2.settings.Saml2Settings;
import com.onelogin.saml2.util.Util;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.config.InitializationService;
import org.opensaml.core.config.Initializer;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.AbstractMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.DOMMetadataResolver;
import org.opensaml.xmlsec.config.impl.XMLObjectProviderInitializer;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.SpecialPermission;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.rest.RestRequest;
import org.opensearch.security.auth.Destroyable;
import org.opensearch.security.auth.HTTPAuthenticator;
import org.opensearch.security.filter.OpenSearchRequest;
import org.opensearch.security.filter.SecurityRequest;
import org.opensearch.security.filter.SecurityRequestChannelUnsupported;
import org.opensearch.security.filter.SecurityResponse;
import org.opensearch.security.opensaml.integration.SecurityXMLObjectProviderInitializer;
import org.opensearch.security.support.PemKeyReader;
import org.opensearch.security.user.AuthCredentials;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class HTTPSamlAuthenticator
implements HTTPAuthenticator,
Destroyable {
    protected static final Logger log = LogManager.getLogger(HTTPSamlAuthenticator.class);
    public static final String IDP_METADATA_URL = "idp.metadata_url";
    public static final String IDP_METADATA_FILE = "idp.metadata_file";
    public static final String IDP_METADATA_CONTENT = "idp.metadata_content";
    public static final String API_AUTHTOKEN_SUFFIX = "api/authtoken";
    private static final String AUTHINFO_SUFFIX = "authinfo";
    private static final String REGEX_PATH_PREFIX = "/(_opendistro/_security|_plugins/_security)/(.*)";
    private static final Pattern PATTERN_PATH_PREFIX = Pattern.compile("/(_opendistro/_security|_plugins/_security)/(.*)");
    private static boolean openSamlInitialized = false;
    public static final String SAML_TYPE = "saml";
    private String subjectKey;
    private String rolesKey;
    private String kibanaRootUrl;
    private String spSignatureAlgorithm;
    private Boolean useForceAuthn;
    private PrivateKey spSignaturePrivateKey;
    private Saml2SettingsProvider saml2SettingsProvider;
    private MetadataResolver metadataResolver;
    private AuthTokenProcessorHandler authTokenProcessorHandler;
    @VisibleForTesting
    protected HTTPJwtAuthenticator httpJwtAuthenticator;
    private Settings jwtSettings;
    private static int resolverIdCounter = 0;

    public HTTPSamlAuthenticator(Settings settings, Path configPath) {
        try {
            HTTPSamlAuthenticator.ensureOpenSamlInitialization();
            this.rolesKey = settings.get("roles_key");
            this.subjectKey = settings.get("subject_key");
            this.kibanaRootUrl = settings.get("kibana_url");
            this.spSignatureAlgorithm = settings.get("sp.signature_algorithm", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
            this.spSignaturePrivateKey = this.getSpSignaturePrivateKey(settings, configPath);
            this.useForceAuthn = settings.getAsBoolean("sp.forceAuthn", null);
            if (this.rolesKey == null || this.rolesKey.isEmpty()) {
                log.warn("roles_key is not configured, will only extract subject from SAML");
                this.rolesKey = null;
            }
            if (this.subjectKey == null || this.subjectKey.isEmpty()) {
                this.subjectKey = null;
            }
            if (this.kibanaRootUrl == null) {
                throw new Exception("kibana_url is unconfigured");
            }
            this.metadataResolver = this.createMetadataResolver(settings, configPath);
            this.saml2SettingsProvider = new Saml2SettingsProvider(settings, this.metadataResolver, this.spSignaturePrivateKey);
            try {
                this.saml2SettingsProvider.getCached();
            }
            catch (Exception e) {
                log.debug("Exception while initializing Saml2SettingsProvider. Possibly, the IdP is unreachable right now. This is recoverable by a meta data refresh.", (Throwable)e);
            }
            this.jwtSettings = this.createJwtAuthenticatorSettings(settings);
            this.authTokenProcessorHandler = new AuthTokenProcessorHandler(settings, this.jwtSettings, this.saml2SettingsProvider);
            this.httpJwtAuthenticator = new HTTPJwtAuthenticator(this.jwtSettings, configPath);
        }
        catch (Exception e) {
            log.error("Error creating HTTPSamlAuthenticator. SAML authentication will not work", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public AuthCredentials extractCredentials(SecurityRequest request, ThreadContext threadContext) throws OpenSearchSecurityException {
        String suffix;
        Matcher matcher = PATTERN_PATH_PREFIX.matcher(request.path());
        String string = suffix = matcher.matches() ? matcher.group(2) : null;
        if (API_AUTHTOKEN_SUFFIX.equals(suffix)) {
            return null;
        }
        AuthCredentials authCredentials = this.httpJwtAuthenticator.extractCredentials(request, threadContext);
        if (AUTHINFO_SUFFIX.equals(suffix)) {
            this.initLogoutUrl(threadContext, authCredentials);
        }
        return authCredentials;
    }

    @Override
    public String getType() {
        return SAML_TYPE;
    }

    @Override
    public Optional<SecurityResponse> reRequestAuthentication(SecurityRequest request, AuthCredentials authCredentials) {
        try {
            String suffix;
            Matcher matcher = PATTERN_PATH_PREFIX.matcher(request.path());
            String string = suffix = matcher.matches() ? matcher.group(2) : null;
            if (API_AUTHTOKEN_SUFFIX.equals(suffix)) {
                if (!(request instanceof OpenSearchRequest)) {
                    throw new SecurityRequestChannelUnsupported("api/authtoken not supported for request of type " + request.getClass().getName(), new Object[0]);
                }
                OpenSearchRequest openSearchRequest = (OpenSearchRequest)request;
                RestRequest restRequest = openSearchRequest.breakEncapsulationForRequest();
                Optional<SecurityResponse> restResponse = this.authTokenProcessorHandler.handle(restRequest);
                if (restResponse.isPresent()) {
                    return restResponse;
                }
            }
            Saml2Settings saml2Settings = this.saml2SettingsProvider.getCached();
            return Optional.of(new SecurityResponse(401, Map.of("WWW-Authenticate", this.getWwwAuthenticateHeader(saml2Settings)), ""));
        }
        catch (Exception e) {
            if (e instanceof SecurityRequestChannelUnsupported) {
                throw (SecurityRequestChannelUnsupported)((Object)e);
            }
            log.error("Error in reRequestAuthentication()", (Throwable)e);
            return Optional.empty();
        }
    }

    private String getWwwAuthenticateHeader(Saml2Settings saml2Settings) throws Exception {
        AuthnRequest authnRequest = this.buildAuthnRequest(saml2Settings);
        return "X-Security-IdP realm=\"OpenSearch Security\" location=\"" + StringEscapeUtils.escapeJava((String)this.getSamlRequestRedirectBindingLocation(IdpEndpointType.SSO, saml2Settings, authnRequest.getEncodedAuthnRequest(Boolean.valueOf(true)))) + "\" requestId=\"" + StringEscapeUtils.escapeJava((String)authnRequest.getId()) + "\"";
    }

    private AuthnRequest buildAuthnRequest(Saml2Settings saml2Settings) {
        boolean forceAuthn = false;
        if (this.useForceAuthn != null) {
            forceAuthn = this.useForceAuthn;
        } else if (!this.isSingleLogoutAvailable(saml2Settings)) {
            forceAuthn = true;
        }
        return new AuthnRequest(saml2Settings, forceAuthn, false, true);
    }

    private PrivateKey getSpSignaturePrivateKey(Settings settings, Path configPath) throws Exception {
        try {
            PrivateKey result = PemKeyReader.loadKeyFromStream(settings.get("sp.signature_private_key_password"), PemKeyReader.resolveStream("sp.signature_private_key", settings));
            if (result == null) {
                result = PemKeyReader.loadKeyFromFile(settings.get("sp.signature_private_key_password"), PemKeyReader.resolve("sp.signature_private_key_filepath", settings, configPath, false));
            }
            return result;
        }
        catch (Exception e) {
            throw new Exception("Invalid value for sp.signature_private_key", e);
        }
    }

    private URL getIdpUrl(IdpEndpointType endpointType, Saml2Settings saml2Settings) {
        if (endpointType == IdpEndpointType.SSO) {
            return saml2Settings.getIdpSingleSignOnServiceUrl();
        }
        return saml2Settings.getIdpSingleLogoutServiceUrl();
    }

    private boolean isSingleLogoutAvailable(Saml2Settings saml2Settings) {
        return saml2Settings.getIdpSingleLogoutServiceUrl() != null;
    }

    @Override
    public void destroy() {
        if (this.metadataResolver instanceof DestructableComponent) {
            ((DestructableComponent)this.metadataResolver).destroy();
        }
    }

    static void ensureOpenSamlInitialization() {
        if (openSamlInitialized) {
            return;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            AccessController.doPrivileged(() -> {
                Thread thread = Thread.currentThread();
                ClassLoader originalClassLoader = thread.getContextClassLoader();
                try {
                    thread.setContextClassLoader(InitializationService.class.getClassLoader());
                    HTTPSamlAuthenticator.initializeOpenSAMLConfiguration();
                }
                catch (InitializationException e) {
                    throw new RuntimeException(e.getCause());
                }
                finally {
                    thread.setContextClassLoader(originalClassLoader);
                }
                openSamlInitialized = true;
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    private static void initializeOpenSAMLConfiguration() throws InitializationException {
        log.info("Initializing OpenSAML using the Java Services API");
        ServiceLoader<Initializer> serviceLoader = ServiceLoader.load(Initializer.class);
        for (Initializer initializer : serviceLoader) {
            if (initializer instanceof XMLObjectProviderInitializer) {
                new SecurityXMLObjectProviderInitializer().init();
                continue;
            }
            initializer.init();
        }
    }

    private MetadataResolver createMetadataResolver(Settings settings, Path configPath) throws Exception {
        Object metadataResolver;
        String idpMetadataUrl = settings.get(IDP_METADATA_URL);
        String idpMetadataFile = settings.get(IDP_METADATA_FILE);
        String idpMetadataBody = settings.get(IDP_METADATA_CONTENT);
        if (idpMetadataUrl != null) {
            metadataResolver = new SamlHTTPMetadataResolver(idpMetadataUrl, settings, configPath);
        } else if (idpMetadataFile != null) {
            metadataResolver = new SamlFilesystemMetadataResolver(idpMetadataFile, settings, configPath);
        } else if (idpMetadataBody != null) {
            metadataResolver = new DOMMetadataResolver(HTTPSamlAuthenticator.getMetadataDOM(idpMetadataBody));
        } else {
            throw new Exception(String.format("One of %s, %s or %s must be configured", IDP_METADATA_URL, IDP_METADATA_FILE, IDP_METADATA_CONTENT));
        }
        metadataResolver.setId(HTTPSamlAuthenticator.class.getName() + "_" + ++resolverIdCounter);
        metadataResolver.setRequireValidMetadata(true);
        metadataResolver.setFailFastInitialization(false);
        BasicParserPool basicParserPool = new BasicParserPool();
        basicParserPool.initialize();
        metadataResolver.setParserPool((ParserPool)basicParserPool);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            AccessController.doPrivileged(() -> HTTPSamlAuthenticator.lambda$createMetadataResolver$1((AbstractMetadataResolver)metadataResolver));
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof ComponentInitializationException) {
                throw (ComponentInitializationException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
        return metadataResolver;
    }

    private Settings createJwtAuthenticatorSettings(Settings settings) {
        Settings.Builder settingsBuilder = Settings.builder();
        Settings jwtSettings = settings.getAsSettings("jwt");
        settingsBuilder.put(jwtSettings);
        if (jwtSettings.get("roles_key") == null && settings.get("roles_key") != null) {
            settingsBuilder.put("roles_key", "roles");
        }
        if (jwtSettings.get("subject_key") == null) {
            settingsBuilder.put("subject_key", "sub");
        }
        return settingsBuilder.build();
    }

    String buildLogoutUrl(AuthCredentials authCredentials) {
        try {
            if (authCredentials == null) {
                return null;
            }
            Saml2Settings saml2Settings = this.saml2SettingsProvider.getCached();
            if (!this.isSingleLogoutAvailable(saml2Settings)) {
                return null;
            }
            String nameIdClaim = this.subjectKey == null ? "sub" : "saml_ni";
            String nameId = authCredentials.getAttributes().get("attr.jwt." + nameIdClaim);
            String nameIdFormat = SamlNameIdFormat.getByShortName(authCredentials.getAttributes().get("attr.jwt.saml_nif")).getUri();
            String sessionIndex = authCredentials.getAttributes().get("attr.jwt.saml_si");
            LogoutRequest logoutRequest = new LogoutRequest(saml2Settings, null, nameId, sessionIndex, nameIdFormat);
            return this.getSamlRequestRedirectBindingLocation(IdpEndpointType.SLO, saml2Settings, logoutRequest.getEncodedLogoutRequest(Boolean.valueOf(true)));
        }
        catch (Exception e) {
            log.error("Error while creating logout URL. Logout will be not available", (Throwable)e);
            return null;
        }
    }

    private void initLogoutUrl(ThreadContext threadContext, AuthCredentials authCredentials) {
        threadContext.putTransient("_opendistro_security_sso_logout_url", (Object)this.buildLogoutUrl(authCredentials));
    }

    private String getSamlRequestRedirectBindingLocation(IdpEndpointType idpEndpointType, Saml2Settings saml2Settings, String samlRequest) throws Exception {
        URL idpUrl = this.getIdpUrl(idpEndpointType, saml2Settings);
        if (Strings.isNullOrEmpty((String)idpUrl.getQuery())) {
            return String.valueOf(this.getIdpUrl(idpEndpointType, saml2Settings)) + "?" + this.getSamlRequestQueryString(samlRequest);
        }
        return String.valueOf(this.getIdpUrl(idpEndpointType, saml2Settings)) + "&" + this.getSamlRequestQueryString(samlRequest);
    }

    private String getSamlRequestQueryString(String samlRequest) throws Exception {
        if (this.spSignaturePrivateKey == null) {
            return "SAMLRequest=" + Util.urlEncoder((String)samlRequest);
        }
        String queryString = "SAMLRequest=" + Util.urlEncoder((String)samlRequest) + "&SigAlg=" + Util.urlEncoder((String)this.spSignatureAlgorithm);
        String signature = this.getSamlRequestQueryStringSignature(queryString);
        queryString = queryString + "&Signature=" + Util.urlEncoder((String)signature);
        return queryString;
    }

    private String getSamlRequestQueryStringSignature(String samlRequestQueryString) throws Exception {
        try {
            return Util.base64encoder((byte[])Util.sign((String)samlRequestQueryString, (PrivateKey)this.spSignaturePrivateKey, (String)this.spSignatureAlgorithm));
        }
        catch (Exception e) {
            throw new Exception("Error while signing SAML request", e);
        }
    }

    private static Element getMetadataDOM(String xmlString) throws IOException, SAXException, ParserConfigurationException {
        try {
            Document doc = Util.loadXML((String)xmlString.trim());
            return doc.getDocumentElement();
        }
        catch (Exception e) {
            log.error("Error while parsing SAML Metadata Body {}", (Object)xmlString, (Object)e);
            throw e;
        }
    }

    private static /* synthetic */ Void lambda$createMetadataResolver$1(AbstractMetadataResolver metadataResolver) throws Exception {
        metadataResolver.initialize();
        return null;
    }

    class HTTPJwtAuthenticator
    extends AbstractHTTPJwtAuthenticator {
        public HTTPJwtAuthenticator(Settings settings, Path configPath) {
            super(settings, configPath);
        }

        @Override
        public String getType() {
            return null;
        }

        @Override
        protected KeyProvider initKeyProvider(Settings settings, Path configPath) throws Exception {
            return new KeyProvider(){

                @Override
                public JWK getKeyAfterRefresh(String kid) throws AuthenticatorUnavailableException, BadCredentialsException {
                    return HTTPSamlAuthenticator.this.authTokenProcessorHandler.getSigningKey();
                }

                @Override
                public JWK getKey(String kid) throws AuthenticatorUnavailableException, BadCredentialsException {
                    return HTTPSamlAuthenticator.this.authTokenProcessorHandler.getSigningKey();
                }
            };
        }
    }

    private static enum IdpEndpointType {
        SSO,
        SLO;

    }
}

