/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.resthandler;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.core.action.ActionListener;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.securityanalytics.threatIntel.action.SARefreshTIFSourceConfigAction;
import org.opensearch.securityanalytics.threatIntel.action.SARefreshTIFSourceConfigRequest;

public class RestRefreshTIFSourceConfigAction
extends BaseRestHandler {
    private static final Logger log = LogManager.getLogger(RestRefreshTIFSourceConfigAction.class);

    public String getName() {
        return "refresh_tif_config_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.getDefault(), "%s/{%s}/_refresh", "/_plugins/_security_analytics/threat_intel/sources", "threat_intel_source_config_id")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String saTifSourceConfigId = request.param("threat_intel_source_config_id", "");
        if (saTifSourceConfigId == null || saTifSourceConfigId.isBlank()) {
            throw new IllegalArgumentException("missing id");
        }
        SARefreshTIFSourceConfigRequest req = new SARefreshTIFSourceConfigRequest(saTifSourceConfigId);
        return channel -> client.execute((ActionType)SARefreshTIFSourceConfigAction.INSTANCE, (ActionRequest)req, (ActionListener)new RestToXContentListener(channel));
    }
}

