/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.correlation.index.codec;

import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.perfield.PerFieldKnnVectorsFormat;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.securityanalytics.correlation.index.mapper.CorrelationVectorFieldMapper;

public abstract class BasePerFieldCorrelationVectorsFormat
extends PerFieldKnnVectorsFormat {
    private final Optional<MapperService> mapperService;
    private final int defaultMaxConnections;
    private final int defaultBeamWidth;
    private final Supplier<KnnVectorsFormat> defaultFormatSupplier;
    private final BiFunction<Integer, Integer, KnnVectorsFormat> formatSupplier;

    public BasePerFieldCorrelationVectorsFormat(Optional<MapperService> mapperService, int defaultMaxConnections, int defaultBeamWidth, Supplier<KnnVectorsFormat> defaultFormatSupplier, BiFunction<Integer, Integer, KnnVectorsFormat> formatSupplier) {
        this.mapperService = mapperService;
        this.defaultMaxConnections = defaultMaxConnections;
        this.defaultBeamWidth = defaultBeamWidth;
        this.defaultFormatSupplier = defaultFormatSupplier;
        this.formatSupplier = formatSupplier;
    }

    public KnnVectorsFormat getKnnVectorsFormatForField(String field) {
        if (!this.isCorrelationVectorFieldType(field)) {
            return this.defaultFormatSupplier.get();
        }
        CorrelationVectorFieldMapper.CorrelationVectorFieldType type = (CorrelationVectorFieldMapper.CorrelationVectorFieldType)this.mapperService.orElseThrow(() -> new IllegalArgumentException(String.format(Locale.getDefault(), "Cannot read field type for field [%s] because mapper service is not available", field))).fieldType(field);
        Map<String, Object> params = type.getCorrelationParams().getParameters();
        int maxConnections = this.getMaxConnections(params);
        int beamWidth = this.getBeamWidth(params);
        return this.formatSupplier.apply(maxConnections, beamWidth);
    }

    private boolean isCorrelationVectorFieldType(String field) {
        return this.mapperService.isPresent() && this.mapperService.get().fieldType(field) instanceof CorrelationVectorFieldMapper.CorrelationVectorFieldType;
    }

    private int getMaxConnections(Map<String, Object> params) {
        if (params != null && params.containsKey("m")) {
            return (Integer)params.get("m");
        }
        return this.defaultMaxConnections;
    }

    private int getBeamWidth(Map<String, Object> params) {
        if (params != null && params.containsKey("ef_construction")) {
            return (Integer)params.get("ef_construction");
        }
        return this.defaultBeamWidth;
    }
}

