/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import org.bouncycastle.util.Pack;

public class FingerprintUtil {
    public static long keyIdFromV6Fingerprint(byte[] byArray) {
        return FingerprintUtil.longFromLeftMostBytes(byArray);
    }

    public static long keyIdFromLibrePgpFingerprint(byte[] byArray) {
        return FingerprintUtil.longFromLeftMostBytes(byArray);
    }

    public static long keyIdFromV4Fingerprint(byte[] byArray) {
        return FingerprintUtil.longFromRightMostBytes(byArray);
    }

    public static long longFromLeftMostBytes(byte[] byArray) {
        return FingerprintUtil.readKeyID(byArray);
    }

    public static long longFromRightMostBytes(byte[] byArray) {
        return FingerprintUtil.readKeyID(byArray, byArray.length - 8);
    }

    public static long readKeyID(byte[] byArray) {
        return FingerprintUtil.readKeyID(byArray, 0);
    }

    public static long readKeyID(byte[] byArray, int n) {
        if (byArray.length < 8) {
            throw new IllegalArgumentException("Byte array MUST contain at least 8 bytes");
        }
        return Pack.bigEndianToLong((byte[])byArray, (int)n);
    }

    public static void writeKeyID(long l, byte[] byArray, int n) {
        if (byArray.length - n < 8) {
            throw new IllegalArgumentException("Not enough space to write key-ID to byte array.");
        }
        Pack.longToBigEndian((long)l, (byte[])byArray, (int)n);
    }

    public static void writeKeyID(long l, byte[] byArray) {
        FingerprintUtil.writeKeyID(l, byArray, 0);
    }
}

