/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.internal.common.WrappedScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
final class PoolBasedSequentialScheduledExecutorService
implements ScheduledExecutorService {
    private final WorkQueueEntry empty;
    private final BasePoolExecutor pool;
    private final List<RunnableFuture<?>> scheduled;
    private final ScheduledFuture<?> cleaner;
    private @Nullable WorkQueueEntry tail;

    public PoolBasedSequentialScheduledExecutorService(BasePoolExecutor pool) {
        this.pool = pool;
        RunnableCompletableFuture future = new RunnableCompletableFuture();
        future.complete(null);
        this.empty = new WorkQueueEntry(null, null, future);
        this.scheduled = new ArrayList();
        this.tail = this.empty;
        this.cleaner = this.scheduleWithFixedDelay(() -> {
            PoolBasedSequentialScheduledExecutorService poolBasedSequentialScheduledExecutorService = this;
            synchronized (poolBasedSequentialScheduledExecutorService) {
                this.scheduled.removeIf(sf -> sf.isCancelled());
                if (this.tail == null) {
                    return;
                }
                WorkQueueEntry entry = this.tail;
                while (entry.prev != null) {
                    if (entry.prev.future.isDone()) {
                        entry.prev = null;
                        break;
                    }
                    entry = entry.prev;
                }
                if (this.tail != this.empty && this.tail.future.isDone()) {
                    this.tail = this.empty;
                }
            }
        }, System.nanoTime() % 13L, 8L, TimeUnit.SECONDS);
    }

    @Override
    public ScheduledFuture<?> schedule(@Nullable Runnable command, long delay, @Nullable TimeUnit unit) {
        return this.schedule(origin -> this.pool.schedule(() -> this.submitToWorkQueue((RunnableFuture)origin.join(), command, true).join(), delay, unit));
    }

    @Override
    public <V> ScheduledFuture<V> schedule(@Nullable Callable<V> callable, long delay, @Nullable TimeUnit unit) {
        return this.schedule(origin -> this.pool.schedule(() -> this.submitToWorkQueue((RunnableFuture)origin.join(), callable, true).join(), delay, unit));
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(@Nullable Runnable command, long initialDelay, long period, @Nullable TimeUnit unit) {
        return this.schedule(origin -> this.pool.scheduleAtFixedRate(() -> {
            CompletableFuture<?> submitted;
            try {
                submitted = this.submitToWorkQueue((RunnableFuture)origin.join(), command, true);
            }
            catch (RejectedExecutionException ex) {
                return;
            }
            submitted.join();
        }, initialDelay, period, unit));
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(@Nullable Runnable command, long initialDelay, long delay, @Nullable TimeUnit unit) {
        return this.schedule(origin -> this.pool.scheduleWithFixedDelay(() -> {
            CompletableFuture<?> submitted;
            try {
                submitted = this.submitToWorkQueue((RunnableFuture)origin.join(), command, true);
            }
            catch (RejectedExecutionException ex) {
                return;
            }
            submitted.join();
        }, initialDelay, delay, unit));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> ScheduledFuture<V> schedule(Function<CompletableFuture<RunnableFuture<?>>, ScheduledFuture<V>> doSchedule) {
        PoolBasedSequentialScheduledExecutorService poolBasedSequentialScheduledExecutorService = this;
        synchronized (poolBasedSequentialScheduledExecutorService) {
            if (this.tail == null) {
                throw new RejectedExecutionException("this scheduled executor has been shutdown before");
            }
            CompletableFuture<RunnableFuture> origin = new CompletableFuture<RunnableFuture>();
            ScheduledFuture<V> future = doSchedule.apply(origin);
            this.scheduled.add((RunnableFuture)((Object)future));
            origin.complete((RunnableFuture)((Object)future));
            return future;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        PoolBasedSequentialScheduledExecutorService poolBasedSequentialScheduledExecutorService = this;
        synchronized (poolBasedSequentialScheduledExecutorService) {
            if (this.tail == null) {
                return;
            }
            this.cleaner.cancel(false);
            this.scheduled.removeIf(sf -> {
                sf.cancel(false);
                return true;
            });
            this.tail = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNullByDefault(value={})
    public List<Runnable> shutdownNow() {
        PoolBasedSequentialScheduledExecutorService poolBasedSequentialScheduledExecutorService = this;
        synchronized (poolBasedSequentialScheduledExecutorService) {
            if (this.tail == null) {
                return List.of();
            }
            this.cleaner.cancel(false);
            Set<@Nullable K> runnables = Collections.newSetFromMap(new IdentityHashMap());
            WorkQueueEntry entry = this.tail;
            this.scheduled.removeIf(sf -> {
                if (sf.cancel(false)) {
                    runnables.add(sf);
                }
                return true;
            });
            this.tail = null;
            while (entry != null) {
                if (!entry.future.cancel(false)) break;
                if (entry.origin != null) {
                    runnables.add(entry.origin);
                } else {
                    runnables.add(entry.future);
                }
                entry = entry.prev;
            }
            return List.copyOf(runnables);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isShutdown() {
        PoolBasedSequentialScheduledExecutorService poolBasedSequentialScheduledExecutorService = this;
        synchronized (poolBasedSequentialScheduledExecutorService) {
            return this.pool == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTerminated() {
        PoolBasedSequentialScheduledExecutorService poolBasedSequentialScheduledExecutorService = this;
        synchronized (poolBasedSequentialScheduledExecutorService) {
            return this.pool == null && this.tail.future.isDone();
        }
    }

    @Override
    public boolean awaitTermination(long timeout, @Nullable TimeUnit unit) throws InterruptedException {
        long timeoutAt = System.currentTimeMillis() + unit.toMillis(timeout);
        while (!this.isTerminated()) {
            if (System.currentTimeMillis() > timeoutAt) {
                return false;
            }
            Thread.onSpinWait();
        }
        return true;
    }

    @Override
    public <T> Future<T> submit(@Nullable Callable<T> task) {
        return this.submitToWorkQueue(null, task, false);
    }

    private CompletableFuture<?> submitToWorkQueue(RunnableFuture<?> origin, @Nullable Runnable task, boolean inPool) {
        Callable<Object> callable = () -> {
            task.run();
            return null;
        };
        return this.submitToWorkQueue(origin, callable, inPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> CompletableFuture<T> submitToWorkQueue(@Nullable RunnableFuture<?> origin, @Nullable Callable<T> task, boolean inPool) {
        CompletableFuture cf;
        boolean runNow;
        BiFunction<Object, Throwable, Object> action = (result, error) -> {
            try {
                Object v = task.call();
                return v;
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw PoolBasedSequentialScheduledExecutorService.unchecked(ex);
            }
            finally {
                this.pool.pending.decrementAndGet();
            }
        };
        PoolBasedSequentialScheduledExecutorService poolBasedSequentialScheduledExecutorService = this;
        synchronized (poolBasedSequentialScheduledExecutorService) {
            if (this.tail == null) {
                throw new RejectedExecutionException("this scheduled executor has been shutdown before");
            }
            int mandatoryPoolSize = this.pool.pending.incrementAndGet();
            this.pool.resizePool(mandatoryPoolSize);
            boolean bl = runNow = inPool && this.tail.future.isDone();
            if (runNow) {
                cf = new RunnableCompletableFuture<T>(task);
                this.tail = new WorkQueueEntry(null, origin, (RunnableCompletableFuture<?>)cf);
            } else {
                cf = this.tail.future.handleAsync(action, (Executor)this.pool);
                ((RunnableCompletableFuture)cf).setCallable(task);
                this.tail = new WorkQueueEntry(this.tail, origin, (RunnableCompletableFuture<?>)cf);
            }
        }
        if (runNow) {
            try {
                ((RunnableCompletableFuture)cf).run();
            }
            finally {
                this.pool.pending.decrementAndGet();
            }
        }
        return cf;
    }

    private static <E extends RuntimeException> E unchecked(Exception ex) throws E {
        throw (RuntimeException)ex;
    }

    @Override
    public <T> Future<T> submit(@Nullable Runnable task, T result) {
        return this.submitToWorkQueue(null, () -> {
            task.run();
            return result;
        }, false);
    }

    @Override
    public Future<?> submit(@Nullable Runnable task) {
        return this.submit(task, null);
    }

    @Override
    @NonNullByDefault(value={})
    public <T> List<Future<T>> invokeAll(@Nullable Collection<? extends @Nullable Callable<T>> tasks) throws InterruptedException {
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>();
        for (Callable<T> callable : tasks) {
            futures.add(this.submit(callable));
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        return futures;
    }

    @Override
    @NonNullByDefault(value={})
    public <T> List<Future<T>> invokeAll(@Nullable Collection<? extends @Nullable Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>();
        for (Callable<T> callable : tasks) {
            futures.add(this.submitToWorkQueue(null, callable, false).orTimeout(timeout, unit));
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        return futures;
    }

    @Override
    public <T> T invokeAny(@Nullable Collection<? extends @Nullable Callable<T>> tasks) throws InterruptedException, ExecutionException {
        try {
            return this.invokeAny(tasks, Long.MAX_VALUE);
        }
        catch (TimeoutException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    @Override
    public <T> T invokeAny(@Nullable Collection<? extends @Nullable Callable<T>> tasks, long timeout, @Nullable TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long timeoutAt = System.currentTimeMillis() + unit.toMillis(timeout);
        return this.invokeAny(tasks, timeoutAt);
    }

    private <T> T invokeAny(@Nullable Collection<? extends @Nullable Callable<T>> tasks, long timeoutAt) throws InterruptedException, ExecutionException, TimeoutException {
        ArrayList<CompletableFuture<T>> futures = new ArrayList<CompletableFuture<T>>();
        for (Callable<T> callable : tasks) {
            futures.add(this.submitToWorkQueue(null, callable, false));
        }
        while (timeoutAt >= System.currentTimeMillis()) {
            boolean bl;
            boolean bl2 = true;
            for (CompletableFuture completableFuture : futures) {
                if (completableFuture.isDone()) {
                    if (completableFuture.isCompletedExceptionally()) continue;
                    for (CompletableFuture completableFuture2 : futures) {
                        if (completableFuture2 == completableFuture) continue;
                        completableFuture2.cancel(true);
                    }
                    return completableFuture.join();
                }
                bl = false;
            }
            if (bl) {
                ExecutionException executionException = new ExecutionException("all tasks failed", null);
                for (CompletableFuture completableFuture : futures) {
                    try {
                        completableFuture.get();
                        throw new AssertionError((Object)"all tasks should be failed");
                    }
                    catch (ExecutionException ex) {
                        executionException.addSuppressed(ex);
                    }
                }
                throw executionException;
            }
            Thread.onSpinWait();
        }
        for (CompletableFuture completableFuture : futures) {
            completableFuture.cancel(true);
        }
        throw new TimeoutException("none of the tasks did complete in time");
    }

    @Override
    public void execute(Runnable command) {
        this.submit(command);
    }

    static class BasePoolExecutor
    extends WrappedScheduledExecutorService {
        protected final Logger logger = LoggerFactory.getLogger(BasePoolExecutor.class);
        private final String threadPoolName;
        private final AtomicInteger pending;
        private volatile int minimumPoolSize;

        public BasePoolExecutor(String threadPoolName, int corePoolSize, ThreadFactory threadFactory) {
            super(corePoolSize, threadFactory);
            this.threadPoolName = threadPoolName;
            this.pending = new AtomicInteger(1);
        }

        public synchronized void resizePool(int mandatoryPoolSize) {
            int corePoolSize = this.getCorePoolSize();
            if (this.minimumPoolSize > mandatoryPoolSize) {
                mandatoryPoolSize = this.minimumPoolSize;
            }
            if (mandatoryPoolSize > corePoolSize) {
                this.setMaximumPoolSize(mandatoryPoolSize + 2);
                this.setCorePoolSize(mandatoryPoolSize);
            } else if (mandatoryPoolSize < corePoolSize) {
                this.setCorePoolSize(mandatoryPoolSize);
                this.setMaximumPoolSize(mandatoryPoolSize + 2);
            }
        }

        public int getMinimumPoolSize() {
            return this.minimumPoolSize;
        }

        public void setMinimumPoolSize(int minimumPoolSize) {
            this.minimumPoolSize = minimumPoolSize;
            this.resizePool(this.getCorePoolSize());
        }

        @Override
        public void shutdown() {
            this.logger.warn("shutdown() invoked on a shared thread pool '{}'. This is a bug, please submit a bug report", (Object)this.threadPoolName, (Object)new IllegalStateException());
        }

        @Override
        @NonNullByDefault(value={})
        public List<Runnable> shutdownNow() {
            this.logger.warn("shutdownNow() invoked on a shared thread pool '{}'. This is a bug, please submit a bug report", (Object)this.threadPoolName, (Object)new IllegalStateException());
            return List.of();
        }
    }

    static class RunnableCompletableFuture<V>
    extends CompletableFuture<V>
    implements RunnableFuture<V> {
        private @Nullable Callable<V> callable;

        public RunnableCompletableFuture() {
            this.callable = null;
        }

        public RunnableCompletableFuture(@Nullable Callable<V> callable) {
            this.callable = callable;
        }

        public void setCallable(@Nullable Callable<V> callable) {
            this.callable = callable;
        }

        @Override
        public <U> RunnableCompletableFuture<U> newIncompleteFuture() {
            return new RunnableCompletableFuture<V>();
        }

        @Override
        public <U> RunnableCompletableFuture<U> handleAsync(BiFunction<? super V, Throwable, ? extends U> fn, Executor executor) {
            return (RunnableCompletableFuture)super.handleAsync(fn, executor);
        }

        @Override
        public void run() {
            if (this.isDone()) {
                return;
            }
            try {
                this.complete(this.callable.call());
            }
            catch (Error | Exception t) {
                this.completeExceptionally(t);
            }
        }
    }

    static class WorkQueueEntry {
        private @Nullable WorkQueueEntry prev;
        private @Nullable RunnableFuture<?> origin;
        private final RunnableCompletableFuture<?> future;

        public WorkQueueEntry(@Nullable WorkQueueEntry prev, @Nullable RunnableFuture<?> origin, RunnableCompletableFuture<?> future) {
            this.prev = prev;
            this.origin = origin;
            this.future = future;
        }
    }
}

