/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt;

import com.hivemq.client.internal.mqtt.MqttProxyConfigImpl;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.internal.util.InetSocketAddressUtil;
import com.hivemq.client.mqtt.MqttProxyConfigBuilder;
import com.hivemq.client.mqtt.MqttProxyProtocol;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MqttProxyConfigImplBuilder<B extends MqttProxyConfigImplBuilder<B>> {
    @NotNull
    private MqttProxyProtocol protocol = MqttProxyConfigImpl.DEFAULT_PROXY_PROTOCOL;
    @Nullable
    private InetSocketAddress address;
    @NotNull
    private Object host = "localhost";
    private int port = -1;
    @Nullable
    private String username;
    @Nullable
    private String password;
    private int handshakeTimeoutMs = 10000;

    MqttProxyConfigImplBuilder() {
    }

    MqttProxyConfigImplBuilder(@Nullable MqttProxyConfigImpl proxyConfig) {
        if (proxyConfig != null) {
            this.protocol = proxyConfig.getProtocol();
            this.address = proxyConfig.getAddress();
            this.username = proxyConfig.getRawUsername();
            this.password = proxyConfig.getRawPassword();
            this.handshakeTimeoutMs = proxyConfig.getHandshakeTimeoutMs();
        }
    }

    @NotNull
    abstract B self();

    @NotNull
    public B protocol(@Nullable MqttProxyProtocol protocol) {
        this.protocol = Checks.notNull(protocol, "Proxy protocol");
        return this.self();
    }

    @NotNull
    public B address(@Nullable InetSocketAddress address) {
        this.address = Checks.notNull(address, "Proxy address");
        return this.self();
    }

    @NotNull
    public B host(@Nullable String host) {
        this.setProxyHost(Checks.notEmpty(host, "Proxy host"));
        return this.self();
    }

    @NotNull
    public B host(@Nullable InetAddress host) {
        this.setProxyHost(Checks.notNull(host, "Proxy host"));
        return this.self();
    }

    private void setProxyHost(@NotNull Object host) {
        this.host = host;
        if (this.address != null) {
            this.port = this.address.getPort();
            this.address = null;
        }
    }

    @NotNull
    public B port(int port) {
        this.port = Checks.unsignedShort(port, "Proxy port");
        if (this.address != null) {
            InetAddress inetAddress = this.address.getAddress();
            this.host = inetAddress != null ? inetAddress : this.address.getHostString();
            this.address = null;
        }
        return this.self();
    }

    @NotNull
    public B username(@Nullable String username) {
        this.username = username;
        return this.self();
    }

    @NotNull
    public B password(@Nullable String password) {
        this.password = password;
        return this.self();
    }

    @NotNull
    public B handshakeTimeout(long timeout, @Nullable TimeUnit timeUnit) {
        Checks.notNull(timeUnit, "Time unit");
        this.handshakeTimeoutMs = (int)Checks.range(timeUnit.toMillis(timeout), 0L, Integer.MAX_VALUE, "Handshake timeout in milliseconds");
        return this.self();
    }

    @NotNull
    private InetSocketAddress getAddress() {
        if (this.address != null) {
            return this.address;
        }
        if (this.host instanceof InetAddress) {
            return new InetSocketAddress((InetAddress)this.host, this.getPort());
        }
        return InetSocketAddressUtil.create((String)this.host, this.getPort());
    }

    private int getPort() {
        if (this.port != -1) {
            return this.port;
        }
        switch (this.protocol) {
            case SOCKS_4: 
            case SOCKS_5: {
                return 1080;
            }
        }
        return 80;
    }

    @NotNull
    public MqttProxyConfigImpl build() {
        return new MqttProxyConfigImpl(this.protocol, this.getAddress(), this.username, this.password, this.handshakeTimeoutMs);
    }

    public static class Nested<P>
    extends MqttProxyConfigImplBuilder<Nested<P>>
    implements MqttProxyConfigBuilder.Nested<P> {
        @NotNull
        private final Function<? super MqttProxyConfigImpl, P> parentConsumer;

        Nested(@Nullable MqttProxyConfigImpl proxyConfig, @NotNull Function<? super MqttProxyConfigImpl, P> parentConsumer) {
            super(proxyConfig);
            this.parentConsumer = parentConsumer;
        }

        @Override
        @NotNull
        Nested<P> self() {
            return this;
        }

        @Override
        @NotNull
        public P applyProxyConfig() {
            return this.parentConsumer.apply(this.build());
        }
    }

    public static class Default
    extends MqttProxyConfigImplBuilder<Default>
    implements MqttProxyConfigBuilder {
        public Default() {
        }

        Default(@Nullable MqttProxyConfigImpl proxyConfig) {
            super(proxyConfig);
        }

        @Override
        @NotNull
        Default self() {
            return this;
        }
    }
}

