/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.CallGenerator;
import org.jetbrains.kotlin.codegen.JvmKotlinType;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.ValueKind;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/codegen/DefaultCallArgs;", "", "size", "", "<init>", "(I)V", "getSize", "()I", "bits", "Ljava/util/BitSet;", "mark", "", "index", "toInts", "", "generateOnStackIfNeeded", "", "callGenerator", "Lorg/jetbrains/kotlin/codegen/CallGenerator;", "isConstructor", "backend"})
public final class DefaultCallArgs {
    private final int size;
    @NotNull
    private final BitSet bits;

    public DefaultCallArgs(int size) {
        this.size = size;
        this.bits = new BitSet(this.size);
    }

    public final int getSize() {
        return this.size;
    }

    public final void mark(int index) {
        boolean bl;
        boolean bl2 = bl = index < this.size;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Mask index should be less then size, but " + index + " >= " + this.size;
            throw new AssertionError((Object)string);
        }
        this.bits.set(index);
    }

    @NotNull
    public final List<Integer> toInts() {
        if (this.bits.isEmpty() || this.size == 0) {
            return CollectionsKt.emptyList();
        }
        ArrayList<Integer> masks = new ArrayList<Integer>(1);
        int mask = 0;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (i != 0 && i % 32 == 0) {
                masks.add(mask);
                mask = 0;
            }
            mask |= this.bits.get(i) ? 1 << i % 32 : 0;
        }
        masks.add(mask);
        return masks;
    }

    public final boolean generateOnStackIfNeeded(@NotNull CallGenerator callGenerator, boolean isConstructor) {
        Intrinsics.checkNotNullParameter((Object)callGenerator, (String)"callGenerator");
        List<Integer> toInts = this.toInts();
        if (!toInts.isEmpty()) {
            Iterator<Integer> iterator2 = toInts.iterator();
            while (iterator2.hasNext()) {
                int mask = ((Number)iterator2.next()).intValue();
                Type type = Type.INT_TYPE;
                Intrinsics.checkNotNullExpressionValue((Object)type, (String)"INT_TYPE");
                JvmKotlinType jvmKotlinType = new JvmKotlinType(type, null, 2, null);
                StackValue stackValue = StackValue.constant(mask, Type.INT_TYPE);
                Intrinsics.checkNotNullExpressionValue((Object)stackValue, (String)"constant(...)");
                CallGenerator.putValueIfNeeded$default(callGenerator, jvmKotlinType, stackValue, ValueKind.DEFAULT_MASK, 0, 8, null);
            }
            Type parameterType = isConstructor ? AsmTypes.DEFAULT_CONSTRUCTOR_MARKER : AsmTypes.OBJECT_TYPE;
            Intrinsics.checkNotNull((Object)parameterType);
            JvmKotlinType jvmKotlinType = new JvmKotlinType(parameterType, null, 2, null);
            StackValue stackValue = StackValue.constant(null, parameterType);
            Intrinsics.checkNotNullExpressionValue((Object)stackValue, (String)"constant(...)");
            CallGenerator.putValueIfNeeded$default(callGenerator, jvmKotlinType, stackValue, ValueKind.METHOD_HANDLE_IN_DEFAULT, 0, 8, null);
        }
        return !((Collection)toInts).isEmpty();
    }
}

