/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.ext.spock;

import com.intellij.execution.JavaRunConfigurationBase;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PathUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.ext.spock.SpecificationKt;
import org.jetbrains.plugins.groovy.spock.rt.SpockJUnitTestTreeNodeManager;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016J5\u0010\b\u001a\u00020\t\"\f\b\u0000\u0010\n*\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\u0006\u001a\u0002H\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/groovy/ext/spock/SpockRunConfigurationExtension;", "Lcom/intellij/execution/RunConfigurationExtension;", "<init>", "()V", "isApplicableFor", "", "configuration", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "updateJavaParameters", "", "T", "params", "Lcom/intellij/execution/configurations/JavaParameters;", "runnerSettings", "Lcom/intellij/execution/configurations/RunnerSettings;", "(Lcom/intellij/execution/configurations/RunConfigurationBase;Lcom/intellij/execution/configurations/JavaParameters;Lcom/intellij/execution/configurations/RunnerSettings;)V", "intellij.groovy"})
public final class SpockRunConfigurationExtension
extends RunConfigurationExtension {
    public boolean isApplicableFor(@NotNull RunConfigurationBase<?> configuration) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        return configuration instanceof JUnitConfiguration;
    }

    public <T extends RunConfigurationBase<?>> void updateJavaParameters(@NotNull T configuration, @NotNull JavaParameters params, @Nullable RunnerSettings runnerSettings) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (!(configuration instanceof JUnitConfiguration)) {
            return;
        }
        Module module = ((JavaRunConfigurationModule)((JavaRunConfigurationBase)configuration).getConfigurationModule()).getModule();
        if (module == null) {
            return;
        }
        Module module2 = module;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module2);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"moduleWithDependenciesAndLibrariesScope(...)");
        GlobalSearchScope scope = globalSearchScope;
        String string = ((JUnitConfiguration)configuration).getPersistentData().MAIN_CLASS_NAME;
        if (string == null) {
            return;
        }
        String mainClass = string;
        Project project = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        DumbService.Companion.getInstance(project).runWithAlternativeResolveEnabled(() -> SpockRunConfigurationExtension.updateJavaParameters$lambda$0(module2, mainClass, scope, params));
    }

    private static final void updateJavaParameters$lambda$0(Module $module, String $mainClass, GlobalSearchScope $scope, JavaParameters $params) {
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)$module.getProject()).findClass($mainClass, $scope);
        if (psiClass == null) {
            return;
        }
        PsiClass clazz = psiClass;
        if (!SpecificationKt.isSpockSpecification(clazz) || !JUnitUtil.isJUnit4TestClass((PsiClass)clazz) && !JUnitUtil.isJUnit3TestClass((PsiClass)clazz)) {
            return;
        }
        $params.getClassPath().add(PathUtil.getJarPathForClass(SpockJUnitTestTreeNodeManager.class));
        $params.getVMParametersList().addNotEmptyProperty("nodeNamesHandler", SpockJUnitTestTreeNodeManager.class.getName());
    }
}

