/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.resolve;

import com.intellij.debugger.streams.resolve.ValuesOrderResolver;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.trace.TraceInfo;
import com.intellij.debugger.streams.wrapper.TraceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class OptionalOrderResolver
implements ValuesOrderResolver {
    @Override
    @NotNull
    public ValuesOrderResolver.Result resolve(@NotNull TraceInfo info) {
        if (info == null) {
            OptionalOrderResolver.$$$reportNull$$$0(0);
        }
        LinkedHashMap<TraceElement, List<TraceElement>> forward = new LinkedHashMap<TraceElement, List<TraceElement>>();
        LinkedHashMap<TraceElement, List<TraceElement>> backward = new LinkedHashMap<TraceElement, List<TraceElement>>();
        Map<Integer, TraceElement> before = info.getValuesOrderBefore();
        Map<Integer, TraceElement> after = info.getValuesOrderAfter();
        if (after.isEmpty()) {
            before.values().forEach(x -> forward.put((TraceElement)x, Collections.emptyList()));
        } else {
            assert (after.size() == 1);
            TraceElement optionalContent = after.values().iterator().next();
            ArrayList<TraceElement> backwardTrace = new ArrayList<TraceElement>();
            Object optionalKey = TraceUtil.extractKey(optionalContent);
            for (TraceElement beforeElement : before.values()) {
                if (Objects.equals(TraceUtil.extractKey(beforeElement), optionalKey)) {
                    backwardTrace.add(beforeElement);
                    forward.put(beforeElement, Collections.singletonList(optionalContent));
                    continue;
                }
                forward.put(beforeElement, Collections.emptyList());
            }
            backward.put(optionalContent, backwardTrace);
        }
        ValuesOrderResolver.Result result = ValuesOrderResolver.Result.of(forward, backward);
        if (result == null) {
            OptionalOrderResolver.$$$reportNull$$$0(1);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/streams/resolve/OptionalOrderResolver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/streams/resolve/OptionalOrderResolver";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

