/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.compiler.impl.javaCompiler.javac.JavacConfiguration;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeUIModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenImporter;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapterLegacyImpl;
import org.jetbrains.idea.maven.importing.StandardMavenModuleType;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.statistics.MavenImportCollector;
import org.jetbrains.idea.maven.utils.MavenCoroutineScopeProvider;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerOptions;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0002&'B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\"\u0010\u0011\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0016\u0010\u0017\u001a\u00020\u00052\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\u0012\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0007J\u000e\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!J\u0016\u0010\"\u001a\u00020!2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0006\u001a\u00020\u0015R\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006("}, d2={"Lorg/jetbrains/idea/maven/importing/MavenProjectImporterUtil;", "", "<init>", "()V", "importLegacyExtensions", "", "project", "Lcom/intellij/openapi/project/Project;", "modifiableModelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "extensionImporters", "", "Lorg/jetbrains/idea/maven/importing/MavenProjectImporterUtil$LegacyExtensionImporter;", "postTasks", "Lorg/jetbrains/idea/maven/project/MavenProjectsProcessorTask;", "activity", "Lcom/intellij/internal/statistic/StructuredIdeActivity;", "scheduleRefreshResolvedArtifacts", "", "projectsToRefresh", "", "Lorg/jetbrains/idea/maven/project/MavenProject;", "removeOutdatedCompilerConfigSettings", "doRefreshFiles", "files", "", "Ljava/io/File;", "selectScope", "Lcom/intellij/openapi/roots/DependencyScope;", "mavenScope", "", "getAttachedJarsLibName", "artifact", "Lorg/jetbrains/idea/maven/model/MavenArtifact;", "createCopyForLocalRepo", "IMPORTED_CLASSIFIERS", "getIMPORTED_CLASSIFIERS", "()Ljava/util/Set;", "RefreshingFilesTask", "LegacyExtensionImporter", "intellij.maven"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMavenProjectImporterUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenProjectImporterUtil.kt\norg/jetbrains/idea/maven/importing/MavenProjectImporterUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,287:1\n774#2:288\n865#2,2:289\n*S KotlinDebug\n*F\n+ 1 MavenProjectImporterUtil.kt\norg/jetbrains/idea/maven/importing/MavenProjectImporterUtil\n*L\n39#1:288\n39#1:289,2\n*E\n"})
public final class MavenProjectImporterUtil {
    @NotNull
    public static final MavenProjectImporterUtil INSTANCE = new MavenProjectImporterUtil();
    @NotNull
    private static final Set<String> IMPORTED_CLASSIFIERS = SetsKt.setOf((Object)"client");

    private MavenProjectImporterUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void importLegacyExtensions(@NotNull Project project, @NotNull IdeModifiableModelsProvider modifiableModelsProvider, @NotNull List<LegacyExtensionImporter> extensionImporters, @NotNull List<? extends MavenProjectsProcessorTask> postTasks, @NotNull StructuredIdeActivity activity) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modifiableModelsProvider, (String)"modifiableModelsProvider");
        Intrinsics.checkNotNullParameter(extensionImporters, (String)"extensionImporters");
        Intrinsics.checkNotNullParameter(postTasks, (String)"postTasks");
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Iterable $this$filter$iv = extensionImporters;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LegacyExtensionImporter it = (LegacyExtensionImporter)element$iv$iv;
            boolean bl = false;
            if (!(!it.isModuleDisposed())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List importers = (List)destination$iv$iv;
        if (importers.isEmpty()) {
            return;
        }
        long beforeBridgesCreation = System.nanoTime();
        IdeUIModifiableModelsProvider ideUIModifiableModelsProvider = modifiableModelsProvider instanceof IdeUIModifiableModelsProvider ? (IdeUIModifiableModelsProvider)modifiableModelsProvider : null;
        destination$iv$iv = ideUIModifiableModelsProvider != null ? (IdeModifiableModelsProvider)ideUIModifiableModelsProvider : ProjectDataManager.getInstance().createModifiableModelsProvider(project);
        Intrinsics.checkNotNull((Object)destination$iv$iv);
        Collection provider = destination$iv$iv;
        long bridgesCreationNano = System.nanoTime() - beforeBridgesCreation;
        try {
            long beforeInitInit = System.nanoTime();
            importers.forEach(arg_0 -> MavenProjectImporterUtil.importLegacyExtensions$lambda$1((IdeModifiableModelsProvider)provider, arg_0));
            bridgesCreationNano += System.nanoTime() - beforeInitInit;
            Map counters = new HashMap();
            importers.forEach(arg_0 -> MavenProjectImporterUtil.importLegacyExtensions$lambda$2(counters, arg_0));
            importers.forEach(arg_0 -> MavenProjectImporterUtil.importLegacyExtensions$lambda$3(postTasks, counters, arg_0));
            importers.forEach(arg_0 -> MavenProjectImporterUtil.importLegacyExtensions$lambda$4(counters, arg_0));
            for (Map.Entry eventPairArray2 : counters.entrySet()) {
                Class key = (Class)eventPairArray2.getKey();
                LegacyExtensionImporter.CountAndTime value = (LegacyExtensionImporter.CountAndTime)eventPairArray2.getValue();
                EventPair[] eventPairArray = new EventPair[]{MavenImportCollector.ACTIVITY_ID.with((Object)activity), MavenImportCollector.IMPORTER_CLASS.with((Object)key), MavenImportCollector.NUMBER_OF_MODULES.with((Object)value.getCount()), MavenImportCollector.TOTAL_DURATION_MS.with((Object)TimeUnit.NANOSECONDS.toMillis(value.getTimeNano()))};
                MavenImportCollector.IMPORTER_RUN.log(project, eventPairArray);
            }
        }
        catch (Throwable throwable) {
            long beforeCommit = System.nanoTime();
            MavenUtil.invokeAndWaitWriteAction(project, () -> MavenProjectImporterUtil.importLegacyExtensions$lambda$6(project, (IdeModifiableModelsProvider)provider));
            long afterCommit = System.nanoTime();
            EventPair[] eventPairArray = new EventPair[]{MavenImportCollector.ACTIVITY_ID.with((Object)activity), MavenImportCollector.DURATION_OF_LEGACY_BRIDGES_CREATION_MS.with((Object)TimeUnit.NANOSECONDS.toMillis(bridgesCreationNano)), MavenImportCollector.DURATION_OF_LEGACY_BRIDGES_COMMIT_MS.with((Object)TimeUnit.NANOSECONDS.toMillis(afterCommit - beforeCommit))};
            MavenImportCollector.LEGACY_IMPORTERS_STATS.log(project, eventPairArray);
            throw throwable;
        }
        long beforeCommit = System.nanoTime();
        MavenUtil.invokeAndWaitWriteAction(project, () -> MavenProjectImporterUtil.importLegacyExtensions$lambda$6(project, (IdeModifiableModelsProvider)provider));
        long afterCommit = System.nanoTime();
        EventPair[] eventPairArray = new EventPair[]{MavenImportCollector.ACTIVITY_ID.with((Object)activity), MavenImportCollector.DURATION_OF_LEGACY_BRIDGES_CREATION_MS.with((Object)TimeUnit.NANOSECONDS.toMillis(bridgesCreationNano)), MavenImportCollector.DURATION_OF_LEGACY_BRIDGES_COMMIT_MS.with((Object)TimeUnit.NANOSECONDS.toMillis(afterCommit - beforeCommit))};
        MavenImportCollector.LEGACY_IMPORTERS_STATS.log(project, eventPairArray);
    }

    public final void scheduleRefreshResolvedArtifacts(@NotNull List<MavenProjectsProcessorTask> postTasks, @NotNull Iterable<MavenProject> projectsToRefresh) {
        Intrinsics.checkNotNullParameter(postTasks, (String)"postTasks");
        Intrinsics.checkNotNullParameter(projectsToRefresh, (String)"projectsToRefresh");
        if (!Registry.Companion.is("maven.sync.refresh.resolved.artifacts", false)) {
            return;
        }
        HashSet<File> files2 = new HashSet<File>();
        for (MavenProject project : projectsToRefresh) {
            for (MavenArtifact dependency : project.getDependencies()) {
                files2.add(dependency.getFile());
            }
        }
        if (MavenUtil.isMavenUnitTestModeEnabled()) {
            this.doRefreshFiles((Set<? extends File>)files2);
        } else {
            postTasks.add(new RefreshingFilesTask((Set<? extends File>)files2));
        }
    }

    @ApiStatus.Internal
    public final void removeOutdatedCompilerConfigSettings(@NotNull Project project) {
        String options;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        JpsJavaCompilerOptions javacOptions = JavacConfiguration.getOptions((Project)project, JavacConfiguration.class);
        CharSequence charSequence = options = javacOptions.ADDITIONAL_OPTIONS_STRING;
        Intrinsics.checkNotNull((Object)charSequence);
        charSequence = charSequence;
        Regex regex = new Regex("(-target (\\S+))");
        String string = "";
        javacOptions.ADDITIONAL_OPTIONS_STRING = options = regex.replaceFirst(charSequence, string);
    }

    private final void doRefreshFiles(Set<? extends File> files2) {
        LocalFileSystem.getInstance().refreshIoFiles((Iterable)files2);
    }

    @JvmStatic
    @NotNull
    public static final DependencyScope selectScope(@Nullable String mavenScope) {
        if (Intrinsics.areEqual((Object)"runtime", (Object)mavenScope)) {
            return DependencyScope.RUNTIME;
        }
        if (Intrinsics.areEqual((Object)"test", (Object)mavenScope)) {
            return DependencyScope.TEST;
        }
        return Intrinsics.areEqual((Object)"provided", (Object)mavenScope) ? DependencyScope.PROVIDED : DependencyScope.COMPILE;
    }

    @NotNull
    public final String getAttachedJarsLibName(@NotNull MavenArtifact artifact) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Object libraryName = artifact.getLibraryName();
        String string = libraryName;
        Intrinsics.checkNotNull((Object)string);
        boolean bl = StringsKt.startsWith$default((String)string, (String)"Maven: ", (boolean)false, (int)2, null);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        String string3 = libraryName;
        Intrinsics.checkNotNull((Object)string3);
        int n = 7;
        String string4 = string3.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        libraryName = "Maven: ATTACHED-JAR: " + string4;
        return libraryName;
    }

    @NotNull
    public final MavenArtifact createCopyForLocalRepo(@NotNull MavenArtifact artifact, @NotNull MavenProject project) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new MavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getBaseVersion(), artifact.getType(), artifact.getClassifier(), artifact.getScope(), artifact.isOptional(), artifact.getExtension(), null, project.getLocalRepository(), false, false);
    }

    @NotNull
    public final Set<String> getIMPORTED_CLASSIFIERS() {
        return IMPORTED_CLASSIFIERS;
    }

    private static final void importLegacyExtensions$lambda$1(IdeModifiableModelsProvider $provider, LegacyExtensionImporter importer) {
        Intrinsics.checkNotNullParameter((Object)importer, (String)"importer");
        importer.init($provider);
    }

    private static final void importLegacyExtensions$lambda$2(Map $counters, LegacyExtensionImporter it) {
        it.preConfig($counters);
    }

    private static final void importLegacyExtensions$lambda$3(List $postTasks, Map $counters, LegacyExtensionImporter it) {
        it.config($postTasks, $counters);
    }

    private static final void importLegacyExtensions$lambda$4(Map $counters, LegacyExtensionImporter it) {
        it.postConfig($counters);
    }

    private static final void importLegacyExtensions$lambda$6$lambda$5(IdeModifiableModelsProvider $provider) {
        $provider.commit();
    }

    private static final void importLegacyExtensions$lambda$6(Project $project, IdeModifiableModelsProvider $provider) {
        ProjectRootManagerEx.getInstanceEx((Project)$project).mergeRootsChangesDuring(() -> MavenProjectImporterUtil.importLegacyExtensions$lambda$6$lambda$5($provider));
    }

    public static final /* synthetic */ void access$doRefreshFiles(MavenProjectImporterUtil $this, Set files2) {
        $this.doRefreshFiles(files2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 ,2\u00020\u0001:\u0002+,BK\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u000b\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0015J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\"\u0010\u001f\u001a\u00020\u001a2\u001a\u0010 \u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\"\u0012\u0004\u0012\u00020#0!J$\u0010$\u001a\u00020\u001a2\u001a\u0010 \u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\"\u0012\u0004\u0012\u00020#0!H\u0002J0\u0010%\u001a\u00020\u001a2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u000e2\u001a\u0010 \u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\"\u0012\u0004\u0012\u00020#0!J2\u0010(\u001a\u00020\u001a2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u000e2\u001a\u0010 \u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\"\u0012\u0004\u0012\u00020#0!H\u0002J\"\u0010)\u001a\u00020\u001a2\u001a\u0010 \u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\"\u0012\u0004\u0012\u00020#0!J$\u0010*\u001a\u00020\u001a2\u001a\u0010 \u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\"\u0012\u0004\u0012\u00020#0!H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018\u00a8\u0006-"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenProjectImporterUtil$LegacyExtensionImporter;", "", "myModule", "Lcom/intellij/openapi/module/Module;", "myMavenProjectsTree", "Lorg/jetbrains/idea/maven/project/MavenProjectsTree;", "myMavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "myMavenProjectChanges", "Lorg/jetbrains/idea/maven/project/MavenProjectChanges;", "myMavenProjectToModuleName", "", "", "myImporters", "", "Lorg/jetbrains/idea/maven/importing/MavenImporter;", "<init>", "(Lcom/intellij/openapi/module/Module;Lorg/jetbrains/idea/maven/project/MavenProjectsTree;Lorg/jetbrains/idea/maven/project/MavenProject;Lorg/jetbrains/idea/maven/project/MavenProjectChanges;Ljava/util/Map;Ljava/util/List;)V", "myRootModelAdapter", "Lorg/jetbrains/idea/maven/importing/MavenRootModelAdapter;", "myModifiableModelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "isModuleDisposed", "", "()Z", "init", "", "ideModelsProvider", "doConfigurationStep", "step", "Ljava/lang/Runnable;", "preConfig", "counters", "", "Ljava/lang/Class;", "Lorg/jetbrains/idea/maven/importing/MavenProjectImporterUtil$LegacyExtensionImporter$CountAndTime;", "doPreConfig", "config", "postTasks", "Lorg/jetbrains/idea/maven/project/MavenProjectsProcessorTask;", "doConfig", "postConfig", "doPostConfig", "CountAndTime", "Companion", "intellij.maven"})
    public static final class LegacyExtensionImporter {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Module myModule;
        @NotNull
        private final MavenProjectsTree myMavenProjectsTree;
        @NotNull
        private final MavenProject myMavenProject;
        @NotNull
        private final MavenProjectChanges myMavenProjectChanges;
        @NotNull
        private final Map<MavenProject, String> myMavenProjectToModuleName;
        @NotNull
        private final List<MavenImporter> myImporters;
        @Nullable
        private MavenRootModelAdapter myRootModelAdapter;
        @Nullable
        private IdeModifiableModelsProvider myModifiableModelsProvider;

        private LegacyExtensionImporter(Module myModule, MavenProjectsTree myMavenProjectsTree, MavenProject myMavenProject, MavenProjectChanges myMavenProjectChanges, Map<MavenProject, String> myMavenProjectToModuleName, List<? extends MavenImporter> myImporters) {
            this.myModule = myModule;
            this.myMavenProjectsTree = myMavenProjectsTree;
            this.myMavenProject = myMavenProject;
            this.myMavenProjectChanges = myMavenProjectChanges;
            this.myMavenProjectToModuleName = myMavenProjectToModuleName;
            this.myImporters = myImporters;
        }

        public final boolean isModuleDisposed() {
            return this.myModule.isDisposed();
        }

        public final void init(@NotNull IdeModifiableModelsProvider ideModelsProvider) {
            Intrinsics.checkNotNullParameter((Object)ideModelsProvider, (String)"ideModelsProvider");
            this.myModifiableModelsProvider = ideModelsProvider;
            this.myRootModelAdapter = new MavenRootModelAdapter(new MavenRootModelAdapterLegacyImpl(this.myMavenProject, this.myModule, this.myModifiableModelsProvider));
        }

        private final void doConfigurationStep(Runnable step) {
            MavenUtil.invokeAndWaitWriteAction(this.myModule.getProject(), step);
        }

        public final void preConfig(@NotNull Map<Class<? extends MavenImporter>, CountAndTime> counters) {
            Intrinsics.checkNotNullParameter(counters, (String)"counters");
            this.doConfigurationStep(() -> LegacyExtensionImporter.preConfig$lambda$0(this, counters));
        }

        private final void doPreConfig(Map<Class<? extends MavenImporter>, CountAndTime> counters) {
            if (this.myModule.isDisposed()) {
                return;
            }
            ModuleType moduleType = ModuleType.get((Module)this.myModule);
            Intrinsics.checkNotNullExpressionValue((Object)moduleType, (String)"get(...)");
            ModuleType moduleType2 = moduleType;
            for (MavenImporter importer : this.myImporters) {
                try {
                    if (importer.getModuleType() != moduleType2) continue;
                    LegacyExtensionImporter.Companion.measureImporterTime(importer, counters, true, () -> LegacyExtensionImporter.doPreConfig$lambda$1(importer, this));
                }
                catch (Exception e) {
                    MavenLog.LOG.error("Exception in MavenImporter.preConfig, skipping it.", (Throwable)e);
                }
            }
        }

        public final void config(@NotNull List<? extends MavenProjectsProcessorTask> postTasks, @NotNull Map<Class<? extends MavenImporter>, CountAndTime> counters) {
            Intrinsics.checkNotNullParameter(postTasks, (String)"postTasks");
            Intrinsics.checkNotNullParameter(counters, (String)"counters");
            this.doConfigurationStep(() -> LegacyExtensionImporter.config$lambda$2(this, postTasks, counters));
        }

        private final void doConfig(List<? extends MavenProjectsProcessorTask> postTasks, Map<Class<? extends MavenImporter>, CountAndTime> counters) {
            if (this.myModule.isDisposed()) {
                return;
            }
            ModuleType moduleType = ModuleType.get((Module)this.myModule);
            Intrinsics.checkNotNullExpressionValue((Object)moduleType, (String)"get(...)");
            ModuleType moduleType2 = moduleType;
            for (MavenImporter importer : this.myImporters) {
                if (importer.getModuleType() != moduleType2) continue;
                try {
                    LegacyExtensionImporter.Companion.measureImporterTime(importer, counters, false, () -> LegacyExtensionImporter.doConfig$lambda$3(importer, this, postTasks));
                }
                catch (Exception e) {
                    MavenLog.LOG.error("Exception in MavenImporter.config, skipping it.", (Throwable)e);
                }
            }
        }

        public final void postConfig(@NotNull Map<Class<? extends MavenImporter>, CountAndTime> counters) {
            Intrinsics.checkNotNullParameter(counters, (String)"counters");
            this.doConfigurationStep(() -> LegacyExtensionImporter.postConfig$lambda$4(this, counters));
        }

        private final void doPostConfig(Map<Class<? extends MavenImporter>, CountAndTime> counters) {
            if (this.myModule.isDisposed()) {
                return;
            }
            ModuleType moduleType = ModuleType.get((Module)this.myModule);
            Intrinsics.checkNotNullExpressionValue((Object)moduleType, (String)"get(...)");
            ModuleType moduleType2 = moduleType;
            for (MavenImporter importer : this.myImporters) {
                try {
                    if (!Intrinsics.areEqual(importer.getModuleType(), (Object)moduleType2)) continue;
                    LegacyExtensionImporter.Companion.measureImporterTime(importer, counters, false, () -> LegacyExtensionImporter.doPostConfig$lambda$5(importer, this));
                }
                catch (Exception e) {
                    MavenLog.LOG.error("Exception in MavenImporter.postConfig, skipping it.", (Throwable)e);
                }
            }
        }

        private static final void preConfig$lambda$0(LegacyExtensionImporter this$0, Map $counters) {
            this$0.doPreConfig($counters);
        }

        private static final void doPreConfig$lambda$1(MavenImporter $importer, LegacyExtensionImporter this$0) {
            $importer.preProcess(this$0.myModule, this$0.myMavenProject, this$0.myMavenProjectChanges, this$0.myModifiableModelsProvider);
        }

        private static final void config$lambda$2(LegacyExtensionImporter this$0, List $postTasks, Map $counters) {
            this$0.doConfig($postTasks, $counters);
        }

        private static final void doConfig$lambda$3(MavenImporter $importer, LegacyExtensionImporter this$0, List $postTasks) {
            IdeModifiableModelsProvider ideModifiableModelsProvider = this$0.myModifiableModelsProvider;
            Intrinsics.checkNotNull((Object)ideModifiableModelsProvider);
            Module module = this$0.myModule;
            MavenRootModelAdapter mavenRootModelAdapter = this$0.myRootModelAdapter;
            Intrinsics.checkNotNull((Object)mavenRootModelAdapter);
            $importer.process(ideModifiableModelsProvider, module, mavenRootModelAdapter, this$0.myMavenProjectsTree, this$0.myMavenProject, this$0.myMavenProjectChanges, this$0.myMavenProjectToModuleName, $postTasks);
        }

        private static final void postConfig$lambda$4(LegacyExtensionImporter this$0, Map $counters) {
            this$0.doPostConfig($counters);
        }

        private static final void doPostConfig$lambda$5(MavenImporter $importer, LegacyExtensionImporter this$0) {
            $importer.postProcess(this$0.myModule, this$0.myMavenProject, this$0.myMavenProjectChanges, this$0.myModifiableModelsProvider);
        }

        @JvmStatic
        @Nullable
        public static final LegacyExtensionImporter createIfApplicable(@NotNull MavenProject mavenProject, @NotNull Module module, @NotNull StandardMavenModuleType moduleType, @NotNull MavenProjectsTree mavenTree, @NotNull MavenProjectChanges changes, @NotNull Map<MavenProject, String> mavenProjectToModuleName, @NotNull List<? extends MavenImporter> mavenImporters) {
            return Companion.createIfApplicable(mavenProject, module, moduleType, mavenTree, changes, mavenProjectToModuleName, mavenImporters);
        }

        public /* synthetic */ LegacyExtensionImporter(Module myModule, MavenProjectsTree myMavenProjectsTree, MavenProject myMavenProject, MavenProjectChanges myMavenProjectChanges, Map myMavenProjectToModuleName, List myImporters, DefaultConstructorMarker $constructor_marker) {
            this(myModule, myMavenProjectsTree, myMavenProject, myMavenProjectChanges, myMavenProjectToModuleName, myImporters);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JT\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0007J<\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00152\u001a\u0010\u0019\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u001b\u0012\u0004\u0012\u00020\u001c0\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002\u00a8\u0006!"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenProjectImporterUtil$LegacyExtensionImporter$Companion;", "", "<init>", "()V", "createIfApplicable", "Lorg/jetbrains/idea/maven/importing/MavenProjectImporterUtil$LegacyExtensionImporter;", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "module", "Lcom/intellij/openapi/module/Module;", "moduleType", "Lorg/jetbrains/idea/maven/importing/StandardMavenModuleType;", "mavenTree", "Lorg/jetbrains/idea/maven/project/MavenProjectsTree;", "changes", "Lorg/jetbrains/idea/maven/project/MavenProjectChanges;", "mavenProjectToModuleName", "", "", "mavenImporters", "", "Lorg/jetbrains/idea/maven/importing/MavenImporter;", "measureImporterTime", "", "importer", "counters", "", "Ljava/lang/Class;", "Lorg/jetbrains/idea/maven/importing/MavenProjectImporterUtil$LegacyExtensionImporter$CountAndTime;", "increaseModuleCounter", "", "r", "Ljava/lang/Runnable;", "intellij.maven"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @Nullable
            public final LegacyExtensionImporter createIfApplicable(@NotNull MavenProject mavenProject, @NotNull Module module, @NotNull StandardMavenModuleType moduleType, @NotNull MavenProjectsTree mavenTree, @NotNull MavenProjectChanges changes, @NotNull Map<MavenProject, String> mavenProjectToModuleName, @NotNull List<? extends MavenImporter> mavenImporters) {
                Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                Intrinsics.checkNotNullParameter((Object)moduleType, (String)"moduleType");
                Intrinsics.checkNotNullParameter((Object)mavenTree, (String)"mavenTree");
                Intrinsics.checkNotNullParameter((Object)changes, (String)"changes");
                Intrinsics.checkNotNullParameter(mavenProjectToModuleName, (String)"mavenProjectToModuleName");
                Intrinsics.checkNotNullParameter(mavenImporters, (String)"mavenImporters");
                if (moduleType == StandardMavenModuleType.COMPOUND_MODULE) {
                    return null;
                }
                List<? extends MavenImporter> suitableImporters = mavenImporters;
                return suitableImporters.isEmpty() ? null : new LegacyExtensionImporter(module, mavenTree, mavenProject, changes, mavenProjectToModuleName, suitableImporters, null);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void measureImporterTime(MavenImporter importer, Map<Class<? extends MavenImporter>, CountAndTime> counters, boolean increaseModuleCounter, Runnable r) {
                long before = System.nanoTime();
                try {
                    r.run();
                }
                finally {
                    CountAndTime countAndTime = counters.computeIfAbsent(importer.getClass(), arg_0 -> Companion.measureImporterTime$lambda$1(Companion::measureImporterTime$lambda$0, arg_0));
                    Intrinsics.checkNotNullExpressionValue((Object)countAndTime, (String)"computeIfAbsent(...)");
                    CountAndTime countAndTime2 = countAndTime;
                    if (increaseModuleCounter) {
                        int n = countAndTime2.getCount();
                        countAndTime2.setCount(n + 1);
                    }
                    countAndTime2.setTimeNano(countAndTime2.getTimeNano() + (System.nanoTime() - before));
                }
            }

            private static final CountAndTime measureImporterTime$lambda$0(Class clazz) {
                return new CountAndTime();
            }

            private static final CountAndTime measureImporterTime$lambda$1(Function1 $tmp0, Object p0) {
                return (CountAndTime)$tmp0.invoke(p0);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenProjectImporterUtil$LegacyExtensionImporter$CountAndTime;", "", "<init>", "()V", "count", "", "getCount", "()I", "setCount", "(I)V", "timeNano", "", "getTimeNano", "()J", "setTimeNano", "(J)V", "intellij.maven"})
        public static final class CountAndTime {
            private int count;
            private long timeNano;

            public final int getCount() {
                return this.count;
            }

            public final void setCount(int n) {
                this.count = n;
            }

            public final long getTimeNano() {
                return this.timeNano;
            }

            public final void setTimeNano(long l) {
                this.timeNano = l;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenProjectImporterUtil$RefreshingFilesTask;", "Lorg/jetbrains/idea/maven/project/MavenProjectsProcessorTask;", "myFiles", "", "Ljava/io/File;", "<init>", "(Ljava/util/Set;)V", "perform", "", "project", "Lcom/intellij/openapi/project/Project;", "embeddersManager", "Lorg/jetbrains/idea/maven/project/MavenEmbeddersManager;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.maven"})
    private static final class RefreshingFilesTask
    implements MavenProjectsProcessorTask {
        @NotNull
        private final Set<File> myFiles;

        public RefreshingFilesTask(@NotNull Set<? extends File> myFiles) {
            Intrinsics.checkNotNullParameter(myFiles, (String)"myFiles");
            this.myFiles = myFiles;
        }

        @Override
        public void perform(@NotNull Project project, @NotNull MavenEmbeddersManager embeddersManager, @NotNull ProgressIndicator indicator) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)embeddersManager, (String)"embeddersManager");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            CoroutineScope cs = MavenCoroutineScopeProvider.Companion.getCoroutineScope(project);
            BuildersKt.launch$default((CoroutineScope)cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ RefreshingFilesTask this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            MavenProjectImporterUtil.access$doRefreshFiles(MavenProjectImporterUtil.INSTANCE, RefreshingFilesTask.access$getMyFiles$p(this.this$0));
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        public static final /* synthetic */ Set access$getMyFiles$p(RefreshingFilesTask $this) {
            return $this.myFiles;
        }
    }
}

