/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.impl.javaCompiler.BackendCompiler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.compiler.options.ExcludeEntryDescription;
import com.intellij.openapi.compiler.options.ExcludesConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.StringKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.MavenDisposable;
import org.jetbrains.idea.maven.importing.MavenApplicableConfigurator;
import org.jetbrains.idea.maven.importing.MavenCompilerConfiguration;
import org.jetbrains.idea.maven.importing.MavenCompilerConfiguratorKt;
import org.jetbrains.idea.maven.importing.MavenCompilerExtension;
import org.jetbrains.idea.maven.importing.MavenImportUtil;
import org.jetbrains.idea.maven.importing.MavenProjectImporterUtil;
import org.jetbrains.idea.maven.importing.MavenWorkspaceConfigurator;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.jps.model.java.compiler.CompilerOptions;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerOptions;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u00013B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\"\u0010\u0016\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0012H\u0002J0\u0010\u001a\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0012H\u0002J*\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0012H\u0002J*\u0010!\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\"2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0012H\u0002J \u0010#\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\"H\u0002J\u0010\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\fH\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0015H\u0002J\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020\u0015H\u0002J\u0014\u0010-\u001a\u0004\u0018\u00010\u00152\b\u0010(\u001a\u0004\u0018\u00010\u0015H\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010\u00152\u0006\u0010.\u001a\u00020\fH\u0002J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020\u0015002\u0006\u00101\u001a\u000202H\u0002\u00a8\u00064"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenCompilerConfigurator;", "Lorg/jetbrains/idea/maven/importing/MavenApplicableConfigurator;", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator;", "<init>", "()V", "beforeModelApplied", "", "context", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator$MutableModelContext;", "afterModelApplied", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator$AppliedModelContext;", "getCompilerConfigurationWhenApplicable", "Lorg/jdom/Element;", "project", "Lcom/intellij/openapi/project/Project;", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "selectDefaultCompilerExtension", "Lorg/jetbrains/idea/maven/importing/MavenCompilerExtension;", "allCompilers", "", "", "setDefaultProjectCompiler", "ideCompilerConfiguration", "Lcom/intellij/compiler/CompilerConfigurationImpl;", "defaultCompilerExtension", "configureModules", "mavenProjectWithModule", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/idea/maven/importing/MavenCompilerConfigurator$MavenProjectWithModulesData;", "applyCompilerExtensionConfiguration", "module", "Lcom/intellij/openapi/module/Module;", "configureTargetLevel", "Lcom/intellij/compiler/CompilerConfiguration;", "excludeArchetypeResources", "getCompilerId", "config", "hasUnresolvedProperty", "", "txt", "findClosingBraceOrNextUnresolvedProperty", "", "index", "s", "getResolvedText", "it", "collectCompilerArgs", "", "mavenCompilerConfiguration", "Lorg/jetbrains/idea/maven/importing/MavenCompilerConfiguration;", "MavenProjectWithModulesData", "intellij.maven"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMavenCompilerConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenCompilerConfigurator.kt\norg/jetbrains/idea/maven/importing/MavenCompilerConfigurator\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,268:1\n1148#2:269\n1317#2:270\n1318#2:273\n1149#2:274\n1317#2:275\n1318#2:278\n1#3:271\n1#3:272\n1863#4,2:276\n1557#4:279\n1628#4,3:280\n1557#4:283\n1628#4,3:284\n*S KotlinDebug\n*F\n+ 1 MavenCompilerConfigurator.kt\norg/jetbrains/idea/maven/importing/MavenCompilerConfigurator\n*L\n43#1:269\n43#1:270\n43#1:273\n43#1:274\n102#1:275\n102#1:278\n43#1:272\n103#1:276,2\n230#1:279\n230#1:280,3\n59#1:283\n59#1:284,3\n*E\n"})
public final class MavenCompilerConfigurator
extends MavenApplicableConfigurator
implements MavenWorkspaceConfigurator {
    public MavenCompilerConfigurator() {
        super("org.apache.maven.plugins", "maven-compiler-plugin");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void beforeModelApplied(@NotNull MavenWorkspaceConfigurator.MutableModelContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        MavenCompilerExtension defaultCompilerExtension = (MavenCompilerExtension)context2.getProject().getUserData(MavenCompilerConfiguratorKt.getDEFAULT_COMPILER_EXTENSION());
        context2.putUserData(MavenCompilerConfiguratorKt.getDEFAULT_COMPILER_EXTENSION(), null);
        if (defaultCompilerExtension == null) {
            void destination$iv;
            void $this$mapNotNullTo$iv;
            Sequence sequence = context2.getMavenProjectsWithModules();
            Collection collection = new LinkedHashSet();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv.iterator();
            while (iterator.hasNext()) {
                String string;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator.next();
                boolean bl = false;
                MavenWorkspaceConfigurator.MavenProjectWithModules it = (MavenWorkspaceConfigurator.MavenProjectWithModules)element$iv;
                boolean bl2 = false;
                if (this.getCompilerConfigurationWhenApplicable(context2.getProject(), it.getMavenProject()) != null) {
                    Element config;
                    boolean bl3 = false;
                    string = this.getCompilerId(config);
                } else {
                    string = null;
                }
                if (string == null) continue;
                String it$iv = string;
                boolean bl4 = false;
                destination$iv.add(it$iv);
            }
            Set allCompilers = (Set)destination$iv;
            defaultCompilerExtension = this.selectDefaultCompilerExtension(allCompilers);
        }
        context2.putUserData(MavenCompilerConfiguratorKt.getDEFAULT_COMPILER_EXTENSION(), defaultCompilerExtension);
    }

    @Override
    public void afterModelApplied(@NotNull MavenWorkspaceConfigurator.AppliedModelContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        MavenCompilerExtension defaultCompilerExtension = (MavenCompilerExtension)context2.getUserData(MavenCompilerConfiguratorKt.getDEFAULT_COMPILER_EXTENSION());
        CompilerConfiguration compilerConfiguration = CompilerConfiguration.getInstance((Project)context2.getProject());
        Intrinsics.checkNotNull((Object)compilerConfiguration, (String)"null cannot be cast to non-null type com.intellij.compiler.CompilerConfigurationImpl");
        CompilerConfigurationImpl ideCompilerConfiguration = (CompilerConfigurationImpl)compilerConfiguration;
        this.setDefaultProjectCompiler(context2.getProject(), ideCompilerConfiguration, defaultCompilerExtension);
        Sequence data = SequencesKt.map(context2.getMavenProjectsWithModules(), MavenCompilerConfigurator::afterModelApplied$lambda$3);
        this.configureModules(context2.getProject(), (Sequence<MavenProjectWithModulesData>)data, ideCompilerConfiguration, defaultCompilerExtension);
        MavenProjectImporterUtil.INSTANCE.removeOutdatedCompilerConfigSettings(context2.getProject());
    }

    private final Element getCompilerConfigurationWhenApplicable(Project project, MavenProject mavenProject) {
        if (!Registry.Companion.is("maven.import.compiler.arguments", true) || !MavenProjectsManager.getInstance(project).getImportingSettings().isAutoDetectCompiler()) {
            return null;
        }
        if (!super.isApplicable(mavenProject)) {
            return null;
        }
        return this.getConfig(mavenProject);
    }

    private final MavenCompilerExtension selectDefaultCompilerExtension(Set<String> allCompilers) {
        Object object;
        block2: {
            String string = (String)CollectionsKt.singleOrNull((Iterable)allCompilers);
            if (string == null) {
                string = "javac";
            }
            String defaultCompilerId = string;
            for (Object object2 : MavenCompilerExtension.EP_NAME.getExtensions()) {
                MavenCompilerExtension it = (MavenCompilerExtension)object2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)defaultCompilerId, (Object)it.getMavenCompilerId())) continue;
                object = object2;
                break block2;
            }
            object = null;
        }
        return (MavenCompilerExtension)object;
    }

    private final void setDefaultProjectCompiler(Project project, CompilerConfigurationImpl ideCompilerConfiguration, MavenCompilerExtension defaultCompilerExtension) {
        MavenCompilerExtension mavenCompilerExtension = defaultCompilerExtension;
        if (mavenCompilerExtension == null || (mavenCompilerExtension = mavenCompilerExtension.getCompiler(project)) == null) {
            return;
        }
        MavenCompilerExtension backendCompiler = mavenCompilerExtension;
        boolean autoDetectCompiler = MavenProjectsManager.getInstance(project).getImportingSettings().isAutoDetectCompiler();
        Object[] objectArray = new Object[]{autoDetectCompiler};
        MavenLog.LOG.debug("maven compiler autodetect = ", objectArray);
        if (!Intrinsics.areEqual((Object)ideCompilerConfiguration.getDefaultCompiler(), (Object)backendCompiler) && autoDetectCompiler) {
            if (ideCompilerConfiguration.getRegisteredJavaCompilers().contains(backendCompiler)) {
                ideCompilerConfiguration.setDefaultCompiler((BackendCompiler)backendCompiler);
            } else {
                MavenCompilerConfiguratorKt.access$getLOG$p().error((BackendCompiler)backendCompiler + " is not registered.");
            }
        }
    }

    private final void configureModules(Project project, Sequence<MavenProjectWithModulesData> mavenProjectWithModule, CompilerConfigurationImpl ideCompilerConfiguration, MavenCompilerExtension defaultCompilerExtension) {
        Sequence<MavenProjectWithModulesData> $this$forEach$iv = mavenProjectWithModule;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MavenProjectWithModulesData mavenProjectWithModulesData = (MavenProjectWithModulesData)element$iv;
            boolean bl = false;
            MavenProject mavenProject = mavenProjectWithModulesData.component1();
            List<Module> modules = mavenProjectWithModulesData.component2();
            Iterable $this$forEach$iv2 = modules;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Module module = (Module)element$iv2;
                boolean bl2 = false;
                this.applyCompilerExtensionConfiguration(mavenProject, module, ideCompilerConfiguration, defaultCompilerExtension);
                this.configureTargetLevel(mavenProject, module, (CompilerConfiguration)ideCompilerConfiguration, defaultCompilerExtension);
            }
            this.excludeArchetypeResources(project, mavenProject, (CompilerConfiguration)ideCompilerConfiguration);
        }
    }

    private final void applyCompilerExtensionConfiguration(MavenProject mavenProject, Module module, CompilerConfigurationImpl ideCompilerConfiguration, MavenCompilerExtension defaultCompilerExtension) {
        String string;
        Object object = mavenProject.getProperties().get("maven.compiler.parameters");
        MavenCompilerConfiguration mavenConfiguration = new MavenCompilerConfiguration(object != null ? object.toString() : null, this.getConfig(mavenProject));
        if (!Intrinsics.areEqual((Object)mavenProject.getPackaging(), (Object)"pom")) {
            Element element = mavenConfiguration.getPluginConfiguration();
            if (element != null) {
                Element it = element;
                boolean bl = false;
                string = this.getCompilerId(it);
            } else {
                string = null;
            }
        } else {
            string = null;
        }
        String projectCompilerId = string;
        for (MavenCompilerExtension compilerExtension : (MavenCompilerExtension[])MavenCompilerExtension.EP_NAME.getExtensions()) {
            JpsJavaCompilerOptions it;
            CompilerOptions compilerOptions;
            boolean applyThisExtension = Intrinsics.areEqual((Object)projectCompilerId, (Object)compilerExtension.getMavenCompilerId()) || projectCompilerId == null && Intrinsics.areEqual((Object)compilerExtension, (Object)defaultCompilerExtension);
            BackendCompiler backendCompiler = compilerExtension.getCompiler(module.getProject());
            Object object2 = compilerOptions = backendCompiler != null ? backendCompiler.getOptions() : null;
            if (applyThisExtension && !mavenConfiguration.isEmpty()) {
                compilerExtension.configureOptions(compilerOptions, module, mavenProject, this.collectCompilerArgs(mavenConfiguration));
                continue;
            }
            if ((compilerOptions instanceof JpsJavaCompilerOptions ? (JpsJavaCompilerOptions)compilerOptions : null) == null) continue;
            it = it;
            boolean bl = false;
            ideCompilerConfiguration.setAdditionalOptions(it, module, CollectionsKt.emptyList());
        }
    }

    private final void configureTargetLevel(MavenProject mavenProject, Module module, CompilerConfiguration ideCompilerConfiguration, MavenCompilerExtension defaultCompilerExtension) {
        String targetLevel;
        MavenCompilerExtension mavenCompilerExtension = defaultCompilerExtension;
        String string = targetLevel = mavenCompilerExtension != null ? mavenCompilerExtension.getDefaultCompilerTargetLevel(mavenProject, module) : null;
        if (targetLevel == null) {
            LanguageLevel level = null;
            if (MavenImportUtil.isTestModule(module.getName())) {
                level = MavenImportUtil.getTargetTestLanguageLevel(mavenProject);
                if (level == null) {
                    level = MavenImportUtil.getTargetLanguageLevel(mavenProject);
                }
            } else {
                level = MavenImportUtil.getTargetLanguageLevel(mavenProject);
            }
            if (level == null) {
                level = MavenImportUtil.getDefaultLevel(mavenProject);
            }
            level = MavenImportUtil.adjustLevelAndNotify(module.getProject(), level);
            targetLevel = level.toJavaVersion().toString();
        }
        MavenLog.LOG.debug("Setting bytecode target level " + targetLevel + " in module " + module.getName());
        ideCompilerConfiguration.setBytecodeTargetLevel(module, targetLevel);
    }

    private final void excludeArchetypeResources(Project project, MavenProject mavenProject, CompilerConfiguration ideCompilerConfiguration) {
        Object object;
        Object object2 = this;
        try {
            MavenCompilerConfigurator $this$excludeArchetypeResources_u24lambda_u249 = object2;
            boolean bl = false;
            String[] stringArray = new String[]{"src", "main", "resources", "archetype-resources"};
            object = Result.constructor-impl((Object)VfsUtil.findRelativeFile((VirtualFile)mavenProject.getDirectoryFile(), (String[])stringArray));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        VirtualFile dir = (VirtualFile)(Result.isFailure-impl((Object)object2) ? null : object2);
        if (dir != null && !ideCompilerConfiguration.isExcludedFromCompilation(dir)) {
            ExcludesConfiguration cfg = ideCompilerConfiguration.getExcludedEntriesConfiguration();
            cfg.addExcludeEntryDescription(new ExcludeEntryDescription(dir, true, false, (Disposable)MavenDisposable.getInstance(project)));
        }
    }

    private final String getCompilerId(Element config) {
        String compilerId = config.getChildTextTrim("compilerId");
        CharSequence charSequence = compilerId;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || Intrinsics.areEqual((Object)"javac", (Object)compilerId) || this.hasUnresolvedProperty(compilerId)) {
            return "javac";
        }
        return compilerId;
    }

    private final boolean hasUnresolvedProperty(String txt) {
        int i2 = StringsKt.indexOf$default((CharSequence)txt, (String)"${", (int)0, (boolean)false, (int)6, null);
        return i2 >= 0 && this.findClosingBraceOrNextUnresolvedProperty(i2 + 1, txt) != -1;
    }

    private final int findClosingBraceOrNextUnresolvedProperty(int index, String s) {
        if (index == -1) {
            return -1;
        }
        Object[] objectArray = new String[]{"}", "${"};
        Pair pair = StringsKt.findAnyOf$default((CharSequence)s, (Collection)CollectionsKt.listOf((Object[])objectArray), (int)index, (boolean)false, (int)4, null);
        if (pair == null) {
            return -1;
        }
        Pair pair2 = pair;
        if (Intrinsics.areEqual((Object)pair2.getSecond(), (Object)"}")) {
            return ((Number)pair2.getFirst()).intValue();
        }
        int nextIndex = Intrinsics.areEqual((Object)pair2.getSecond(), (Object)"${") ? ((Number)pair2.getFirst()).intValue() + 2 : ((Number)pair2.getFirst()).intValue() + 1;
        return this.findClosingBraceOrNextUnresolvedProperty(nextIndex, s);
    }

    private final String getResolvedText(String txt) {
        String string = StringKt.nullize$default((String)txt, (boolean)false, (int)1, null);
        if (string == null) {
            return null;
        }
        String result2 = string;
        if (this.hasUnresolvedProperty(result2)) {
            return null;
        }
        return result2;
    }

    private final String getResolvedText(Element it) {
        return this.getResolvedText(it.getTextTrim());
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> collectCompilerArgs(MavenCompilerConfiguration mavenCompilerConfiguration) {
        Element pluginConfiguration;
        List options = new ArrayList();
        Element element = pluginConfiguration = mavenCompilerConfiguration.getPluginConfiguration();
        Object parameters = element != null ? element.getChild("parameters") : null;
        Object object = parameters;
        boolean bl = object != null && (object = object.getTextTrim()) != null ? Boolean.parseBoolean((String)object) : false;
        if (bl) {
            ((Collection)options).add("-parameters");
        } else if (parameters == null) {
            String string = mavenCompilerConfiguration.getPropertyCompilerParameters();
            boolean bl2 = string != null ? Boolean.parseBoolean(string) : false;
            if (bl2) {
                ((Collection)options).add("-parameters");
            }
        }
        if (pluginConfiguration == null) {
            return options;
        }
        Element compilerArguments = pluginConfiguration.getChild("compilerArguments");
        if (compilerArguments != null) {
            void $this$mapTo$iv$iv;
            Set unresolvedArgs = new LinkedHashSet();
            List list = compilerArguments.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Element element2 = (Element)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                String $this$collectCompilerArgs_u24lambda_u2411_u24lambda_u2410 = it.getName();
                boolean bl4 = false;
                Intrinsics.checkNotNull((Object)$this$collectCompilerArgs_u24lambda_u2411_u24lambda_u2410);
                Object key = StringsKt.startsWith$default((String)$this$collectCompilerArgs_u24lambda_u2411_u24lambda_u2410, (String)"-", (boolean)false, (int)2, null) ? $this$collectCompilerArgs_u24lambda_u2411_u24lambda_u2410 : "-" + $this$collectCompilerArgs_u24lambda_u2411_u24lambda_u2410;
                Intrinsics.checkNotNull((Object)it);
                String value = this.getResolvedText((Element)it);
                if (value == null) {
                    String string = it.getTextTrim();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTextTrim(...)");
                    if (this.hasUnresolvedProperty(string)) {
                        ((Collection)unresolvedArgs).add(key);
                    }
                }
                collection.add(TuplesKt.to((Object)key, (Object)value));
            }
            Map effectiveArguments = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            effectiveArguments.forEach((arg_0, arg_1) -> MavenCompilerConfigurator.collectCompilerArgs$lambda$13((arg_0, arg_1) -> MavenCompilerConfigurator.collectCompilerArgs$lambda$12(options, unresolvedArgs, arg_0, arg_1), arg_0, arg_1));
        }
        ContainerUtil.addIfNotNull((Collection)options, (Object)this.getResolvedText(pluginConfiguration.getChildTextTrim("compilerArgument")));
        Element compilerArgs = pluginConfiguration.getChild("compilerArgs");
        if (compilerArgs != null) {
            for (Element arg : compilerArgs.getChildren("arg")) {
                Collection collection = options;
                Intrinsics.checkNotNull((Object)arg);
                ContainerUtil.addIfNotNull((Collection)collection, (Object)this.getResolvedText(arg));
            }
            for (Element compilerArg : compilerArgs.getChildren("compilerArg")) {
                Collection collection = options;
                Intrinsics.checkNotNull((Object)compilerArg);
                ContainerUtil.addIfNotNull((Collection)collection, (Object)this.getResolvedText(compilerArg));
            }
        }
        return options;
    }

    /*
     * WARNING - void declaration
     */
    private static final MavenProjectWithModulesData afterModelApplied$lambda$3(MavenWorkspaceConfigurator.MavenProjectWithModules it) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterable iterable = it.getModules();
        MavenProject mavenProject = it.getMavenProject();
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            MavenWorkspaceConfigurator.ModuleWithType moduleWithType = (MavenWorkspaceConfigurator.ModuleWithType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Module)it2.getModule());
        }
        List list = (List)destination$iv$iv;
        MavenProject mavenProject2 = mavenProject;
        return new MavenProjectWithModulesData(mavenProject2, list);
    }

    private static final Unit collectCompilerArgs$lambda$12(List $options, Set $unresolvedArgs, String key, String value) {
        Intrinsics.checkNotNull((Object)key);
        if (StringsKt.startsWith$default((String)key, (String)"-A", (boolean)false, (int)2, null) && value != null) {
            $options.add(key + "=" + value);
        } else if (!$unresolvedArgs.contains(key)) {
            $options.add(key);
            ContainerUtil.addIfNotNull((Collection)$options, (Object)value);
        }
        return Unit.INSTANCE;
    }

    private static final void collectCompilerArgs$lambda$13(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenCompilerConfigurator$MavenProjectWithModulesData;", "", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "modules", "", "Lcom/intellij/openapi/module/Module;", "<init>", "(Lorg/jetbrains/idea/maven/project/MavenProject;Ljava/util/List;)V", "getMavenProject", "()Lorg/jetbrains/idea/maven/project/MavenProject;", "getModules", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.maven"})
    private static final class MavenProjectWithModulesData {
        @NotNull
        private final MavenProject mavenProject;
        @NotNull
        private final List<Module> modules;

        public MavenProjectWithModulesData(@NotNull MavenProject mavenProject, @NotNull List<? extends Module> modules) {
            Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
            Intrinsics.checkNotNullParameter(modules, (String)"modules");
            this.mavenProject = mavenProject;
            this.modules = modules;
        }

        @NotNull
        public final MavenProject getMavenProject() {
            return this.mavenProject;
        }

        @NotNull
        public final List<Module> getModules() {
            return this.modules;
        }

        @NotNull
        public final MavenProject component1() {
            return this.mavenProject;
        }

        @NotNull
        public final List<Module> component2() {
            return this.modules;
        }

        @NotNull
        public final MavenProjectWithModulesData copy(@NotNull MavenProject mavenProject, @NotNull List<? extends Module> modules) {
            Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
            Intrinsics.checkNotNullParameter(modules, (String)"modules");
            return new MavenProjectWithModulesData(mavenProject, modules);
        }

        public static /* synthetic */ MavenProjectWithModulesData copy$default(MavenProjectWithModulesData mavenProjectWithModulesData, MavenProject mavenProject, List list, int n, Object object) {
            if ((n & 1) != 0) {
                mavenProject = mavenProjectWithModulesData.mavenProject;
            }
            if ((n & 2) != 0) {
                list = mavenProjectWithModulesData.modules;
            }
            return mavenProjectWithModulesData.copy(mavenProject, list);
        }

        @NotNull
        public String toString() {
            return "MavenProjectWithModulesData(mavenProject=" + this.mavenProject + ", modules=" + this.modules + ")";
        }

        public int hashCode() {
            int result2 = this.mavenProject.hashCode();
            result2 = result2 * 31 + ((Object)this.modules).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MavenProjectWithModulesData)) {
                return false;
            }
            MavenProjectWithModulesData mavenProjectWithModulesData = (MavenProjectWithModulesData)other;
            if (!Intrinsics.areEqual((Object)this.mavenProject, (Object)mavenProjectWithModulesData.mavenProject)) {
                return false;
            }
            return Intrinsics.areEqual(this.modules, mavenProjectWithModulesData.modules);
        }
    }
}

