/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.IExternalSystemSourceType;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioPathPrefixTreeFactory;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.util.containers.prefix.set.MutablePrefixTreeSet;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalSourceDirectorySet;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\t\u001a\u00020\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\"\u0010\t\u001a\u00020\n2\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00130\u0011H\u0002J\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\fJ\"\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00180\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ0\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00130\u0011H\u0002J \u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0006H\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u001e2\u0006\u0010\u001f\u001a\u00020\u0006H\u0002J\"\u0010 \u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00130\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0002J(\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0\u00130\u00112\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J(\u0010 \u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00130\u00112\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002R*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/plugins/gradle/service/project/GradleContentRootIndex;", "", "<init>", "()V", "contentRootWeightMap", "Ljava/util/HashMap;", "Ljava/nio/file/Path;", "", "Lkotlin/collections/HashMap;", "addSourceRoots", "", "sourceSet", "Lorg/jetbrains/plugins/gradle/model/ExternalSourceSet;", "sourceSetNode", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lorg/jetbrains/plugins/gradle/model/data/GradleSourceSetData;", "sources", "", "Lcom/intellij/openapi/externalSystem/model/project/IExternalSystemSourceType;", "", "resolveContentRoots", "", "externalProject", "Lorg/jetbrains/plugins/gradle/model/ExternalProject;", "", "resolveContentRoot", "projectRootPath", "buildRootPath", "sourceRootPath", "resolveParentPaths", "", "path", "getSources", "getSourceRoots", "Lcom/intellij/openapi/externalSystem/model/project/ContentRootData$SourceRoot;", "intellij.gradle"})
@SourceDebugExtension(value={"SMAP\nGradleContentRootIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleContentRootIndex.kt\norg/jetbrains/plugins/gradle/service/project/GradleContentRootIndex\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,131:1\n1628#2,3:132\n1246#2,2:137\n1557#2:139\n1628#2,3:140\n1249#2:143\n1246#2,2:146\n1557#2:148\n1628#2,3:149\n1249#2:152\n462#3:135\n412#3:136\n462#3:144\n412#3:145\n*S KotlinDebug\n*F\n+ 1 GradleContentRootIndex.kt\norg/jetbrains/plugins/gradle/service/project/GradleContentRootIndex\n*L\n54#1:132,3\n106#1:137,2\n106#1:139\n106#1:140,3\n106#1:143\n125#1:146,2\n126#1:148\n126#1:149,3\n125#1:152\n106#1:135\n106#1:136\n125#1:144\n125#1:145\n*E\n"})
public final class GradleContentRootIndex {
    @NotNull
    private final HashMap<Path, Integer> contentRootWeightMap = new HashMap();

    public final void addSourceRoots(@NotNull ExternalSourceSet sourceSet) {
        Intrinsics.checkNotNullParameter((Object)sourceSet, (String)"sourceSet");
        Map<IExternalSystemSourceType, Collection<Path>> sources = this.getSources(sourceSet);
        this.addSourceRoots(sources);
    }

    public final void addSourceRoots(@NotNull DataNode<GradleSourceSetData> sourceSetNode) {
        Intrinsics.checkNotNullParameter(sourceSetNode, (String)"sourceSetNode");
        Map<IExternalSystemSourceType, Collection<Path>> sources = this.getSources(sourceSetNode);
        this.addSourceRoots(sources);
    }

    private final void addSourceRoots(Map<IExternalSystemSourceType, ? extends Collection<? extends Path>> sources) {
        HashSet contentRootPaths = new HashSet();
        for (Collection<? extends Path> collection : sources.values()) {
            for (Path path : collection) {
                contentRootPaths.addAll(this.resolveParentPaths(path));
            }
        }
        Iterator iterator = contentRootPaths.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<Collection<Path>> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Collection<Path> collection = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"next(...)");
            Path path = (Path)((Object)collection);
            Integer n = this.contentRootWeightMap.getOrDefault(path, 0);
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getOrDefault(...)");
            int contentRootWeight = ((Number)n).intValue();
            ((Map)this.contentRootWeightMap).put(path, contentRootWeight + 1);
        }
    }

    @NotNull
    public final Set<Path> resolveContentRoots(@NotNull ExternalProject externalProject, @NotNull ExternalSourceSet sourceSet) {
        Intrinsics.checkNotNullParameter((Object)externalProject, (String)"externalProject");
        Intrinsics.checkNotNullParameter((Object)sourceSet, (String)"sourceSet");
        Map<IExternalSystemSourceType, Collection<Path>> sources = this.getSources(sourceSet);
        return this.resolveContentRoots(externalProject, sources);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> resolveContentRoots(@NotNull ExternalProject externalProject, @NotNull DataNode<GradleSourceSetData> sourceSetNode) {
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)externalProject, (String)"externalProject");
        Intrinsics.checkNotNullParameter(sourceSetNode, (String)"sourceSetNode");
        Map<IExternalSystemSourceType, Collection<Path>> sources = this.getSources(sourceSetNode);
        Set<Path> contentRoots = this.resolveContentRoots(externalProject, sources);
        Iterable iterable = contentRoots;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            Path path = (Path)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(NioPathUtil.toCanonicalPath((Path)it));
        }
        return (Set)destination$iv;
    }

    private final Set<Path> resolveContentRoots(ExternalProject externalProject, Map<IExternalSystemSourceType, ? extends Collection<? extends Path>> sources) {
        Path projectRootPath = externalProject.getProjectDir().toPath();
        Path buildRootPath = externalProject.getBuildDir().toPath();
        MutablePrefixTreeSet contentRootPaths = NioPathPrefixTreeFactory.INSTANCE.createSet((Object[])new Path[0]);
        for (Collection<? extends Path> collection : sources.values()) {
            for (Path path : collection) {
                Intrinsics.checkNotNull((Object)projectRootPath);
                Intrinsics.checkNotNull((Object)buildRootPath);
                Path contentRootPath = this.resolveContentRoot(projectRootPath, buildRootPath, path);
                contentRootPaths.add((Object)contentRootPath);
            }
        }
        return contentRootPaths.getRoots();
    }

    private final Path resolveContentRoot(Path projectRootPath, Path buildRootPath, Path sourceRootPath) {
        if (!sourceRootPath.startsWith(projectRootPath)) {
            return sourceRootPath;
        }
        if (sourceRootPath.startsWith(buildRootPath)) {
            return sourceRootPath;
        }
        Path contentRootPath = sourceRootPath.getParent();
        if (contentRootPath == null || Intrinsics.areEqual((Object)contentRootPath, (Object)projectRootPath)) {
            return sourceRootPath;
        }
        Integer contentRootWeight = this.contentRootWeightMap.get(contentRootPath);
        if (contentRootWeight == null || contentRootWeight > 1) {
            return sourceRootPath;
        }
        return contentRootPath;
    }

    private final List<Path> resolveParentPaths(Path path) {
        ArrayList<Path> result = new ArrayList<Path>();
        for (Path parentPath = path; parentPath != null; parentPath = parentPath.getParent()) {
            result.add(parentPath);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<IExternalSystemSourceType, Collection<Path>> getSources(ExternalSourceSet sourceSet) {
        void $this$mapValuesTo$iv$iv;
        Map map = sourceSet.getSources();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getSources(...)");
        Map $this$mapValues$iv = map;
        boolean $i$f$mapValues = false;
        Map map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$mapTo$iv$iv;
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            Set set = ((ExternalSourceDirectorySet)it.getValue()).getSrcDirs();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getSrcDirs(...)");
            Iterable $this$map$iv = set;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                File file = (File)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                boolean $i$f$getSources$lambda$1$stub_for_inlining = false;
                collection.add(p0.toPath());
            }
            List list = (List)destination$iv$iv2;
            map4.put(k, list);
        }
        return destination$iv$iv;
    }

    private final Map<IExternalSystemSourceType, Collection<ContentRootData.SourceRoot>> getSourceRoots(DataNode<GradleSourceSetData> sourceSetNode) {
        HashMap<Object, HashSet> sources = new HashMap<Object, HashSet>();
        for (DataNode contentRootNode : ExternalSystemApiUtil.findAll(sourceSetNode, (Key)ProjectKeys.CONTENT_ROOT)) {
            for (ExternalSystemSourceType sourceRootType : EntriesMappings.entries$0) {
                sources.computeIfAbsent(sourceRootType, arg_0 -> GradleContentRootIndex.getSourceRoots$lambda$3(GradleContentRootIndex::getSourceRoots$lambda$2, arg_0)).addAll(((ContentRootData)contentRootNode.getData()).getPaths(sourceRootType));
            }
        }
        return sources;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<IExternalSystemSourceType, Collection<Path>> getSources(DataNode<GradleSourceSetData> sourceSetNode) {
        void $this$mapValuesTo$iv$iv;
        Map<IExternalSystemSourceType, Collection<ContentRootData.SourceRoot>> $this$mapValues$iv = this.getSourceRoots(sourceSetNode);
        boolean $i$f$mapValues = false;
        Map<IExternalSystemSourceType, Collection<ContentRootData.SourceRoot>> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$mapTo$iv$iv;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            Collection sourceRoots = (Collection)entry2.getValue();
            Iterable $this$map$iv = sourceRoots;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void sourceRoot;
                ContentRootData.SourceRoot sourceRoot2 = (ContentRootData.SourceRoot)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add(Path.of(FileUtil.toSystemDependentName((String)sourceRoot.getPath()), new String[0]));
            }
            List list = (List)destination$iv$iv2;
            map3.put(k, list);
        }
        return destination$iv$iv;
    }

    private static final HashSet getSourceRoots$lambda$2(IExternalSystemSourceType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new HashSet();
    }

    private static final HashSet getSourceRoots$lambda$3(Function1 $tmp0, Object p0) {
        return (HashSet)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<ExternalSystemSourceType> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])ExternalSystemSourceType.values()));
        }
    }
}

