/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import git4idea.remote.GitRemoteUrlCoordinates;
import git4idea.remote.hosting.HostedGitRepositoryMapping;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitRepositoryMappingData;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.api.GHRepositoryPath;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.util.GithubUrlUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000  2\u00020\u00012\u00020\u0002:\u0001 B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0096\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0016H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006!"}, d2={"Lorg/jetbrains/plugins/github/util/GHGitRepositoryMapping;", "Lgit4idea/ui/branch/GitRepositoryMappingData;", "Lgit4idea/remote/hosting/HostedGitRepositoryMapping;", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "remote", "Lgit4idea/remote/GitRemoteUrlCoordinates;", "<init>", "(Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;Lgit4idea/remote/GitRemoteUrlCoordinates;)V", "getRepository", "()Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "getRemote", "()Lgit4idea/remote/GitRemoteUrlCoordinates;", "gitRemote", "Lgit4idea/repo/GitRemote;", "getGitRemote", "()Lgit4idea/repo/GitRemote;", "gitRepository", "Lgit4idea/repo/GitRepository;", "getGitRepository", "()Lgit4idea/repo/GitRepository;", "repositoryPath", "", "getRepositoryPath", "()Ljava/lang/String;", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "intellij.vcs.github"})
public final class GHGitRepositoryMapping
implements GitRepositoryMappingData,
HostedGitRepositoryMapping {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GHRepositoryCoordinates repository;
    @NotNull
    private final GitRemoteUrlCoordinates remote;

    public GHGitRepositoryMapping(@NotNull GHRepositoryCoordinates repository, @NotNull GitRemoteUrlCoordinates remote) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
        this.repository = repository;
        this.remote = remote;
    }

    @NotNull
    public GHRepositoryCoordinates getRepository() {
        return this.repository;
    }

    @NotNull
    public GitRemoteUrlCoordinates getRemote() {
        return this.remote;
    }

    @NotNull
    public GitRemote getGitRemote() {
        return this.getRemote().getRemote();
    }

    @NotNull
    public GitRepository getGitRepository() {
        return this.getRemote().getRepository();
    }

    @NotNull
    public String getRepositoryPath() {
        return this.getRepository().getRepositoryPath().getRepository();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GHGitRepositoryMapping)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getRepository(), (Object)((GHGitRepositoryMapping)other).getRepository());
    }

    public int hashCode() {
        return this.getRepository().hashCode();
    }

    @NotNull
    public String toString() {
        return "(repository=" + this.getRepository() + ", remote=" + this.getRepository() + ")";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/github/util/GHGitRepositoryMapping$Companion;", "", "<init>", "()V", "create", "Lorg/jetbrains/plugins/github/util/GHGitRepositoryMapping;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "remote", "Lgit4idea/remote/GitRemoteUrlCoordinates;", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final GHGitRepositoryMapping create(@NotNull GithubServerPath server, @NotNull GitRemoteUrlCoordinates remote) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
            GHRepositoryPath gHRepositoryPath = GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(remote.getUrl());
            if (gHRepositoryPath == null) {
                return null;
            }
            GHRepositoryPath repositoryPath = gHRepositoryPath;
            GHRepositoryCoordinates repository = new GHRepositoryCoordinates(server, repositoryPath);
            return new GHGitRepositoryMapping(repository, remote);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

