/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.driver.JTreeLocation;
import org.assertj.swing.driver.JTreeMatchingPathQuery;
import org.assertj.swing.driver.JTreePathFinder;
import org.assertj.swing.edt.GuiActionRunner;

final class JTreeNodeTextQuery {
    @Nullable
    @RunsInEDT
    static String nodeText(@Nonnull JTree tree, int row, @Nonnull JTreeLocation location, @Nonnull JTreePathFinder pathFinder) {
        return GuiActionRunner.execute(() -> {
            TreePath matchingPath = location.pathFor(tree, row);
            return pathFinder.cellReader().valueAt(tree, Preconditions.checkNotNull(matchingPath.getLastPathComponent()));
        });
    }

    @Nullable
    @RunsInEDT
    static String nodeText(@Nonnull JTree tree, @Nonnull String path, @Nonnull JTreePathFinder pathFinder) {
        return GuiActionRunner.execute(() -> {
            TreePath matchingPath = JTreeMatchingPathQuery.matchingPathWithRootIfInvisible(tree, path, pathFinder);
            return pathFinder.cellReader().valueAt(tree, Preconditions.checkNotNull(matchingPath.getLastPathComponent()));
        });
    }

    private JTreeNodeTextQuery() {
    }
}

