/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.compiler.plugins.kotlin.inference;

import androidx.compose.compiler.plugins.kotlin.inference.Binding;
import androidx.compose.compiler.plugins.kotlin.inference.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tJ\u0018\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tH\u0002J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\fH\u0002J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u001a\u001a\u00020\u0007H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Landroidx/compose/compiler/plugins/kotlin/inference/Bindings;", "", "<init>", "()V", "listeners", "", "Lkotlin/Function0;", "", "open", "Landroidx/compose/compiler/plugins/kotlin/inference/Binding;", "closed", "target", "", "onChange", "callback", "unify", "", "a", "b", "unifyValues", "value", "Landroidx/compose/compiler/plugins/kotlin/inference/Value;", "bind", "binding", "token", "bindingValueChanged", "changed", "compiler-hosted"})
public final class Bindings {
    @NotNull
    private final List<Function0<Unit>> listeners = new ArrayList();

    @NotNull
    public final Binding open() {
        return new Binding(null, SetsKt.setOf((Object)this), 1, null);
    }

    @NotNull
    public final Binding closed(@NotNull String target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return new Binding(target, SetsKt.emptySet());
    }

    @NotNull
    public final Function0<Unit> onChange(@NotNull Function0<Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.listeners.add(callback);
        return () -> Bindings.onChange$lambda$0(this, callback);
    }

    public final boolean unify(@NotNull Binding a, @NotNull Binding b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        String at = a.getValue().getToken();
        String bt = b.getValue().getToken();
        return at != null && bt == null ? this.bind(b, at) : (at == null && bt != null ? this.bind(a, bt) : (at != null && bt != null ? Intrinsics.areEqual((Object)at, (Object)bt) : this.bind(a, b)));
    }

    private final void unifyValues(Binding b, Value value) {
        b.setValue(value);
        Binding current = b.getNext();
        while (!Intrinsics.areEqual((Object)current, (Object)b)) {
            current.setValue(value);
            current = current.getNext();
        }
    }

    private final boolean bind(Binding a, Binding b) {
        Value bValue;
        Value aValue = a.getValue();
        if (Intrinsics.areEqual((Object)aValue, (Object)(bValue = b.getValue()))) {
            return true;
        }
        int aValueSize = aValue.getSize();
        int bValueSize = bValue.getSize();
        Set newObservers = SetsKt.plus(aValue.getObservers(), (Iterable)bValue.getObservers());
        if (aValueSize > bValueSize) {
            aValue.setSize(aValue.getSize() + bValueSize);
            aValue.setObservers(newObservers);
            this.unifyValues(b, aValue);
        } else {
            bValue.setSize(bValue.getSize() + aValueSize);
            bValue.setObservers(newObservers);
            this.unifyValues(a, bValue);
        }
        Binding nextA = a.getNext();
        Binding nextB = b.getNext();
        a.setNext(nextB);
        b.setNext(nextA);
        this.bindingValueChanged(a.getValue());
        return true;
    }

    private final boolean bind(Binding binding, String token) {
        Value value = binding.getValue();
        value.setToken(token);
        this.bindingValueChanged(value);
        value.setObservers(SetsKt.emptySet());
        return true;
    }

    private final void bindingValueChanged(Value value) {
        for (Bindings observer : value.getObservers()) {
            observer.changed();
        }
    }

    private final void changed() {
        if (!((Collection)this.listeners).isEmpty()) {
            for (Function0 listener : CollectionsKt.toMutableList((Collection)this.listeners)) {
                listener.invoke();
            }
        }
    }

    private static final Unit onChange$lambda$0(Bindings this$0, Function0 $callback) {
        this$0.listeners.remove($callback);
        return Unit.INSTANCE;
    }
}

