/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.internal.publication;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.HasConfigurableAttributes;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.component.SoftwareComponentVariant;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.CompositeDomainObjectSet;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.artifacts.DefaultExcludeRule;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.dependencies.DefaultProjectDependencyConstraint;
import org.gradle.api.internal.artifacts.dsl.dependencies.PlatformSupport;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MavenVersionUtils;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.DefaultVersionSelectorScheme;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.MavenVersionSelectorScheme;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectDependencyPublicationResolver;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.component.MavenPublishingAwareVariant;
import org.gradle.api.internal.component.SoftwareComponentInternal;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.publish.VersionMappingStrategy;
import org.gradle.api.publish.internal.CompositePublicationArtifactSet;
import org.gradle.api.publish.internal.DefaultPublicationArtifactSet;
import org.gradle.api.publish.internal.PublicationArtifactInternal;
import org.gradle.api.publish.internal.PublicationArtifactSet;
import org.gradle.api.publish.internal.PublicationInternal;
import org.gradle.api.publish.internal.validation.PublicationWarningsCollector;
import org.gradle.api.publish.internal.versionmapping.VersionMappingStrategyInternal;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.publish.maven.MavenArtifactSet;
import org.gradle.api.publish.maven.MavenPom;
import org.gradle.api.publish.maven.internal.artifact.AbstractMavenArtifact;
import org.gradle.api.publish.maven.internal.artifact.DefaultMavenArtifactSet;
import org.gradle.api.publish.maven.internal.artifact.DerivedMavenArtifact;
import org.gradle.api.publish.maven.internal.artifact.SingleOutputTaskMavenArtifact;
import org.gradle.api.publish.maven.internal.dependencies.DefaultMavenDependency;
import org.gradle.api.publish.maven.internal.dependencies.DefaultMavenProjectDependency;
import org.gradle.api.publish.maven.internal.dependencies.MavenDependencyInternal;
import org.gradle.api.publish.maven.internal.publication.DefaultMavenPom;
import org.gradle.api.publish.maven.internal.publication.DefaultMavenPomDependencies;
import org.gradle.api.publish.maven.internal.publication.MavenPomDependencies;
import org.gradle.api.publish.maven.internal.publication.MavenPomInternal;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.api.publish.maven.internal.publisher.MavenNormalizedPublication;
import org.gradle.api.publish.maven.internal.publisher.MutableMavenProjectIdentity;
import org.gradle.api.publish.maven.internal.validation.MavenPublicationErrorChecker;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.Cast;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.Factory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.util.internal.CollectionUtils;
import org.gradle.util.internal.GUtil;

public abstract class DefaultMavenPublication
implements MavenPublicationInternal {
    private static final Logger LOG = Logging.getLogger(DefaultMavenPublication.class);
    private static final String API_VARIANT = "api";
    private static final String API_ELEMENTS_VARIANT = "apiElements";
    private static final Set<ExcludeRule> EXCLUDE_ALL_RULE = Collections.singleton(new DefaultExcludeRule("*", "*"));
    private static final Comparator<String> VARIANT_ORDERING = (left, right) -> {
        if (API_VARIANT.equals(left) || API_ELEMENTS_VARIANT.equals(left)) {
            return -1;
        }
        if (API_VARIANT.equals(right) || API_ELEMENTS_VARIANT.equals(right)) {
            return 1;
        }
        return left.compareTo((String)right);
    };
    @VisibleForTesting
    public static final String INCOMPATIBLE_FEATURE = " contains dependencies that will produce a pom file that cannot be consumed by a Maven client.";
    @VisibleForTesting
    public static final String UNSUPPORTED_FEATURE = " contains dependencies that cannot be represented in a published pom file.";
    @VisibleForTesting
    public static final String PUBLICATION_WARNING_FOOTER = "These issues indicate information that is lost in the published 'pom' metadata file, which may be an issue if the published library is consumed by an old Gradle version or Apache Maven.\nThe 'module' metadata file, which is used by Gradle 6+ is not affected.";
    private final String name;
    private final ImmutableAttributesFactory immutableAttributesFactory;
    private final VersionMappingStrategyInternal versionMappingStrategy;
    private final TaskDependencyFactory taskDependencyFactory;
    private final Factory<ComponentParser> componentParserFactory;
    private final MavenPomInternal pom;
    private final MutableMavenProjectIdentity projectIdentity;
    private final DefaultMavenArtifactSet mainArtifacts;
    private final PublicationArtifactSet<MavenArtifact> metadataArtifacts;
    private final PublicationArtifactSet<MavenArtifact> derivedArtifacts;
    private final PublicationArtifactSet<MavenArtifact> publishableArtifacts;
    private final Property<ComponentParser.ParsedComponent> parsedComponent;
    private final Set<String> silencedVariants = new HashSet<String>();
    private MavenArtifact pomArtifact;
    private SingleOutputTaskMavenArtifact moduleMetadataArtifact;
    private TaskProvider<? extends Task> moduleDescriptorGenerator;
    private boolean isPublishWithOriginalFileName;
    private boolean alias;
    private boolean populated;
    private boolean artifactsOverridden;
    private boolean versionMappingInUse = false;
    private boolean silenceAllPublicationWarnings;
    private boolean withBuildIdentifier = false;

    @Inject
    public DefaultMavenPublication(String name, MutableMavenProjectIdentity projectIdentity, NotationParser<Object, MavenArtifact> mavenArtifactParser, Instantiator instantiator, ObjectFactory objectFactory, ProjectDependencyPublicationResolver projectDependencyResolver, FileCollectionFactory fileCollectionFactory, ImmutableAttributesFactory immutableAttributesFactory, CollectionCallbackActionDecorator collectionCallbackActionDecorator, VersionMappingStrategyInternal versionMappingStrategy, PlatformSupport platformSupport, DocumentationRegistry documentationRegistry, TaskDependencyFactory taskDependencyFactory) {
        this.name = name;
        this.projectIdentity = projectIdentity;
        this.immutableAttributesFactory = immutableAttributesFactory;
        this.versionMappingStrategy = versionMappingStrategy;
        this.taskDependencyFactory = taskDependencyFactory;
        this.componentParserFactory = () -> new ComponentParser(platformSupport, projectDependencyResolver, mavenArtifactParser, documentationRegistry);
        this.parsedComponent = objectFactory.property(ComponentParser.ParsedComponent.class);
        this.parsedComponent.convention(this.getComponent().map(this::parseComponent));
        this.parsedComponent.finalizeValueOnRead();
        this.mainArtifacts = (DefaultMavenArtifactSet)instantiator.newInstance(DefaultMavenArtifactSet.class, new Object[]{name, mavenArtifactParser, fileCollectionFactory, collectionCallbackActionDecorator});
        this.metadataArtifacts = new DefaultPublicationArtifactSet(MavenArtifact.class, "metadata artifacts for " + name, fileCollectionFactory, collectionCallbackActionDecorator);
        this.derivedArtifacts = new DefaultPublicationArtifactSet(MavenArtifact.class, "derived artifacts for " + name, fileCollectionFactory, collectionCallbackActionDecorator);
        this.publishableArtifacts = new CompositePublicationArtifactSet(taskDependencyFactory, MavenArtifact.class, (PublicationArtifactSet[])Cast.uncheckedCast((Object)new PublicationArtifactSet[]{this.mainArtifacts, this.metadataArtifacts, this.derivedArtifacts}));
        this.pom = (MavenPomInternal)instantiator.newInstance(DefaultMavenPom.class, new Object[]{this, instantiator, objectFactory});
        this.pom.getDependencies().set(this.parsedComponent.map(ComponentParser.ParsedComponent::getDependencies).orElse((Object)DefaultMavenPomDependencies.EMPTY));
    }

    public abstract Property<SoftwareComponentInternal> getComponent();

    public String getName() {
        return this.name;
    }

    public void withoutBuildIdentifier() {
        this.withBuildIdentifier = false;
    }

    public void withBuildIdentifier() {
        this.withBuildIdentifier = true;
    }

    public boolean isPublishBuildId() {
        return this.withBuildIdentifier;
    }

    public DisplayName getDisplayName() {
        return Describables.withTypeAndName((Object)"Maven publication", (String)this.name);
    }

    public boolean isLegacy() {
        return false;
    }

    @Override
    public MavenPomInternal getPom() {
        return this.pom;
    }

    @Override
    public void setPomGenerator(TaskProvider<? extends Task> pomGenerator) {
        if (this.pomArtifact != null) {
            this.metadataArtifacts.remove((Object)this.pomArtifact);
        }
        this.pomArtifact = new SingleOutputTaskMavenArtifact(pomGenerator, "pom", null, this.taskDependencyFactory);
        this.metadataArtifacts.add((Object)this.pomArtifact);
    }

    @Override
    public void setModuleDescriptorGenerator(TaskProvider<? extends Task> descriptorGenerator) {
        this.moduleDescriptorGenerator = descriptorGenerator;
        if (this.moduleMetadataArtifact != null) {
            this.metadataArtifacts.remove((Object)this.moduleMetadataArtifact);
        }
        this.moduleMetadataArtifact = null;
        this.updateModuleDescriptorArtifact();
    }

    private void updateModuleDescriptorArtifact() {
        if (!this.canPublishModuleMetadata()) {
            return;
        }
        if (this.moduleDescriptorGenerator == null) {
            return;
        }
        this.moduleMetadataArtifact = new SingleOutputTaskMavenArtifact(this.moduleDescriptorGenerator, "module", null, this.taskDependencyFactory);
        this.metadataArtifacts.add((Object)this.moduleMetadataArtifact);
        this.moduleDescriptorGenerator = null;
    }

    @Override
    public void pom(Action<? super MavenPom> configure) {
        configure.execute((Object)this.pom);
    }

    public boolean isAlias() {
        return this.alias;
    }

    public void setAlias(boolean alias) {
        this.alias = alias;
    }

    @Override
    public void from(SoftwareComponent component) {
        if (this.getComponent().isPresent()) {
            throw new InvalidUserDataException(String.format("Maven publication '%s' cannot include multiple components", this.name));
        }
        this.getComponent().set((Object)((SoftwareComponentInternal)component));
        this.getComponent().finalizeValue();
        this.artifactsOverridden = false;
        this.updateModuleDescriptorArtifact();
    }

    private void populateFromComponent() {
        if (this.populated) {
            return;
        }
        this.populated = true;
        if (!this.artifactsOverridden && this.parsedComponent.isPresent()) {
            this.mainArtifacts.addAll(((ComponentParser.ParsedComponent)this.parsedComponent.get()).getArtifacts());
        }
    }

    private ComponentParser.ParsedComponent parseComponent(SoftwareComponentInternal component) {
        component.finalizeValue();
        ComponentParser.ParsedComponent result = ((ComponentParser)this.componentParserFactory.create()).build(component, this.getCoordinates(), this.versionMappingInUse);
        if (!this.silenceAllPublicationWarnings) {
            result.getWarnings().complete(this.getDisplayName() + " pom metadata", this.silencedVariants);
        }
        return result;
    }

    private static Set<ExcludeRule> getExcludeRules(Set<ExcludeRule> globalExcludes, ModuleDependency dependency) {
        return dependency.isTransitive() ? Sets.union(globalExcludes, (Set)dependency.getExcludeRules()) : EXCLUDE_ALL_RULE;
    }

    @Override
    public MavenArtifact artifact(Object source) {
        return this.mainArtifacts.artifact(source);
    }

    @Override
    public MavenArtifact artifact(Object source, Action<? super MavenArtifact> config) {
        return this.mainArtifacts.artifact(source, config);
    }

    @Override
    public MavenArtifactSet getArtifacts() {
        this.populateFromComponent();
        return this.mainArtifacts;
    }

    @Override
    public void setArtifacts(Iterable<?> sources) {
        this.artifactsOverridden = true;
        this.mainArtifacts.clear();
        for (Object source : sources) {
            this.artifact(source);
        }
    }

    @Override
    public String getGroupId() {
        return (String)this.projectIdentity.getGroupId().get();
    }

    @Override
    public void setGroupId(String groupId) {
        this.projectIdentity.getGroupId().set((Object)groupId);
    }

    @Override
    public String getArtifactId() {
        return (String)this.projectIdentity.getArtifactId().get();
    }

    @Override
    public void setArtifactId(String artifactId) {
        this.projectIdentity.getArtifactId().set((Object)artifactId);
    }

    @Override
    public String getVersion() {
        return (String)this.projectIdentity.getVersion().get();
    }

    @Override
    public void setVersion(String version) {
        this.projectIdentity.getVersion().set((Object)version);
    }

    @Override
    public void versionMapping(Action<? super VersionMappingStrategy> configureAction) {
        this.versionMappingInUse = true;
        configureAction.execute((Object)this.versionMappingStrategy);
    }

    @Override
    public void suppressPomMetadataWarningsFor(String variantName) {
        this.silencedVariants.add(variantName);
    }

    @Override
    public void suppressAllPomMetadataWarnings() {
        this.silenceAllPublicationWarnings = true;
    }

    @Override
    public VersionMappingStrategyInternal getVersionMappingStrategy() {
        return this.versionMappingStrategy;
    }

    @Override
    public boolean writeGradleMetadataMarker() {
        return this.canPublishModuleMetadata() && this.moduleMetadataArtifact != null && this.moduleMetadataArtifact.isEnabled();
    }

    public PublicationArtifactSet<MavenArtifact> getPublishableArtifacts() {
        this.populateFromComponent();
        return this.publishableArtifacts;
    }

    public void allPublishableArtifacts(Action<? super MavenArtifact> action) {
        this.publishableArtifacts.all(action);
    }

    public void whenPublishableArtifactRemoved(Action<? super MavenArtifact> action) {
        this.publishableArtifacts.whenObjectRemoved(action);
    }

    public MavenArtifact addDerivedArtifact(MavenArtifact originalArtifact, PublicationInternal.DerivedArtifact file) {
        DerivedMavenArtifact artifact = new DerivedMavenArtifact((AbstractMavenArtifact)originalArtifact, file, this.taskDependencyFactory);
        this.derivedArtifacts.add((Object)artifact);
        return artifact;
    }

    public void removeDerivedArtifact(MavenArtifact artifact) {
        this.derivedArtifacts.remove((Object)artifact);
    }

    @Override
    public MutableMavenProjectIdentity getMavenProjectIdentity() {
        return this.projectIdentity;
    }

    @Override
    public MavenNormalizedPublication asNormalisedPublication() {
        this.populateFromComponent();
        Map<MavenArtifact, MavenArtifact> normalizedArtifacts = this.normalizedMavenArtifacts();
        return new MavenNormalizedPublication(this.name, this.projectIdentity, this.pom.getPackaging(), DefaultMavenPublication.normalizedArtifactFor(this.getPomArtifact(), normalizedArtifacts), DefaultMavenPublication.normalizedArtifactFor(this.determineMainArtifact(), normalizedArtifacts), new LinkedHashSet<MavenArtifact>(normalizedArtifacts.values()));
    }

    @Nullable
    private static MavenArtifact normalizedArtifactFor(@Nullable MavenArtifact artifact, Map<MavenArtifact, MavenArtifact> normalizedArtifacts) {
        if (artifact == null) {
            return null;
        }
        MavenArtifact normalized = normalizedArtifacts.get(artifact);
        if (normalized != null) {
            return normalized;
        }
        return DefaultMavenPublication.normalizedArtifactFor(artifact);
    }

    private Map<MavenArtifact, MavenArtifact> normalizedMavenArtifacts() {
        return this.artifactsToBePublished().stream().collect(Collectors.toMap(Function.identity(), DefaultMavenPublication::normalizedArtifactFor));
    }

    private static MavenArtifact normalizedArtifactFor(MavenArtifact artifact) {
        return new SerializableMavenArtifact(artifact);
    }

    private DomainObjectSet<MavenArtifact> artifactsToBePublished() {
        return CompositeDomainObjectSet.create(MavenArtifact.class, (DomainObjectCollection[])((DomainObjectCollection[])Cast.uncheckedCast((Object)new DomainObjectCollection[]{this.mainArtifacts, this.metadataArtifacts, this.derivedArtifacts}))).matching(element -> {
            if (!((PublicationArtifactInternal)element).shouldBePublished()) {
                return false;
            }
            if (this.moduleMetadataArtifact == element) {
                return this.moduleMetadataArtifact.isEnabled();
            }
            return true;
        });
    }

    private MavenArtifact getPomArtifact() {
        if (this.pomArtifact == null) {
            throw new IllegalStateException("pomArtifact not set for publication");
        }
        return this.pomArtifact;
    }

    @Override
    public String determinePackagingFromArtifacts() {
        Set<MavenArtifact> unclassifiedArtifacts = this.getUnclassifiedArtifactsWithExtension();
        if (unclassifiedArtifacts.size() == 1) {
            return unclassifiedArtifacts.iterator().next().getExtension();
        }
        return "pom";
    }

    @Nullable
    private MavenArtifact determineMainArtifact() {
        Set<MavenArtifact> unclassifiedArtifacts = this.getUnclassifiedArtifactsWithExtension();
        if (unclassifiedArtifacts.isEmpty()) {
            return null;
        }
        if (unclassifiedArtifacts.size() == 1) {
            return unclassifiedArtifacts.iterator().next();
        }
        for (MavenArtifact unclassifiedArtifact : unclassifiedArtifacts) {
            String packaging = this.pom.getPackaging();
            if (!unclassifiedArtifact.getExtension().equals(packaging)) continue;
            return unclassifiedArtifact;
        }
        return null;
    }

    private Set<MavenArtifact> getUnclassifiedArtifactsWithExtension() {
        this.populateFromComponent();
        return CollectionUtils.filter((Set)((Object)this.mainArtifacts), mavenArtifact -> DefaultMavenPublication.hasNoClassifier(mavenArtifact) && DefaultMavenPublication.hasExtension(mavenArtifact));
    }

    private static boolean hasNoClassifier(MavenArtifact element) {
        return element.getClassifier() == null || element.getClassifier().length() == 0;
    }

    private static boolean hasExtension(MavenArtifact element) {
        return element.getExtension() != null && element.getExtension().length() > 0;
    }

    public ModuleVersionIdentifier getCoordinates() {
        return DefaultModuleVersionIdentifier.newId((String)this.getGroupId(), (String)this.getArtifactId(), (String)this.getVersion());
    }

    @Nullable
    public <T> T getCoordinates(Class<T> type) {
        if (type.isAssignableFrom(ModuleVersionIdentifier.class)) {
            return type.cast(this.getCoordinates());
        }
        return null;
    }

    @Override
    public void publishWithOriginalFileName() {
        this.isPublishWithOriginalFileName = true;
    }

    private boolean canPublishModuleMetadata() {
        return this.getComponent().isPresent();
    }

    public PublicationInternal.PublishedFile getPublishedFile(PublishArtifact source) {
        this.populateFromComponent();
        MavenPublicationErrorChecker.checkThatArtifactIsPublishedUnmodified(source, this.mainArtifacts);
        final String publishedUrl = this.getPublishedUrl(source);
        final String publishedName = this.isPublishWithOriginalFileName ? source.getFile().getName() : publishedUrl;
        return new PublicationInternal.PublishedFile(){

            public String getName() {
                return publishedName;
            }

            public String getUri() {
                return publishedUrl;
            }
        };
    }

    @Nullable
    public ImmutableAttributes getAttributes() {
        String version = (String)this.getMavenProjectIdentity().getVersion().get();
        String status = MavenVersionUtils.inferStatusFromVersionNumber((String)version);
        return this.immutableAttributesFactory.of(ProjectInternal.STATUS_ATTRIBUTE, (Object)status);
    }

    private String getPublishedUrl(PublishArtifact source) {
        return this.getArtifactFileName(source.getClassifier(), source.getExtension());
    }

    private String getArtifactFileName(String classifier, String extension) {
        StringBuilder artifactPath = new StringBuilder();
        ModuleVersionIdentifier coordinates = this.getCoordinates();
        artifactPath.append(coordinates.getName());
        artifactPath.append('-');
        artifactPath.append(coordinates.getVersion());
        if (GUtil.isTrue((Object)classifier)) {
            artifactPath.append('-');
            artifactPath.append(classifier);
        }
        if (GUtil.isTrue((Object)extension)) {
            artifactPath.append('.');
            artifactPath.append(extension);
        }
        return artifactPath.toString();
    }

    static /* synthetic */ Logger access$100() {
        return LOG;
    }

    private static class SerializableMavenArtifact
    implements MavenArtifact,
    PublicationArtifactInternal {
        private final File file;
        private final String extension;
        private final String classifier;
        private final boolean shouldBePublished;

        public SerializableMavenArtifact(MavenArtifact artifact) {
            PublicationArtifactInternal artifactInternal = (PublicationArtifactInternal)artifact;
            this.file = artifact.getFile();
            this.extension = artifact.getExtension();
            this.classifier = artifact.getClassifier();
            this.shouldBePublished = artifactInternal.shouldBePublished();
        }

        @Override
        public String getExtension() {
            return this.extension;
        }

        @Override
        public void setExtension(String extension) {
            throw new IllegalStateException();
        }

        @Override
        @Nullable
        public String getClassifier() {
            return this.classifier;
        }

        @Override
        public void setClassifier(@Nullable String classifier) {
            throw new IllegalStateException();
        }

        public File getFile() {
            return this.file;
        }

        public void builtBy(Object ... tasks) {
            throw new IllegalStateException();
        }

        public TaskDependency getBuildDependencies() {
            throw new IllegalStateException();
        }

        public boolean shouldBePublished() {
            return this.shouldBePublished;
        }
    }

    private static class PublishedDependency {
        private final String group;
        private final String name;
        private final String targetConfiguration;
        private final AttributeContainer attributes;
        private final Set<DependencyArtifact> artifacts;
        private final Set<ExcludeRule> excludeRules;
        private final List<Capability> requestedCapabilities;

        private PublishedDependency(String group, String name, String targetConfiguration, AttributeContainer attributes, Set<DependencyArtifact> artifacts, Set<ExcludeRule> excludeRules, List<Capability> requestedCapabilities) {
            this.group = group;
            this.name = name;
            this.targetConfiguration = targetConfiguration;
            this.attributes = attributes;
            this.artifacts = artifacts;
            this.excludeRules = excludeRules;
            this.requestedCapabilities = requestedCapabilities;
        }

        static PublishedDependency of(ModuleDependency dep) {
            return new PublishedDependency(dep.getGroup(), dep.getName(), dep.getTargetConfiguration(), dep.getAttributes(), dep.getArtifacts(), dep.getExcludeRules(), dep.getRequestedCapabilities());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PublishedDependency that = (PublishedDependency)o;
            return Objects.equal((Object)this.group, (Object)that.group) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.targetConfiguration, (Object)that.targetConfiguration) && Objects.equal((Object)this.attributes, (Object)that.attributes) && Objects.equal(this.artifacts, that.artifacts) && Objects.equal(this.excludeRules, that.excludeRules) && Objects.equal(this.requestedCapabilities, that.requestedCapabilities);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.group, this.name, this.targetConfiguration, this.attributes, this.artifacts, this.excludeRules, this.requestedCapabilities});
        }
    }

    private static class ArtifactKey {
        final File file;
        final String classifier;
        final String extension;

        public ArtifactKey(File file, @Nullable String classifier, @Nullable String extension) {
            this.file = file;
            this.classifier = classifier;
            this.extension = extension;
        }

        public boolean equals(Object obj) {
            ArtifactKey other = (ArtifactKey)obj;
            return this.file.equals(other.file) && Objects.equal((Object)this.classifier, (Object)other.classifier) && Objects.equal((Object)this.extension, (Object)other.extension);
        }

        public int hashCode() {
            return this.file.hashCode() ^ Objects.hashCode((Object[])new Object[]{this.classifier, this.extension});
        }
    }

    private static class ComponentParser {
        private final PlatformSupport platformSupport;
        private final ProjectDependencyPublicationResolver projectDependencyResolver;
        private final NotationParser<Object, MavenArtifact> mavenArtifactParser;
        private final DocumentationRegistry documentationRegistry;
        private final Set<MavenArtifact> artifacts = new LinkedHashSet<MavenArtifact>();
        private final Set<MavenDependencyInternal> runtimeDependencies = new LinkedHashSet<MavenDependencyInternal>();
        private final Set<MavenDependencyInternal> apiDependencies = new LinkedHashSet<MavenDependencyInternal>();
        private final Set<MavenDependencyInternal> optionalApiDependencies = new LinkedHashSet<MavenDependencyInternal>();
        private final Set<MavenDependencyInternal> optionalRuntimeDependencies = new LinkedHashSet<MavenDependencyInternal>();
        private final Set<MavenDependencyInternal> runtimeDependencyConstraints = new LinkedHashSet<MavenDependencyInternal>();
        private final Set<MavenDependencyInternal> apiDependencyConstraints = new LinkedHashSet<MavenDependencyInternal>();
        private final Set<MavenDependencyInternal> importDependencyConstraints = new LinkedHashSet<MavenDependencyInternal>();
        private final PublicationWarningsCollector publicationWarningsCollector = new PublicationWarningsCollector(DefaultMavenPublication.access$100(), " contains dependencies that cannot be represented in a published pom file.", " contains dependencies that will produce a pom file that cannot be consumed by a Maven client.", "These issues indicate information that is lost in the published 'pom' metadata file, which may be an issue if the published library is consumed by an old Gradle version or Apache Maven.\nThe 'module' metadata file, which is used by Gradle 6+ is not affected.", "suppressPomMetadataWarningsFor");

        public ComponentParser(PlatformSupport platformSupport, ProjectDependencyPublicationResolver projectDependencyResolver, NotationParser<Object, MavenArtifact> mavenArtifactParser, DocumentationRegistry documentationRegistry) {
            this.platformSupport = platformSupport;
            this.projectDependencyResolver = projectDependencyResolver;
            this.mavenArtifactParser = mavenArtifactParser;
            this.documentationRegistry = documentationRegistry;
        }

        private ParsedComponent build(SoftwareComponentInternal component, ModuleVersionIdentifier coordinates, boolean versionMappingInUse) {
            MavenPublicationErrorChecker.checkForUnpublishableAttributes((SoftwareComponentInternal)component, (DocumentationRegistry)this.documentationRegistry);
            HashSet seenArtifacts = Sets.newHashSet();
            HashSet seenDependencies = Sets.newHashSet();
            HashSet seenConstraints = Sets.newHashSet();
            for (SoftwareComponentVariant variant : ComponentParser.getSortedVariants(component)) {
                for (PublishArtifact publishArtifact : variant.getArtifacts()) {
                    ArtifactKey key = new ArtifactKey(publishArtifact.getFile(), publishArtifact.getClassifier(), publishArtifact.getExtension());
                    if (!seenArtifacts.add(key)) continue;
                    this.artifacts.add((MavenArtifact)this.mavenArtifactParser.parseNotation((Object)publishArtifact));
                }
                Set globalExcludes = variant.getGlobalExcludes();
                this.publicationWarningsCollector.newContext(variant.getName());
                Set<MavenDependencyInternal> dependencies = this.dependenciesFor(variant);
                for (ModuleDependency dependency : variant.getDependencies()) {
                    if (!seenDependencies.add(PublishedDependency.of(dependency)) || ComponentParser.isDependencyWithDefaultArtifact(dependency) && ComponentParser.dependencyMatchesProject(dependency, coordinates)) continue;
                    if (this.platformSupport.isTargetingPlatform((HasConfigurableAttributes)dependency)) {
                        if (dependency instanceof ProjectDependency) {
                            this.addImportDependencyConstraint((ProjectDependency)dependency);
                            continue;
                        }
                        if (ComponentParser.isMavenIncompatibleVersionInUse(dependency.getVersion(), versionMappingInUse)) {
                            this.publicationWarningsCollector.addIncompatible(String.format("%s:%s:%s declared with a Maven incompatible version notation", dependency.getGroup(), dependency.getName(), dependency.getVersion()));
                        }
                        this.addImportDependencyConstraint(dependency);
                        continue;
                    }
                    if (!dependency.getAttributes().isEmpty()) {
                        this.publicationWarningsCollector.addUnsupported(String.format("%s:%s:%s declared with Gradle attributes", dependency.getGroup(), dependency.getName(), dependency.getVersion()));
                    }
                    if (dependency instanceof ProjectDependency) {
                        this.addProjectDependency((ProjectDependency)dependency, globalExcludes, dependencies);
                        continue;
                    }
                    if (ComponentParser.isMavenIncompatibleVersionInUse(dependency.getVersion(), versionMappingInUse)) {
                        this.publicationWarningsCollector.addIncompatible(String.format("%s:%s:%s declared with a Maven incompatible version notation", dependency.getGroup(), dependency.getName(), dependency.getVersion()));
                    }
                    ComponentParser.addModuleDependency(dependency, globalExcludes, dependencies);
                }
                Set<MavenDependencyInternal> dependencyConstraints = this.dependencyConstraintsFor(variant);
                for (DependencyConstraint dependency : variant.getDependencyConstraints()) {
                    if (!seenConstraints.add(dependency)) continue;
                    if (dependency instanceof DefaultProjectDependencyConstraint) {
                        this.addDependencyConstraint((DefaultProjectDependencyConstraint)dependency, dependencyConstraints);
                        continue;
                    }
                    if (dependency.getVersion() == null) continue;
                    if (ComponentParser.isMavenIncompatibleVersionInUse(dependency.getVersion(), versionMappingInUse)) {
                        this.publicationWarningsCollector.addIncompatible(String.format("constraint %s:%s:%s declared with a Maven incompatible version notation", dependency.getGroup(), dependency.getName(), dependency.getVersion()));
                    }
                    ComponentParser.addDependencyConstraint(dependency, dependencyConstraints);
                }
                if (variant.getCapabilities().isEmpty()) continue;
                for (Capability capability : variant.getCapabilities()) {
                    if (!ComponentParser.isNotDefaultCapability(capability, coordinates)) continue;
                    this.publicationWarningsCollector.addVariantUnsupported(String.format("Declares capability %s:%s:%s which cannot be mapped to Maven", capability.getGroup(), capability.getName(), capability.getVersion()));
                }
            }
            return new ParsedComponent(this.artifacts, new DefaultMavenPomDependencies((ImmutableList<MavenDependencyInternal>)ImmutableList.copyOf(this.runtimeDependencies), (ImmutableList<MavenDependencyInternal>)ImmutableList.copyOf(this.apiDependencies), (ImmutableList<MavenDependencyInternal>)ImmutableList.copyOf(this.optionalApiDependencies), (ImmutableList<MavenDependencyInternal>)ImmutableList.copyOf(this.optionalRuntimeDependencies), (ImmutableList<MavenDependencyInternal>)ImmutableList.copyOf(this.runtimeDependencyConstraints), (ImmutableList<MavenDependencyInternal>)ImmutableList.copyOf(this.apiDependencyConstraints), (ImmutableList<MavenDependencyInternal>)ImmutableList.copyOf(this.importDependencyConstraints)), this.publicationWarningsCollector);
        }

        private static boolean isNotDefaultCapability(Capability capability, ModuleVersionIdentifier coordinates) {
            return !capability.getGroup().equals(coordinates.getGroup()) || !capability.getName().equals(coordinates.getName()) || !capability.getVersion().equals(coordinates.getVersion());
        }

        private static boolean isDependencyWithDefaultArtifact(ModuleDependency dependency) {
            if (dependency.getArtifacts().isEmpty()) {
                return true;
            }
            return dependency.getArtifacts().stream().allMatch(artifact -> Strings.nullToEmpty((String)artifact.getClassifier()).isEmpty());
        }

        private static boolean dependencyMatchesProject(ModuleDependency dependency, ModuleVersionIdentifier coordinates) {
            return coordinates.getModule().equals(DefaultModuleIdentifier.newId((String)dependency.getGroup(), (String)dependency.getName()));
        }

        private static boolean isMavenIncompatibleVersionInUse(@Nullable String version, boolean versionMappingInUse) {
            if (versionMappingInUse) {
                return false;
            }
            if (version == null) {
                return false;
            }
            if (DefaultVersionSelectorScheme.isSubVersion((String)version)) {
                return true;
            }
            if (DefaultVersionSelectorScheme.isLatestVersion((String)version)) {
                return !MavenVersionSelectorScheme.isSubstituableLatest((String)version);
            }
            return false;
        }

        private void addImportDependencyConstraint(ProjectDependency dependency) {
            ModuleVersionIdentifier identifier = (ModuleVersionIdentifier)this.projectDependencyResolver.resolve(ModuleVersionIdentifier.class, dependency);
            this.importDependencyConstraints.add(new DefaultMavenDependency(identifier.getGroup(), identifier.getName(), identifier.getVersion(), "pom"));
        }

        private void addImportDependencyConstraint(ModuleDependency dependency) {
            this.importDependencyConstraints.add(new DefaultMavenDependency(dependency.getGroup(), dependency.getName(), dependency.getVersion(), "pom"));
        }

        private static List<SoftwareComponentVariant> getSortedVariants(SoftwareComponentInternal component) {
            Comparator<SoftwareComponentVariant> comparator = component instanceof AdhocComponentWithVariants ? Comparator.comparing(x -> ((MavenPublishingAwareVariant)x).getScopeMapping()) : (u1, u2) -> VARIANT_ORDERING.compare(u1.getName(), u2.getName());
            return component.getUsages().stream().sorted(comparator).collect(Collectors.toList());
        }

        private Set<MavenDependencyInternal> dependenciesFor(SoftwareComponentVariant variant) {
            String name;
            if (variant instanceof MavenPublishingAwareVariant) {
                MavenPublishingAwareVariant.ScopeMapping mapping = ((MavenPublishingAwareVariant)variant).getScopeMapping();
                switch (mapping) {
                    case compile: {
                        return this.apiDependencies;
                    }
                    case runtime: {
                        return this.runtimeDependencies;
                    }
                    case compile_optional: {
                        return this.optionalApiDependencies;
                    }
                    case runtime_optional: {
                        return this.optionalRuntimeDependencies;
                    }
                }
            }
            if (DefaultMavenPublication.API_VARIANT.equals(name = variant.getName()) || DefaultMavenPublication.API_ELEMENTS_VARIANT.equals(name)) {
                return this.apiDependencies;
            }
            return this.runtimeDependencies;
        }

        private Set<MavenDependencyInternal> dependencyConstraintsFor(SoftwareComponentVariant variant) {
            String name;
            if (variant instanceof MavenPublishingAwareVariant) {
                MavenPublishingAwareVariant.ScopeMapping mapping = ((MavenPublishingAwareVariant)variant).getScopeMapping();
                switch (mapping) {
                    case compile: 
                    case compile_optional: {
                        return this.apiDependencyConstraints;
                    }
                    case runtime: 
                    case runtime_optional: {
                        return this.runtimeDependencyConstraints;
                    }
                }
            }
            if (DefaultMavenPublication.API_VARIANT.equals(name = variant.getName()) || DefaultMavenPublication.API_ELEMENTS_VARIANT.equals(name)) {
                return this.apiDependencyConstraints;
            }
            return this.runtimeDependencyConstraints;
        }

        private void addProjectDependency(ProjectDependency dependency, Set<ExcludeRule> globalExcludes, Set<MavenDependencyInternal> dependencies) {
            ModuleVersionIdentifier identifier = (ModuleVersionIdentifier)this.projectDependencyResolver.resolve(ModuleVersionIdentifier.class, dependency);
            DefaultMavenDependency moduleDependency = new DefaultMavenDependency(identifier.getGroup(), identifier.getName(), identifier.getVersion(), Collections.emptyList(), DefaultMavenPublication.getExcludeRules(globalExcludes, (ModuleDependency)dependency));
            dependencies.add(new DefaultMavenProjectDependency(moduleDependency, dependency.getDependencyProject().getPath()));
        }

        private static void addModuleDependency(ModuleDependency dependency, Set<ExcludeRule> globalExcludes, Set<MavenDependencyInternal> dependencies) {
            dependencies.add(new DefaultMavenDependency(dependency.getGroup(), dependency.getName(), dependency.getVersion(), dependency.getArtifacts(), DefaultMavenPublication.getExcludeRules(globalExcludes, dependency)));
        }

        private static void addDependencyConstraint(DependencyConstraint dependency, Set<MavenDependencyInternal> dependencies) {
            dependencies.add(new DefaultMavenDependency(dependency.getGroup(), dependency.getName(), dependency.getVersion()));
        }

        private void addDependencyConstraint(DefaultProjectDependencyConstraint dependency, Set<MavenDependencyInternal> dependencies) {
            ProjectDependency projectDependency = dependency.getProjectDependency();
            ModuleVersionIdentifier identifier = (ModuleVersionIdentifier)this.projectDependencyResolver.resolve(ModuleVersionIdentifier.class, projectDependency);
            DefaultMavenDependency moduleDependency = new DefaultMavenDependency(identifier.getGroup(), identifier.getName(), identifier.getVersion());
            dependencies.add(new DefaultMavenProjectDependency(moduleDependency, projectDependency.getDependencyProject().getPath()));
        }

        private static class ParsedComponent {
            private final Set<MavenArtifact> artifacts;
            private final MavenPomDependencies dependencies;
            private final PublicationWarningsCollector warnings;

            public ParsedComponent(Set<MavenArtifact> artifacts, MavenPomDependencies dependencies, PublicationWarningsCollector warnings) {
                this.artifacts = artifacts;
                this.dependencies = dependencies;
                this.warnings = warnings;
            }

            public Set<MavenArtifact> getArtifacts() {
                return this.artifacts;
            }

            public MavenPomDependencies getDependencies() {
                return this.dependencies;
            }

            public PublicationWarningsCollector getWarnings() {
                return this.warnings;
            }
        }
    }
}

