/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.InetAddress;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.ConnectController;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.panel.FreeColButton;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.plaf.FreeColComboBoxRenderer;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColModFile;
import net.sf.freecol.common.io.FreeColRules;
import net.sf.freecol.common.metaserver.MetaServerUtils;
import net.sf.freecol.common.metaserver.ServerInfo;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.option.OptionGroup;

public final class NewPanel
extends FreeColPanel
implements ItemListener {
    private static final Logger logger = Logger.getLogger(NewPanel.class.getName());
    private final Specification fixedSpecification;
    private Specification specification = null;
    private OptionGroup difficulty = null;
    private final JTextField nameBox;
    private final ButtonGroup buttonGroup;
    private final JLabel advantagesLabel;
    private final JComboBox<NationOptions.Advantages> advantagesBox;
    private final JLabel serverPortLabel;
    private final JTextField serverPortField;
    private final JComboBox<InetAddress> serverAddressBox;
    private final JLabel rulesLabel;
    private final JComboBox<FreeColModFile> rulesBox;
    private final JCheckBox publicServer;
    private final JLabel difficultyLabel;
    private final JComboBox<OptionGroup> difficultyBox;
    private final JButton difficultyButton;
    private final JLabel joinNameLabel;
    private final JTextField joinNameField;
    private final JLabel joinPortLabel;
    private final JTextField joinPortField;
    private final Component[] joinComponents;
    private final Component[] serverComponents;
    private final Component[] gameComponents;

    public NewPanel(FreeColClient freeColClient) {
        this(freeColClient, null);
    }

    public NewPanel(FreeColClient freeColClient, Specification specification) {
        super(freeColClient, null, new MigLayout("wrap 6", "[15]", ""));
        String selectRules;
        this.fixedSpecification = specification;
        this.buttonGroup = new ButtonGroup();
        JRadioButton single = new JRadioButton(Messages.message("newPanel.singlePlayerGame"), true);
        JRadioButton join = new JRadioButton(Messages.message("newPanel.joinMultiPlayerGame"), false);
        JRadioButton start = new JRadioButton(Messages.message("newPanel.startMultiplayerGame"), false);
        JRadioButton meta = new JRadioButton(Messages.message("newPanel.getServerList") + " (" + FreeCol.getMetaServerAddress() + ")", false);
        this.buttonGroup.add(single);
        single.setActionCommand(String.valueOf((Object)NewPanelAction.SINGLE));
        single.addActionListener(ae -> this.enableComponents());
        this.buttonGroup.add(join);
        join.setActionCommand(String.valueOf((Object)NewPanelAction.JOIN));
        join.addActionListener(ae -> this.enableComponents());
        this.buttonGroup.add(start);
        start.setActionCommand(String.valueOf((Object)NewPanelAction.START));
        start.addActionListener(ae -> this.enableComponents());
        this.buttonGroup.add(meta);
        meta.setActionCommand(String.valueOf((Object)NewPanelAction.META_SERVER));
        meta.addActionListener(ae -> this.enableComponents());
        single.setSelected(true);
        String name = this.getClientOptions().getText("model.option.playerName");
        if (name == null || name.isEmpty()) {
            name = FreeCol.getName();
        }
        this.nameBox = new JTextField(name, 20);
        this.advantagesLabel = Utility.localizedLabel("newPanel.nationalAdvantages");
        this.advantagesBox = new JComboBox<NationOptions.Advantages>(new NationOptions.Advantages[]{NationOptions.Advantages.SELECTABLE, NationOptions.Advantages.FIXED, NationOptions.Advantages.NONE});
        this.advantagesBox.setRenderer(new FreeColComboBoxRenderer());
        this.serverPortLabel = Utility.localizedLabel("newPanel.startServerOnPort");
        this.serverPortField = new JTextField(Integer.toString(FreeCol.getServerPort()));
        this.serverPortField.addActionListener(ae -> this.getSelectedPort(this.serverPortField));
        this.serverAddressBox = Utility.createServerInetAddressBox();
        this.rulesLabel = Utility.localizedLabel("rules");
        this.rulesBox = new JComboBox();
        if (this.fixedSpecification == null) {
            selectRules = FreeCol.getRules();
            for (FreeColModFile tc : FreeColRules.getRulesList()) {
                this.rulesBox.addItem(tc);
                if (!selectRules.equals(tc.getId())) continue;
                this.rulesBox.setSelectedItem(tc);
            }
        } else {
            selectRules = this.fixedSpecification.getId();
            for (FreeColModFile tc : FreeColRules.getRulesList()) {
                if (!selectRules.equals(tc.getId())) continue;
                this.rulesBox.addItem(tc);
                this.rulesBox.setSelectedItem(tc);
            }
        }
        if (this.rulesBox.getSelectedItem() == null) {
            this.rulesBox.setSelectedItem(this.rulesBox.getItemCount() - 1);
            logger.warning("No TC found for: " + selectRules + ", failling back to " + this.rulesBox.getSelectedItem());
        }
        this.rulesBox.setRenderer(new FreeColComboBoxRenderer("mod."));
        this.rulesBox.addItemListener(this);
        this.publicServer = new JCheckBox(Messages.message("newPanel.publicServer"));
        this.serverAddressBox.addActionListener(event -> {
            InetAddress address = (InetAddress)this.serverAddressBox.getSelectedItem();
            this.publicServer.setEnabled(!address.isLoopbackAddress());
        });
        InetAddress address = (InetAddress)this.serverAddressBox.getSelectedItem();
        this.publicServer.setEnabled(!address.isLoopbackAddress());
        this.difficultyLabel = Utility.localizedLabel("difficulty");
        this.difficultyBox = new JComboBox();
        this.difficultyBox.setRenderer(new FreeColComboBoxRenderer());
        this.difficultyBox.addItemListener(this);
        this.difficultyButton = Utility.localizedButton("newPanel.showDifficulty");
        this.difficultyButton.addActionListener(ae -> this.getGUI().showDifficultyDialog(this.specification, this.difficulty, this.difficulty.isEditable(), group -> {
            if (group != null) {
                this.update(true);
            }
        }));
        this.joinNameLabel = Utility.localizedLabel("host");
        this.joinNameField = new JTextField(FreeCol.getServerHost());
        this.joinPortLabel = Utility.localizedLabel("port");
        this.joinPortField = new JTextField(Integer.toString(FreeCol.getServerPort()));
        this.joinPortField.addActionListener(ae -> this.getSelectedPort(this.joinPortField));
        this.okButton.setActionCommand(String.valueOf((Object)NewPanelAction.OK));
        final FreeColButton cancel = Utility.localizedButton("cancel");
        cancel.setActionCommand(String.valueOf((Object)NewPanelAction.CANCEL));
        cancel.addActionListener(ae -> {
            GUI gui = this.getGUI();
            gui.removeComponent(this);
            if (this.getFreeColClient().isMapEditor()) {
                gui.startMapEditorGUI();
            } else {
                gui.showMainPanel(null);
            }
        });
        this.setEscapeAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                cancel.doClick();
            }
        });
        this.add((Component)Utility.localizedHeader("newPanel.newGamePanel", Utility.FONTSPEC_TITLE), "span 6, center");
        this.add((Component)single, "newline, span 3");
        this.add((Component)new JSeparator(1), "spany 7, grow");
        this.add((Component)Utility.localizedLabel("name"), "span, split 2");
        this.add((Component)this.nameBox, "growx");
        this.add((Component)start, "newline, span 3");
        this.add(this.advantagesLabel);
        this.add(this.advantagesBox, "growx");
        this.add(this.serverAddressBox, "newline, skip");
        this.add((Component)this.serverPortLabel, "newline, skip");
        this.add((Component)this.serverPortField, "width 60:");
        this.add(this.rulesLabel);
        this.add(this.rulesBox, "growx");
        this.add((Component)this.publicServer, "newline, skip, span 2");
        this.add(this.difficultyLabel);
        this.add(this.difficultyBox, "growx");
        this.add((Component)meta, "newline, span 3");
        this.add((Component)this.difficultyButton, "skip 2, growx");
        this.add((Component)join, "newline, span 3");
        this.add((Component)this.joinNameLabel, "newline, skip, split 2");
        this.add((Component)this.joinNameField, "width 80:");
        this.add((Component)this.joinPortLabel, "split 2");
        this.add((Component)this.joinPortField, "width 60:");
        this.add((Component)this.okButton, "newline, span, split 2, tag ok");
        this.add((Component)cancel, "tag cancel");
        this.joinComponents = new Component[]{this.joinNameLabel, this.joinNameField, this.joinPortLabel, this.joinPortField};
        this.serverComponents = new Component[]{this.serverAddressBox, this.serverPortLabel, this.serverPortField, this.publicServer};
        this.gameComponents = new Component[]{this.advantagesLabel, this.advantagesBox, this.rulesLabel, this.rulesBox, this.difficultyLabel, this.difficultyBox, this.difficultyButton};
        this.specification = this.getSpecification();
        if (this.specification == null) {
            throw new RuntimeException("No specification found for: " + this);
        }
        this.difficulty = this.specification.getDifficultyOptionGroup(FreeCol.getDifficulty());
        this.updateDifficultyBox();
        if (this.difficulty == null) {
            int index = this.difficultyBox.getItemCount() / 2;
            this.difficultyBox.setSelectedItem(index);
            this.difficulty = this.getSelectedDifficulty();
        }
        if (this.difficulty == null) {
            throw new RuntimeException("No difficulty found for: " + this);
        }
        logger.info("NewPanel initialized with " + this.specification.getId() + "/" + this.difficulty.getId());
        this.enableComponents();
        this.setSize(this.getPreferredSize());
    }

    private void update(boolean changed) {
        if (!changed) {
            return;
        }
        if (this.difficulty.isEditable()) {
            this.specification.prepare(null, this.difficulty);
        } else {
            String oldId = this.difficulty.getId();
            this.difficulty = this.specification.getDifficultyOptionGroup(oldId);
        }
        this.updateDifficultyBox();
    }

    private boolean checkTC() {
        if (this.specification.getId().equals(this.getSelectedRules().getId())) {
            return false;
        }
        this.specification = this.getSpecification();
        return true;
    }

    private boolean checkDifficulty() {
        OptionGroup difficulty = this.getSelectedDifficulty();
        if (this.difficulty.getId().equals(difficulty.getId())) {
            return false;
        }
        this.difficulty = difficulty;
        return true;
    }

    private void updateDifficultyBox() {
        this.difficultyBox.removeItemListener(this);
        this.difficultyBox.removeAllItems();
        for (OptionGroup og : this.specification.getDifficultyLevels()) {
            this.difficultyBox.addItem(og);
        }
        if (this.difficulty != null) {
            this.difficultyBox.setSelectedItem(this.difficulty);
        }
        this.difficultyButton.setEnabled(this.difficulty != null);
        String text = this.difficulty != null && this.difficulty.isEditable() ? "newPanel.editDifficulty" : "newPanel.showDifficulty";
        this.difficultyButton.setText(Messages.message(text));
        this.difficultyBox.addItemListener(this);
    }

    private String getSelectedName() {
        return this.nameBox.getText();
    }

    private NationOptions.Advantages getSelectedAdvantages() {
        return (NationOptions.Advantages)this.advantagesBox.getSelectedItem();
    }

    private FreeColModFile getSelectedRules() {
        return (FreeColModFile)this.rulesBox.getSelectedItem();
    }

    private OptionGroup getSelectedDifficulty() {
        return (OptionGroup)this.difficultyBox.getSelectedItem();
    }

    private int getSelectedPort(JTextField field) {
        int port;
        try {
            port = Integer.parseInt(field.getText());
        }
        catch (NumberFormatException e) {
            port = -1;
        }
        if (0 < port && port < 65536) {
            return port;
        }
        field.setForeground(Color.red);
        return -1;
    }

    private void enableComponents() {
        NewPanelAction action = Enum.valueOf(NewPanelAction.class, this.buttonGroup.getSelection().getActionCommand());
        switch (action) {
            case SINGLE: {
                this.enableComponents(this.joinComponents, false);
                this.enableComponents(this.serverComponents, false);
                this.enableComponents(this.gameComponents, true);
                this.rulesBox.setEnabled(true);
                break;
            }
            case JOIN: {
                this.enableComponents(this.joinComponents, true);
                this.enableComponents(this.serverComponents, false);
                this.enableComponents(this.gameComponents, false);
                this.rulesBox.setEnabled(false);
                break;
            }
            case START: {
                this.enableComponents(this.joinComponents, false);
                this.enableComponents(this.serverComponents, true);
                this.enableComponents(this.gameComponents, true);
                this.rulesBox.setEnabled(true);
                break;
            }
            case META_SERVER: {
                this.enableComponents(this.joinComponents, false);
                this.enableComponents(this.serverComponents, false);
                this.enableComponents(this.gameComponents, false);
                this.rulesBox.setEnabled(false);
                break;
            }
        }
    }

    private void enableComponents(Component[] components, boolean enable) {
        for (Component c : components) {
            c.setEnabled(enable);
        }
    }

    @Override
    public Specification getSpecification() {
        if (this.fixedSpecification != null) {
            return this.fixedSpecification;
        }
        return FreeCol.loadSpecification(this.getSelectedRules(), null, null);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        ConnectController cc = this.getFreeColClient().getConnectController();
        GUI gui = this.getGUI();
        String command = ae.getActionCommand();
        block0 : switch (Enum.valueOf(NewPanelAction.class, command)) {
            case OK: {
                FreeCol.setName(this.getSelectedName());
                FreeCol.setAdvantages(this.getSelectedAdvantages());
                FreeCol.setRules(this.getSelectedRules().getId());
                NewPanelAction action = Enum.valueOf(NewPanelAction.class, this.buttonGroup.getSelection().getActionCommand());
                switch (action) {
                    case SINGLE: {
                        this.specification.prepare(this.getSelectedAdvantages(), this.difficulty);
                        if (!cc.startSinglePlayerGame(this.specification)) break block0;
                        return;
                    }
                    case JOIN: {
                        int joinPort = this.getSelectedPort(this.joinPortField);
                        if (joinPort < 0) break;
                        if (!cc.joinMultiplayerGame(this.joinNameField.getText(), joinPort)) break block0;
                        return;
                    }
                    case START: {
                        boolean publicServerValue;
                        int serverPort = this.getSelectedPort(this.serverPortField);
                        if (serverPort < 0) break;
                        this.specification.prepare(this.getSelectedAdvantages(), this.difficulty);
                        InetAddress serverAddress = (InetAddress)this.serverAddressBox.getSelectedItem();
                        boolean bl = publicServerValue = this.publicServer.isSelected() && !serverAddress.isLoopbackAddress();
                        if (!cc.startMultiplayerGame(this.specification, publicServerValue, serverAddress, serverPort)) break block0;
                        return;
                    }
                    case META_SERVER: {
                        List<ServerInfo> servers = MetaServerUtils.getServerList();
                        if (servers == null) break block0;
                        gui.showServerListPanel(servers);
                        break;
                    }
                }
                break;
            }
            default: {
                super.actionPerformed(ae);
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.update(this.checkTC() || this.checkDifficulty());
    }

    private static enum NewPanelAction {
        OK,
        CANCEL,
        SINGLE,
        JOIN,
        START,
        META_SERVER,
        SHOW_DIFFICULTY;

    }
}

