# Copyright (C) 2006-2010 Søren Roug, European Environment Agency
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
#
# Contributor(s):
#


__doc__=""" In principle the OpenDocument schema converted to python structures.
Currently it contains the legal child elements of a given element.
To be used for validation check in the API
"""

from .namespaces import (
    ANIMNS, CHARTNS, CONFIGNS, DCNS, DR3DNS, DRAWNS, FORMNS, MANIFESTNS, MATHNS,
    METANS, NUMBERNS, OFFICENS, PRESENTATIONNS, SCRIPTNS, STYLENS, SVGNS, TABLENS,
    TEXTNS, XFORMSNS, XLINKNS, SMILNS, FONS
)

# The following code is generated from the RelaxNG schema with this notice:

#   OASIS OpenDocument v1.1
#   OASIS Standard, 1 Feb 2007
#   Relax-NG Schema

#   $Id$

#   © 2002-2007 OASIS Open
#   © 1999-2007 Sun Microsystems, Inc.

#   This document and translations of it may be copied and furnished
#   to others, and derivative works that comment on or otherwise explain
#   it or assist in its implementation may be prepared, copied,
#   published and distributed, in whole or in part, without restriction
#   of any kind, provided that the above copyright notice and this
#   paragraph are included on all such copies and derivative works.
#   However, this document itself does not be modified in any way, such
#   as by removing the copyright notice or references to OASIS, except
#   as needed for the purpose of developing OASIS specifications, in
#   which case the procedures for copyrights defined in the OASIS
#   Intellectual Property Rights document must be followed, or as
#   required to translate it into languages other than English.
#

allowed_children = {
        (DCNS,'creator') : (
        ),
        (DCNS,'date') : (
        ),
        (DCNS,'description') : (
        ),
        (DCNS,'language') : (
        ),
        (DCNS,'subject') : (
        ),
        (DCNS,'title') : (
        ),
# Completes Dublin Core start
        # (DCNS,'contributor') : (
        # ),
        # (DCNS,'coverage') : (
        # ),
        # (DCNS,'format') : (
        # ),
        # (DCNS,'identifier') : (
        # ),
        # (DCNS,'publisher') : (
        # ),
        # (DCNS,'relation') : (
        # ),
        # (DCNS,'rights') : (
        # ),
        # (DCNS,'source') : (
        # ),
        # (DCNS,'type') : (
        # ),
# Completes Dublin Core end
        (MATHNS,'math') : None,

        (XFORMSNS,'model') : None,

        (ANIMNS,'animate') : (
        ),
        (ANIMNS,'animateColor') : (
        ),
        (ANIMNS,'animateMotion') : (
        ),
        (ANIMNS,'animateTransform') : (
        ),
        (ANIMNS,'audio') : (
        ),
        (ANIMNS,'command') : (
                (ANIMNS,'param'),
        ),
# allowed_children
        (ANIMNS,'iterate') : (
                (ANIMNS,'animate'),
                (ANIMNS,'animateColor'),
                (ANIMNS,'animateMotion'),
                (ANIMNS,'animateTransform'),
                (ANIMNS,'audio'),
                (ANIMNS,'command'),
                (ANIMNS,'iterate'),
                (ANIMNS,'par'),
                (ANIMNS,'seq'),
                (ANIMNS,'set'),
                (ANIMNS,'transitionFilter'),
        ),
        (ANIMNS,'par') : (
                (ANIMNS,'animate'),
                (ANIMNS,'animateColor'),
                (ANIMNS,'animateMotion'),
                (ANIMNS,'animateTransform'),
                (ANIMNS,'audio'),
                (ANIMNS,'command'),
                (ANIMNS,'iterate'),
                (ANIMNS,'par'),
                (ANIMNS,'seq'),
                (ANIMNS,'set'),
                (ANIMNS,'transitionFilter'),
        ),
# allowed_children
        (ANIMNS,'param') : (
        ),
        (ANIMNS,'seq') : (
                (ANIMNS,'animate'),
                (ANIMNS,'animateColor'),
                (ANIMNS,'animateMotion'),
                (ANIMNS,'animateTransform'),
                (ANIMNS,'audio'),
                (ANIMNS,'command'),
                (ANIMNS,'iterate'),
                (ANIMNS,'par'),
                (ANIMNS,'seq'),
                (ANIMNS,'set'),
                (ANIMNS,'transitionFilter'),
        ),
        (ANIMNS,'set') : (
        ),
        (ANIMNS,'transitionFilter') : (
        ),
        (CHARTNS,'axis') : (
                (CHARTNS,'categories'),
                (CHARTNS,'grid'),
                (CHARTNS,'title'),
        ),
# allowed_children
        (CHARTNS,'categories') : (
        ),
        (CHARTNS,'chart') : (
                (CHARTNS,'footer'),
                (CHARTNS,'legend'),
                (CHARTNS,'plot-area'),
                (CHARTNS,'subtitle'),
                (CHARTNS,'title'),
                (TABLENS,'table'),
        ),
        (CHARTNS,'data-point') : (
        ),
        (CHARTNS,'domain') : (
        ),
        (CHARTNS,'error-indicator') : (
        ),
        (CHARTNS,'floor') : (
        ),
        (CHARTNS,'footer') : (
                (TEXTNS,'p'),
        ),
        (CHARTNS,'grid') : (
        ),
        (CHARTNS,'legend') : (
        ),
# allowed_children
        (CHARTNS,'mean-value') : (
        ),
        (CHARTNS,'plot-area') : (
                (CHARTNS,'axis'),
                (CHARTNS,'floor'),
                (CHARTNS,'series'),
                (CHARTNS,'stock-gain-marker'),
                (CHARTNS,'stock-loss-marker'),
                (CHARTNS,'stock-range-line'),
                (CHARTNS,'wall'),
                (DR3DNS,'light'),
        ),
        (CHARTNS,'regression-curve') : (
        ),
        (CHARTNS,'series') : (
                (CHARTNS,'data-point'),
                (CHARTNS,'domain'),
                (CHARTNS,'error-indicator'),
                (CHARTNS,'mean-value'),
                (CHARTNS,'regression-curve'),
        ),
        (CHARTNS,'stock-gain-marker') : (
        ),
        (CHARTNS,'stock-loss-marker') : (
        ),
# allowed_children
        (CHARTNS,'stock-range-line') : (
        ),
        (CHARTNS,'subtitle') : (
                (TEXTNS,'p'),
        ),
        (CHARTNS,'symbol-image') : (
        ),
        (CHARTNS,'title') : (
                (TEXTNS,'p'),
        ),
        (CHARTNS,'wall') : (
        ),
        (CONFIGNS,'config-item') : (
        ),
        (CONFIGNS,'config-item-map-entry') : (
                (CONFIGNS,'config-item'),
                (CONFIGNS,'config-item-map-indexed'),
                (CONFIGNS,'config-item-map-named'),
                (CONFIGNS,'config-item-set'),
        ),
        (CONFIGNS,'config-item-map-indexed') : (
                (CONFIGNS,'config-item-map-entry'),
        ),
        (CONFIGNS,'config-item-map-named') : (
                (CONFIGNS,'config-item-map-entry'),
        ),
# allowed_children
        (CONFIGNS,'config-item-set') : (
                (CONFIGNS,'config-item'),
                (CONFIGNS,'config-item-map-indexed'),
                (CONFIGNS,'config-item-map-named'),
                (CONFIGNS,'config-item-set'),
        ),
        (MANIFESTNS,'algorithm') : (
        ),
        (MANIFESTNS,'encryption-data') : (
                (MANIFESTNS,'algorithm'),
                (MANIFESTNS,'key-derivation'),
        ),
        (MANIFESTNS,'file-entry') : (
                (MANIFESTNS,'encryption-data'),
        ),
        (MANIFESTNS,'key-derivation') : (
        ),
        (MANIFESTNS,'manifest') : (
                (MANIFESTNS,'file-entry'),
        ),
        (NUMBERNS,'am-pm') : (
        ),
        (NUMBERNS,'boolean') : (
        ),
# allowed_children
        (NUMBERNS,'boolean-style') : (
                (NUMBERNS,'boolean'),
                (NUMBERNS,'text'),
                (STYLENS,'map'),
                (STYLENS,'text-properties'),
        ),
        (NUMBERNS,'currency-style') : (
                (NUMBERNS,'currency-symbol'),
                (NUMBERNS,'number'),
                (NUMBERNS,'text'),
                (STYLENS,'map'),
                (STYLENS,'text-properties'),
        ),
        (NUMBERNS,'currency-symbol') : (
        ),
        (NUMBERNS,'date-style') : (
                (NUMBERNS,'am-pm'),
                (NUMBERNS,'day'),
                (NUMBERNS,'day-of-week'),
                (NUMBERNS,'era'),
                (NUMBERNS,'hours'),
                (NUMBERNS,'minutes'),
                (NUMBERNS,'month'),
                (NUMBERNS,'quarter'),
                (NUMBERNS,'seconds'),
                (NUMBERNS,'text'),
                (NUMBERNS,'week-of-year'),
                (NUMBERNS,'year'),
                (STYLENS,'map'),
                (STYLENS,'text-properties'),
        ),
# allowed_children
        (NUMBERNS,'day') : (
        ),
        (NUMBERNS,'day-of-week') : (
        ),
        (NUMBERNS,'embedded-text') : (
        ),
        (NUMBERNS,'era') : (
        ),
        (NUMBERNS,'fraction') : (
        ),
        (NUMBERNS,'hours') : (
        ),
        (NUMBERNS,'minutes') : (
        ),
        (NUMBERNS,'month') : (
        ),
        (NUMBERNS,'number') : (
                (NUMBERNS,'embedded-text'),
        ),
        (NUMBERNS,'number-style') : (
                (NUMBERNS,'fraction'),
                (NUMBERNS,'number'),
                (NUMBERNS,'scientific-number'),
                (NUMBERNS,'text'),
                (STYLENS,'map'),
                (STYLENS,'text-properties'),
        ),
# allowed_children
        (NUMBERNS,'percentage-style') : (
                (NUMBERNS,'number'),
                (NUMBERNS,'text'),
                (STYLENS,'map'),
                (STYLENS,'text-properties'),
        ),
        (NUMBERNS,'quarter') : (
        ),
        (NUMBERNS,'scientific-number') : (
        ),
        (NUMBERNS,'seconds') : (
        ),
        (NUMBERNS,'text') : (
        ),
        (NUMBERNS,'text-content') : (
        ),
        (NUMBERNS,'text-style') : (
                (NUMBERNS,'text'),
                (NUMBERNS,'text-content'),
                (STYLENS,'map'),
                (STYLENS,'text-properties'),
        ),
# allowed_children
        (NUMBERNS,'time-style') : (
                (NUMBERNS,'am-pm'),
                (NUMBERNS,'hours'),
                (NUMBERNS,'minutes'),
                (NUMBERNS,'seconds'),
                (NUMBERNS,'text'),
                (STYLENS,'map'),
                (STYLENS,'text-properties'),
        ),
# allowed_children
        (NUMBERNS,'week-of-year') : (
        ),
        (NUMBERNS,'year') : (
        ),
        (DR3DNS,'cube') : (
        ),
        (DR3DNS,'extrude') : (
        ),
        (DR3DNS,'light') : (
        ),
        (DR3DNS,'rotate') : (
        ),
        (DR3DNS,'scene') : (
                (DR3DNS,'cube'),
                (DR3DNS,'extrude'),
                (DR3DNS,'light'),
                (DR3DNS,'rotate'),
                (DR3DNS,'scene'),
                (DR3DNS,'sphere'),
                (SVGNS,'title'),
                (SVGNS,'desc'),
        ),
        (DR3DNS,'sphere') : (
        ),
        (DRAWNS,'a') : (
                (DRAWNS,'frame'),
        ),
# allowed_children
        (DRAWNS,'applet') : (
                (DRAWNS,'param'),
        ),
        (DRAWNS,'area-circle') : (
                (OFFICENS,'event-listeners'),
                (SVGNS,'desc'),
                (SVGNS,'title'),
        ),
        (DRAWNS,'area-polygon') : (
                (OFFICENS,'event-listeners'),
                (SVGNS,'desc'),
                (SVGNS,'title'),
        ),
        (DRAWNS,'area-rectangle') : (
                (OFFICENS,'event-listeners'),
                (SVGNS,'desc'),
                (SVGNS,'title'),
        ),
        (DRAWNS,'caption') : (
                (DRAWNS,'glue-point'),
                (OFFICENS,'event-listeners'),
                (SVGNS,'desc'),
                (SVGNS,'title'),
                (TEXTNS,'list'),
                (TEXTNS,'p'),
        ),
        (DRAWNS,'circle') : (
                (DRAWNS,'glue-point'),
                (OFFICENS,'event-listeners'),
                (SVGNS,'desc'),
                (SVGNS,'title'),
                (TEXTNS,'list'),
                (TEXTNS,'p'),
        ),
# allowed_children
        (DRAWNS,'connector') : (
                (DRAWNS,'glue-point'),
                (OFFICENS,'event-listeners'),
                (SVGNS,'desc'),
                (SVGNS,'title'),
                (TEXTNS,'list'),
                (TEXTNS,'p'),
        ),
        (DRAWNS,'contour-path') : (
        ),
        (DRAWNS,'contour-polygon') : (
        ),
        (DRAWNS,'control') : (
                (DRAWNS,'glue-point'),
                (SVGNS,'desc'),
                (SVGNS,'title'),
        ),
        (DRAWNS,'custom-shape') : (
                (DRAWNS,'enhanced-geometry'),
                (DRAWNS,'glue-point'),
                (OFFICENS,'event-listeners'),
                (SVGNS,'desc'),
                (SVGNS,'title'),
                (TEXTNS,'list'),
                (TEXTNS,'p'),
        ),
# allowed_children
        (DRAWNS,'ellipse') : (
                (DRAWNS,'glue-point'),
                (OFFICENS,'event-listeners'),
                (SVGNS,'desc'),
                (SVGNS,'title'),
                (TEXTNS,'list'),
                (TEXTNS,'p'),
        ),
        (DRAWNS,'enhanced-geometry') : (
                (DRAWNS,'equation'),
                (DRAWNS,'handle'),
        ),
        (DRAWNS,'equation') : (
        ),
# allowed_children
        (DRAWNS,'fill-image') : (
        ),
        (DRAWNS,'floating-frame') : (
        ),
        (DRAWNS,'frame') : (
                (DRAWNS,'applet'),
                (DRAWNS,'contour-path'),
                (DRAWNS,'contour-polygon'),
                (DRAWNS,'floating-frame'),
                (DRAWNS,'glue-point'),
                (DRAWNS,'image'),
                (DRAWNS,'image-map'),
                (DRAWNS,'object'),
                (DRAWNS,'object-ole'),
                (DRAWNS,'plugin'),
                (DRAWNS,'text-box'),
                (OFFICENS,'event-listeners'),
                (SVGNS,'desc'),
                (SVGNS,'title'),
        ),
# allowed_children
        (DRAWNS,'g') : (
                (DR3DNS,'scene'),
                (DRAWNS,'caption'),
                (DRAWNS,'circle'),
                (DRAWNS,'connector'),
                (DRAWNS,'control'),
                (DRAWNS,'custom-shape'),
                (DRAWNS,'ellipse'),
                (DRAWNS,'frame'),
                (DRAWNS,'g'),
                (DRAWNS,'glue-point'),
                (DRAWNS,'line'),
                (DRAWNS,'measure'),
                (DRAWNS,'page-thumbnail'),
                (DRAWNS,'path'),
                (DRAWNS,'polygon'),
                (DRAWNS,'polyline'),
                (DRAWNS,'rect'),
                (DRAWNS,'regular-polygon'),
                (SVGNS,'desc'),
                (SVGNS,'title'),
                (OFFICENS,'event-listeners'),
        ),
        (DRAWNS,'glue-point') : (
        ),
        (DRAWNS,'gradient') : (
        ),
        (DRAWNS,'handle') : (
        ),
        (DRAWNS,'hatch') : (
        ),
# allowed_children
        (DRAWNS,'image') : (
                (OFFICENS,'binary-data'),
                (TEXTNS,'list'),
                (TEXTNS,'p'),
        ),
        (DRAWNS,'image-map') : (
                (DRAWNS,'area-circle'),
                (DRAWNS,'area-polygon'),
                (DRAWNS,'area-rectangle'),
        ),
        (DRAWNS,'layer') : (
                (SVGNS,'desc'),
                (SVGNS,'title'),
        ),
        (DRAWNS,'layer-set') : (
                (DRAWNS,'layer'),
        ),
        (DRAWNS,'line') : (
                (DRAWNS,'glue-point'),
                (OFFICENS,'event-listeners'),
                (SVGNS,'desc'),
                (SVGNS,'title'),
                (TEXTNS,'list'),
                (TEXTNS,'p'),
        ),
        (DRAWNS,'marker') : (
        ),
        (DRAWNS,'measure') : (
                (DRAWNS,'glue-point'),
                (OFFICENS,'event-listeners'),
                (TEXTNS,'list'),
                (TEXTNS,'p'),
                (SVGNS,'title'),
                (SVGNS,'desc'),
        ),
        (DRAWNS,'object') : (
                (MATHNS,'math'),
                (OFFICENS,'document'),
        ),
# allowed_children
        (DRAWNS,'object-ole') : (
                (OFFICENS,'binary-data'),
        ),
        (DRAWNS,'opacity') : (
        ),
        (DRAWNS,'page') : (
                (ANIMNS,'animate'),
                (ANIMNS,'animateColor'),
                (ANIMNS,'animateMotion'),
                (ANIMNS,'animateTransform'),
                (ANIMNS,'audio'),
                (ANIMNS,'command'),
                (ANIMNS,'iterate'),
                (ANIMNS,'par'),
                (ANIMNS,'seq'),
                (ANIMNS,'set'),
                (ANIMNS,'transitionFilter'),
                (DR3DNS,'scene'),
                (DRAWNS,'caption'),
                (DRAWNS,'circle'),
                (DRAWNS,'connector'),
                (DRAWNS,'control'),
                (DRAWNS,'custom-shape'),
                (DRAWNS,'ellipse'),
                (DRAWNS,'frame'),
                (DRAWNS,'g'),
                (DRAWNS,'line'),
                (DRAWNS,'measure'),
                (DRAWNS,'page-thumbnail'),
                (DRAWNS,'path'),
                (DRAWNS,'polygon'),
                (DRAWNS,'polyline'),
                (DRAWNS,'rect'),
                (DRAWNS,'regular-polygon'),
                (OFFICENS,'forms'),
                (PRESENTATIONNS,'animations'),
                (PRESENTATIONNS,'notes'),
        ),
# allowed_children
        (DRAWNS,'page-thumbnail') : (
                (SVGNS,'desc'),
                (SVGNS,'title'),
        ),
        (DRAWNS,'param') : (
        ),
        (DRAWNS,'path') : (
                (DRAWNS,'glue-point'),
                (OFFICENS,'event-listeners'),
                (SVGNS,'desc'),
                (SVGNS,'title'),
                (TEXTNS,'list'),
                (TEXTNS,'p'),
        ),
        (DRAWNS,'plugin') : (
                (DRAWNS,'param'),
        ),
        (DRAWNS,'polygon') : (
                (DRAWNS,'glue-point'),
                (OFFICENS,'event-listeners'),
                (SVGNS,'title'),
                (SVGNS,'desc'),
                (TEXTNS,'list'),
                (TEXTNS,'p'),
        ),
        (DRAWNS,'polyline') : (
                (DRAWNS,'glue-point'),
                (OFFICENS,'event-listeners'),
                (SVGNS,'desc'),
                (SVGNS,'title'),
                (TEXTNS,'list'),
                (TEXTNS,'p'),
        ),
# allowed_children
        (DRAWNS,'rect') : (
                (DRAWNS,'glue-point'),
                (OFFICENS,'event-listeners'),
                (SVGNS,'desc'),
                (SVGNS,'title'),
                (TEXTNS,'list'),
                (TEXTNS,'p'),
        ),
        (DRAWNS,'regular-polygon') : (
                (DRAWNS,'glue-point'),
                (OFFICENS,'event-listeners'),
                (SVGNS,'desc'),
                (SVGNS,'title'),
                (TEXTNS,'list'),
                (TEXTNS,'p'),
        ),
        (DRAWNS,'stroke-dash') : (
        ),
        (DRAWNS,'text-box') : (
                (DR3DNS,'scene'),
                (DRAWNS,'a'),
                (DRAWNS,'caption'),
                (DRAWNS,'circle'),
                (DRAWNS,'connector'),
                (DRAWNS,'control'),
                (DRAWNS,'custom-shape'),
                (DRAWNS,'ellipse'),
                (DRAWNS,'frame'),
                (DRAWNS,'g'),
                (DRAWNS,'line'),
                (DRAWNS,'measure'),
                (DRAWNS,'page-thumbnail'),
                (DRAWNS,'path'),
                (DRAWNS,'polygon'),
                (DRAWNS,'polyline'),
                (DRAWNS,'rect'),
                (DRAWNS,'regular-polygon'),
                (TABLENS,'table'),
                (TEXTNS,'alphabetical-index'),
                (TEXTNS,'bibliography'),
                (TEXTNS,'change'),
                (TEXTNS,'change-end'),
                (TEXTNS,'change-start'),
                (TEXTNS,'h'),
                (TEXTNS,'illustration-index'),
                (TEXTNS,'list'),
                (TEXTNS,'numbered-paragraph'),
                (TEXTNS,'object-index'),
                (TEXTNS,'p'),
                (TEXTNS,'section'),
                (TEXTNS,'soft-page-break'),
                (TEXTNS,'table-index'),
                (TEXTNS,'table-of-content'),
                (TEXTNS,'user-index'),
        ),
# allowed_children
        (FORMNS,'button') : (
                (FORMNS,'properties'),
                (OFFICENS,'event-listeners'),
        ),
        (FORMNS,'checkbox') : (
                (FORMNS,'properties'),
                (OFFICENS,'event-listeners'),
        ),
        (FORMNS,'column') : (
                (FORMNS,'checkbox'),
                (FORMNS,'combobox'),
                (FORMNS,'date'),
                (FORMNS,'formatted-text'),
                (FORMNS,'listbox'),
                (FORMNS,'number'),
                (FORMNS,'text'),
                (FORMNS,'textarea'),
        ),
        (FORMNS,'combobox') : (
                (FORMNS,'item'),
                (FORMNS,'properties'),
                (OFFICENS,'event-listeners'),
        ),
        (FORMNS,'connection-resource') : (
        ),
        (FORMNS,'date') : (
                (FORMNS,'properties'),
                (OFFICENS,'event-listeners'),
        ),
        (FORMNS,'file') : (
                (FORMNS,'properties'),
                (OFFICENS,'event-listeners'),
        ),
        (FORMNS,'fixed-text') : (
                (FORMNS,'properties'),
                (OFFICENS,'event-listeners'),
        ),
# allowed_children
        (FORMNS,'form') : (
                (FORMNS,'button'),
                (FORMNS,'checkbox'),
                (FORMNS,'combobox'),
                (FORMNS,'connection-resource'),
                (FORMNS,'date'),
                (FORMNS,'file'),
                (FORMNS,'fixed-text'),
                (FORMNS,'form'),
                (FORMNS,'formatted-text'),
                (FORMNS,'frame'),
                (FORMNS,'generic-control'),
                (FORMNS,'grid'),
                (FORMNS,'hidden'),
                (FORMNS,'image'),
                (FORMNS,'image-frame'),
                (FORMNS,'listbox'),
                (FORMNS,'number'),
                (FORMNS,'password'),
                (FORMNS,'properties'),
                (FORMNS,'radio'),
                (FORMNS,'text'),
                (FORMNS,'textarea'),
                (FORMNS,'time'),
                (FORMNS,'value-range'),
                (OFFICENS,'event-listeners'),
        ),
        (FORMNS,'formatted-text') : (
                (FORMNS,'properties'),
                (OFFICENS,'event-listeners'),
        ),
        (FORMNS,'frame') : (
                (FORMNS,'properties'),
                (OFFICENS,'event-listeners'),
        ),
        (FORMNS,'generic-control') : (
                (FORMNS,'properties'),
                (OFFICENS,'event-listeners'),
        ),
        (FORMNS,'grid') : (
                (FORMNS,'column'),
                (FORMNS,'properties'),
                (OFFICENS,'event-listeners'),
        ),
        (FORMNS,'hidden') : (
                (FORMNS,'properties'),
                (OFFICENS,'event-listeners'),
        ),
        (FORMNS,'image') : (
                (FORMNS,'properties'),
                (OFFICENS,'event-listeners'),
        ),
# allowed_children
        (FORMNS,'image-frame') : (
                (FORMNS,'properties'),
                (OFFICENS,'event-listeners'),
        ),
        (FORMNS,'item') : (
        ),
        (FORMNS,'list-property') : (
                (FORMNS,'list-value'),
                (FORMNS,'list-value'),
                (FORMNS,'list-value'),
                (FORMNS,'list-value'),
                (FORMNS,'list-value'),
                (FORMNS,'list-value'),
                (FORMNS,'list-value'),
        ),
        (FORMNS,'list-value') : (
        ),
        (FORMNS,'listbox') : (
                (FORMNS,'option'),
                (FORMNS,'properties'),
                (OFFICENS,'event-listeners'),
        ),
        (FORMNS,'number') : (
                (FORMNS,'properties'),
                (OFFICENS,'event-listeners'),
        ),
        (FORMNS,'option') : (
        ),
        (FORMNS,'password') : (
                (FORMNS,'properties'),
                (OFFICENS,'event-listeners'),
        ),
        (FORMNS,'properties') : (
                (FORMNS,'list-property'),
                (FORMNS,'property'),
        ),
        (FORMNS,'property') : (
        ),
        (FORMNS,'radio') : (
                (FORMNS,'properties'),
                (OFFICENS,'event-listeners'),
        ),
        (FORMNS,'text') : (
                (FORMNS,'properties'),
                (OFFICENS,'event-listeners'),
        ),
        (FORMNS,'textarea') : (
                (FORMNS,'properties'),
                (OFFICENS,'event-listeners'),
                (TEXTNS,'p'),
        ),
        (FORMNS,'time') : (
                (FORMNS,'properties'),
                (OFFICENS,'event-listeners'),
        ),
        (FORMNS,'value-range') : (
                (FORMNS,'properties'),
                (OFFICENS,'event-listeners'),
        ),
        (METANS,'auto-reload') : (
        ),
        (METANS,'creation-date') : (
        ),
        (METANS,'date-string') : (
        ),
        (METANS,'document-statistic') : (
        ),
        (METANS,'editing-cycles') : (
        ),
        (METANS,'editing-duration') : (
        ),
        (METANS,'generator') : (
        ),
        (METANS,'hyperlink-behaviour') : (
        ),
        (METANS,'initial-creator') : (
        ),
        (METANS,'keyword') : (
        ),
        (METANS,'print-date') : (
        ),
        (METANS,'printed-by') : (
        ),
        (METANS,'template') : (
        ),
        (METANS,'user-defined') : (
        ),
# allowed_children
        (OFFICENS,'annotation') : (
                (DCNS,'creator'),
                (DCNS,'date'),
                (METANS,'date-string'),
                (TEXTNS,'list'),
                (TEXTNS,'p'),
        ),
        (OFFICENS,'automatic-styles') : (
                (NUMBERNS,'boolean-style'),
                (NUMBERNS,'currency-style'),
                (NUMBERNS,'date-style'),
                (NUMBERNS,'number-style'),
                (NUMBERNS,'percentage-style'),
                (NUMBERNS,'text-style'),
                (NUMBERNS,'time-style'),
                (STYLENS,'page-layout'),
                (STYLENS,'style'),
                (TEXTNS,'list-style'),
        ),
        (OFFICENS,'binary-data') : (
        ),
        (OFFICENS,'body') : (
                (OFFICENS,'chart'),
                (OFFICENS,'drawing'),
                (OFFICENS,'image'),
                (OFFICENS,'presentation'),
                (OFFICENS,'spreadsheet'),
                (OFFICENS,'text'),
        ),
        (OFFICENS,'change-info') : (
                (DCNS,'creator'),
                (DCNS,'date'),
                (TEXTNS,'p'),
        ),
        (OFFICENS,'chart') : (
                (CHARTNS,'chart'),
                (TABLENS,'calculation-settings'),
                (TABLENS,'consolidation'),
                (TABLENS,'content-validations'),
                (TABLENS,'data-pilot-tables'),
                (TABLENS,'database-ranges'),
                (TABLENS,'dde-links'),
                (TABLENS,'label-ranges'),
                (TABLENS,'named-expressions'),
                (TEXTNS,'alphabetical-index-auto-mark-file'),
                (TEXTNS,'dde-connection-decls'),
                (TEXTNS,'sequence-decls'),
                (TEXTNS,'user-field-decls'),
                (TEXTNS,'variable-decls'),
        ),
        (OFFICENS,'dde-source') : (
        ),
        (OFFICENS,'document') : (
                (OFFICENS,'automatic-styles'),
                (OFFICENS,'body'),
                (OFFICENS,'font-face-decls'),
                (OFFICENS,'master-styles'),
                (OFFICENS,'meta'),
                (OFFICENS,'scripts'),
                (OFFICENS,'settings'),
                (OFFICENS,'styles'),
        ),
        (OFFICENS,'document-content') : (
                (OFFICENS,'automatic-styles'),
                (OFFICENS,'body'),
                (OFFICENS,'font-face-decls'),
                (OFFICENS,'scripts'),
        ),
        (OFFICENS,'document-meta') : (
                (OFFICENS,'meta'),
        ),
        (OFFICENS,'document-settings') : (
                (OFFICENS,'settings'),
        ),
        (OFFICENS,'document-styles') : (
                (OFFICENS,'automatic-styles'),
                (OFFICENS,'font-face-decls'),
                (OFFICENS,'master-styles'),
                (OFFICENS,'styles'),
        ),
        (OFFICENS,'drawing') : (
                (DRAWNS,'page'),
                (TABLENS,'calculation-settings'),
                (TABLENS,'consolidation'),
                (TABLENS,'content-validations'),
                (TABLENS,'data-pilot-tables'),
                (TABLENS,'database-ranges'),
                (TABLENS,'dde-links'),
                (TABLENS,'label-ranges'),
                (TABLENS,'named-expressions'),
                (TEXTNS,'alphabetical-index-auto-mark-file'),
                (TEXTNS,'dde-connection-decls'),
                (TEXTNS,'sequence-decls'),
                (TEXTNS,'user-field-decls'),
                (TEXTNS,'variable-decls'),
        ),
        (OFFICENS,'event-listeners') : (
                (PRESENTATIONNS,'event-listener'),
                (SCRIPTNS,'event-listener'),
        ),
        (OFFICENS,'font-face-decls') : (
                (STYLENS,'font-face'),
        ),
# allowed_children
        (OFFICENS,'forms') : (
                (XFORMSNS,'model'),
                (FORMNS,'form'),
        ),
        (OFFICENS,'image') : (
                (DRAWNS,'frame'),
        ),
        (OFFICENS,'master-styles') : (
                (DRAWNS,'layer-set'),
                (STYLENS,'handout-master'),
                (STYLENS,'master-page'),
                (TABLENS,'table-template'),
        ),
        (OFFICENS,'meta') : (
                (DCNS,'creator'),
                (DCNS,'date'),
                (DCNS,'description'),
                (DCNS,'language'),
                (DCNS,'subject'),
                (DCNS,'title'),
# Completes Dublin Core start
#               (DCNS,'contributor'),
#               (DCNS,'coverage'),
#               (DCNS,'format'),
#               (DCNS,'identifier'),
#               (DCNS,'publisher'),
#               (DCNS,'relation'),
#               (DCNS,'rights'),
#               (DCNS,'source'),
#               (DCNS,'type'),
# Completes Dublin Core end
                (METANS,'auto-reload'),
                (METANS,'creation-date'),
                (METANS,'document-statistic'),
                (METANS,'editing-cycles'),
                (METANS,'editing-duration'),
                (METANS,'generator'),
                (METANS,'hyperlink-behaviour'),
                (METANS,'initial-creator'),
                (METANS,'keyword'),
                (METANS,'print-date'),
                (METANS,'printed-by'),
                (METANS,'template'),
                (METANS,'user-defined'),
        ),
        (OFFICENS,'presentation') : (
                (DRAWNS,'page'),
                (PRESENTATIONNS,'date-time-decl'),
                (PRESENTATIONNS,'footer-decl'),
                (PRESENTATIONNS,'header-decl'),
                (PRESENTATIONNS,'settings'),
                (TABLENS,'calculation-settings'),
                (TABLENS,'consolidation'),
                (TABLENS,'content-validations'),
                (TABLENS,'data-pilot-tables'),
                (TABLENS,'database-ranges'),
                (TABLENS,'dde-links'),
                (TABLENS,'label-ranges'),
                (TABLENS,'named-expressions'),
                (TEXTNS,'alphabetical-index-auto-mark-file'),
                (TEXTNS,'dde-connection-decls'),
                (TEXTNS,'sequence-decls'),
                (TEXTNS,'user-field-decls'),
                (TEXTNS,'variable-decls'),
        ),
# allowed_children
        (OFFICENS,'script') : None,

        (OFFICENS,'scripts') : (
                (OFFICENS,'event-listeners'),
                (OFFICENS,'script'),
        ),
        (OFFICENS,'settings') : (
                (CONFIGNS,'config-item-set'),
        ),
        (OFFICENS,'spreadsheet') : (
                (TABLENS,'calculation-settings'),
                (TABLENS,'consolidation'),
                (TABLENS,'content-validations'),
                (TABLENS,'data-pilot-tables'),
                (TABLENS,'database-ranges'),
                (TABLENS,'dde-links'),
                (TABLENS,'label-ranges'),
                (TABLENS,'named-expressions'),
                (TABLENS,'table'),
                (TABLENS,'tracked-changes'),
                (TEXTNS,'alphabetical-index-auto-mark-file'),
                (TEXTNS,'dde-connection-decls'),
                (TEXTNS,'sequence-decls'),
                (TEXTNS,'user-field-decls'),
                (TEXTNS,'variable-decls'),
        ),
        (OFFICENS,'styles') : (
                (NUMBERNS,'boolean-style'),
                (NUMBERNS,'currency-style'),
                (NUMBERNS,'date-style'),
                (NUMBERNS,'number-style'),
                (NUMBERNS,'percentage-style'),
                (NUMBERNS,'text-style'),
                (NUMBERNS,'time-style'),
                (DRAWNS,'fill-image'),
                (DRAWNS,'gradient'),
                (DRAWNS,'hatch'),
                (DRAWNS,'marker'),
                (DRAWNS,'opacity'),
                (DRAWNS,'stroke-dash'),
                (STYLENS,'default-style'),
                (STYLENS,'presentation-page-layout'),
                (STYLENS,'style'),
                (SVGNS,'linearGradient'),
                (SVGNS,'radialGradient'),
                (TEXTNS,'bibliography-configuration'),
                (TEXTNS,'linenumbering-configuration'),
                (TEXTNS,'list-style'),
                (TEXTNS,'notes-configuration'),
                (TEXTNS,'outline-style'),
        ),
        (OFFICENS,'text') : (
                (DR3DNS,'scene'),
                (DRAWNS,'a'),
                (DRAWNS,'caption'),
                (DRAWNS,'circle'),
                (DRAWNS,'connector'),
                (DRAWNS,'control'),
                (DRAWNS,'custom-shape'),
                (DRAWNS,'ellipse'),
                (DRAWNS,'frame'),
                (DRAWNS,'g'),
                (DRAWNS,'line'),
                (DRAWNS,'measure'),
                (DRAWNS,'page-thumbnail'),
                (DRAWNS,'path'),
                (DRAWNS,'polygon'),
                (DRAWNS,'polyline'),
                (DRAWNS,'rect'),
                (DRAWNS,'regular-polygon'),
                (OFFICENS,'forms'),
                (TABLENS,'calculation-settings'),
                (TABLENS,'consolidation'),
                (TABLENS,'content-validations'),
                (TABLENS,'data-pilot-tables'),
                (TABLENS,'database-ranges'),
                (TABLENS,'dde-links'),
                (TABLENS,'label-ranges'),
                (TABLENS,'named-expressions'),
                (TABLENS,'table'),
                (TEXTNS,'alphabetical-index'),
                (TEXTNS,'alphabetical-index-auto-mark-file'),
                (TEXTNS,'bibliography'),
                (TEXTNS,'change'),
                (TEXTNS,'change-end'),
                (TEXTNS,'change-start'),
                (TEXTNS,'dde-connection-decls'),
                (TEXTNS,'h'),
                (TEXTNS,'illustration-index'),
                (TEXTNS,'list'),
                (TEXTNS,'numbered-paragraph'),
                (TEXTNS,'object-index'),
                (TEXTNS,'p'),
                (TEXTNS,'page-sequence'),
                (TEXTNS,'section'),
                (TEXTNS,'sequence-decls'),
                (TEXTNS,'soft-page-break'),
                (TEXTNS,'table-index'),
                (TEXTNS,'table-of-content'),
                (TEXTNS,'tracked-changes'),
                (TEXTNS,'user-field-decls'),
                (TEXTNS,'user-index'),
                (TEXTNS,'variable-decls'),
        ),
        (PRESENTATIONNS,'animation-group') : (
                (PRESENTATIONNS,'dim'),
                (PRESENTATIONNS,'hide-shape'),
                (PRESENTATIONNS,'hide-text'),
                (PRESENTATIONNS,'play'),
                (PRESENTATIONNS,'show-shape'),
                (PRESENTATIONNS,'show-text'),
        ),
        (PRESENTATIONNS,'animations') : (
                (PRESENTATIONNS,'animation-group'),
                (PRESENTATIONNS,'dim'),
                (PRESENTATIONNS,'hide-shape'),
                (PRESENTATIONNS,'hide-text'),
                (PRESENTATIONNS,'play'),
                (PRESENTATIONNS,'show-shape'),
                (PRESENTATIONNS,'show-text'),
        ),
        (PRESENTATIONNS,'date-time') : (
        ),
        (PRESENTATIONNS,'date-time-decl') : (
        ),
        (PRESENTATIONNS,'dim') : (
                (PRESENTATIONNS,'sound'),
        ),
        (PRESENTATIONNS,'event-listener') : (
                (PRESENTATIONNS,'sound'),
        ),
        (PRESENTATIONNS,'footer') : (
        ),
        (PRESENTATIONNS,'footer-decl') : (
        ),
        (PRESENTATIONNS,'header') : (
        ),
        (PRESENTATIONNS,'header-decl') : (
        ),
        (PRESENTATIONNS,'hide-shape') : (
                (PRESENTATIONNS,'sound'),
        ),
        (PRESENTATIONNS,'hide-text') : (
                (PRESENTATIONNS,'sound'),
        ),
# allowed_children
        (PRESENTATIONNS,'notes') : (
                (DR3DNS,'scene'),
                (DRAWNS,'caption'),
                (DRAWNS,'circle'),
                (DRAWNS,'connector'),
                (DRAWNS,'control'),
                (DRAWNS,'custom-shape'),
                (DRAWNS,'ellipse'),
                (DRAWNS,'frame'),
                (DRAWNS,'g'),
                (DRAWNS,'line'),
                (DRAWNS,'measure'),
                (DRAWNS,'page-thumbnail'),
                (DRAWNS,'path'),
                (DRAWNS,'polygon'),
                (DRAWNS,'polyline'),
                (DRAWNS,'rect'),
                (DRAWNS,'regular-polygon'),
                (OFFICENS,'forms'),
        ),
        (PRESENTATIONNS,'placeholder') : (
        ),
        (PRESENTATIONNS,'play') : (
        ),
        (PRESENTATIONNS,'settings') : (
                (PRESENTATIONNS,'show'),
        ),
        (PRESENTATIONNS,'show') : (
        ),
        (PRESENTATIONNS,'show-shape') : (
                (PRESENTATIONNS,'sound'),
        ),
        (PRESENTATIONNS,'show-text') : (
                (PRESENTATIONNS,'sound'),
        ),
        (PRESENTATIONNS,'sound') : (
        ),
        (SCRIPTNS,'event-listener') : (
        ),
        (STYLENS,'background-image') : (
                (OFFICENS,'binary-data'),
        ),
        (STYLENS,'chart-properties') : (
                (CHARTNS,'symbol-image'),
        ),
        (STYLENS,'column') : (
        ),
        (STYLENS,'column-sep') : (
        ),
        (STYLENS,'columns') : (
                (STYLENS,'column'),
                (STYLENS,'column-sep'),
        ),
        (STYLENS,'default-style') : (
                (STYLENS,'chart-properties'),
                (STYLENS,'drawing-page-properties'),
                (STYLENS,'graphic-properties'),
                (STYLENS,'paragraph-properties'),
                (STYLENS,'ruby-properties'),
                (STYLENS,'section-properties'),
                (STYLENS,'table-cell-properties'),
                (STYLENS,'table-column-properties'),
                (STYLENS,'table-properties'),
                (STYLENS,'table-row-properties'),
                (STYLENS,'text-properties'),
        ),
        (STYLENS,'drawing-page-properties') : (
                (PRESENTATIONNS,'sound'),
        ),
        (STYLENS,'drop-cap') : (
        ),
        (STYLENS,'font-face') : (
                (SVGNS,'definition-src'),
                (SVGNS,'font-face-src'),
        ),
        (STYLENS,'footer') : (
                (STYLENS,'region-center'),
                (STYLENS,'region-left'),
                (STYLENS,'region-right'),
                (TABLENS,'table'),
                (TEXTNS,'alphabetical-index'),
                (TEXTNS,'alphabetical-index-auto-mark-file'),
                (TEXTNS,'bibliography'),
                (TEXTNS,'change'),
                (TEXTNS,'change-end'),
                (TEXTNS,'change-start'),
                (TEXTNS,'dde-connection-decls'),
                (TEXTNS,'h'),
                (TEXTNS,'illustration-index'),
                (TEXTNS,'index-title'),
                (TEXTNS,'list'),
                (TEXTNS,'object-index'),
                (TEXTNS,'p'),
                (TEXTNS,'section'),
                (TEXTNS,'sequence-decls'),
                (TEXTNS,'table-index'),
                (TEXTNS,'table-of-content'),
                (TEXTNS,'tracked-changes'),
                (TEXTNS,'user-field-decls'),
                (TEXTNS,'user-index'),
                (TEXTNS,'variable-decls'),
        ),
# allowed_children
        (STYLENS,'footer-left') : (
                (STYLENS,'region-center'),
                (STYLENS,'region-left'),
                (STYLENS,'region-right'),
                (TABLENS,'table'),
                (TEXTNS,'alphabetical-index'),
                (TEXTNS,'alphabetical-index-auto-mark-file'),
                (TEXTNS,'bibliography'),
                (TEXTNS,'change'),
                (TEXTNS,'change-end'),
                (TEXTNS,'change-start'),
                (TEXTNS,'dde-connection-decls'),
                (TEXTNS,'h'),
                (TEXTNS,'illustration-index'),
                (TEXTNS,'index-title'),
                (TEXTNS,'list'),
                (TEXTNS,'object-index'),
                (TEXTNS,'p'),
                (TEXTNS,'section'),
                (TEXTNS,'sequence-decls'),
                (TEXTNS,'table-index'),
                (TEXTNS,'table-of-content'),
                (TEXTNS,'tracked-changes'),
                (TEXTNS,'user-field-decls'),
                (TEXTNS,'user-index'),
                (TEXTNS,'variable-decls'),
        ),
        (STYLENS,'footer-style') : (
                (STYLENS,'header-footer-properties'),
        ),
        (STYLENS,'footnote-sep') : (
        ),
        (STYLENS,'graphic-properties') : (
                (STYLENS,'background-image'),
                (STYLENS,'columns'),
                (TEXTNS,'list-style'),
        ),
# allowed_children
        (STYLENS,'handout-master') : (
                (DR3DNS,'scene'),
                (DRAWNS,'caption'),
                (DRAWNS,'circle'),
                (DRAWNS,'connector'),
                (DRAWNS,'control'),
                (DRAWNS,'custom-shape'),
                (DRAWNS,'ellipse'),
                (DRAWNS,'frame'),
                (DRAWNS,'g'),
                (DRAWNS,'line'),
                (DRAWNS,'measure'),
                (DRAWNS,'page-thumbnail'),
                (DRAWNS,'path'),
                (DRAWNS,'polygon'),
                (DRAWNS,'polyline'),
                (DRAWNS,'rect'),
                (DRAWNS,'regular-polygon'),
        ),
        (STYLENS,'header') : (
                (STYLENS,'region-center'),
                (STYLENS,'region-left'),
                (STYLENS,'region-right'),
                (TABLENS,'table'),
                (TEXTNS,'alphabetical-index'),
                (TEXTNS,'alphabetical-index-auto-mark-file'),
                (TEXTNS,'bibliography'),
                (TEXTNS,'change'),
                (TEXTNS,'change-end'),
                (TEXTNS,'change-start'),
                (TEXTNS,'dde-connection-decls'),
                (TEXTNS,'h'),
                (TEXTNS,'illustration-index'),
                (TEXTNS,'index-title'),
                (TEXTNS,'list'),
                (TEXTNS,'object-index'),
                (TEXTNS,'p'),
                (TEXTNS,'section'),
                (TEXTNS,'sequence-decls'),
                (TEXTNS,'table-index'),
                (TEXTNS,'table-of-content'),
                (TEXTNS,'tracked-changes'),
                (TEXTNS,'user-field-decls'),
                (TEXTNS,'user-index'),
                (TEXTNS,'variable-decls'),
        ),
# allowed_children
        (STYLENS,'header-footer-properties') : (
                (STYLENS,'background-image'),
        ),
        (STYLENS,'header-left') : (
                (STYLENS,'region-center'),
                (STYLENS,'region-left'),
                (STYLENS,'region-right'),
                (TABLENS,'table'),
                (TEXTNS,'alphabetical-index'),
                (TEXTNS,'alphabetical-index-auto-mark-file'),
                (TEXTNS,'bibliography'),
                (TEXTNS,'change'),
                (TEXTNS,'change-end'),
                (TEXTNS,'change-start'),
                (TEXTNS,'dde-connection-decls'),
                (TEXTNS,'h'),
                (TEXTNS,'illustration-index'),
                (TEXTNS,'index-title'),
                (TEXTNS,'list'),
                (TEXTNS,'object-index'),
                (TEXTNS,'p'),
                (TEXTNS,'section'),
                (TEXTNS,'sequence-decls'),
                (TEXTNS,'table-index'),
                (TEXTNS,'table-of-content'),
                (TEXTNS,'tracked-changes'),
                (TEXTNS,'user-field-decls'),
                (TEXTNS,'user-index'),
                (TEXTNS,'variable-decls'),
        ),
        (STYLENS,'header-style') : (
                (STYLENS,'header-footer-properties'),
        ),
        (STYLENS,'list-level-properties') : (
        ),
        (STYLENS,'map') : (
        ),
        (STYLENS,'master-page') : (
                (DR3DNS,'scene'),
                (DRAWNS,'caption'),
                (DRAWNS,'circle'),
                (DRAWNS,'connector'),
                (DRAWNS,'control'),
                (DRAWNS,'custom-shape'),
                (DRAWNS,'ellipse'),
                (DRAWNS,'frame'),
                (DRAWNS,'g'),
                (DRAWNS,'line'),
                (DRAWNS,'measure'),
                (DRAWNS,'page-thumbnail'),
                (DRAWNS,'path'),
                (DRAWNS,'polygon'),
                (DRAWNS,'polyline'),
                (DRAWNS,'rect'),
                (DRAWNS,'regular-polygon'),
                (OFFICENS,'forms'),
                (PRESENTATIONNS,'notes'),
                (STYLENS,'footer'),
                (STYLENS,'footer-left'),
                (STYLENS,'header'),
                (STYLENS,'header-left'),
                (STYLENS,'style'),
        ),
        (STYLENS,'page-layout') : (
                (STYLENS,'footer-style'),
                (STYLENS,'header-style'),
                (STYLENS,'page-layout-properties'),
        ),
        (STYLENS,'page-layout-properties') : (
                (STYLENS,'background-image'),
                (STYLENS,'columns'),
                (STYLENS,'footnote-sep'),
        ),
# allowed_children
        (STYLENS,'paragraph-properties') : (
                (STYLENS,'background-image'),
                (STYLENS,'drop-cap'),
                (STYLENS,'tab-stops'),
        ),
        (STYLENS,'presentation-page-layout') : (
                (PRESENTATIONNS,'placeholder'),
        ),
        (STYLENS,'region-center') : (
                (TEXTNS,'p'),
        ),
        (STYLENS,'region-left') : (
                (TEXTNS,'p'),
        ),
        (STYLENS,'region-right') : (
                (TEXTNS,'p'),
        ),
        (STYLENS,'ruby-properties') : (
        ),
        (STYLENS,'section-properties') : (
                (STYLENS,'background-image'),
                (STYLENS,'columns'),
                (TEXTNS,'notes-configuration'),
        ),
        (STYLENS,'style') : (
                (STYLENS,'chart-properties'),
                (STYLENS,'drawing-page-properties'),
                (STYLENS,'graphic-properties'),
                (STYLENS,'map'),
                (STYLENS,'paragraph-properties'),
                (STYLENS,'ruby-properties'),
                (STYLENS,'section-properties'),
                (STYLENS,'table-cell-properties'),
                (STYLENS,'table-column-properties'),
                (STYLENS,'table-properties'),
                (STYLENS,'table-row-properties'),
                (STYLENS,'text-properties'),
        ),
        (STYLENS,'tab-stop') : (
        ),
        (STYLENS,'tab-stops') : (
                (STYLENS,'tab-stop'),
        ),
# allowed_children
        (STYLENS,'table-cell-properties') : (
                (STYLENS,'background-image'),
        ),
        (STYLENS,'table-column-properties') : (
        ),
        (STYLENS,'table-properties') : (
                (STYLENS,'background-image'),
        ),
        (STYLENS,'table-row-properties') : (
                (STYLENS,'background-image'),
        ),
        (STYLENS,'text-properties') : (
        ),
        (SVGNS,'definition-src') : (
        ),
        (SVGNS,'desc') : (
        ),
        (SVGNS,'font-face-format') : (
        ),
        (SVGNS,'font-face-name') : (
        ),
        (SVGNS,'font-face-src') : (
                (SVGNS,'font-face-name'),
                (SVGNS,'font-face-uri'),
        ),
        (SVGNS,'font-face-uri') : (
                (SVGNS,'font-face-format'),
        ),
        (SVGNS,'linearGradient') : (
                (SVGNS,'stop'),
        ),
        (SVGNS,'radialGradient') : (
                (SVGNS,'stop'),
        ),
        (SVGNS,'stop') : (
        ),
        (SVGNS,'title') : (
        ),
        (TABLENS,'body') : (
        ),
        (TABLENS,'calculation-settings') : (
                (TABLENS,'iteration'),
                (TABLENS,'null-date'),
        ),
# allowed_children
        (TABLENS,'cell-address') : (
        ),
        (TABLENS,'cell-content-change') : (
                (OFFICENS,'change-info'),
                (TABLENS,'cell-address'),
                (TABLENS,'deletions'),
                (TABLENS,'dependencies'),
                (TABLENS,'previous'),
        ),
        (TABLENS,'cell-content-deletion') : (
                (TABLENS,'cell-address'),
                (TABLENS,'change-track-table-cell'),
        ),
        (TABLENS,'cell-range-source') : (
        ),
        (TABLENS,'change-deletion') : (
        ),
        (TABLENS,'change-track-table-cell') : (
                (TEXTNS,'p'),
        ),
        (TABLENS,'consolidation') : (
        ),
        (TABLENS,'content-validation') : (
                (OFFICENS,'event-listeners'),
                (TABLENS,'error-macro'),
                (TABLENS,'error-message'),
                (TABLENS,'help-message'),
        ),
# allowed_children
        (TABLENS,'content-validations') : (
                (TABLENS,'content-validation'),
        ),
        (TABLENS,'covered-table-cell') : (
                (DR3DNS,'scene'),
                (DRAWNS,'a'),
                (DRAWNS,'caption'),
                (DRAWNS,'circle'),
                (DRAWNS,'connector'),
                (DRAWNS,'control'),
                (DRAWNS,'custom-shape'),
                (DRAWNS,'ellipse'),
                (DRAWNS,'frame'),
                (DRAWNS,'g'),
                (DRAWNS,'line'),
                (DRAWNS,'measure'),
                (DRAWNS,'page-thumbnail'),
                (DRAWNS,'path'),
                (DRAWNS,'polygon'),
                (DRAWNS,'polyline'),
                (DRAWNS,'rect'),
                (DRAWNS,'regular-polygon'),
                (OFFICENS,'annotation'),
                (TABLENS,'cell-range-source'),
                (TABLENS,'detective'),
                (TABLENS,'table'),
                (TEXTNS,'alphabetical-index'),
                (TEXTNS,'bibliography'),
                (TEXTNS,'change'),
                (TEXTNS,'change-end'),
                (TEXTNS,'change-start'),
                (TEXTNS,'h'),
                (TEXTNS,'illustration-index'),
                (TEXTNS,'list'),
                (TEXTNS,'numbered-paragraph'),
                (TEXTNS,'object-index'),
                (TEXTNS,'p'),
                (TEXTNS,'section'),
                (TEXTNS,'soft-page-break'),
                (TEXTNS,'table-index'),
                (TEXTNS,'table-of-content'),
                (TEXTNS,'user-index'),
        ),
# allowed_children
        (TABLENS,'cut-offs') : (
                (TABLENS,'insertion-cut-off'),
                (TABLENS,'movement-cut-off'),
        ),
        (TABLENS,'data-pilot-display-info') : (
        ),
        (TABLENS,'data-pilot-field') : (
                (TABLENS,'data-pilot-field-reference'),
                (TABLENS,'data-pilot-groups'),
                (TABLENS,'data-pilot-level'),
        ),
        (TABLENS,'data-pilot-field-reference') : (
        ),
        (TABLENS,'data-pilot-group') : (
                (TABLENS,'data-pilot-group-member'),
        ),
        (TABLENS,'data-pilot-group-member') : (
        ),
        (TABLENS,'data-pilot-groups') : (
                (TABLENS,'data-pilot-group'),
        ),
        (TABLENS,'data-pilot-layout-info') : (
        ),
        (TABLENS,'data-pilot-level') : (
                (TABLENS,'data-pilot-display-info'),
                (TABLENS,'data-pilot-layout-info'),
                (TABLENS,'data-pilot-members'),
                (TABLENS,'data-pilot-sort-info'),
                (TABLENS,'data-pilot-subtotals'),
        ),
        (TABLENS,'data-pilot-member') : (
        ),
        (TABLENS,'data-pilot-members') : (
                (TABLENS,'data-pilot-member'),
        ),
        (TABLENS,'data-pilot-sort-info') : (
        ),
        (TABLENS,'data-pilot-subtotal') : (
        ),
        (TABLENS,'data-pilot-subtotals') : (
                (TABLENS,'data-pilot-subtotal'),
        ),
# allowed_children
        (TABLENS,'data-pilot-table') : (
                (TABLENS,'data-pilot-field'),
                (TABLENS,'database-source-query'),
                (TABLENS,'database-source-sql'),
                (TABLENS,'database-source-table'),
                (TABLENS,'source-cell-range'),
                (TABLENS,'source-service'),
        ),
        (TABLENS,'data-pilot-tables') : (
                (TABLENS,'data-pilot-table'),
        ),
        (TABLENS,'database-range') : (
                (TABLENS,'database-source-query'),
                (TABLENS,'database-source-sql'),
                (TABLENS,'database-source-table'),
                (TABLENS,'filter'),
                (TABLENS,'sort'),
                (TABLENS,'subtotal-rules'),
        ),
        (TABLENS,'database-ranges') : (
                (TABLENS,'database-range'),
        ),
        (TABLENS,'database-source-query') : (
        ),
        (TABLENS,'database-source-sql') : (
        ),
        (TABLENS,'database-source-table') : (
        ),
# allowed_children
        (TABLENS,'dde-link') : (
                (OFFICENS,'dde-source'),
                (TABLENS,'table'),
        ),
        (TABLENS,'dde-links') : (
                (TABLENS,'dde-link'),
        ),
        (TABLENS,'deletion') : (
                (OFFICENS,'change-info'),
                (TABLENS,'cut-offs'),
                (TABLENS,'deletions'),
                (TABLENS,'dependencies'),
        ),
        (TABLENS,'deletions') : (
                (TABLENS,'cell-content-deletion'),
                (TABLENS,'change-deletion'),
        ),
        (TABLENS,'dependencies') : (
                (TABLENS,'dependency'),
        ),
        (TABLENS,'dependency') : (
        ),
        (TABLENS,'detective') : (
                (TABLENS,'highlighted-range'),
                (TABLENS,'operation'),
        ),
# allowed_children
        (TABLENS,'error-macro') : (
        ),
        (TABLENS,'error-message') : (
                (TEXTNS,'p'),
        ),
        (TABLENS,'even-columns') : (
        ),
        (TABLENS,'even-rows') : (
        ),
        (TABLENS,'filter') : (
                (TABLENS,'filter-and'),
                (TABLENS,'filter-condition'),
                (TABLENS,'filter-or'),
        ),
        (TABLENS,'filter-and') : (
                (TABLENS,'filter-condition'),
                (TABLENS,'filter-or'),
        ),
        (TABLENS,'filter-condition') : (
        ),
        (TABLENS,'filter-or') : (
                (TABLENS,'filter-and'),
                (TABLENS,'filter-condition'),
        ),
# allowed_children
        (TABLENS,'first-column') : (
        ),
        (TABLENS,'first-row') : (
        ),
        (TABLENS,'help-message') : (
                (TEXTNS,'p'),
        ),
        (TABLENS,'highlighted-range') : (
        ),
        (TABLENS,'insertion') : (
                (OFFICENS,'change-info'),
                (TABLENS,'deletions'),
                (TABLENS,'dependencies'),
        ),
        (TABLENS,'insertion-cut-off') : (
        ),
        (TABLENS,'iteration') : (
        ),
        (TABLENS,'label-range') : (
        ),
        (TABLENS,'label-ranges') : (
                (TABLENS,'label-range'),
        ),
        (TABLENS,'last-column') : (
        ),
        (TABLENS,'last-row') : (
        ),
        (TABLENS,'movement') : (
                (OFFICENS,'change-info'),
                (TABLENS,'deletions'),
                (TABLENS,'dependencies'),
                (TABLENS,'source-range-address'),
                (TABLENS,'target-range-address'),
        ),
        (TABLENS,'movement-cut-off') : (
        ),
        (TABLENS,'named-expression') : (
        ),
        (TABLENS,'named-expressions') : (
                (TABLENS,'named-expression'),
                (TABLENS,'named-range'),
        ),
# allowed_children
        (TABLENS,'named-range') : (
        ),
        (TABLENS,'null-date') : (
        ),
        (TABLENS,'odd-columns') : (
        ),
        (TABLENS,'odd-rows') : (
        ),
        (TABLENS,'operation') : (
        ),
        (TABLENS,'previous') : (
                (TABLENS,'change-track-table-cell'),
        ),
        (TABLENS,'scenario') : (
        ),
        (TABLENS,'shapes') : (
                (DR3DNS,'scene'),
                (DRAWNS,'caption'),
                (DRAWNS,'circle'),
                (DRAWNS,'connector'),
                (DRAWNS,'control'),
                (DRAWNS,'custom-shape'),
                (DRAWNS,'ellipse'),
                (DRAWNS,'frame'),
                (DRAWNS,'g'),
                (DRAWNS,'line'),
                (DRAWNS,'measure'),
                (DRAWNS,'page-thumbnail'),
                (DRAWNS,'path'),
                (DRAWNS,'polygon'),
                (DRAWNS,'polyline'),
                (DRAWNS,'rect'),
                (DRAWNS,'regular-polygon'),
        ),
# allowed_children
        (TABLENS,'sort') : (
                (TABLENS,'sort-by'),
        ),
        (TABLENS,'sort-by') : (
        ),
        (TABLENS,'sort-groups') : (
        ),
        (TABLENS,'source-cell-range') : (
                (TABLENS,'filter'),
        ),
        (TABLENS,'source-range-address') : (
        ),
        (TABLENS,'source-service') : (
        ),
        (TABLENS,'subtotal-field') : (
        ),
        (TABLENS,'subtotal-rule') : (
                (TABLENS,'subtotal-field'),
        ),
        (TABLENS,'subtotal-rules') : (
                (TABLENS,'sort-groups'),
                (TABLENS,'subtotal-rule'),
        ),
# allowed_children
        (TABLENS,'table') : (
                (OFFICENS,'dde-source'),
                (OFFICENS,'forms'),
                (TEXTNS,'soft-page-break'),
                (TABLENS,'scenario'),
                (TABLENS,'shapes'),
                (TABLENS,'table-column'),
                (TABLENS,'table-column-group'),
                (TABLENS,'table-columns'),
                (TABLENS,'table-header-columns'),
                (TABLENS,'table-header-rows'),
                (TABLENS,'table-row'),
                (TABLENS,'table-row-group'),
                (TABLENS,'table-rows'),
                (TABLENS,'table-source'),
        ),
        (TABLENS,'table-cell') : (
                (DR3DNS,'scene'),
                (DRAWNS,'a'),
                (DRAWNS,'caption'),
                (DRAWNS,'circle'),
                (DRAWNS,'connector'),
                (DRAWNS,'control'),
                (DRAWNS,'custom-shape'),
                (DRAWNS,'ellipse'),
                (DRAWNS,'frame'),
                (DRAWNS,'g'),
                (DRAWNS,'line'),
                (DRAWNS,'measure'),
                (DRAWNS,'page-thumbnail'),
                (DRAWNS,'path'),
                (DRAWNS,'polygon'),
                (DRAWNS,'polyline'),
                (DRAWNS,'rect'),
                (DRAWNS,'regular-polygon'),
                (OFFICENS,'annotation'),
                (TABLENS,'cell-range-source'),
                (TABLENS,'detective'),
                (TABLENS,'table'),
                (TEXTNS,'alphabetical-index'),
                (TEXTNS,'bibliography'),
                (TEXTNS,'change'),
                (TEXTNS,'change-end'),
                (TEXTNS,'change-start'),
                (TEXTNS,'h'),
                (TEXTNS,'illustration-index'),
                (TEXTNS,'list'),
                (TEXTNS,'numbered-paragraph'),
                (TEXTNS,'object-index'),
                (TEXTNS,'p'),
                (TEXTNS,'section'),
                (TEXTNS,'soft-page-break'),
                (TEXTNS,'table-index'),
                (TEXTNS,'table-of-content'),
                (TEXTNS,'user-index'),
        ),
# allowed_children
        (TABLENS,'table-column') : (
        ),
        (TABLENS,'table-column-group') : (
                (TABLENS,'table-column'),
                (TABLENS,'table-column-group'),
                (TABLENS,'table-columns'),
                (TABLENS,'table-header-columns'),
        ),
        (TABLENS,'table-columns') : (
                (TABLENS,'table-column'),
        ),
        (TABLENS,'table-header-columns') : (
                (TABLENS,'table-column'),
        ),
        (TABLENS,'table-header-rows') : (
                (TABLENS,'table-row'),
                (TEXTNS,'soft-page-break'),
        ),
        (TABLENS,'table-row') : (
                (TABLENS,'covered-table-cell'),
                (TABLENS,'table-cell'),
        ),
        (TABLENS,'table-row-group') : (
                (TABLENS,'table-header-rows'),
                (TABLENS,'table-row'),
                (TABLENS,'table-row-group'),
                (TABLENS,'table-rows'),
                (TEXTNS,'soft-page-break'),
        ),
        (TABLENS,'table-rows') : (
                (TABLENS,'table-row'),
                (TEXTNS,'soft-page-break'),
        ),
# allowed_children
        (TABLENS,'table-source') : (
        ),
        (TABLENS,'table-template') : (
                (TABLENS,'body'),
                (TABLENS,'even-columns'),
                (TABLENS,'even-rows'),
                (TABLENS,'first-column'),
                (TABLENS,'first-row'),
                (TABLENS,'last-column'),
                (TABLENS,'last-row'),
                (TABLENS,'odd-columns'),
                (TABLENS,'odd-rows'),
        ),
        (TABLENS,'target-range-address') : (
        ),
        (TABLENS,'tracked-changes') : (
                (TABLENS,'cell-content-change'),
                (TABLENS,'deletion'),
                (TABLENS,'insertion'),
                (TABLENS,'movement'),
        ),
# allowed_children
        (TEXTNS,'a') : (
                (DR3DNS,'scene'),
                (DRAWNS,'a'),
                (DRAWNS,'caption'),
                (DRAWNS,'circle'),
                (DRAWNS,'connector'),
                (DRAWNS,'control'),
                (DRAWNS,'custom-shape'),
                (DRAWNS,'ellipse'),
                (DRAWNS,'frame'),
                (DRAWNS,'g'),
                (DRAWNS,'line'),
                (DRAWNS,'measure'),
                (DRAWNS,'page-thumbnail'),
                (DRAWNS,'path'),
                (DRAWNS,'polygon'),
                (DRAWNS,'polyline'),
                (DRAWNS,'rect'),
                (DRAWNS,'regular-polygon'),
                (OFFICENS,'annotation'),
                (OFFICENS,'event-listeners'),
                (PRESENTATIONNS,'date-time'),
                (PRESENTATIONNS,'footer'),
                (PRESENTATIONNS,'header'),
                (TEXTNS,'a'),
                (TEXTNS,'alphabetical-index-mark'),
                (TEXTNS,'alphabetical-index-mark-end'),
                (TEXTNS,'alphabetical-index-mark-start'),
                (TEXTNS,'author-initials'),
                (TEXTNS,'author-name'),
                (TEXTNS,'bibliography-mark'),
                (TEXTNS,'bookmark'),
                (TEXTNS,'bookmark-end'),
                (TEXTNS,'bookmark-ref'),
                (TEXTNS,'bookmark-start'),
                (TEXTNS,'change'),
                (TEXTNS,'change-end'),
                (TEXTNS,'change-start'),
                (TEXTNS,'chapter'),
                (TEXTNS,'conditional-text'),
                (TEXTNS,'creation-date'),
                (TEXTNS,'creation-time'),
                (TEXTNS,'creator'),
                (TEXTNS,'database-display'),
                (TEXTNS,'database-name'),
                (TEXTNS,'database-next'),
                (TEXTNS,'database-row-number'),
                (TEXTNS,'database-row-select'),
                (TEXTNS,'date'),
                (TEXTNS,'dde-connection'),
                (TEXTNS,'description'),
                (TEXTNS,'editing-cycles'),
                (TEXTNS,'editing-duration'),
                (TEXTNS,'execute-macro'),
                (TEXTNS,'expression'),
                (TEXTNS,'file-name'),
                (TEXTNS,'hidden-paragraph'),
                (TEXTNS,'hidden-text'),
                (TEXTNS,'initial-creator'),
                (TEXTNS,'keywords'),
                (TEXTNS,'line-break'),
                (TEXTNS,'measure'),
                (TEXTNS,'modification-date'),
                (TEXTNS,'modification-time'),
                (TEXTNS,'note'),
                (TEXTNS,'note-ref'),
                (TEXTNS,'page-count'),
                (TEXTNS,'paragraph-count'),
                (TEXTNS,'word-count'),
                (TEXTNS,'character-count'),
                (TEXTNS,'table-count'),
                (TEXTNS,'image-count'),
                (TEXTNS,'object-count'),
                (TEXTNS,'page-continuation'),
                (TEXTNS,'page-number'),
                (TEXTNS,'page-variable-get'),
                (TEXTNS,'page-variable-set'),
                (TEXTNS,'placeholder'),
                (TEXTNS,'print-date'),
                (TEXTNS,'print-time'),
                (TEXTNS,'printed-by'),
                (TEXTNS,'reference-mark'),
                (TEXTNS,'reference-mark-end'),
                (TEXTNS,'reference-mark-start'),
                (TEXTNS,'reference-ref'),
                (TEXTNS,'ruby'),
                (TEXTNS,'s'),
                (TEXTNS,'script'),
                (TEXTNS,'sender-city'),
                (TEXTNS,'sender-company'),
                (TEXTNS,'sender-country'),
                (TEXTNS,'sender-email'),
                (TEXTNS,'sender-fax'),
                (TEXTNS,'sender-firstname'),
                (TEXTNS,'sender-initials'),
                (TEXTNS,'sender-lastname'),
                (TEXTNS,'sender-phone-private'),
                (TEXTNS,'sender-phone-work'),
                (TEXTNS,'sender-position'),
                (TEXTNS,'sender-postal-code'),
                (TEXTNS,'sender-state-or-province'),
                (TEXTNS,'sender-street'),
                (TEXTNS,'sender-title'),
                (TEXTNS,'sequence'),
                (TEXTNS,'sequence-ref'),
                (TEXTNS,'sheet-name'),
                (TEXTNS,'soft-page-break'),
                (TEXTNS,'span'),
                (TEXTNS,'subject'),
                (TEXTNS,'tab'),
                (TEXTNS,'table-formula'),
                (TEXTNS,'template-name'),
                (TEXTNS,'text-input'),
                (TEXTNS,'time'),
                (TEXTNS,'title'),
                (TEXTNS,'toc-mark'),
                (TEXTNS,'toc-mark-end'),
                (TEXTNS,'toc-mark-start'),
                (TEXTNS,'user-defined'),
                (TEXTNS,'user-field-get'),
                (TEXTNS,'user-field-input'),
                (TEXTNS,'user-index-mark'),
                (TEXTNS,'user-index-mark-end'),
                (TEXTNS,'user-index-mark-start'),
                (TEXTNS,'variable-get'),
                (TEXTNS,'variable-input'),
                (TEXTNS,'variable-set'),
        ),
# allowed_children
        (TEXTNS,'alphabetical-index') : (
                (TEXTNS,'alphabetical-index-source'),
                (TEXTNS,'index-body'),
        ),
        (TEXTNS,'alphabetical-index-auto-mark-file') : (
        ),
        (TEXTNS,'alphabetical-index-entry-template') : (
                (TEXTNS,'index-entry-chapter'),
                (TEXTNS,'index-entry-page-number'),
                (TEXTNS,'index-entry-span'),
                (TEXTNS,'index-entry-tab-stop'),
                (TEXTNS,'index-entry-text'),
        ),
        (TEXTNS,'alphabetical-index-mark') : (
        ),
        (TEXTNS,'alphabetical-index-mark-end') : (
        ),
        (TEXTNS,'alphabetical-index-mark-start') : (
        ),
        (TEXTNS,'alphabetical-index-source') : (
                (TEXTNS,'alphabetical-index-entry-template'),
                (TEXTNS,'index-title-template'),
        ),
        (TEXTNS,'author-initials') : (
        ),
        (TEXTNS,'author-name') : (
        ),
        (TEXTNS,'bibliography') : (
                (TEXTNS,'bibliography-source'),
                (TEXTNS,'index-body'),
        ),
        (TEXTNS,'bibliography-configuration') : (
                (TEXTNS,'sort-key'),
        ),
        (TEXTNS,'bibliography-entry-template') : (
                (TEXTNS,'index-entry-bibliography'),
                (TEXTNS,'index-entry-span'),
                (TEXTNS,'index-entry-tab-stop'),
        ),
# allowed_children
        (TEXTNS,'bibliography-mark') : (
        ),
        (TEXTNS,'bibliography-source') : (
                (TEXTNS,'bibliography-entry-template'),
                (TEXTNS,'index-title-template'),
        ),
        (TEXTNS,'bookmark') : (
        ),
        (TEXTNS,'bookmark-end') : (
        ),
        (TEXTNS,'bookmark-ref') : (
        ),
        (TEXTNS,'bookmark-start') : (
        ),
        (TEXTNS,'change') : (
        ),
        (TEXTNS,'change-end') : (
        ),
        (TEXTNS,'change-start') : (
        ),
        (TEXTNS,'changed-region') : (
                (TEXTNS,'deletion'),
                (TEXTNS,'format-change'),
                (TEXTNS,'insertion'),
        ),
        (TEXTNS,'chapter') : (
        ),
        (TEXTNS,'character-count') : (
        ),
        (TEXTNS,'conditional-text') : (
        ),
        (TEXTNS,'creation-date') : (
        ),
        (TEXTNS,'creation-time') : (
        ),
        (TEXTNS,'creator') : (
        ),
        (TEXTNS,'database-display') : (
                (FORMNS,'connection-resource'),
        ),
        (TEXTNS,'database-name') : (
                (FORMNS,'connection-resource'),
        ),
        (TEXTNS,'database-next') : (
                (FORMNS,'connection-resource'),
        ),
        (TEXTNS,'database-row-number') : (
                (FORMNS,'connection-resource'),
        ),
        (TEXTNS,'database-row-select') : (
                (FORMNS,'connection-resource'),
        ),
        (TEXTNS,'date') : (
        ),
        (TEXTNS,'dde-connection') : (
        ),
        (TEXTNS,'dde-connection-decl') : (
        ),
        (TEXTNS,'dde-connection-decls') : (
                (TEXTNS,'dde-connection-decl'),
        ),
# allowed_children
        (TEXTNS,'deletion') : (
                (DR3DNS,'scene'),
                (DRAWNS,'a'),
                (DRAWNS,'caption'),
                (DRAWNS,'circle'),
                (DRAWNS,'connector'),
                (DRAWNS,'control'),
                (DRAWNS,'custom-shape'),
                (DRAWNS,'ellipse'),
                (DRAWNS,'frame'),
                (DRAWNS,'g'),
                (DRAWNS,'line'),
                (DRAWNS,'measure'),
                (DRAWNS,'page-thumbnail'),
                (DRAWNS,'path'),
                (DRAWNS,'polygon'),
                (DRAWNS,'polyline'),
                (DRAWNS,'rect'),
                (DRAWNS,'regular-polygon'),
                (OFFICENS,'change-info'),
                (TABLENS,'table'),
                (TEXTNS,'alphabetical-index'),
                (TEXTNS,'bibliography'),
                (TEXTNS,'change'),
                (TEXTNS,'change-end'),
                (TEXTNS,'change-start'),
                (TEXTNS,'h'),
                (TEXTNS,'illustration-index'),
                (TEXTNS,'list'),
                (TEXTNS,'numbered-paragraph'),
                (TEXTNS,'object-index'),
                (TEXTNS,'p'),
                (TEXTNS,'section'),
                (TEXTNS,'soft-page-break'),
                (TEXTNS,'table-index'),
                (TEXTNS,'table-of-content'),
                (TEXTNS,'user-index'),
        ),
        (TEXTNS,'description') : (
        ),
        (TEXTNS,'editing-cycles') : (
        ),
        (TEXTNS,'editing-duration') : (
        ),
        (TEXTNS,'execute-macro') : (
                (OFFICENS,'event-listeners'),
        ),
        (TEXTNS,'expression') : (
        ),
        (TEXTNS,'file-name') : (
        ),
        (TEXTNS,'format-change') : (
                (OFFICENS,'change-info'),
        ),
# allowed_children
        (TEXTNS,'h') : (
                (DR3DNS,'scene'),
                (DRAWNS,'a'),
                (DRAWNS,'caption'),
                (DRAWNS,'circle'),
                (DRAWNS,'connector'),
                (DRAWNS,'control'),
                (DRAWNS,'custom-shape'),
                (DRAWNS,'ellipse'),
                (DRAWNS,'frame'),
                (DRAWNS,'g'),
                (DRAWNS,'line'),
                (DRAWNS,'measure'),
                (DRAWNS,'page-thumbnail'),
                (DRAWNS,'path'),
                (DRAWNS,'polygon'),
                (DRAWNS,'polyline'),
                (DRAWNS,'rect'),
                (DRAWNS,'regular-polygon'),
                (OFFICENS,'annotation'),
                (PRESENTATIONNS,'date-time'),
                (PRESENTATIONNS,'footer'),
                (PRESENTATIONNS,'header'),
                (TEXTNS,'a'),
                (TEXTNS,'alphabetical-index-mark'),
                (TEXTNS,'alphabetical-index-mark-end'),
                (TEXTNS,'alphabetical-index-mark-start'),
                (TEXTNS,'author-initials'),
                (TEXTNS,'author-name'),
                (TEXTNS,'bibliography-mark'),
                (TEXTNS,'bookmark'),
                (TEXTNS,'bookmark-end'),
                (TEXTNS,'bookmark-ref'),
                (TEXTNS,'bookmark-start'),
                (TEXTNS,'change'),
                (TEXTNS,'change-end'),
                (TEXTNS,'change-start'),
                (TEXTNS,'chapter'),
                (TEXTNS,'conditional-text'),
                (TEXTNS,'creation-date'),
                (TEXTNS,'creation-time'),
                (TEXTNS,'creator'),
                (TEXTNS,'database-display'),
                (TEXTNS,'database-name'),
                (TEXTNS,'database-next'),
                (TEXTNS,'database-row-number'),
                (TEXTNS,'database-row-select'),
                (TEXTNS,'date'),
                (TEXTNS,'dde-connection'),
                (TEXTNS,'description'),
                (TEXTNS,'editing-cycles'),
                (TEXTNS,'editing-duration'),
                (TEXTNS,'execute-macro'),
                (TEXTNS,'expression'),
                (TEXTNS,'file-name'),
                (TEXTNS,'hidden-paragraph'),
                (TEXTNS,'hidden-text'),
                (TEXTNS,'initial-creator'),
                (TEXTNS,'keywords'),
                (TEXTNS,'line-break'),
                (TEXTNS,'measure'),
                (TEXTNS,'modification-date'),
                (TEXTNS,'modification-time'),
                (TEXTNS,'note'),
                (TEXTNS,'note-ref'),
                (TEXTNS,'number'),
                (TEXTNS,'page-count'),
                (TEXTNS,'paragraph-count'),
                (TEXTNS,'word-count'),
                (TEXTNS,'character-count'),
                (TEXTNS,'table-count'),
                (TEXTNS,'image-count'),
                (TEXTNS,'object-count'),
                (TEXTNS,'page-continuation'),
                (TEXTNS,'page-number'),
                (TEXTNS,'page-variable-get'),
                (TEXTNS,'page-variable-set'),
                (TEXTNS,'placeholder'),
                (TEXTNS,'print-date'),
                (TEXTNS,'print-time'),
                (TEXTNS,'printed-by'),
                (TEXTNS,'reference-mark'),
                (TEXTNS,'reference-mark-end'),
                (TEXTNS,'reference-mark-start'),
                (TEXTNS,'reference-ref'),
                (TEXTNS,'ruby'),
                (TEXTNS,'s'),
                (TEXTNS,'script'),
                (TEXTNS,'sender-city'),
                (TEXTNS,'sender-company'),
                (TEXTNS,'sender-country'),
                (TEXTNS,'sender-email'),
                (TEXTNS,'sender-fax'),
                (TEXTNS,'sender-firstname'),
                (TEXTNS,'sender-initials'),
                (TEXTNS,'sender-lastname'),
                (TEXTNS,'sender-phone-private'),
                (TEXTNS,'sender-phone-work'),
                (TEXTNS,'sender-position'),
                (TEXTNS,'sender-postal-code'),
                (TEXTNS,'sender-state-or-province'),
                (TEXTNS,'sender-street'),
                (TEXTNS,'sender-title'),
                (TEXTNS,'sequence'),
                (TEXTNS,'sequence-ref'),
                (TEXTNS,'sheet-name'),
                (TEXTNS,'soft-page-break'),
                (TEXTNS,'span'),
                (TEXTNS,'subject'),
                (TEXTNS,'tab'),
                (TEXTNS,'table-formula'),
                (TEXTNS,'template-name'),
                (TEXTNS,'text-input'),
                (TEXTNS,'time'),
                (TEXTNS,'title'),
                (TEXTNS,'toc-mark'),
                (TEXTNS,'toc-mark-end'),
                (TEXTNS,'toc-mark-start'),
                (TEXTNS,'user-defined'),
                (TEXTNS,'user-field-get'),
                (TEXTNS,'user-field-input'),
                (TEXTNS,'user-index-mark'),
                (TEXTNS,'user-index-mark-end'),
                (TEXTNS,'user-index-mark-start'),
                (TEXTNS,'variable-get'),
                (TEXTNS,'variable-input'),
                (TEXTNS,'variable-set'),
        ),
# allowed_children
        (TEXTNS,'hidden-paragraph') : (
        ),
        (TEXTNS,'hidden-text') : (
        ),
        (TEXTNS,'illustration-index') : (
                (TEXTNS,'illustration-index-source'),
                (TEXTNS,'index-body'),
        ),
        (TEXTNS,'illustration-index-entry-template') : (
                (TEXTNS,'index-entry-page-number'),
                (TEXTNS,'index-entry-span'),
                (TEXTNS,'index-entry-tab-stop'),
                (TEXTNS,'index-entry-text'),
        ),
        (TEXTNS,'illustration-index-source') : (
                (TEXTNS,'illustration-index-entry-template'),
                (TEXTNS,'index-title-template'),
        ),
        (TEXTNS,'image-count') : (
        ),
# allowed_children
        (TEXTNS,'index-body') : (
                (DR3DNS,'scene'),
                (DRAWNS,'a'),
                (DRAWNS,'caption'),
                (DRAWNS,'circle'),
                (DRAWNS,'connector'),
                (DRAWNS,'control'),
                (DRAWNS,'custom-shape'),
                (DRAWNS,'ellipse'),
                (DRAWNS,'frame'),
                (DRAWNS,'g'),
                (DRAWNS,'line'),
                (DRAWNS,'measure'),
                (DRAWNS,'page-thumbnail'),
                (DRAWNS,'path'),
                (DRAWNS,'polygon'),
                (DRAWNS,'polyline'),
                (DRAWNS,'rect'),
                (DRAWNS,'regular-polygon'),
                (TABLENS,'table'),
                (TEXTNS,'alphabetical-index'),
                (TEXTNS,'bibliography'),
                (TEXTNS,'change'),
                (TEXTNS,'change-end'),
                (TEXTNS,'change-start'),
                (TEXTNS,'h'),
                (TEXTNS,'illustration-index'),
                (TEXTNS,'index-title'),
                (TEXTNS,'list'),
                (TEXTNS,'numbered-paragraph'),
                (TEXTNS,'object-index'),
                (TEXTNS,'p'),
                (TEXTNS,'section'),
                (TEXTNS,'soft-page-break'),
                (TEXTNS,'table-index'),
                (TEXTNS,'table-of-content'),
                (TEXTNS,'user-index'),
        ),
        (TEXTNS,'index-entry-bibliography') : (
        ),
        (TEXTNS,'index-entry-chapter') : (
        ),
        (TEXTNS,'index-entry-link-end') : (
        ),
        (TEXTNS,'index-entry-link-start') : (
        ),
        (TEXTNS,'index-entry-page-number') : (
        ),
        (TEXTNS,'index-entry-span') : (
        ),
        (TEXTNS,'index-entry-tab-stop') : (
        ),
        (TEXTNS,'index-entry-text') : (
        ),
        (TEXTNS,'index-source-style') : (
        ),
        (TEXTNS,'index-source-styles') : (
                (TEXTNS,'index-source-style'),
        ),
# allowed_children
        (TEXTNS,'index-title') : (
                (DR3DNS,'scene'),
                (DRAWNS,'a'),
                (DRAWNS,'caption'),
                (DRAWNS,'circle'),
                (DRAWNS,'connector'),
                (DRAWNS,'control'),
                (DRAWNS,'custom-shape'),
                (DRAWNS,'ellipse'),
                (DRAWNS,'frame'),
                (DRAWNS,'g'),
                (DRAWNS,'line'),
                (DRAWNS,'measure'),
                (DRAWNS,'page-thumbnail'),
                (DRAWNS,'path'),
                (DRAWNS,'polygon'),
                (DRAWNS,'polyline'),
                (DRAWNS,'rect'),
                (DRAWNS,'regular-polygon'),
                (TABLENS,'table'),
                (TEXTNS,'alphabetical-index'),
                (TEXTNS,'bibliography'),
                (TEXTNS,'change'),
                (TEXTNS,'change-end'),
                (TEXTNS,'change-start'),
                (TEXTNS,'h'),
                (TEXTNS,'illustration-index'),
                (TEXTNS,'index-title'),
                (TEXTNS,'list'),
                (TEXTNS,'numbered-paragraph'),
                (TEXTNS,'object-index'),
                (TEXTNS,'p'),
                (TEXTNS,'section'),
                (TEXTNS,'soft-page-break'),
                (TEXTNS,'table-index'),
                (TEXTNS,'table-of-content'),
                (TEXTNS,'user-index'),
        ),
        (TEXTNS,'index-title-template') : (
        ),
        (TEXTNS,'initial-creator') : (
        ),
        (TEXTNS,'insertion') : (
                (OFFICENS,'change-info'),
        ),
        (TEXTNS,'keywords') : (
        ),
        (TEXTNS,'line-break') : (
        ),
        (TEXTNS,'linenumbering-configuration') : (
                (TEXTNS,'linenumbering-separator'),
        ),
        (TEXTNS,'linenumbering-separator') : (
        ),
        (TEXTNS,'list') : (
                (TEXTNS,'list-header'),
                (TEXTNS,'list-item'),
        ),
        (TEXTNS,'list-header') : (
                (TEXTNS,'h'),
                (TEXTNS,'list'),
                (TEXTNS,'number'),
                (TEXTNS,'p'),
                (TEXTNS,'soft-page-break'),
        ),
        (TEXTNS,'list-item') : (
                (TEXTNS,'h'),
                (TEXTNS,'list'),
                (TEXTNS,'number'),
                (TEXTNS,'p'),
                (TEXTNS,'soft-page-break'),
        ),
        (TEXTNS,'list-level-style-bullet') : (
                (STYLENS,'list-level-properties'),
                (STYLENS,'text-properties'),
        ),
        (TEXTNS,'list-level-style-image') : (
                (OFFICENS,'binary-data'),
                (STYLENS,'list-level-properties'),
        ),
        (TEXTNS,'list-level-style-number') : (
                (STYLENS,'list-level-properties'),
                (STYLENS,'text-properties'),
        ),
        (TEXTNS,'list-style') : (
                (TEXTNS,'list-level-style-bullet'),
                (TEXTNS,'list-level-style-image'),
                (TEXTNS,'list-level-style-number'),
        ),
        (TEXTNS,'measure') : (
        ),
        (TEXTNS,'modification-date') : (
        ),
        (TEXTNS,'modification-time') : (
        ),
        (TEXTNS,'note') : (
                (TEXTNS,'note-body'),
                (TEXTNS,'note-citation'),
        ),
# allowed_children
        (TEXTNS,'note-body') : (
                (DR3DNS,'scene'),
                (DRAWNS,'a'),
                (DRAWNS,'caption'),
                (DRAWNS,'circle'),
                (DRAWNS,'connector'),
                (DRAWNS,'control'),
                (DRAWNS,'custom-shape'),
                (DRAWNS,'ellipse'),
                (DRAWNS,'frame'),
                (DRAWNS,'g'),
                (DRAWNS,'line'),
                (DRAWNS,'measure'),
                (DRAWNS,'page-thumbnail'),
                (DRAWNS,'path'),
                (DRAWNS,'polygon'),
                (DRAWNS,'polyline'),
                (DRAWNS,'rect'),
                (DRAWNS,'regular-polygon'),
                (TABLENS,'table'),
                (TEXTNS,'alphabetical-index'),
                (TEXTNS,'bibliography'),
                (TEXTNS,'change'),
                (TEXTNS,'change-end'),
                (TEXTNS,'change-start'),
                (TEXTNS,'h'),
                (TEXTNS,'illustration-index'),
                (TEXTNS,'list'),
                (TEXTNS,'numbered-paragraph'),
                (TEXTNS,'object-index'),
                (TEXTNS,'p'),
                (TEXTNS,'section'),
                (TEXTNS,'soft-page-break'),
                (TEXTNS,'table-index'),
                (TEXTNS,'table-of-content'),
                (TEXTNS,'user-index'),
        ),
        (TEXTNS,'note-citation') : (
        ),
        (TEXTNS,'note-continuation-notice-backward') : (
        ),
        (TEXTNS,'note-continuation-notice-forward') : (
        ),
        (TEXTNS,'note-ref') : (
        ),
        (TEXTNS,'notes-configuration') : (
                (TEXTNS,'note-continuation-notice-backward'),
                (TEXTNS,'note-continuation-notice-forward'),
        ),
        (TEXTNS,'number') : (
        ),
        (TEXTNS,'numbered-paragraph') : (
                (TEXTNS,'h'),
                (TEXTNS,'number'),
                (TEXTNS,'p'),
        ),
        (TEXTNS,'object-count') : (
        ),
        (TEXTNS,'object-index') : (
                (TEXTNS,'index-body'),
                (TEXTNS,'object-index-source'),
        ),
        (TEXTNS,'object-index-entry-template') : (
                (TEXTNS,'index-entry-page-number'),
                (TEXTNS,'index-entry-span'),
                (TEXTNS,'index-entry-tab-stop'),
                (TEXTNS,'index-entry-text'),
        ),
        (TEXTNS,'object-index-source') : (
                (TEXTNS,'index-title-template'),
                (TEXTNS,'object-index-entry-template'),
        ),
        (TEXTNS,'outline-level-style') : (
                (STYLENS,'list-level-properties'),
                (STYLENS,'text-properties'),
        ),
        (TEXTNS,'outline-style') : (
                (TEXTNS,'outline-level-style'),
        ),
# allowed_children
        (TEXTNS,'p') : (
                (DR3DNS,'scene'),
                (DRAWNS,'a'),
                (DRAWNS,'caption'),
                (DRAWNS,'circle'),
                (DRAWNS,'connector'),
                (DRAWNS,'control'),
                (DRAWNS,'custom-shape'),
                (DRAWNS,'ellipse'),
                (DRAWNS,'frame'),
                (DRAWNS,'g'),
                (DRAWNS,'line'),
                (DRAWNS,'measure'),
                (DRAWNS,'page-thumbnail'),
                (DRAWNS,'path'),
                (DRAWNS,'polygon'),
                (DRAWNS,'polyline'),
                (DRAWNS,'rect'),
                (DRAWNS,'regular-polygon'),
                (OFFICENS,'annotation'),
                (PRESENTATIONNS,'date-time'),
                (PRESENTATIONNS,'footer'),
                (PRESENTATIONNS,'header'),
                (TEXTNS,'a'),
                (TEXTNS,'alphabetical-index-mark'),
                (TEXTNS,'alphabetical-index-mark-end'),
                (TEXTNS,'alphabetical-index-mark-start'),
                (TEXTNS,'author-initials'),
                (TEXTNS,'author-name'),
                (TEXTNS,'bibliography-mark'),
                (TEXTNS,'bookmark'),
                (TEXTNS,'bookmark-end'),
                (TEXTNS,'bookmark-ref'),
                (TEXTNS,'bookmark-start'),
                (TEXTNS,'change'),
                (TEXTNS,'change-end'),
                (TEXTNS,'change-start'),
                (TEXTNS,'chapter'),
                (TEXTNS,'character-count'),
                (TEXTNS,'conditional-text'),
                (TEXTNS,'creation-date'),
                (TEXTNS,'creation-time'),
                (TEXTNS,'creator'),
                (TEXTNS,'database-display'),
                (TEXTNS,'database-name'),
                (TEXTNS,'database-next'),
                (TEXTNS,'database-row-number'),
                (TEXTNS,'database-row-select'),
                (TEXTNS,'date'),
                (TEXTNS,'dde-connection'),
                (TEXTNS,'description'),
                (TEXTNS,'editing-cycles'),
                (TEXTNS,'editing-duration'),
                (TEXTNS,'execute-macro'),
                (TEXTNS,'expression'),
                (TEXTNS,'file-name'),
                (TEXTNS,'hidden-paragraph'),
                (TEXTNS,'hidden-text'),
                (TEXTNS,'image-count'),
                (TEXTNS,'initial-creator'),
                (TEXTNS,'keywords'),
                (TEXTNS,'line-break'),
                (TEXTNS,'measure'),
                (TEXTNS,'modification-date'),
                (TEXTNS,'modification-time'),
                (TEXTNS,'note'),
                (TEXTNS,'note-ref'),
                (TEXTNS,'object-count'),
                (TEXTNS,'page-continuation'),
                (TEXTNS,'page-count'),
                (TEXTNS,'page-number'),
                (TEXTNS,'page-variable-get'),
                (TEXTNS,'page-variable-set'),
                (TEXTNS,'paragraph-count'),
                (TEXTNS,'placeholder'),
                (TEXTNS,'print-date'),
                (TEXTNS,'printed-by'),
                (TEXTNS,'print-time'),
                (TEXTNS,'reference-mark'),
                (TEXTNS,'reference-mark-end'),
                (TEXTNS,'reference-mark-start'),
                (TEXTNS,'reference-ref'),
                (TEXTNS,'ruby'),
                (TEXTNS,'s'),
                (TEXTNS,'script'),
                (TEXTNS,'sender-city'),
                (TEXTNS,'sender-company'),
                (TEXTNS,'sender-country'),
                (TEXTNS,'sender-email'),
                (TEXTNS,'sender-fax'),
                (TEXTNS,'sender-firstname'),
                (TEXTNS,'sender-initials'),
                (TEXTNS,'sender-lastname'),
                (TEXTNS,'sender-phone-private'),
                (TEXTNS,'sender-phone-work'),
                (TEXTNS,'sender-position'),
                (TEXTNS,'sender-postal-code'),
                (TEXTNS,'sender-state-or-province'),
                (TEXTNS,'sender-street'),
                (TEXTNS,'sender-title'),
                (TEXTNS,'sequence'),
                (TEXTNS,'sequence-ref'),
                (TEXTNS,'sheet-name'),
                (TEXTNS,'soft-page-break'),
                (TEXTNS,'span'),
                (TEXTNS,'subject'),
                (TEXTNS,'tab'),
                (TEXTNS,'table-count'),
                (TEXTNS,'table-formula'),
                (TEXTNS,'template-name'),
                (TEXTNS,'text-input'),
                (TEXTNS,'time'),
                (TEXTNS,'title'),
                (TEXTNS,'toc-mark'),
                (TEXTNS,'toc-mark-end'),
                (TEXTNS,'toc-mark-start'),
                (TEXTNS,'user-defined'),
                (TEXTNS,'user-field-get'),
                (TEXTNS,'user-field-input'),
                (TEXTNS,'user-index-mark'),
                (TEXTNS,'user-index-mark-end'),
                (TEXTNS,'user-index-mark-start'),
                (TEXTNS,'variable-get'),
                (TEXTNS,'variable-input'),
                (TEXTNS,'variable-set'),
                (TEXTNS,'word-count'),
        ),
        (TEXTNS,'page') : (
        ),
        (TEXTNS,'page-count') : (
        ),
        (TEXTNS,'page-continuation') : (
        ),
        (TEXTNS,'page-number') : (
        ),
        (TEXTNS,'page-sequence') : (
                (TEXTNS,'page'),
        ),
        (TEXTNS,'page-variable-get') : (
        ),
        (TEXTNS,'page-variable-set') : (
        ),
        (TEXTNS,'paragraph-count') : (
        ),
        (TEXTNS,'placeholder') : (
        ),
        (TEXTNS,'print-date') : (
        ),
        (TEXTNS,'print-time') : (
        ),
        (TEXTNS,'printed-by') : (
        ),
        (TEXTNS,'reference-mark') : (
        ),
        (TEXTNS,'reference-mark-end') : (
        ),
# allowed_children
        (TEXTNS,'reference-mark-start') : (
        ),
        (TEXTNS,'reference-ref') : (
        ),
        (TEXTNS,'ruby') : (
                (TEXTNS,'ruby-base'),
                (TEXTNS,'ruby-text'),
        ),
        (TEXTNS,'ruby-base') : (
                (DR3DNS,'scene'),
                (DRAWNS,'a'),
                (DRAWNS,'caption'),
                (DRAWNS,'circle'),
                (DRAWNS,'connector'),
                (DRAWNS,'control'),
                (DRAWNS,'custom-shape'),
                (DRAWNS,'ellipse'),
                (DRAWNS,'frame'),
                (DRAWNS,'g'),
                (DRAWNS,'line'),
                (DRAWNS,'measure'),
                (DRAWNS,'page-thumbnail'),
                (DRAWNS,'path'),
                (DRAWNS,'polygon'),
                (DRAWNS,'polyline'),
                (DRAWNS,'rect'),
                (DRAWNS,'regular-polygon'),
                (OFFICENS,'annotation'),
                (PRESENTATIONNS,'date-time'),
                (PRESENTATIONNS,'footer'),
                (PRESENTATIONNS,'header'),
                (TEXTNS,'a'),
                (TEXTNS,'alphabetical-index-mark'),
                (TEXTNS,'alphabetical-index-mark-end'),
                (TEXTNS,'alphabetical-index-mark-start'),
                (TEXTNS,'author-initials'),
                (TEXTNS,'author-name'),
                (TEXTNS,'bibliography-mark'),
                (TEXTNS,'bookmark'),
                (TEXTNS,'bookmark-end'),
                (TEXTNS,'bookmark-ref'),
                (TEXTNS,'bookmark-start'),
                (TEXTNS,'change'),
                (TEXTNS,'change-end'),
                (TEXTNS,'change-start'),
                (TEXTNS,'chapter'),
                (TEXTNS,'conditional-text'),
                (TEXTNS,'creation-date'),
                (TEXTNS,'creation-time'),
                (TEXTNS,'creator'),
                (TEXTNS,'database-display'),
                (TEXTNS,'database-name'),
                (TEXTNS,'database-next'),
                (TEXTNS,'database-row-number'),
                (TEXTNS,'database-row-select'),
                (TEXTNS,'date'),
                (TEXTNS,'dde-connection'),
                (TEXTNS,'description'),
                (TEXTNS,'editing-cycles'),
                (TEXTNS,'editing-duration'),
                (TEXTNS,'execute-macro'),
                (TEXTNS,'expression'),
                (TEXTNS,'file-name'),
                (TEXTNS,'hidden-paragraph'),
                (TEXTNS,'hidden-text'),
                (TEXTNS,'initial-creator'),
                (TEXTNS,'keywords'),
                (TEXTNS,'line-break'),
                (TEXTNS,'measure'),
                (TEXTNS,'modification-date'),
                (TEXTNS,'modification-time'),
                (TEXTNS,'note'),
                (TEXTNS,'note-ref'),
                (TEXTNS,'page-count'),
                (TEXTNS,'paragraph-count'),
                (TEXTNS,'word-count'),
                (TEXTNS,'character-count'),
                (TEXTNS,'table-count'),
                (TEXTNS,'image-count'),
                (TEXTNS,'object-count'),
                (TEXTNS,'page-continuation'),
                (TEXTNS,'page-number'),
                (TEXTNS,'page-variable-get'),
                (TEXTNS,'page-variable-set'),
                (TEXTNS,'placeholder'),
                (TEXTNS,'print-date'),
                (TEXTNS,'print-time'),
                (TEXTNS,'printed-by'),
                (TEXTNS,'reference-mark'),
                (TEXTNS,'reference-mark-end'),
                (TEXTNS,'reference-mark-start'),
                (TEXTNS,'reference-ref'),
                (TEXTNS,'ruby'),
                (TEXTNS,'s'),
                (TEXTNS,'script'),
                (TEXTNS,'sender-city'),
                (TEXTNS,'sender-company'),
                (TEXTNS,'sender-country'),
                (TEXTNS,'sender-email'),
                (TEXTNS,'sender-fax'),
                (TEXTNS,'sender-firstname'),
                (TEXTNS,'sender-initials'),
                (TEXTNS,'sender-lastname'),
                (TEXTNS,'sender-phone-private'),
                (TEXTNS,'sender-phone-work'),
                (TEXTNS,'sender-position'),
                (TEXTNS,'sender-postal-code'),
                (TEXTNS,'sender-state-or-province'),
                (TEXTNS,'sender-street'),
                (TEXTNS,'sender-title'),
                (TEXTNS,'sequence'),
                (TEXTNS,'sequence-ref'),
                (TEXTNS,'sheet-name'),
                (TEXTNS,'soft-page-break'),
                (TEXTNS,'span'),
                (TEXTNS,'subject'),
                (TEXTNS,'tab'),
                (TEXTNS,'table-formula'),
                (TEXTNS,'template-name'),
                (TEXTNS,'text-input'),
                (TEXTNS,'time'),
                (TEXTNS,'title'),
                (TEXTNS,'toc-mark'),
                (TEXTNS,'toc-mark-end'),
                (TEXTNS,'toc-mark-start'),
                (TEXTNS,'user-defined'),
                (TEXTNS,'user-field-get'),
                (TEXTNS,'user-field-input'),
                (TEXTNS,'user-index-mark'),
                (TEXTNS,'user-index-mark-end'),
                (TEXTNS,'user-index-mark-start'),
                (TEXTNS,'variable-get'),
                (TEXTNS,'variable-input'),
                (TEXTNS,'variable-set'),
        ),
# allowed_children
        (TEXTNS,'ruby-text') : (
        ),
        (TEXTNS,'s') : (
        ),
        (TEXTNS,'script') : (
        ),
        (TEXTNS,'section') : (
                (DR3DNS,'scene'),
                (DRAWNS,'a'),
                (DRAWNS,'caption'),
                (DRAWNS,'circle'),
                (DRAWNS,'connector'),
                (DRAWNS,'control'),
                (DRAWNS,'custom-shape'),
                (DRAWNS,'ellipse'),
                (DRAWNS,'frame'),
                (DRAWNS,'g'),
                (DRAWNS,'line'),
                (DRAWNS,'measure'),
                (DRAWNS,'page-thumbnail'),
                (DRAWNS,'path'),
                (DRAWNS,'polygon'),
                (DRAWNS,'polyline'),
                (DRAWNS,'rect'),
                (DRAWNS,'regular-polygon'),
                (OFFICENS,'dde-source'),
                (TABLENS,'table'),
                (TEXTNS,'alphabetical-index'),
                (TEXTNS,'bibliography'),
                (TEXTNS,'change'),
                (TEXTNS,'change-end'),
                (TEXTNS,'change-start'),
                (TEXTNS,'h'),
                (TEXTNS,'illustration-index'),
                (TEXTNS,'list'),
                (TEXTNS,'numbered-paragraph'),
                (TEXTNS,'object-index'),
                (TEXTNS,'p'),
                (TEXTNS,'section'),
                (TEXTNS,'section-source'),
                (TEXTNS,'soft-page-break'),
                (TEXTNS,'table-index'),
                (TEXTNS,'table-of-content'),
                (TEXTNS,'user-index'),
        ),
        (TEXTNS,'section-source') : (
        ),
        (TEXTNS,'sender-city') : (
        ),
        (TEXTNS,'sender-company') : (
        ),
        (TEXTNS,'sender-country') : (
        ),
# allowed_children
        (TEXTNS,'sender-email') : (
        ),
        (TEXTNS,'sender-fax') : (
        ),
        (TEXTNS,'sender-firstname') : (
        ),
        (TEXTNS,'sender-initials') : (
        ),
        (TEXTNS,'sender-lastname') : (
        ),
        (TEXTNS,'sender-phone-private') : (
        ),
        (TEXTNS,'sender-phone-work') : (
        ),
        (TEXTNS,'sender-position') : (
        ),
        (TEXTNS,'sender-postal-code') : (
        ),
        (TEXTNS,'sender-state-or-province') : (
        ),
        (TEXTNS,'sender-street') : (
        ),
        (TEXTNS,'sender-title') : (
        ),
        (TEXTNS,'sequence') : (
        ),
        (TEXTNS,'sequence-decl') : (
        ),
        (TEXTNS,'sequence-decls') : (
                (TEXTNS,'sequence-decl'),
        ),
        (TEXTNS,'sequence-ref') : (
        ),
        (TEXTNS,'sheet-name') : (
        ),
        (TEXTNS,'soft-page-break') : (
        ),
        (TEXTNS,'sort-key') : (
        ),
# allowed_children
        (TEXTNS,'span') : (
                (DR3DNS,'scene'),
                (DRAWNS,'a'),
                (DRAWNS,'caption'),
                (DRAWNS,'circle'),
                (DRAWNS,'connector'),
                (DRAWNS,'control'),
                (DRAWNS,'custom-shape'),
                (DRAWNS,'ellipse'),
                (DRAWNS,'frame'),
                (DRAWNS,'g'),
                (DRAWNS,'line'),
                (DRAWNS,'measure'),
                (DRAWNS,'page-thumbnail'),
                (DRAWNS,'path'),
                (DRAWNS,'polygon'),
                (DRAWNS,'polyline'),
                (DRAWNS,'rect'),
                (DRAWNS,'regular-polygon'),
                (OFFICENS,'annotation'),
                (PRESENTATIONNS,'date-time'),
                (PRESENTATIONNS,'footer'),
                (PRESENTATIONNS,'header'),
                (TEXTNS,'a'),
                (TEXTNS,'alphabetical-index-mark'),
                (TEXTNS,'alphabetical-index-mark-end'),
                (TEXTNS,'alphabetical-index-mark-start'),
                (TEXTNS,'author-initials'),
                (TEXTNS,'author-name'),
                (TEXTNS,'bibliography-mark'),
                (TEXTNS,'bookmark'),
                (TEXTNS,'bookmark-end'),
                (TEXTNS,'bookmark-ref'),
                (TEXTNS,'bookmark-start'),
                (TEXTNS,'change'),
                (TEXTNS,'change-end'),
                (TEXTNS,'change-start'),
                (TEXTNS,'chapter'),
                (TEXTNS,'conditional-text'),
                (TEXTNS,'creation-date'),
                (TEXTNS,'creation-time'),
                (TEXTNS,'creator'),
                (TEXTNS,'database-display'),
                (TEXTNS,'database-name'),
                (TEXTNS,'database-next'),
                (TEXTNS,'database-row-number'),
                (TEXTNS,'database-row-select'),
                (TEXTNS,'date'),
                (TEXTNS,'dde-connection'),
                (TEXTNS,'description'),
                (TEXTNS,'editing-cycles'),
                (TEXTNS,'editing-duration'),
                (TEXTNS,'execute-macro'),
                (TEXTNS,'expression'),
                (TEXTNS,'file-name'),
                (TEXTNS,'hidden-paragraph'),
                (TEXTNS,'hidden-text'),
                (TEXTNS,'initial-creator'),
                (TEXTNS,'keywords'),
                (TEXTNS,'line-break'),
                (TEXTNS,'measure'),
                (TEXTNS,'modification-date'),
                (TEXTNS,'modification-time'),
                (TEXTNS,'note'),
                (TEXTNS,'note-ref'),
                (TEXTNS,'page-count'),
                (TEXTNS,'paragraph-count'),
                (TEXTNS,'word-count'),
                (TEXTNS,'character-count'),
                (TEXTNS,'table-count'),
                (TEXTNS,'image-count'),
                (TEXTNS,'object-count'),
                (TEXTNS,'page-continuation'),
                (TEXTNS,'page-number'),
                (TEXTNS,'page-variable-get'),
                (TEXTNS,'page-variable-set'),
                (TEXTNS,'placeholder'),
                (TEXTNS,'print-date'),
                (TEXTNS,'print-time'),
                (TEXTNS,'printed-by'),
                (TEXTNS,'reference-mark'),
                (TEXTNS,'reference-mark-end'),
                (TEXTNS,'reference-mark-start'),
                (TEXTNS,'reference-ref'),
                (TEXTNS,'ruby'),
                (TEXTNS,'s'),
                (TEXTNS,'script'),
                (TEXTNS,'sender-city'),
                (TEXTNS,'sender-company'),
                (TEXTNS,'sender-country'),
                (TEXTNS,'sender-email'),
                (TEXTNS,'sender-fax'),
                (TEXTNS,'sender-firstname'),
                (TEXTNS,'sender-initials'),
                (TEXTNS,'sender-lastname'),
                (TEXTNS,'sender-phone-private'),
                (TEXTNS,'sender-phone-work'),
                (TEXTNS,'sender-position'),
                (TEXTNS,'sender-postal-code'),
                (TEXTNS,'sender-state-or-province'),
                (TEXTNS,'sender-street'),
                (TEXTNS,'sender-title'),
                (TEXTNS,'sequence'),
                (TEXTNS,'sequence-ref'),
                (TEXTNS,'sheet-name'),
                (TEXTNS,'soft-page-break'),
                (TEXTNS,'span'),
                (TEXTNS,'subject'),
                (TEXTNS,'tab'),
                (TEXTNS,'table-formula'),
                (TEXTNS,'template-name'),
                (TEXTNS,'text-input'),
                (TEXTNS,'time'),
                (TEXTNS,'title'),
                (TEXTNS,'toc-mark'),
                (TEXTNS,'toc-mark-end'),
                (TEXTNS,'toc-mark-start'),
                (TEXTNS,'user-defined'),
                (TEXTNS,'user-field-get'),
                (TEXTNS,'user-field-input'),
                (TEXTNS,'user-index-mark'),
                (TEXTNS,'user-index-mark-end'),
                (TEXTNS,'user-index-mark-start'),
                (TEXTNS,'variable-get'),
                (TEXTNS,'variable-input'),
                (TEXTNS,'variable-set'),
        ),
# allowed_children
        (TEXTNS,'subject') : (
        ),
        (TEXTNS,'tab') : (
        ),
        (TEXTNS,'table-count') : (
        ),
        (TEXTNS,'table-formula') : (
        ),
        (TEXTNS,'table-index') : (
                (TEXTNS,'index-body'),
                (TEXTNS,'table-index-source'),
        ),
        (TEXTNS,'table-index-entry-template') : (
                (TEXTNS,'index-entry-page-number'),
                (TEXTNS,'index-entry-span'),
                (TEXTNS,'index-entry-tab-stop'),
                (TEXTNS,'index-entry-text'),
        ),
        (TEXTNS,'table-index-source') : (
                (TEXTNS,'index-title-template'),
                (TEXTNS,'table-index-entry-template'),
        ),
        (TEXTNS,'table-of-content') : (
                (TEXTNS,'index-body'),
                (TEXTNS,'table-of-content-source'),
        ),
        (TEXTNS,'table-of-content-entry-template') : (
                (TEXTNS,'index-entry-chapter'),
                (TEXTNS,'index-entry-link-end'),
                (TEXTNS,'index-entry-link-start'),
                (TEXTNS,'index-entry-page-number'),
                (TEXTNS,'index-entry-span'),
                (TEXTNS,'index-entry-tab-stop'),
                (TEXTNS,'index-entry-text'),
        ),
        (TEXTNS,'table-of-content-source') : (
                (TEXTNS,'index-source-styles'),
                (TEXTNS,'index-title-template'),
                (TEXTNS,'table-of-content-entry-template'),
        ),
        (TEXTNS,'template-name') : (
        ),
        (TEXTNS,'text-input') : (
        ),
        (TEXTNS,'time') : (
        ),
        (TEXTNS,'title') : (
        ),
        (TEXTNS,'toc-mark') : (
        ),
        (TEXTNS,'toc-mark-end') : (
        ),
        (TEXTNS,'toc-mark-start') : (
        ),
# allowed_children
        (TEXTNS,'tracked-changes') : (
                (TEXTNS,'changed-region'),
        ),
        (TEXTNS,'user-defined') : (
        ),
        (TEXTNS,'user-field-decl') : (
        ),
        (TEXTNS,'user-field-decls') : (
                (TEXTNS,'user-field-decl'),
        ),
        (TEXTNS,'user-field-get') : (
        ),
        (TEXTNS,'user-field-input') : (
        ),
        (TEXTNS,'user-index') : (
                (TEXTNS,'index-body'),
                (TEXTNS,'user-index-source'),
        ),
        (TEXTNS,'user-index-entry-template') : (
                (TEXTNS,'index-entry-chapter'),
                (TEXTNS,'index-entry-page-number'),
                (TEXTNS,'index-entry-span'),
                (TEXTNS,'index-entry-tab-stop'),
                (TEXTNS,'index-entry-text'),
        ),
# allowed_children
        (TEXTNS,'user-index-mark') : (
        ),
        (TEXTNS,'user-index-mark-end') : (
        ),
        (TEXTNS,'user-index-mark-start') : (
        ),
        (TEXTNS,'user-index-source') : (
                (TEXTNS,'index-source-styles'),
                (TEXTNS,'index-title-template'),
                (TEXTNS,'user-index-entry-template'),
        ),
        (TEXTNS,'variable-decl') : (
        ),
        (TEXTNS,'variable-decls') : (
                (TEXTNS,'variable-decl'),
        ),
        (TEXTNS,'variable-get') : (
        ),
        (TEXTNS,'variable-input') : (
        ),
        (TEXTNS,'variable-set') : (
        ),
        (TEXTNS,'word-count') : (
        ),
}

#
# List of elements that allows text nodes
#
allows_text = (
        (CONFIGNS,'config-item'),
        (DCNS,'creator'),
        (DCNS,'date'),
        (DCNS,'description'),
        (DCNS,'language'),
        (DCNS,'subject'),
        (DCNS,'title'),
# Completes Dublin Core start
#       (DCNS,'contributor'),
#       (DCNS,'coverage'),
#       (DCNS,'format'),
#       (DCNS,'identifier'),
#       (DCNS,'publisher'),
#       (DCNS,'relation'),
#       (DCNS,'rights'),
#       (DCNS,'source'),
#       (DCNS,'type'),
# Completes Dublin Core end
        (FORMNS,'item'),
        (FORMNS,'option'),
        (MATHNS,'math'),
        (METANS,'creation-date'),
        (METANS,'date-string'),
        (METANS,'editing-cycles'),
        (METANS,'editing-duration'),
# allows_text
        (METANS,'generator'),
        (METANS,'initial-creator'),
        (METANS,'keyword'),
        (METANS,'print-date'),
        (METANS,'printed-by'),
        (METANS,'user-defined'),
        (NUMBERNS,'currency-symbol'),
        (NUMBERNS,'embedded-text'),
        (NUMBERNS,'text'),
        (OFFICENS,'binary-data'),
        (OFFICENS,'script'),
        (PRESENTATIONNS,'date-time-decl'),
        (PRESENTATIONNS,'footer-decl'),
        (PRESENTATIONNS,'header-decl'),
        (SVGNS,'desc'),
        (SVGNS,'title'),
        (TEXTNS,'a'),
        (TEXTNS,'author-initials'),
        (TEXTNS,'author-name'),
        (TEXTNS,'bibliography-mark'),
        (TEXTNS,'bookmark-ref'),
        (TEXTNS,'chapter'),
        (TEXTNS,'character-count'),
        (TEXTNS,'conditional-text'),
        (TEXTNS,'creation-date'),
        (TEXTNS,'creation-time'),
        (TEXTNS,'creator'),
        (TEXTNS,'database-display'),
        (TEXTNS,'database-name'),
        (TEXTNS,'database-row-number'),
        (TEXTNS,'date'),
        (TEXTNS,'dde-connection'),
        (TEXTNS,'description'),
        (TEXTNS,'editing-cycles'),
        (TEXTNS,'editing-duration'),
        (TEXTNS,'execute-macro'),
        (TEXTNS,'expression'),
        (TEXTNS,'file-name'),
        (TEXTNS,'h'),
        (TEXTNS,'hidden-paragraph'),
        (TEXTNS,'hidden-text'),
        (TEXTNS,'image-count'),
# allowed_children
        (TEXTNS,'index-entry-span'),
        (TEXTNS,'index-title-template'),
        (TEXTNS,'initial-creator'),
        (TEXTNS,'keywords'),
        (TEXTNS,'linenumbering-separator'),
        (TEXTNS,'measure'),
        (TEXTNS,'modification-date'),
        (TEXTNS,'modification-time'),
        (TEXTNS,'note-citation'),
        (TEXTNS,'note-continuation-notice-backward'),
        (TEXTNS,'note-continuation-notice-forward'),
        (TEXTNS,'note-ref'),
        (TEXTNS,'number'),
        (TEXTNS,'object-count'),
        (TEXTNS,'p'),
        (TEXTNS,'page-continuation'),
        (TEXTNS,'page-count'),
        (TEXTNS,'page-number'),
        (TEXTNS,'page-variable-get'),
        (TEXTNS,'page-variable-set'),
        (TEXTNS,'paragraph-count'),
        (TEXTNS,'placeholder'),
        (TEXTNS,'print-date'),
        (TEXTNS,'print-time'),
        (TEXTNS,'printed-by'),
        (TEXTNS,'reference-ref'),
        (TEXTNS,'ruby-base'),
        (TEXTNS,'ruby-text'),
        (TEXTNS,'script'),
        (TEXTNS,'sender-city'),
        (TEXTNS,'sender-company'),
        (TEXTNS,'sender-country'),
        (TEXTNS,'sender-email'),
        (TEXTNS,'sender-fax'),
        (TEXTNS,'sender-firstname'),
        (TEXTNS,'sender-initials'),
        (TEXTNS,'sender-lastname'),
        (TEXTNS,'sender-phone-private'),
        (TEXTNS,'sender-phone-work'),
        (TEXTNS,'sender-position'),
        (TEXTNS,'sender-postal-code'),
        (TEXTNS,'sender-state-or-province'),
        (TEXTNS,'sender-street'),
        (TEXTNS,'sender-title'),
        (TEXTNS,'sequence'),
        (TEXTNS,'sequence-ref'),
        (TEXTNS,'sheet-name'),
# allowed_children
        (TEXTNS,'span'),
        (TEXTNS,'subject'),
        (TEXTNS,'table-count'),
        (TEXTNS,'table-formula'),
        (TEXTNS,'template-name'),
        (TEXTNS,'text-input'),
        (TEXTNS,'time'),
        (TEXTNS,'title'),
        (TEXTNS,'user-defined'),
        (TEXTNS,'user-field-get'),
        (TEXTNS,'user-field-input'),
        (TEXTNS,'variable-get'),
        (TEXTNS,'variable-input'),
        (TEXTNS,'variable-set'),
        (TEXTNS,'word-count'),
)

# Only the elements with at least one required attribute is listed

required_attributes = {
        (ANIMNS,'animate'): (
                (SMILNS,'attributeName'),
        ),
        (ANIMNS,'animateColor'): (
                (SMILNS,'attributeName'),
        ),
        (ANIMNS,'animateMotion'): (
                (SMILNS,'attributeName'),
        ),
        (ANIMNS,'animateTransform'): (
                (SVGNS,'type'),
                (SMILNS,'attributeName'),
        ),
        (ANIMNS,'command'): (
                (ANIMNS,'command'),
        ),
        (ANIMNS,'param'): (
                (ANIMNS,'name'),
                (ANIMNS,'value'),
        ),
        (ANIMNS,'set'): (
                (SMILNS,'attributeName'),
        ),
# required_attributes
        (ANIMNS,'transitionFilter'): (
                (SMILNS,'type'),
        ),
        (CHARTNS,'axis'): (
                (CHARTNS,'dimension'),
        ),
        (CHARTNS,'chart'): (
                (CHARTNS,'class'),
        ),
        (CHARTNS,'symbol-image'): (
                (XLINKNS,'href'),
        ),
        (CONFIGNS,'config-item'): (
                (CONFIGNS,'type'),
                (CONFIGNS,'name'),
        ),
        (CONFIGNS,'config-item-map-indexed'): (
                (CONFIGNS,'name'),
        ),
        (CONFIGNS,'config-item-map-named'): (
                (CONFIGNS,'name'),
        ),
        (CONFIGNS,'config-item-set'): (
                (CONFIGNS,'name'),
        ),
# required_attributes
        (NUMBERNS,'boolean-style'): (
                (STYLENS,'name'),
        ),
        (NUMBERNS,'currency-style'): (
                (STYLENS,'name'),
        ),
        (NUMBERNS,'date-style'): (
                (STYLENS,'name'),
        ),
        (NUMBERNS,'embedded-text'): (
                (NUMBERNS,'position'),
        ),
        (NUMBERNS,'number-style'): (
                (STYLENS,'name'),
        ),
        (NUMBERNS,'percentage-style'): (
                (STYLENS,'name'),
        ),
        (NUMBERNS,'text-style'): (
                (STYLENS,'name'),
        ),
        (NUMBERNS,'time-style'): (
                (STYLENS,'name'),
        ),
        (DR3DNS,'extrude'): (
                (SVGNS,'d'),
                (SVGNS,'viewBox'),
        ),
        (DR3DNS,'light'): (
                (DR3DNS,'direction'),
        ),
        (DR3DNS,'rotate'): (
                (SVGNS,'viewBox'),
                (SVGNS,'d'),
        ),
# required_attributes
        (DRAWNS,'a'): (
                (XLINKNS,'href'),
        ),
        (DRAWNS,'area-circle'): (
                (SVGNS,'cy'),
                (SVGNS,'cx'),
                (SVGNS,'r'),
        ),
        (DRAWNS,'area-polygon'): (
                (SVGNS,'height'),
                (SVGNS,'width'),
                (DRAWNS,'points'),
                (SVGNS,'y'),
                (SVGNS,'x'),
                (SVGNS,'viewBox'),
        ),
        (DRAWNS,'area-rectangle'): (
                (SVGNS,'y'),
                (SVGNS,'x'),
                (SVGNS,'height'),
                (SVGNS,'width'),
        ),
        (DRAWNS,'contour-path'): (
                (DRAWNS,'recreate-on-edit'),
                (SVGNS,'viewBox'),
                (SVGNS,'d'),
        ),
        (DRAWNS,'contour-polygon'): (
                (DRAWNS,'points'),
                (DRAWNS,'recreate-on-edit'),
                (SVGNS,'viewBox'),
        ),
        (DRAWNS,'control'): (
                (DRAWNS,'control'),
        ),
        (DRAWNS,'fill-image'): (
                (XLINKNS,'href'),
                (DRAWNS,'name'),
        ),
        (DRAWNS,'floating-frame'): (
                (XLINKNS,'href'),
        ),
        (DRAWNS,'glue-point'): (
                (SVGNS,'y'),
                (SVGNS,'x'),
                (DRAWNS,'id'),
                (DRAWNS,'escape-direction'),
        ),
# required_attributes
        (DRAWNS,'gradient'): (
                (DRAWNS,'style'),
        ),
        (DRAWNS,'handle'): (
                (DRAWNS,'handle-position'),
        ),
        (DRAWNS,'hatch'): (
                (DRAWNS,'style'),
                (DRAWNS,'name'),
        ),
        (DRAWNS,'layer'): (
                (DRAWNS,'name'),
        ),
        (DRAWNS,'line'): (
                (SVGNS,'y1'),
                (SVGNS,'x2'),
                (SVGNS,'x1'),
                (SVGNS,'y2'),
        ),
        (DRAWNS,'marker'): (
                (SVGNS,'d'),
                (DRAWNS,'name'),
                (SVGNS,'viewBox'),
        ),
        (DRAWNS,'measure'): (
                (SVGNS,'y1'),
                (SVGNS,'x2'),
                (SVGNS,'x1'),
                (SVGNS,'y2'),
        ),
        (DRAWNS,'opacity'): (
                (DRAWNS,'style'),
        ),
        (DRAWNS,'page'): (
                (DRAWNS,'master-page-name'),
        ),
        (DRAWNS,'path'): (
                (SVGNS,'d'),
                (SVGNS,'viewBox'),
        ),
        (DRAWNS,'plugin'): (
                (XLINKNS,'href'),
        ),
        (DRAWNS,'polygon'): (
                (DRAWNS,'points'),
                (SVGNS,'viewBox'),
        ),
# required_attributes
        (DRAWNS,'polyline'): (
                (DRAWNS,'points'),
                (SVGNS,'viewBox'),
        ),
        (DRAWNS,'regular-polygon'): (
                (DRAWNS,'corners'),
        ),
        (DRAWNS,'stroke-dash'): (
                (DRAWNS,'name'),
        ),
        (FORMNS,'button'): (
                (FORMNS,'id'),
        ),
        (FORMNS,'checkbox'): (
                (FORMNS,'id'),
        ),
        (FORMNS,'combobox'): (
                (FORMNS,'id'),
        ),
        (FORMNS,'connection-resource'): (
                (XLINKNS,'href'),
        ),
        (FORMNS,'date'): (
                (FORMNS,'id'),
        ),
        (FORMNS,'file'): (
                (FORMNS,'id'),
        ),
        (FORMNS,'fixed-text'): (
                (FORMNS,'id'),
        ),
        (FORMNS,'formatted-text'): (
                (FORMNS,'id'),
        ),
        (FORMNS,'frame'): (
                (FORMNS,'id'),
        ),
        (FORMNS,'generic-control'): (
                (FORMNS,'id'),
        ),
        (FORMNS,'grid'): (
                (FORMNS,'id'),
        ),
        (FORMNS,'hidden'): (
                (FORMNS,'id'),
        ),
# required_attributes
        (FORMNS,'image'): (
                (FORMNS,'id'),
        ),
        (FORMNS,'image-frame'): (
                (FORMNS,'id'),
        ),
        (FORMNS,'list-property'): (
                (FORMNS,'property-name'),
        ),
        (FORMNS,'list-value'): (
                (OFFICENS,'string-value'),
        ),
        (FORMNS,'listbox'): (
                (FORMNS,'id'),
        ),
        (FORMNS,'number'): (
                (FORMNS,'id'),
        ),
        (FORMNS,'password'): (
                (FORMNS,'id'),
        ),
        (FORMNS,'property'): (
                (FORMNS,'property-name'),
        ),
        (FORMNS,'radio'): (
                (FORMNS,'id'),
        ),
        (FORMNS,'text'): (
                (FORMNS,'id'),
        ),
        (FORMNS,'textarea'): (
                (FORMNS,'id'),
        ),
        (FORMNS,'time'): (
                (FORMNS,'id'),
        ),
        (FORMNS,'value-range'): (
                (FORMNS,'id'),
        ),
        (MANIFESTNS,'algorithm') : (
                (MANIFESTNS,'algorithm-name'),
                (MANIFESTNS,'initialisation-vector'),
        ),
        (MANIFESTNS,'encryption-data') : (
                (MANIFESTNS,'checksum-type'),
                (MANIFESTNS,'checksum'),
        ),
        (MANIFESTNS,'file-entry') : (
                (MANIFESTNS,'full-path'),
                (MANIFESTNS,'media-type'),
        ),
        (MANIFESTNS,'key-derivation') : (
                (MANIFESTNS,'key-derivation-name'),
                (MANIFESTNS,'salt'),
                (MANIFESTNS,'iteration-count'),
        ),
# required_attributes
        (METANS,'template'): (
                (XLINKNS,'href'),
        ),
        (METANS,'user-defined'): (
                (METANS,'name'),
        ),
        (OFFICENS,'dde-source'): (
                (OFFICENS,'dde-topic'),
                (OFFICENS,'dde-application'),
                (OFFICENS,'dde-item'),
        ),
        (OFFICENS,'document'): (
                (OFFICENS,'mimetype'),
        ),
        (OFFICENS,'script'): (
                (SCRIPTNS,'language'),
        ),
        (PRESENTATIONNS,'date-time-decl'): (
                (PRESENTATIONNS,'source'),
                (PRESENTATIONNS,'name'),
        ),
        (PRESENTATIONNS,'dim'): (
                (DRAWNS,'color'),
                (DRAWNS,'shape-id'),
        ),
# required_attributes
        (PRESENTATIONNS,'event-listener'): (
                (PRESENTATIONNS,'action'),
                (SCRIPTNS,'event-name'),
        ),
        (PRESENTATIONNS,'footer-decl'): (
                (PRESENTATIONNS,'name'),
        ),
        (PRESENTATIONNS,'header-decl'): (
                (PRESENTATIONNS,'name'),
        ),
        (PRESENTATIONNS,'hide-shape'): (
                (DRAWNS,'shape-id'),
        ),
        (PRESENTATIONNS,'hide-text'): (
                (DRAWNS,'shape-id'),
        ),
        (PRESENTATIONNS,'placeholder'): (
                (SVGNS,'y'),
                (SVGNS,'x'),
                (SVGNS,'height'),
                (PRESENTATIONNS,'object'),
                (SVGNS,'width'),
        ),
        (PRESENTATIONNS,'play'): (
                (DRAWNS,'shape-id'),
        ),
        (PRESENTATIONNS,'show'): (
                (PRESENTATIONNS,'name'),
                (PRESENTATIONNS,'pages'),
        ),
        (PRESENTATIONNS,'show-shape'): (
                (DRAWNS,'shape-id'),
        ),
        (PRESENTATIONNS,'show-text'): (
                (DRAWNS,'shape-id'),
        ),
        (PRESENTATIONNS,'sound'): (
                (XLINKNS,'href'),
        ),
        (SCRIPTNS,'event-listener'): (
                (SCRIPTNS,'language'),
                (SCRIPTNS,'event-name'),
        ),
        (STYLENS,'column'): (
                (STYLENS,'rel-width'),
        ),
# required_attributes
        (STYLENS,'column-sep'): (
                (STYLENS,'width'),
        ),
        (STYLENS,'columns'): (
                (FONS,'column-count'),
        ),
        (STYLENS,'font-face'): (
                (STYLENS,'name'),
        ),
        (STYLENS,'handout-master'): (
                (STYLENS,'page-layout-name'),
        ),
        (STYLENS,'map'): (
                (STYLENS,'apply-style-name'),
                (STYLENS,'condition'),
        ),
        (STYLENS,'master-page'): (
                (STYLENS,'page-layout-name'),
                (STYLENS,'name'),
        ),
        (STYLENS,'page-layout'): (
                (STYLENS,'name'),
        ),
        (STYLENS,'presentation-page-layout'): (
                (STYLENS,'name'),
        ),
        (STYLENS,'style'): (
                (STYLENS,'name'),
        ),
        (STYLENS,'tab-stop'): (
                (STYLENS,'position'),
        ),
        (SVGNS,'definition-src'): (
                (XLINKNS,'href'),
        ),
        (SVGNS,'font-face-uri'): (
                (XLINKNS,'href'),
        ),
        (SVGNS,'linearGradient'): (
                (DRAWNS,'name'),
        ),
        (SVGNS,'radialGradient'): (
                (DRAWNS,'name'),
        ),
        (SVGNS,'stop'): (
                (SVGNS,'offset'),
        ),
# required_attributes
        (TABLENS,'body'): (
                (TEXTNS,'style-name'),
        ),
        (TABLENS,'cell-address'): (
                (TABLENS,'column'),
                (TABLENS,'table'),
                (TABLENS,'row'),
        ),
        (TABLENS,'cell-content-change'): (
                (TABLENS,'id'),
        ),
        (TABLENS,'cell-range-source'): (
                (TABLENS,'last-row-spanned'),
                (TABLENS,'last-column-spanned'),
                (XLINKNS,'href'),
                (TABLENS,'name'),
        ),
        (TABLENS,'consolidation'): (
                (TABLENS,'function'),
                (TABLENS,'source-cell-range-addresses'),
                (TABLENS,'target-cell-address'),
        ),
        (TABLENS,'content-validation'): (
                (TABLENS,'name'),
        ),
        (TABLENS,'data-pilot-display-info'): (
                (TABLENS,'member-count'),
                (TABLENS,'data-field'),
                (TABLENS,'enabled'),
                (TABLENS,'display-member-mode'),
        ),
# required_attributes
        (TABLENS,'data-pilot-field'): (
                (TABLENS,'source-field-name'),
        ),
        (TABLENS,'data-pilot-field-reference'): (
                (TABLENS,'field-name'),
                (TABLENS,'type'),
        ),
        (TABLENS,'data-pilot-group'): (
                (TABLENS,'name'),
        ),
        (TABLENS,'data-pilot-group-member'): (
                (TABLENS,'name'),
        ),
        (TABLENS,'data-pilot-groups'): (
                (TABLENS,'source-field-name'),
                (TABLENS,'step'),
                (TABLENS,'grouped-by'),
        ),
        (TABLENS,'data-pilot-layout-info'): (
                (TABLENS,'add-empty-lines'),
                (TABLENS,'layout-mode'),
        ),
        (TABLENS,'data-pilot-member'): (
                (TABLENS,'name'),
        ),
        (TABLENS,'data-pilot-sort-info'): (
                (TABLENS,'order'),
        ),
        (TABLENS,'data-pilot-subtotal'): (
                (TABLENS,'function'),
        ),
        (TABLENS,'data-pilot-table'): (
                (TABLENS,'target-range-address'),
                (TABLENS,'name'),
        ),
        (TABLENS,'database-range'): (
                (TABLENS,'target-range-address'),
        ),
# required_attributes
        (TABLENS,'database-source-query'): (
                (TABLENS,'query-name'),
                (TABLENS,'database-name'),
        ),
        (TABLENS,'database-source-sql'): (
                (TABLENS,'database-name'),
                (TABLENS,'sql-statement'),
        ),
        (TABLENS,'database-source-table'): (
                (TABLENS,'database-table-name'),
                (TABLENS,'database-name'),
        ),
        (TABLENS,'deletion'): (
                (TABLENS,'position'),
                (TABLENS,'type'),
                (TABLENS,'id'),
        ),
        (TABLENS,'dependency'): (
                (TABLENS,'id'),
        ),
        (TABLENS,'even-columns'): (
                (TEXTNS,'style-name'),
        ),
        (TABLENS,'even-rows'): (
                (TEXTNS,'style-name'),
        ),
        (TABLENS,'filter-condition'): (
                (TABLENS,'operator'),
                (TABLENS,'field-number'),
                (TABLENS,'value'),
        ),
        (TABLENS,'first-column'): (
                (TEXTNS,'style-name'),
        ),
        (TABLENS,'first-row'): (
                (TEXTNS,'style-name'),
        ),
        (TABLENS,'insertion'): (
                (TABLENS,'position'),
                (TABLENS,'type'),
                (TABLENS,'id'),
        ),
        (TABLENS,'insertion-cut-off'): (
                (TABLENS,'position'),
                (TABLENS,'id'),
        ),
# required_attributes
        (TABLENS,'label-range'): (
                (TABLENS,'label-cell-range-address'),
                (TABLENS,'data-cell-range-address'),
                (TABLENS,'orientation'),
        ),
        (TABLENS,'last-column'): (
                (TEXTNS,'style-name'),
        ),
        (TABLENS,'last-row'): (
                (TEXTNS,'style-name'),
        ),
        (TABLENS,'movement'): (
                (TABLENS,'id'),
        ),
        (TABLENS,'named-expression'): (
                (TABLENS,'expression'),
                (TABLENS,'name'),
        ),
        (TABLENS,'named-range'): (
                (TABLENS,'name'),
                (TABLENS,'cell-range-address'),
        ),
        (TABLENS,'odd-columns'): (
                (TEXTNS,'style-name'),
        ),
        (TABLENS,'odd-rows'): (
                (TEXTNS,'style-name'),
        ),
        (TABLENS,'operation'): (
                (TABLENS,'index'),
                (TABLENS,'name'),
        ),
# required_attributes
        (TABLENS,'scenario'): (
                (TABLENS,'is-active'),
                (TABLENS,'scenario-ranges'),
        ),
        (TABLENS,'sort-by'): (
                (TABLENS,'field-number'),
        ),
        (TABLENS,'source-cell-range'): (
                (TABLENS,'cell-range-address'),
        ),
        (TABLENS,'source-service'): (
                (TABLENS,'source-name'),
                (TABLENS,'object-name'),
                (TABLENS,'name'),
        ),
        (TABLENS,'subtotal-field'): (
                (TABLENS,'function'),
                (TABLENS,'field-number'),
        ),
        (TABLENS,'subtotal-rule'): (
                (TABLENS,'group-by-field-number'),
        ),
        (TABLENS,'table-source'): (
                (XLINKNS,'href'),
        ),
        (TABLENS,'table-template'): (
                (TEXTNS,'last-row-end-column'),
                (TEXTNS,'first-row-end-column'),
                (TEXTNS,'name'),
                (TEXTNS,'last-row-start-column'),
                (TEXTNS,'first-row-start-column'),
        ),
        (TEXTNS,'a'): (
                (XLINKNS,'href'),
        ),
# required_attributes
        (TEXTNS,'alphabetical-index'): (
                (TEXTNS,'name'),
        ),
        (TEXTNS,'alphabetical-index-auto-mark-file'): (
                (XLINKNS,'href'),
        ),
        (TEXTNS,'alphabetical-index-entry-template'): (
                (TEXTNS,'style-name'),
                (TEXTNS,'outline-level'),
        ),
        (TEXTNS,'alphabetical-index-mark'): (
                (TEXTNS,'string-value'),
        ),
        (TEXTNS,'alphabetical-index-mark-end'): (
                (TEXTNS,'id'),
        ),
        (TEXTNS,'alphabetical-index-mark-start'): (
                (TEXTNS,'id'),
        ),
        (TEXTNS,'bibliography'): (
                (TEXTNS,'name'),
        ),
        (TEXTNS,'bibliography-entry-template'): (
                (TEXTNS,'style-name'),
                (TEXTNS,'bibliography-type'),
        ),
        (TEXTNS,'bibliography-mark'): (
                (TEXTNS,'bibliography-type'),
        ),
        (TEXTNS,'bookmark'): (
                (TEXTNS,'name'),
        ),
# required_attributes
        (TEXTNS,'bookmark-end'): (
                (TEXTNS,'name'),
        ),
        (TEXTNS,'bookmark-start'): (
                (TEXTNS,'name'),
        ),
        (TEXTNS,'change'): (
                (TEXTNS,'change-id'),
        ),
        (TEXTNS,'change-end'): (
                (TEXTNS,'change-id'),
        ),
        (TEXTNS,'change-start'): (
                (TEXTNS,'change-id'),
        ),
        (TEXTNS,'changed-region'): (
                (TEXTNS,'id'),
        ),
        (TEXTNS,'chapter'): (
                (TEXTNS,'display'),
                (TEXTNS,'outline-level'),
        ),
        (TEXTNS,'conditional-text'): (
                (TEXTNS,'string-value-if-true'),
                (TEXTNS,'string-value-if-false'),
                (TEXTNS,'condition'),
        ),
        (TEXTNS,'database-display'): (
                (TEXTNS,'column-name'),
                (TEXTNS,'table-name'),
        ),
        (TEXTNS,'database-name'): (
                (TEXTNS,'table-name'),
        ),
        (TEXTNS,'database-next'): (
                (TEXTNS,'table-name'),
        ),
        (TEXTNS,'database-row-number'): (
                (TEXTNS,'table-name'),
        ),
        (TEXTNS,'database-row-select'): (
                (TEXTNS,'table-name'),
        ),
        (TEXTNS,'dde-connection'): (
                (TEXTNS,'connection-name'),
        ),
# required_attributes
        (TEXTNS,'dde-connection-decl'): (
                (OFFICENS,'dde-topic'),
                (OFFICENS,'dde-application'),
                (OFFICENS,'name'),
                (OFFICENS,'dde-item'),
        ),
        (TEXTNS,'h'): (
                (TEXTNS,'outline-level'),
        ),
        (TEXTNS,'hidden-paragraph'): (
                (TEXTNS,'condition'),
        ),
        (TEXTNS,'hidden-text'): (
                (TEXTNS,'string-value'),
                (TEXTNS,'condition'),
        ),
        (TEXTNS,'illustration-index'): (
                (TEXTNS,'name'),
        ),
        (TEXTNS,'illustration-index-entry-template'): (
                (TEXTNS,'style-name'),
        ),
        (TEXTNS,'index-entry-bibliography'): (
                (TEXTNS,'bibliography-data-field'),
        ),
        (TEXTNS,'index-source-style'): (
                (TEXTNS,'style-name'),
        ),
        (TEXTNS,'index-source-styles'): (
                (TEXTNS,'outline-level'),
        ),
        (TEXTNS,'index-title'): (
                (TEXTNS,'name'),
        ),
        (TEXTNS,'list-level-style-bullet'): (
                (TEXTNS,'bullet-char'),
                (TEXTNS,'level'),
        ),
        (TEXTNS,'list-level-style-image'): (
                (TEXTNS,'level'),
        ),
        (TEXTNS,'list-level-style-number'): (
                (TEXTNS,'level'),
        ),
        (TEXTNS,'list-style'): (
                (STYLENS,'name'),
        ),
# required_attributes
        (TEXTNS,'measure'): (
                (TEXTNS,'kind'),
        ),
        (TEXTNS,'note'): (
                (TEXTNS,'note-class'),
        ),
        (TEXTNS,'note-ref'): (
                (TEXTNS,'note-class'),
        ),
        (TEXTNS,'notes-configuration'): (
                (TEXTNS,'note-class'),
        ),
        (TEXTNS,'object-index'): (
                (TEXTNS,'name'),
        ),
        (TEXTNS,'object-index-entry-template'): (
                (TEXTNS,'style-name'),
        ),
        (TEXTNS,'outline-level-style'): (
                (TEXTNS,'level'),
        ),
        (TEXTNS,'page'): (
                (TEXTNS,'master-page-name'),
        ),
        (TEXTNS,'page-continuation'): (
                (TEXTNS,'select-page'),
        ),
        (TEXTNS,'placeholder'): (
                (TEXTNS,'placeholder-type'),
        ),
        (TEXTNS,'reference-mark'): (
                (TEXTNS,'name'),
        ),
        (TEXTNS,'reference-mark-end'): (
                (TEXTNS,'name'),
        ),
        (TEXTNS,'reference-mark-start'): (
                (TEXTNS,'name'),
        ),
        (TEXTNS,'section'): (
                (TEXTNS,'name'),
        ),
        (TEXTNS,'sequence'): (
                (TEXTNS,'name'),
        ),
        (TEXTNS,'sequence-decl'): (
                (TEXTNS,'display-outline-level'),
                (TEXTNS,'name'),
        ),
# required_attributes
        (TEXTNS,'sort-key'): (
                (TEXTNS,'key'),
        ),
        (TEXTNS,'table-index'): (
                (TEXTNS,'name'),
        ),
        (TEXTNS,'table-index-entry-template'): (
                (TEXTNS,'style-name'),
        ),
        (TEXTNS,'table-of-content'): (
                (TEXTNS,'name'),
        ),
        (TEXTNS,'table-of-content-entry-template'): (
                (TEXTNS,'style-name'),
                (TEXTNS,'outline-level'),
        ),
        (TEXTNS,'toc-mark'): (
                (TEXTNS,'string-value'),
        ),
        (TEXTNS,'toc-mark-end'): (
                (TEXTNS,'id'),
        ),
        (TEXTNS,'toc-mark-start'): (
                (TEXTNS,'id'),
        ),
        (TEXTNS,'user-defined'): (
                (TEXTNS,'name'),
        ),
        (TEXTNS,'user-field-decl'): (
                (TEXTNS,'name'),
        ),
        (TEXTNS,'user-field-get'): (
                (TEXTNS,'name'),
        ),
        (TEXTNS,'user-field-input'): (
                (TEXTNS,'name'),
        ),
        (TEXTNS,'user-index'): (
                (TEXTNS,'name'),
        ),
        (TEXTNS,'user-index-entry-template'): (
                (TEXTNS,'style-name'),
                (TEXTNS,'outline-level'),
        ),
# required_attributes
        (TEXTNS,'user-index-mark'): (
                (TEXTNS,'index-name'),
                (TEXTNS,'string-value'),
        ),
        (TEXTNS,'user-index-mark-end'): (
                (TEXTNS,'id'),
        ),
        (TEXTNS,'user-index-mark-start'): (
                (TEXTNS,'index-name'),
                (TEXTNS,'id'),
        ),
        (TEXTNS,'user-index-source'): (
                (TEXTNS,'index-name'),
        ),
        (TEXTNS,'variable-decl'): (
                (TEXTNS,'name'),
                (OFFICENS,'value-type'),
        ),
        (TEXTNS,'variable-get'): (
                (TEXTNS,'name'),
        ),
        (TEXTNS,'variable-input'): (
                (TEXTNS,'name'),
                (OFFICENS,'value-type'),
        ),
        (TEXTNS,'variable-set'): (
                (TEXTNS,'name'),
        ),
}

# Empty list means the element has no allowed attributes
# None means anything goes

allowed_attributes = {
        (DCNS,'creator'):(
        ),
        (DCNS,'date'):(
        ),
        (DCNS,'description'):(
        ),
        (DCNS,'language'):(
        ),
        (DCNS,'subject'):(
        ),
        (DCNS,'title'):(
        ),
# Completes Dublin Core start
#       (DCNS,'contributor') : (
#       ),
#       (DCNS,'coverage') : (
#       ),
#       (DCNS,'format') : (
#       ),
#       (DCNS,'identifier') : (
#       ),
#       (DCNS,'publisher') : (
#       ),
#       (DCNS,'relation') : (
#       ),
#       (DCNS,'rights') : (
#       ),
#       (DCNS,'source') : (
#       ),
#       (DCNS,'type') : (
#       ),
# Completes Dublin Core end
        (MATHNS,'math'): None,
        (XFORMSNS,'model'): None,
# allowed_attributes
        (ANIMNS,'animate'):(
                (ANIMNS,'formula'),
                (ANIMNS,'sub-item'),
                (SMILNS,'accelerate'),
                (SMILNS,'accumulate'),
                (SMILNS,'additive'),
                (SMILNS,'attributeName'),
                (SMILNS,'autoReverse'),
                (SMILNS,'begin'),
                (SMILNS,'by'),
                (SMILNS,'calcMode'),
                (SMILNS,'decelerate'),
                (SMILNS,'dur'),
                (SMILNS,'end'),
                (SMILNS,'fill'),
                (SMILNS,'fillDefault'),
                (SMILNS,'from'),
                (SMILNS,'keySplines'),
                (SMILNS,'keyTimes'),
                (SMILNS,'repeatCount'),
                (SMILNS,'repeatDur'),
                (SMILNS,'restart'),
                (SMILNS,'restartDefault'),
                (SMILNS,'targetElement'),
                (SMILNS,'to'),
                (SMILNS,'values'),
        ),
# allowed_attributes
        (ANIMNS,'animateColor'):(
                (ANIMNS,'color-interpolation'),
                (ANIMNS,'color-interpolation-direction'),
                (ANIMNS,'formula'),
                (ANIMNS,'sub-item'),
                (SMILNS,'accelerate'),
                (SMILNS,'accumulate'),
                (SMILNS,'additive'),
                (SMILNS,'attributeName'),
                (SMILNS,'autoReverse'),
                (SMILNS,'begin'),
                (SMILNS,'by'),
                (SMILNS,'calcMode'),
                (SMILNS,'decelerate'),
                (SMILNS,'dur'),
                (SMILNS,'end'),
                (SMILNS,'fill'),
                (SMILNS,'fillDefault'),
                (SMILNS,'from'),
                (SMILNS,'keySplines'),
                (SMILNS,'keyTimes'),
                (SMILNS,'repeatCount'),
                (SMILNS,'repeatDur'),
                (SMILNS,'restart'),
                (SMILNS,'restartDefault'),
                (SMILNS,'targetElement'),
                (SMILNS,'to'),
                (SMILNS,'values'),
        ),
# allowed_attributes
        (ANIMNS,'animateMotion'):(
                (ANIMNS,'formula'),
                (ANIMNS,'sub-item'),
                (SMILNS,'accelerate'),
                (SMILNS,'accumulate'),
                (SMILNS,'additive'),
                (SMILNS,'attributeName'),
                (SMILNS,'autoReverse'),
                (SMILNS,'begin'),
                (SMILNS,'by'),
                (SMILNS,'calcMode'),
                (SMILNS,'decelerate'),
                (SMILNS,'dur'),
                (SMILNS,'end'),
                (SMILNS,'fill'),
                (SMILNS,'fillDefault'),
                (SMILNS,'from'),
                (SMILNS,'keySplines'),
                (SMILNS,'keyTimes'),
                (SMILNS,'repeatCount'),
                (SMILNS,'repeatDur'),
                (SMILNS,'restart'),
                (SMILNS,'restartDefault'),
                (SMILNS,'targetElement'),
                (SMILNS,'to'),
                (SMILNS,'values'),
                (SVGNS,'origin'),
                (SVGNS,'path'),
        ),
# allowed_attributes
        (ANIMNS,'animateTransform'):(
                (ANIMNS,'formula'),
                (ANIMNS,'sub-item'),
                (SMILNS,'accelerate'),
                (SMILNS,'accumulate'),
                (SMILNS,'additive'),
                (SMILNS,'attributeName'),
                (SMILNS,'autoReverse'),
                (SMILNS,'begin'),
                (SMILNS,'by'),
                (SMILNS,'decelerate'),
                (SMILNS,'dur'),
                (SMILNS,'end'),
                (SMILNS,'fill'),
                (SMILNS,'fillDefault'),
                (SMILNS,'from'),
                (SMILNS,'repeatCount'),
                (SMILNS,'repeatDur'),
                (SMILNS,'restart'),
                (SMILNS,'restartDefault'),
                (SMILNS,'targetElement'),
                (SMILNS,'to'),
                (SMILNS,'values'),
                (SVGNS,'type'),
        ),
# allowed_attributes
        (ANIMNS,'audio'):(
                (ANIMNS,'audio-level'),
                (ANIMNS,'id'),
                (PRESENTATIONNS,'group-id'),
                (PRESENTATIONNS,'master-element'),
                (PRESENTATIONNS,'node-type'),
                (PRESENTATIONNS,'preset-class'),
                (PRESENTATIONNS,'preset-id'),
                (PRESENTATIONNS,'preset-sub-type'),
                (SMILNS,'begin'),
                (SMILNS,'dur'),
                (SMILNS,'end'),
                (SMILNS,'repeatCount'),
                (SMILNS,'repeatDur'),
                (XLINKNS,'href'),
        ),
        (ANIMNS,'command'):(
                (PRESENTATIONNS,'node-type'),
                (SMILNS,'begin'),
                (SMILNS,'end'),
                (PRESENTATIONNS,'group-id'),
                (PRESENTATIONNS,'preset-class'),
                (PRESENTATIONNS,'preset-id'),
                (ANIMNS,'sub-item'),
                (ANIMNS,'command'),
                (PRESENTATIONNS,'preset-sub-type'),
                (SMILNS,'targetElement'),
                (ANIMNS,'id'),
                (PRESENTATIONNS,'master-element'),
        ),
# allowed_attributes
        (ANIMNS,'iterate'):(
                (ANIMNS,'id'),
                (ANIMNS,'iterate-interval'),
                (ANIMNS,'iterate-type'),
                (ANIMNS,'sub-item'),
                (PRESENTATIONNS,'group-id'),
                (PRESENTATIONNS,'master-element'),
                (PRESENTATIONNS,'node-type'),
                (PRESENTATIONNS,'preset-class'),
                (PRESENTATIONNS,'preset-id'),
                (PRESENTATIONNS,'preset-sub-type'),
                (SMILNS,'accelerate'),
                (SMILNS,'autoReverse'),
                (SMILNS,'begin'),
                (SMILNS,'decelerate'),
                (SMILNS,'dur'),
                (SMILNS,'end'),
                (SMILNS,'endsync'),
                (SMILNS,'fill'),
                (SMILNS,'fillDefault'),
                (SMILNS,'repeatCount'),
                (SMILNS,'repeatDur'),
                (SMILNS,'restart'),
                (SMILNS,'restartDefault'),
                (SMILNS,'targetElement'),
        ),
        (ANIMNS,'par'):(
                (PRESENTATIONNS,'node-type'),
                (SMILNS,'decelerate'),
                (SMILNS,'begin'),
                (SMILNS,'end'),
                (PRESENTATIONNS,'group-id'),
                (SMILNS,'accelerate'),
                (SMILNS,'repeatDur'),
                (SMILNS,'repeatCount'),
                (SMILNS,'autoReverse'),
                (PRESENTATIONNS,'preset-class'),
                (SMILNS,'fillDefault'),
                (PRESENTATIONNS,'preset-id'),
                (PRESENTATIONNS,'preset-sub-type'),
                (SMILNS,'restartDefault'),
                (SMILNS,'endsync'),
                (SMILNS,'dur'),
                (SMILNS,'fill'),
                (ANIMNS,'id'),
                (SMILNS,'restart'),
                (PRESENTATIONNS,'master-element'),
        ),
# allowed_attributes
        (ANIMNS,'param'):(
                (ANIMNS,'name'),
                (ANIMNS,'value'),
        ),
        (ANIMNS,'seq'):(
                (ANIMNS,'id'),
                (PRESENTATIONNS,'group-id'),
                (PRESENTATIONNS,'master-element'),
                (PRESENTATIONNS,'node-type'),
                (PRESENTATIONNS,'preset-class'),
                (PRESENTATIONNS,'preset-id'),
                (PRESENTATIONNS,'preset-sub-type'),
                (SMILNS,'accelerate'),
                (SMILNS,'autoReverse'),
                (SMILNS,'begin'),
                (SMILNS,'decelerate'),
                (SMILNS,'dur'),
                (SMILNS,'end'),
                (SMILNS,'endsync'),
                (SMILNS,'fill'),
                (SMILNS,'fillDefault'),
                (SMILNS,'repeatCount'),
                (SMILNS,'repeatDur'),
                (SMILNS,'restart'),
                (SMILNS,'restartDefault'),
        ),
        (ANIMNS,'set'):(
                (ANIMNS,'sub-item'),
                (SMILNS,'accelerate'),
                (SMILNS,'accumulate'),
                (SMILNS,'autoReverse'),
                (SMILNS,'additive'),
                (SMILNS,'attributeName'),
                (SMILNS,'begin'),
                (SMILNS,'decelerate'),
                (SMILNS,'dur'),
                (SMILNS,'end'),
                (SMILNS,'fill'),
                (SMILNS,'fillDefault'),
                (SMILNS,'repeatCount'),
                (SMILNS,'repeatDur'),
                (SMILNS,'restart'),
                (SMILNS,'restartDefault'),
                (SMILNS,'targetElement'),
                (SMILNS,'to'),

        ),
# allowed_attributes
        (ANIMNS,'transitionFilter'):(
                (ANIMNS,'formula'),
                (ANIMNS,'sub-item'),
                (SMILNS,'accelerate'),
                (SMILNS,'accumulate'),
                (SMILNS,'additive'),
                (SMILNS,'autoReverse'),
                (SMILNS,'begin'),
                (SMILNS,'by'),
                (SMILNS,'calcMode'),
                (SMILNS,'decelerate'),
                (SMILNS,'direction'),
                (SMILNS,'dur'),
                (SMILNS,'end'),
                (SMILNS,'fadeColor'),
                (SMILNS,'fill'),
                (SMILNS,'fillDefault'),
                (SMILNS,'from'),
                (SMILNS,'mode'),
                (SMILNS,'repeatCount'),
                (SMILNS,'repeatDur'),
                (SMILNS,'restart'),
                (SMILNS,'restartDefault'),
                (SMILNS,'subtype'),
                (SMILNS,'targetElement'),
                (SMILNS,'to'),
                (SMILNS,'type'),
                (SMILNS,'values'),

        ),
# allowed_attributes
        (CHARTNS,'axis'):(
                (CHARTNS,'style-name'),
                (CHARTNS,'dimension'),
                (CHARTNS,'name'),
        ),
        (CHARTNS,'categories'):(
                (TABLENS,'cell-range-address'),
        ),
        (CHARTNS,'chart'):(
                (CHARTNS,'column-mapping'),
                (CHARTNS,'row-mapping'),
                (SVGNS,'height'),
                (SVGNS,'width'),
                (CHARTNS,'style-name'),
                (CHARTNS,'class'),
        ),
        (CHARTNS,'data-point'):(
                (CHARTNS,'repeated'),
                (CHARTNS,'style-name'),
        ),
        (CHARTNS,'domain'):(
                (TABLENS,'cell-range-address'),
        ),
        (CHARTNS,'error-indicator'):(
                (CHARTNS,'style-name'),
        ),
        (CHARTNS,'floor'):(
                (SVGNS,'width'),
                (CHARTNS,'style-name'),
        ),
# allowed_attributes
        (CHARTNS,'footer'):(
                (SVGNS,'y'),
                (SVGNS,'x'),
                (TABLENS,'cell-range'),
                (CHARTNS,'style-name'),
        ),
        (CHARTNS,'grid'):(
                (CHARTNS,'style-name'),
                (CHARTNS,'class'),
        ),
        (CHARTNS,'legend'):(
                (CHARTNS,'legend-align'),
                (STYLENS,'legend-expansion-aspect-ratio'),
                (STYLENS,'legend-expansion'),
                (CHARTNS,'legend-position'),
                (CHARTNS,'style-name'),
                (SVGNS,'y'),
                (SVGNS,'x'),
        ),
        (CHARTNS,'mean-value'):(
                (CHARTNS,'style-name'),
        ),
        (CHARTNS,'plot-area'):(
                (DR3DNS,'ambient-color'),
                (DR3DNS,'distance'),
                (DR3DNS,'vrp'),
                (DR3DNS,'focal-length'),
                (CHARTNS,'data-source-has-labels'),
                (DR3DNS,'lighting-mode'),
                (DR3DNS,'shade-mode'),
                (DR3DNS,'transform'),
                (DR3DNS,'shadow-slant'),
                (SVGNS,'height'),
                (SVGNS,'width'),
                (CHARTNS,'style-name'),
                (DR3DNS,'vup'),
                (SVGNS,'y'),
                (SVGNS,'x'),
                (DR3DNS,'vpn'),
                (TABLENS,'cell-range-address'),
                (DR3DNS,'projection'),
        ),
        (CHARTNS,'regression-curve'):(
                (CHARTNS,'style-name'),
        ),
        (CHARTNS,'series'):(
                (CHARTNS,'style-name'),
                (CHARTNS,'attached-axis'),
                (CHARTNS,'values-cell-range-address'),
                (CHARTNS,'label-cell-address'),
                (CHARTNS,'class'),
        ),
        (CHARTNS,'stock-gain-marker'):(
                (CHARTNS,'style-name'),
        ),
# allowed_attributes
        (CHARTNS,'stock-loss-marker'):(
                (CHARTNS,'style-name'),
        ),
        (CHARTNS,'stock-range-line'):(
                (CHARTNS,'style-name'),
        ),
        (CHARTNS,'subtitle'):(
                (SVGNS,'y'),
                (SVGNS,'x'),
                (TABLENS,'cell-range'),
                (CHARTNS,'style-name'),
        ),
        (CHARTNS,'symbol-image'):(
                (XLINKNS,'href'),
        ),
        (CHARTNS,'title'):(
                (SVGNS,'y'),
                (SVGNS,'x'),
                (TABLENS,'cell-range'),
                (CHARTNS,'style-name'),
        ),
        (CHARTNS,'wall'):(
                (SVGNS,'width'),
                (CHARTNS,'style-name'),
        ),
        (CONFIGNS,'config-item'):(
                (CONFIGNS,'type'),
                (CONFIGNS,'name'),
        ),
        (CONFIGNS,'config-item-map-entry'):(
                (CONFIGNS,'name'),
        ),
        (CONFIGNS,'config-item-map-indexed'):(
                (CONFIGNS,'name'),
        ),
        (CONFIGNS,'config-item-map-named'):(
                (CONFIGNS,'name'),
        ),
        (CONFIGNS,'config-item-set'):(
                (CONFIGNS,'name'),
        ),
# allowed_attributes
        (NUMBERNS,'am-pm'):(
        ),
        (NUMBERNS,'boolean'):(
        ),
        (NUMBERNS,'boolean-style'):(
                (NUMBERNS,'transliteration-language'),
                (STYLENS,'name'),
                (STYLENS,'display-name'),
                (NUMBERNS,'language'),
                (NUMBERNS,'title'),
                (NUMBERNS,'country'),
                (NUMBERNS,'transliteration-format'),
                (NUMBERNS,'transliteration-style'),
                (STYLENS,'volatile'),
                (NUMBERNS,'transliteration-country'),
        ),
        (NUMBERNS,'currency-style'):(
                (NUMBERNS,'transliteration-language'),
                (STYLENS,'name'),
                (STYLENS,'display-name'),
                (NUMBERNS,'language'),
                (NUMBERNS,'title'),
                (NUMBERNS,'country'),
                (NUMBERNS,'transliteration-format'),
                (NUMBERNS,'transliteration-style'),
                (STYLENS,'volatile'),
                (NUMBERNS,'transliteration-country'),
                (NUMBERNS,'automatic-order'),
        ),
        (NUMBERNS,'currency-symbol'):(
                (NUMBERNS,'country'),
                (NUMBERNS,'language'),
        ),
# allowed_attributes
        (NUMBERNS,'date-style'):(
                (NUMBERNS,'transliteration-language'),
                (STYLENS,'name'),
                (STYLENS,'display-name'),
                (NUMBERNS,'language'),
                (NUMBERNS,'title'),
                (NUMBERNS,'country'),
                (NUMBERNS,'transliteration-format'),
                (NUMBERNS,'transliteration-style'),
                (NUMBERNS,'format-source'),
                (STYLENS,'volatile'),
                (NUMBERNS,'transliteration-country'),
                (NUMBERNS,'automatic-order'),
        ),
        (NUMBERNS,'day'):(
                (NUMBERNS,'style'),
                (NUMBERNS,'calendar'),
        ),
        (NUMBERNS,'day-of-week'):(
                (NUMBERNS,'style'),
                (NUMBERNS,'calendar'),
        ),
        (NUMBERNS,'embedded-text'):(
                (NUMBERNS,'position'),
        ),
        (NUMBERNS,'era'):(
                (NUMBERNS,'style'),
                (NUMBERNS,'calendar'),
        ),
        (NUMBERNS,'fraction'):(
                (NUMBERNS,'grouping'),
                (NUMBERNS,'min-denominator-digits'),
                (NUMBERNS,'min-numerator-digits'),
                (NUMBERNS,'min-integer-digits'),
                (NUMBERNS,'denominator-value'),
        ),
        (NUMBERNS,'hours'):(
                (NUMBERNS,'style'),
        ),
# allowed_attributes
        (NUMBERNS,'minutes'):(
                (NUMBERNS,'style'),
        ),
        (NUMBERNS,'month'):(
                (NUMBERNS,'style'),
                (NUMBERNS,'calendar'),
                (NUMBERNS,'possessive-form'),
                (NUMBERNS,'textual'),
        ),
        (NUMBERNS,'number'):(
                (NUMBERNS,'display-factor'),
                (NUMBERNS,'decimal-places'),
                (NUMBERNS,'decimal-replacement'),
                (NUMBERNS,'min-integer-digits'),
                (NUMBERNS,'grouping'),
        ),
        (NUMBERNS,'number-style'):(
                (NUMBERNS,'transliteration-language'),
                (STYLENS,'name'),
                (STYLENS,'display-name'),
                (NUMBERNS,'language'),
                (NUMBERNS,'title'),
                (NUMBERNS,'country'),
                (NUMBERNS,'transliteration-format'),
                (NUMBERNS,'transliteration-style'),
                (STYLENS,'volatile'),
                (NUMBERNS,'transliteration-country'),
        ),
# allowed_attributes
        (NUMBERNS,'percentage-style'):(
                (NUMBERNS,'transliteration-language'),
                (STYLENS,'name'),
                (STYLENS,'display-name'),
                (NUMBERNS,'language'),
                (NUMBERNS,'title'),
                (NUMBERNS,'country'),
                (NUMBERNS,'transliteration-format'),
                (NUMBERNS,'transliteration-style'),
                (STYLENS,'volatile'),
                (NUMBERNS,'transliteration-country'),
        ),
        (NUMBERNS,'quarter'):(
                (NUMBERNS,'style'),
                (NUMBERNS,'calendar'),
        ),
        (NUMBERNS,'scientific-number'):(
                (NUMBERNS,'min-exponent-digits'),
                (NUMBERNS,'decimal-places'),
                (NUMBERNS,'min-integer-digits'),
                (NUMBERNS,'grouping'),
        ),
        (NUMBERNS,'seconds'):(
                (NUMBERNS,'style'),
                (NUMBERNS,'decimal-places'),
        ),
        (NUMBERNS,'text'):(
        ),
        (NUMBERNS,'text-content'):(
        ),
        (NUMBERNS,'text-style'):(
                (NUMBERNS,'transliteration-language'),
                (STYLENS,'name'),
                (STYLENS,'display-name'),
                (NUMBERNS,'language'),
                (NUMBERNS,'title'),
                (NUMBERNS,'country'),
                (NUMBERNS,'transliteration-format'),
                (NUMBERNS,'transliteration-style'),
                (STYLENS,'volatile'),
                (NUMBERNS,'transliteration-country'),
        ),
        (NUMBERNS,'time-style'):(
                (NUMBERNS,'transliteration-language'),
                (NUMBERNS,'transliteration-format'),
                (STYLENS,'name'),
                (STYLENS,'display-name'),
                (NUMBERNS,'language'),
                (NUMBERNS,'title'),
                (NUMBERNS,'country'),
                (NUMBERNS,'truncate-on-overflow'),
                (NUMBERNS,'transliteration-style'),
                (NUMBERNS,'format-source'),
                (STYLENS,'volatile'),
                (NUMBERNS,'transliteration-country'),
        ),
        (NUMBERNS,'week-of-year'):(
                (NUMBERNS,'calendar'),
        ),
        (NUMBERNS,'year'):(
                (NUMBERNS,'style'),
                (NUMBERNS,'calendar'),
        ),
        (DR3DNS,'cube'):(
                (DR3DNS,'min-edge'),
                (DR3DNS,'max-edge'),
                (DRAWNS,'layer'),
                (DR3DNS,'transform'),
                (DRAWNS,'z-index'),
                (DRAWNS,'class-names'),
                (DRAWNS,'style-name'),
                (PRESENTATIONNS,'style-name'),
                (PRESENTATIONNS,'class-names'),
                (DRAWNS,'id'),
        ),
        (DR3DNS,'extrude'):(
                (DRAWNS,'layer'),
                (SVGNS,'d'),
                (DR3DNS,'transform'),
                (SVGNS,'viewBox'),
                (DRAWNS,'z-index'),
                (DRAWNS,'class-names'),
                (DRAWNS,'style-name'),
                (PRESENTATIONNS,'style-name'),
                (PRESENTATIONNS,'class-names'),
                (DRAWNS,'id'),
        ),
        (DR3DNS,'light'):(
                (DR3DNS,'diffuse-color'),
                (DR3DNS,'direction'),
                (DR3DNS,'specular'),
                (DR3DNS,'enabled'),
        ),
        (DR3DNS,'rotate'):(
                (DRAWNS,'layer'),
                (SVGNS,'d'),
                (DR3DNS,'transform'),
                (SVGNS,'viewBox'),
                (DRAWNS,'z-index'),
                (DRAWNS,'class-names'),
                (DRAWNS,'style-name'),
                (PRESENTATIONNS,'style-name'),
                (PRESENTATIONNS,'class-names'),
                (DRAWNS,'id'),
        ),
# allowed_attributes
        (DR3DNS,'scene'):(
                (DR3DNS,'ambient-color'),
                (DR3DNS,'distance'),
                (DR3DNS,'focal-length'),
                (DR3DNS,'lighting-mode'),
                (DR3DNS,'projection'),
                (DR3DNS,'shade-mode'),
                (DR3DNS,'shadow-slant'),
                (DR3DNS,'transform'),
                (DR3DNS,'vpn'),
                (DR3DNS,'vrp'),
                (DR3DNS,'vup'),
                (DRAWNS,'id'),
                (DRAWNS,'caption-id'),
                (DRAWNS,'layer'),
                (DRAWNS,'z-index'),
                (DRAWNS,'class-names'),
                (DRAWNS,'style-name'),
                (PRESENTATIONNS,'class-names'),
                (PRESENTATIONNS,'style-name'),
                (SVGNS,'height'),
                (SVGNS,'width'),
                (SVGNS,'x'),
                (SVGNS,'y'),
                (TABLENS,'end-cell-address'),
                (TABLENS,'end-x'),
                (TABLENS,'end-y'),
                (TABLENS,'table-background'),
                (TEXTNS,'anchor-page-number'),
                (TEXTNS,'anchor-type'),
        ),
        (DR3DNS,'sphere'):(
                (DRAWNS,'layer'),
                (DR3DNS,'center'),
                (DR3DNS,'transform'),
                (DRAWNS,'z-index'),
                (DRAWNS,'class-names'),
                (DRAWNS,'style-name'),
                (PRESENTATIONNS,'style-name'),
                (PRESENTATIONNS,'class-names'),
                (DRAWNS,'id'),
                (DR3DNS,'size'),
        ),
        (DRAWNS,'a'):(
                (OFFICENS,'name'),
                (OFFICENS,'title'),
                (XLINKNS,'show'),
                (OFFICENS,'target-frame-name'),
                (XLINKNS,'actuate'),
                (XLINKNS,'href'),
                (XLINKNS,'type'),
                (OFFICENS,'server-map'),
        ),
        (DRAWNS,'applet'):(
                (DRAWNS,'code'),
                (XLINKNS,'show'),
                (DRAWNS,'object'),
                (XLINKNS,'actuate'),
                (XLINKNS,'href'),
                (XLINKNS,'type'),
                (DRAWNS,'archive'),
                (DRAWNS,'may-script'),
        ),
        (DRAWNS,'area-circle'):(
                (OFFICENS,'name'),
                (XLINKNS,'show'),
                (SVGNS,'cx'),
                (XLINKNS,'type'),
                (DRAWNS,'nohref'),
                (SVGNS,'cy'),
                (XLINKNS,'href'),
                (SVGNS,'r'),
                (OFFICENS,'target-frame-name'),
        ),
        (DRAWNS,'area-polygon'):(
                (OFFICENS,'name'),
                (XLINKNS,'show'),
                (XLINKNS,'type'),
                (SVGNS,'height'),
                (DRAWNS,'nohref'),
                (SVGNS,'width'),
                (XLINKNS,'href'),
                (SVGNS,'y'),
                (SVGNS,'x'),
                (OFFICENS,'target-frame-name'),
                (SVGNS,'viewBox'),
                (DRAWNS,'points'),
        ),
        (DRAWNS,'area-rectangle'):(
                (OFFICENS,'name'),
                (XLINKNS,'show'),
                (XLINKNS,'type'),
                (SVGNS,'height'),
                (DRAWNS,'nohref'),
                (SVGNS,'width'),
                (XLINKNS,'href'),
                (SVGNS,'y'),
                (SVGNS,'x'),
                (OFFICENS,'target-frame-name'),
        ),
        (DRAWNS,'caption'):(
                (TABLENS,'table-background'),
                (DRAWNS,'layer'),
                (DRAWNS,'caption-id'),
                (TABLENS,'end-cell-address'),
                (DRAWNS,'name'),
                (DRAWNS,'text-style-name'),
                (DRAWNS,'caption-point-y'),
                (DRAWNS,'caption-point-x'),
                (DRAWNS,'transform'),
                (TABLENS,'end-y'),
                (DRAWNS,'corner-radius'),
                (SVGNS,'width'),
                (DRAWNS,'z-index'),
                (DRAWNS,'class-names'),
                (DRAWNS,'style-name'),
                (PRESENTATIONNS,'style-name'),
                (PRESENTATIONNS,'class-names'),
                (TABLENS,'end-x'),
                (TEXTNS,'anchor-page-number'),
                (SVGNS,'y'),
                (SVGNS,'x'),
                (SVGNS,'height'),
                (DRAWNS,'id'),
                (TEXTNS,'anchor-type'),
        ),
        (DRAWNS,'circle'):(
                (DRAWNS,'end-angle'),
                (DRAWNS,'id'),
                (DRAWNS,'kind'),
                (DRAWNS,'layer'),
                (DRAWNS,'name'),
                (DRAWNS,'start-angle'),
                (DRAWNS,'class-names'),
                (DRAWNS,'style-name'),
                (DRAWNS,'caption-id'),
                (DRAWNS,'text-style-name'),
                (DRAWNS,'transform'),
                (DRAWNS,'z-index'),
                (PRESENTATIONNS,'class-names'),
                (PRESENTATIONNS,'style-name'),
                (SVGNS,'cx'),
                (SVGNS,'cy'),
                (SVGNS,'height'),
                (SVGNS,'r'),
                (SVGNS,'width'),
                (SVGNS,'x'),
                (SVGNS,'y'),
                (TABLENS,'end-cell-address'),
                (TABLENS,'end-x'),
                (TABLENS,'end-y'),
                (TABLENS,'table-background'),
                (TEXTNS,'anchor-page-number'),
                (TEXTNS,'anchor-type'),
        ),
        (DRAWNS,'connector'):(
                (DRAWNS,'layer'),
                (DRAWNS,'end-shape'),
                (TEXTNS,'anchor-page-number'),
                (SVGNS,'y1'),
                (SVGNS,'y2'),
                (TABLENS,'table-background'),
                (TABLENS,'end-cell-address'),
                (DRAWNS,'transform'),
                (DRAWNS,'id'),
                (TABLENS,'end-y'),
                (TABLENS,'end-x'),
                (DRAWNS,'class-names'),
                (DRAWNS,'style-name'),
                (PRESENTATIONNS,'class-names'),
                (DRAWNS,'caption-id'),
                (DRAWNS,'type'),
                (DRAWNS,'start-shape'),
                (DRAWNS,'z-index'),
                (PRESENTATIONNS,'style-name'),
                (DRAWNS,'start-glue-point'),
                (SVGNS,'x2'),
                (SVGNS,'x1'),
                (TEXTNS,'anchor-type'),
                (DRAWNS,'line-skew'),
                (DRAWNS,'name'),
                (DRAWNS,'end-glue-point'),
                (DRAWNS,'text-style-name'),
        ),
        (DRAWNS,'contour-path'):(
                (SVGNS,'d'),
                (SVGNS,'width'),
                (DRAWNS,'recreate-on-edit'),
                (SVGNS,'viewBox'),
                (SVGNS,'height'),
        ),
        (DRAWNS,'contour-polygon'):(
                (SVGNS,'width'),
                (DRAWNS,'points'),
                (DRAWNS,'recreate-on-edit'),
                (SVGNS,'viewBox'),
                (SVGNS,'height'),
        ),
        (DRAWNS,'control'):(
                (DRAWNS,'control'),
                (DRAWNS,'layer'),
                (DRAWNS,'caption-id'),
                (TABLENS,'end-cell-address'),
                (DRAWNS,'name'),
                (DRAWNS,'text-style-name'),
                (TABLENS,'table-background'),
                (DRAWNS,'transform'),
                (SVGNS,'height'),
                (SVGNS,'width'),
                (DRAWNS,'z-index'),
                (DRAWNS,'class-names'),
                (DRAWNS,'style-name'),
                (PRESENTATIONNS,'style-name'),
                (PRESENTATIONNS,'class-names'),
                (TABLENS,'end-x'),
                (TEXTNS,'anchor-page-number'),
                (SVGNS,'y'),
                (SVGNS,'x'),
                (TABLENS,'end-y'),
                (DRAWNS,'id'),
                (TEXTNS,'anchor-type'),
        ),
        (DRAWNS,'custom-shape'):(
                (DRAWNS,'engine'),
                (DRAWNS,'caption-id'),
                (DRAWNS,'layer'),
                (TABLENS,'end-cell-address'),
                (DRAWNS,'name'),
                (DRAWNS,'text-style-name'),
                (TABLENS,'table-background'),
                (DRAWNS,'transform'),
                (SVGNS,'height'),
                (SVGNS,'width'),
                (DRAWNS,'z-index'),
                (DRAWNS,'class-names'),
                (DRAWNS,'style-name'),
                (PRESENTATIONNS,'style-name'),
                (PRESENTATIONNS,'class-names'),
                (TABLENS,'end-x'),
                (TEXTNS,'anchor-page-number'),
                (SVGNS,'y'),
                (SVGNS,'x'),
                (TABLENS,'end-y'),
                (DRAWNS,'data'),
                (DRAWNS,'id'),
                (TEXTNS,'anchor-type'),
        ),
# allowed_attributes
        (DRAWNS,'ellipse'):(
                (DRAWNS,'layer'),
                (DRAWNS,'start-angle'),
                (SVGNS,'cy'),
                (SVGNS,'cx'),
                (TABLENS,'table-background'),
                (TABLENS,'end-cell-address'),
                (SVGNS,'rx'),
                (DRAWNS,'transform'),
                (DRAWNS,'id'),
                (SVGNS,'width'),
                (TABLENS,'end-y'),
                (TABLENS,'end-x'),
                (DRAWNS,'class-names'),
                (DRAWNS,'style-name'),
                (PRESENTATIONNS,'class-names'),
                (DRAWNS,'end-angle'),
                (DRAWNS,'z-index'),
                (DRAWNS,'caption-id'),
                (PRESENTATIONNS,'style-name'),
                (SVGNS,'height'),
                (TEXTNS,'anchor-type'),
                (SVGNS,'ry'),
                (DRAWNS,'kind'),
                (DRAWNS,'name'),
                (TEXTNS,'anchor-page-number'),
                (SVGNS,'y'),
                (SVGNS,'x'),
                (DRAWNS,'text-style-name'),
        ),
# allowed_attributes
        (DRAWNS,'enhanced-geometry'):(
                (DRAWNS,'extrusion-rotation-center'),
                (DRAWNS,'extrusion-shininess'),
                (DRAWNS,'extrusion-rotation-angle'),
                (DRAWNS,'extrusion-allowed'),
                (DRAWNS,'extrusion-first-light-level'),
                (DRAWNS,'extrusion-specularity'),
                (DRAWNS,'extrusion-viewpoint'),
                (DRAWNS,'extrusion-second-light-level'),
                (DRAWNS,'extrusion-origin'),
                (DRAWNS,'extrusion-color'),
                (SVGNS,'viewBox'),
                (DR3DNS,'projection'),
                (DRAWNS,'extrusion-metal'),
                (DRAWNS,'extrusion-number-of-line-segments'),
                (DRAWNS,'text-path-same-letter-heights'),
                (DRAWNS,'extrusion-first-light-harsh'),
                (DRAWNS,'enhanced-path'),
                (DRAWNS,'text-rotate-angle'),
                (DRAWNS,'type'),
                (DRAWNS,'glue-point-leaving-directions'),
                (DRAWNS,'concentric-gradient-fill-allowed'),
                (DRAWNS,'text-path-scale'),
                (DRAWNS,'extrusion-brightness'),
                (DRAWNS,'extrusion-first-light-direction'),
                (DRAWNS,'extrusion-light-face'),
                (DRAWNS,'text-path-allowed'),
                (DRAWNS,'glue-points'),
                (DRAWNS,'mirror-vertical'),
                (DRAWNS,'extrusion-depth'),
                (DRAWNS,'extrusion-diffusion'),
                (DRAWNS,'extrusion-second-light-direction'),
                (DRAWNS,'extrusion-skew'),
                (DR3DNS,'shade-mode'),
                (DRAWNS,'path-stretchpoint-y'),
                (DRAWNS,'modifiers'),
                (DRAWNS,'extrusion'),
                (DRAWNS,'path-stretchpoint-x'),
                (DRAWNS,'text-areas'),
                (DRAWNS,'mirror-horizontal'),
                (DRAWNS,'text-path-mode'),
                (DRAWNS,'extrusion-second-light-harsh'),
                (DRAWNS,'glue-point-type'),
                (DRAWNS,'text-path'),
        ),
# allowed_attributes
        (DRAWNS,'equation'):(
                (DRAWNS,'formula'),
                (DRAWNS,'name'),
        ),
        (DRAWNS,'fill-image'):(
                (DRAWNS,'name'),
                (XLINKNS,'show'),
                (XLINKNS,'actuate'),
                (SVGNS,'height'),
                (SVGNS,'width'),
                (XLINKNS,'href'),
                (DRAWNS,'display-name'),
                (XLINKNS,'type'),
        ),
        (DRAWNS,'floating-frame'):(
                (XLINKNS,'href'),
                (XLINKNS,'actuate'),
                (DRAWNS,'frame-name'),
                (XLINKNS,'type'),
                (XLINKNS,'show'),
        ),
        (DRAWNS,'frame'):(
                (DRAWNS,'copy-of'),
                (DRAWNS,'id'),
                (DRAWNS,'layer'),
                (DRAWNS,'name'),
                (DRAWNS,'class-names'),
                (DRAWNS,'caption-id'),
                (DRAWNS,'style-name'),
                (DRAWNS,'text-style-name'),
                (DRAWNS,'transform'),
                (DRAWNS,'z-index'),
                (PRESENTATIONNS,'class'),
                (PRESENTATIONNS,'class-names'),
                (PRESENTATIONNS,'placeholder'),
                (PRESENTATIONNS,'style-name'),
                (PRESENTATIONNS,'user-transformed'),
                (STYLENS,'rel-height'),
                (STYLENS,'rel-width'),
                (SVGNS,'height'),
                (SVGNS,'width'),
                (SVGNS,'x'),
                (SVGNS,'y'),
                (TABLENS,'end-cell-address'),
                (TABLENS,'end-x'),
                (TABLENS,'end-y'),
                (TABLENS,'table-background'),
                (TEXTNS,'anchor-page-number'),
                (TEXTNS,'anchor-type'),
        ),
# allowed_attributes
        (DRAWNS,'g'):(
                (DRAWNS,'id'),
                (DRAWNS,'caption-id'),
                (DRAWNS,'name'),
                (DRAWNS,'class-names'),
                (DRAWNS,'style-name'),
                (DRAWNS,'z-index'),
                (PRESENTATIONNS,'class-names'),
                (PRESENTATIONNS,'style-name'),
                (SVGNS,'y'),
                (TABLENS,'end-cell-address'),
                (TABLENS,'end-x'),
                (TABLENS,'end-y'),
                (TABLENS,'table-background'),
                (TEXTNS,'anchor-page-number'),
                (TEXTNS,'anchor-type'),
        ),
        (DRAWNS,'glue-point'):(
                (SVGNS,'y'),
                (SVGNS,'x'),
                (DRAWNS,'align'),
                (DRAWNS,'id'),
                (DRAWNS,'escape-direction'),
        ),
        (DRAWNS,'gradient'):(
                (DRAWNS,'style'),
                (DRAWNS,'angle'),
                (DRAWNS,'name'),
                (DRAWNS,'end-color'),
                (DRAWNS,'start-color'),
                (DRAWNS,'cy'),
                (DRAWNS,'cx'),
                (DRAWNS,'display-name'),
                (DRAWNS,'border'),
                (DRAWNS,'end-intensity'),
                (DRAWNS,'start-intensity'),
        ),
        (DRAWNS,'handle'):(
                (DRAWNS,'handle-radius-range-minimum'),
                (DRAWNS,'handle-switched'),
                (DRAWNS,'handle-range-y-maximum'),
                (DRAWNS,'handle-mirror-horizontal'),
                (DRAWNS,'handle-range-x-maximum'),
                (DRAWNS,'handle-mirror-vertical'),
                (DRAWNS,'handle-range-y-minimum'),
                (DRAWNS,'handle-radius-range-maximum'),
                (DRAWNS,'handle-range-x-minimum'),
                (DRAWNS,'handle-position'),
                (DRAWNS,'handle-polar'),
        ),
        (DRAWNS,'hatch'):(
                (DRAWNS,'distance'),
                (DRAWNS,'style'),
                (DRAWNS,'name'),
                (DRAWNS,'color'),
                (DRAWNS,'display-name'),
                (DRAWNS,'rotation'),
        ),
        (DRAWNS,'image'):(
                (DRAWNS,'filter-name'),
                (XLINKNS,'href'),
                (XLINKNS,'type'),
                (XLINKNS,'actuate'),
                (XLINKNS,'show'),
        ),
        (DRAWNS,'image-map'):(
        ),
        (DRAWNS,'layer'):(
                (DRAWNS,'protected'),
                (DRAWNS,'name'),
                (DRAWNS,'display'),
        ),
# allowed_attributes
        (DRAWNS,'layer-set'):(
        ),
        (DRAWNS,'line'):(
                (DRAWNS,'class-names'),
                (DRAWNS,'id'),
                (DRAWNS,'caption-id'),
                (DRAWNS,'layer'),
                (DRAWNS,'name'),
                (DRAWNS,'style-name'),
                (DRAWNS,'text-style-name'),
                (DRAWNS,'transform'),
                (DRAWNS,'z-index'),
                (PRESENTATIONNS,'class-names'),
                (PRESENTATIONNS,'style-name'),
                (SVGNS,'x1'),
                (SVGNS,'x2'),
                (SVGNS,'y1'),
                (SVGNS,'y2'),
                (TABLENS,'end-cell-address'),
                (TABLENS,'end-x'),
                (TABLENS,'end-y'),
                (TABLENS,'table-background'),
                (TEXTNS,'anchor-page-number'),
                (TEXTNS,'anchor-type'),
        ),
        (DRAWNS,'marker'):(
                (SVGNS,'d'),
                (DRAWNS,'display-name'),
                (DRAWNS,'name'),
                (SVGNS,'viewBox'),
        ),
# allowed_attributes
        (DRAWNS,'measure'):(
                (TABLENS,'end-cell-address'),
                (DRAWNS,'layer'),
                (SVGNS,'y2'),
                (DRAWNS,'name'),
                (DRAWNS,'text-style-name'),
                (DRAWNS,'transform'),
                (TABLENS,'table-background'),
                (SVGNS,'x2'),
                (DRAWNS,'z-index'),
                (DRAWNS,'class-names'),
                (DRAWNS,'style-name'),
                (PRESENTATIONNS,'style-name'),
                (PRESENTATIONNS,'class-names'),
                (TABLENS,'end-x'),
                (TEXTNS,'anchor-page-number'),
                (SVGNS,'y1'),
                (DRAWNS,'caption-id'),
                (TABLENS,'end-y'),
                (SVGNS,'x1'),
                (DRAWNS,'id'),
                (TEXTNS,'anchor-type'),
        ),
        (DRAWNS,'object'):(
                (XLINKNS,'type'),
                (XLINKNS,'href'),
                (DRAWNS,'notify-on-update-of-ranges'),
                (XLINKNS,'actuate'),
                (XLINKNS,'show'),
        ),
        (DRAWNS,'object-ole'):(
                (XLINKNS,'actuate'),
                (XLINKNS,'href'),
                (XLINKNS,'type'),
                (DRAWNS,'class-id'),
                (XLINKNS,'show'),
        ),
        (DRAWNS,'opacity'):(
                (DRAWNS,'style'),
                (DRAWNS,'angle'),
                (DRAWNS,'name'),
                (DRAWNS,'start'),
                (DRAWNS,'cy'),
                (DRAWNS,'cx'),
                (DRAWNS,'end'),
                (DRAWNS,'display-name'),
                (DRAWNS,'border'),
        ),
        (DRAWNS,'page'):(
                (PRESENTATIONNS,'presentation-page-layout-name'),
                (DRAWNS,'name'),
                (DRAWNS,'nav-order'),
                (PRESENTATIONNS,'use-footer-name'),
                (DRAWNS,'style-name'),
                (PRESENTATIONNS,'use-header-name'),
                (DRAWNS,'master-page-name'),
                (DRAWNS,'id'),
                (PRESENTATIONNS,'use-date-time-name'),
        ),
        (DRAWNS,'page-thumbnail'):(
                (TABLENS,'table-background'),
                (DRAWNS,'caption-id'),
                (PRESENTATIONNS,'user-transformed'),
                (DRAWNS,'layer'),
                (TABLENS,'end-cell-address'),
                (DRAWNS,'name'),
                (DRAWNS,'id'),
                (DRAWNS,'transform'),
                (DRAWNS,'page-number'),
                (SVGNS,'height'),
                (SVGNS,'width'),
                (DRAWNS,'z-index'),
                (DRAWNS,'class-names'),
                (DRAWNS,'style-name'),
                (PRESENTATIONNS,'style-name'),
                (PRESENTATIONNS,'class-names'),
                (TABLENS,'end-x'),
                (TEXTNS,'anchor-page-number'),
                (SVGNS,'y'),
                (SVGNS,'x'),
                (TABLENS,'end-y'),
                (PRESENTATIONNS,'placeholder'),
                (PRESENTATIONNS,'class'),
                (TEXTNS,'anchor-type'),
        ),
        (DRAWNS,'param'):(
                (DRAWNS,'name'),
                (DRAWNS,'value'),
        ),
# allowed_attributes
        (DRAWNS,'path'):(
                (TABLENS,'table-background'),
                (DRAWNS,'layer'),
                (TABLENS,'end-cell-address'),
                (DRAWNS,'caption-id'),
                (SVGNS,'d'),
                (DRAWNS,'text-style-name'),
                (DRAWNS,'id'),
                (DRAWNS,'transform'),
                (SVGNS,'height'),
                (SVGNS,'width'),
                (DRAWNS,'z-index'),
                (DRAWNS,'class-names'),
                (DRAWNS,'style-name'),
                (PRESENTATIONNS,'style-name'),
                (PRESENTATIONNS,'class-names'),
                (TABLENS,'end-x'),
                (TEXTNS,'anchor-type'),
                (TEXTNS,'anchor-page-number'),
                (SVGNS,'y'),
                (SVGNS,'x'),
                (TABLENS,'end-y'),
                (SVGNS,'viewBox'),
                (DRAWNS,'name'),
        ),
        (DRAWNS,'plugin'):(
                (XLINKNS,'type'),
                (XLINKNS,'href'),
                (DRAWNS,'mime-type'),
                (XLINKNS,'actuate'),
                (XLINKNS,'show'),
        ),
        (DRAWNS,'polygon'):(
                (DRAWNS,'caption-id'),
                (TABLENS,'table-background'),
                (DRAWNS,'layer'),
                (TABLENS,'end-cell-address'),
                (DRAWNS,'name'),
                (DRAWNS,'text-style-name'),
                (DRAWNS,'id'),
                (DRAWNS,'transform'),
                (PRESENTATIONNS,'style-name'),
                (SVGNS,'height'),
                (SVGNS,'width'),
                (DRAWNS,'z-index'),
                (DRAWNS,'points'),
                (DRAWNS,'class-names'),
                (DRAWNS,'style-name'),
                (PRESENTATIONNS,'class-names'),
                (TABLENS,'end-x'),
                (TEXTNS,'anchor-page-number'),
                (SVGNS,'y'),
                (SVGNS,'x'),
                (TABLENS,'end-y'),
                (SVGNS,'viewBox'),
                (TEXTNS,'anchor-type'),
        ),
# allowed_attributes
        (DRAWNS,'polyline'):(
                (TABLENS,'table-background'),
                (DRAWNS,'layer'),
                (TABLENS,'end-cell-address'),
                (DRAWNS,'name'),
                (DRAWNS,'text-style-name'),
                (DRAWNS,'id'),
                (DRAWNS,'caption-id'),
                (DRAWNS,'transform'),
                (PRESENTATIONNS,'style-name'),
                (SVGNS,'height'),
                (SVGNS,'width'),
                (DRAWNS,'z-index'),
                (DRAWNS,'points'),
                (DRAWNS,'class-names'),
                (DRAWNS,'style-name'),
                (PRESENTATIONNS,'class-names'),
                (TABLENS,'end-x'),
                (TEXTNS,'anchor-page-number'),
                (SVGNS,'y'),
                (SVGNS,'x'),
                (TABLENS,'end-y'),
                (SVGNS,'viewBox'),
                (TEXTNS,'anchor-type'),
        ),
        (DRAWNS,'rect'):(
                (DRAWNS,'corner-radius'),
                (DRAWNS,'caption-id'),
                (DRAWNS,'id'),
                (DRAWNS,'layer'),
                (DRAWNS,'name'),
                (DRAWNS,'text-style-name'),
                (DRAWNS,'transform'),
                (DRAWNS,'z-index'),
                (DRAWNS,'class-names'),
                (DRAWNS,'style-name'),
                (PRESENTATIONNS,'class-names'),
                (PRESENTATIONNS,'style-name'),
                (SVGNS,'height'),
                (SVGNS,'width'),
                (SVGNS,'x'),
                (SVGNS,'y'),
                (TABLENS,'end-cell-address'),
                (TABLENS,'end-x'),
                (TABLENS,'end-y'),
                (TABLENS,'table-background'),
                (TEXTNS,'anchor-page-number'),
                (TEXTNS,'anchor-type'),
        ),
# allowed_attributes
        (DRAWNS,'regular-polygon'):(
                (TABLENS,'table-background'),
                (DRAWNS,'layer'),
                (TABLENS,'end-cell-address'),
                (DRAWNS,'caption-id'),
                (DRAWNS,'name'),
                (DRAWNS,'text-style-name'),
                (TEXTNS,'anchor-page-number'),
                (DRAWNS,'concave'),
                (DRAWNS,'sharpness'),
                (DRAWNS,'transform'),
                (SVGNS,'height'),
                (SVGNS,'width'),
                (DRAWNS,'z-index'),
                (DRAWNS,'class-names'),
                (DRAWNS,'style-name'),
                (PRESENTATIONNS,'style-name'),
                (PRESENTATIONNS,'class-names'),
                (TABLENS,'end-x'),
                (DRAWNS,'corners'),
                (SVGNS,'y'),
                (SVGNS,'x'),
                (TABLENS,'end-y'),
                (DRAWNS,'id'),
                (TEXTNS,'anchor-type'),
        ),
        (DRAWNS,'stroke-dash'):(
                (DRAWNS,'distance'),
                (DRAWNS,'dots1-length'),
                (DRAWNS,'name'),
                (DRAWNS,'dots2-length'),
                (DRAWNS,'style'),
                (DRAWNS,'dots1'),
                (DRAWNS,'display-name'),
                (DRAWNS,'dots2'),
        ),
        (DRAWNS,'text-box'):(
                (FONS,'min-width'),
                (DRAWNS,'corner-radius'),
                (FONS,'max-height'),
                (FONS,'min-height'),
                (DRAWNS,'chain-next-name'),
                (FONS,'max-width'),
                (TEXTNS,'id'),
        ),
# allowed_attributes
        (FORMNS,'button'):(
                (FORMNS,'tab-stop'),
                (FORMNS,'focus-on-click'),
                (FORMNS,'image-align'),
                (FORMNS,'name'),
                (FORMNS,'tab-index'),
                (FORMNS,'control-implementation'),
                (XFORMSNS,'bind'),
                (FORMNS,'button-type'),
                (FORMNS,'title'),
                (FORMNS,'default-button'),
                (FORMNS,'value'),
                (FORMNS,'label'),
                (FORMNS,'disabled'),
                (FORMNS,'printable'),
                (FORMNS,'image-data'),
                (XLINKNS,'href'),
                (FORMNS,'toggle'),
                (FORMNS,'xforms-submission'),
                (OFFICENS,'target-frame'),
                (FORMNS,'id'),
                (FORMNS,'image-position'),
        ),
        (FORMNS,'checkbox'):(
                (FORMNS,'tab-stop'),
                (FORMNS,'image-align'),
                (FORMNS,'name'),
                (FORMNS,'tab-index'),
                (FORMNS,'control-implementation'),
                (XFORMSNS,'bind'),
                (FORMNS,'data-field'),
                (FORMNS,'title'),
                (FORMNS,'is-tristate'),
                (FORMNS,'current-state'),
                (FORMNS,'value'),
                (FORMNS,'label'),
                (FORMNS,'disabled'),
                (FORMNS,'printable'),
                (FORMNS,'state'),
                (FORMNS,'visual-effect'),
                (FORMNS,'id'),
                (FORMNS,'image-position'),
        ),
        (FORMNS,'column'):(
                (FORMNS,'control-implementation'),
                (FORMNS,'text-style-name'),
                (FORMNS,'name'),
                (FORMNS,'label'),
        ),
        (FORMNS,'combobox'):(
                (FORMNS,'convert-empty-to-null'),
                (FORMNS,'max-length'),
                (FORMNS,'tab-stop'),
                (FORMNS,'name'),
                (FORMNS,'dropdown'),
                (FORMNS,'control-implementation'),
                (XFORMSNS,'bind'),
                (FORMNS,'data-field'),
                (FORMNS,'tab-index'),
                (FORMNS,'auto-complete'),
                (FORMNS,'value'),
                (FORMNS,'disabled'),
                (FORMNS,'printable'),
                (FORMNS,'readonly'),
                (FORMNS,'list-source'),
                (FORMNS,'title'),
                (FORMNS,'list-source-type'),
                (FORMNS,'id'),
                (FORMNS,'current-value'),
                (FORMNS,'size'),
        ),
# allowed_attributes
        (FORMNS,'connection-resource'):(
                (XLINKNS,'href'),
        ),
        (FORMNS,'date'):(
                (FORMNS,'convert-empty-to-null'),
                (FORMNS,'max-length'),
                (FORMNS,'tab-stop'),
                (FORMNS,'name'),
                (FORMNS,'tab-index'),
                (FORMNS,'control-implementation'),
                (FORMNS,'min-value'),
                (FORMNS,'data-field'),
                (FORMNS,'max-value'),
                (FORMNS,'value'),
                (FORMNS,'disabled'),
                (FORMNS,'printable'),
                (FORMNS,'readonly'),
                (XFORMSNS,'bind'),
                (FORMNS,'title'),
                (FORMNS,'id'),
                (FORMNS,'current-value'),
        ),
        (FORMNS,'file'):(
                (FORMNS,'max-length'),
                (FORMNS,'tab-stop'),
                (FORMNS,'name'),
                (FORMNS,'tab-index'),
                (FORMNS,'control-implementation'),
                (XFORMSNS,'bind'),
                (FORMNS,'title'),
                (FORMNS,'value'),
                (FORMNS,'disabled'),
                (FORMNS,'printable'),
                (FORMNS,'readonly'),
                (FORMNS,'id'),
                (FORMNS,'current-value'),
        ),
        (FORMNS,'fixed-text'):(
                (FORMNS,'name'),
                (FORMNS,'for'),
                (FORMNS,'title'),
                (FORMNS,'control-implementation'),
                (XFORMSNS,'bind'),
                (FORMNS,'multi-line'),
                (FORMNS,'label'),
                (FORMNS,'disabled'),
                (FORMNS,'printable'),
                (FORMNS,'id'),
        ),
# allowed_attributes
        (FORMNS,'form'):(
                (XLINKNS,'actuate'),
                (XLINKNS,'href'),
                (FORMNS,'allow-deletes'),
                (FORMNS,'command-type'),
                (FORMNS,'apply-filter'),
                (XLINKNS,'type'),
                (FORMNS,'method'),
                (OFFICENS,'target-frame'),
                (FORMNS,'navigation-mode'),
                (FORMNS,'detail-fields'),
                (FORMNS,'master-fields'),
                (FORMNS,'allow-updates'),
                (FORMNS,'name'),
                (FORMNS,'tab-cycle'),
                (FORMNS,'control-implementation'),
                (FORMNS,'escape-processing'),
                (FORMNS,'filter'),
                (FORMNS,'command'),
                (FORMNS,'datasource'),
                (FORMNS,'enctype'),
                (FORMNS,'allow-inserts'),
                (FORMNS,'ignore-result'),
                (FORMNS,'order'),
        ),
        (FORMNS,'formatted-text'):(
                (FORMNS,'convert-empty-to-null'),
                (FORMNS,'max-length'),
                (FORMNS,'tab-stop'),
                (FORMNS,'max-value'),
                (FORMNS,'name'),
                (FORMNS,'tab-index'),
                (FORMNS,'control-implementation'),
                (XFORMSNS,'bind'),
                (FORMNS,'data-field'),
                (FORMNS,'title'),
                (FORMNS,'value'),
                (FORMNS,'disabled'),
                (FORMNS,'printable'),
                (FORMNS,'readonly'),
                (FORMNS,'min-value'),
                (FORMNS,'validation'),
                (FORMNS,'id'),
                (FORMNS,'current-value'),
        ),
        (FORMNS,'frame'):(
                (FORMNS,'name'),
                (FORMNS,'for'),
                (FORMNS,'title'),
                (FORMNS,'control-implementation'),
                (XFORMSNS,'bind'),
                (FORMNS,'label'),
                (FORMNS,'disabled'),
                (FORMNS,'printable'),
                (FORMNS,'id'),
        ),
# allowed_attributes
        (FORMNS,'generic-control'):(
                (FORMNS,'control-implementation'),
                (XFORMSNS,'bind'),
                (FORMNS,'name'),
                (FORMNS,'id'),
        ),
        (FORMNS,'grid'):(
                (FORMNS,'tab-stop'),
                (FORMNS,'name'),
                (FORMNS,'tab-index'),
                (FORMNS,'control-implementation'),
                (XFORMSNS,'bind'),
                (FORMNS,'title'),
                (FORMNS,'disabled'),
                (FORMNS,'printable'),
                (FORMNS,'id'),
        ),
        (FORMNS,'hidden'):(
                (FORMNS,'control-implementation'),
                (XFORMSNS,'bind'),
                (FORMNS,'name'),
                (FORMNS,'value'),
                (FORMNS,'id'),
        ),
        (FORMNS,'image'):(
                (FORMNS,'tab-stop'),
                (FORMNS,'name'),
                (FORMNS,'tab-index'),
                (FORMNS,'control-implementation'),
                (XFORMSNS,'bind'),
                (FORMNS,'button-type'),
                (FORMNS,'title'),
                (FORMNS,'value'),
                (OFFICENS,'target-frame'),
                (FORMNS,'disabled'),
                (FORMNS,'printable'),
                (FORMNS,'image-data'),
                (XLINKNS,'href'),
                (FORMNS,'id'),
        ),
        (FORMNS,'image-frame'):(
                (FORMNS,'name'),
                (FORMNS,'title'),
                (FORMNS,'control-implementation'),
                (XFORMSNS,'bind'),
                (FORMNS,'data-field'),
                (FORMNS,'readonly'),
                (FORMNS,'disabled'),
                (FORMNS,'printable'),
                (FORMNS,'image-data'),
                (FORMNS,'id'),
        ),
        (FORMNS,'item'):(
                (FORMNS,'label'),
        ),
        (FORMNS,'list-property'):(
                (FORMNS,'property-name'),
                (OFFICENS,'value-type'),
        ),
        (FORMNS,'list-value'):(
                (OFFICENS,'string-value'),
        ),
# allowed_attributes
        (FORMNS,'listbox'):(
                (FORMNS,'tab-stop'),
                (FORMNS,'bound-column'),
                (FORMNS,'multiple'),
                (FORMNS,'name'),
                (FORMNS,'dropdown'),
                (FORMNS,'control-implementation'),
                (XFORMSNS,'bind'),
                (FORMNS,'data-field'),
                (FORMNS,'tab-index'),
                (FORMNS,'disabled'),
                (FORMNS,'printable'),
                (FORMNS,'list-source'),
                (FORMNS,'title'),
                (FORMNS,'list-source-type'),
                (FORMNS,'id'),
                (FORMNS,'xforms-list-source'),
                (FORMNS,'size'),
        ),
        (FORMNS,'number'):(
                (FORMNS,'convert-empty-to-null'),
                (FORMNS,'max-length'),
                (FORMNS,'tab-stop'),
                (FORMNS,'name'),
                (FORMNS,'tab-index'),
                (FORMNS,'control-implementation'),
                (FORMNS,'min-value'),
                (FORMNS,'data-field'),
                (FORMNS,'max-value'),
                (FORMNS,'value'),
                (FORMNS,'disabled'),
                (FORMNS,'printable'),
                (FORMNS,'readonly'),
                (XFORMSNS,'bind'),
                (FORMNS,'title'),
                (FORMNS,'id'),
                (FORMNS,'current-value'),
        ),
        (FORMNS,'option'):(
                (FORMNS,'current-selected'),
                (FORMNS,'selected'),
                (FORMNS,'value'),
                (FORMNS,'label'),
        ),
        (FORMNS,'password'):(
                (FORMNS,'convert-empty-to-null'),
                (FORMNS,'max-length'),
                (FORMNS,'tab-stop'),
                (FORMNS,'name'),
                (FORMNS,'tab-index'),
                (FORMNS,'control-implementation'),
                (XFORMSNS,'bind'),
                (FORMNS,'title'),
                (FORMNS,'value'),
                (FORMNS,'disabled'),
                (FORMNS,'printable'),
                (FORMNS,'echo-char'),
                (FORMNS,'id'),
        ),
        (FORMNS,'properties'):(
        ),
        (FORMNS,'property'):(
                (OFFICENS,'string-value'),
                (OFFICENS,'value'),
                (OFFICENS,'boolean-value'),
                (FORMNS,'property-name'),
                (OFFICENS,'currency'),
                (OFFICENS,'date-value'),
                (OFFICENS,'value-type'),
                (OFFICENS,'time-value'),
        ),
        (FORMNS,'radio'):(
                (FORMNS,'tab-stop'),
                (FORMNS,'selected'),
                (FORMNS,'image-align'),
                (FORMNS,'name'),
                (FORMNS,'tab-index'),
                (FORMNS,'control-implementation'),
                (XFORMSNS,'bind'),
                (FORMNS,'data-field'),
                (FORMNS,'current-selected'),
                (FORMNS,'value'),
                (FORMNS,'label'),
                (FORMNS,'disabled'),
                (FORMNS,'printable'),
                (FORMNS,'title'),
                (FORMNS,'visual-effect'),
                (FORMNS,'id'),
                (FORMNS,'image-position'),
        ),
        (FORMNS,'text'):(
                (FORMNS,'convert-empty-to-null'),
                (FORMNS,'max-length'),
                (FORMNS,'tab-stop'),
                (FORMNS,'name'),
                (FORMNS,'tab-index'),
                (FORMNS,'control-implementation'),
                (XFORMSNS,'bind'),
                (FORMNS,'data-field'),
                (FORMNS,'title'),
                (FORMNS,'value'),
                (FORMNS,'disabled'),
                (FORMNS,'printable'),
                (FORMNS,'readonly'),
                (FORMNS,'id'),
                (FORMNS,'current-value'),
        ),
        (FORMNS,'textarea'):(
                (FORMNS,'convert-empty-to-null'),
                (FORMNS,'max-length'),
                (FORMNS,'tab-stop'),
                (FORMNS,'name'),
                (FORMNS,'tab-index'),
                (FORMNS,'control-implementation'),
                (XFORMSNS,'bind'),
                (FORMNS,'data-field'),
                (FORMNS,'title'),
                (FORMNS,'value'),
                (FORMNS,'disabled'),
                (FORMNS,'printable'),
                (FORMNS,'readonly'),
                (FORMNS,'id'),
                (FORMNS,'current-value'),
        ),
        (FORMNS,'time'):(
                (FORMNS,'convert-empty-to-null'),
                (FORMNS,'max-length'),
                (FORMNS,'tab-stop'),
                (FORMNS,'name'),
                (FORMNS,'tab-index'),
                (FORMNS,'control-implementation'),
                (FORMNS,'min-value'),
                (FORMNS,'data-field'),
                (FORMNS,'max-value'),
                (FORMNS,'value'),
                (FORMNS,'disabled'),
                (FORMNS,'printable'),
                (FORMNS,'readonly'),
                (XFORMSNS,'bind'),
                (FORMNS,'title'),
                (FORMNS,'id'),
                (FORMNS,'current-value'),
        ),
        (FORMNS,'value-range'):(
                (FORMNS,'tab-stop'),
                (FORMNS,'max-value'),
                (FORMNS,'name'),
                (FORMNS,'tab-index'),
                (FORMNS,'control-implementation'),
                (XFORMSNS,'bind'),
                (FORMNS,'title'),
                (FORMNS,'value'),
                (FORMNS,'disabled'),
                (FORMNS,'printable'),
                (FORMNS,'orientation'),
                (FORMNS,'page-step-size'),
                (FORMNS,'delay-for-repeat'),
                (FORMNS,'min-value'),
                (FORMNS,'id'),
                (FORMNS,'step-size'),
        ),
        (MANIFESTNS,'algorithm') : (
                (MANIFESTNS,'algorithm-name'),
                (MANIFESTNS,'initialisation-vector'),
        ),
        (MANIFESTNS,'encryption-data') : (
                (MANIFESTNS,'checksum-type'),
                (MANIFESTNS,'checksum'),
        ),
        (MANIFESTNS,'file-entry') : (
                (MANIFESTNS,'full-path'),
                (MANIFESTNS,'media-type'),
                (MANIFESTNS,'size'),
        ),
        (MANIFESTNS,'key-derivation') : (
                (MANIFESTNS,'key-derivation-name'),
                (MANIFESTNS,'salt'),
                (MANIFESTNS,'iteration-count'),
        ),
        (MANIFESTNS,'manifest'):(
        ),
# allowed_attributes
        (METANS,'auto-reload'):(
                (METANS,'delay'),
                (XLINKNS,'actuate'),
                (XLINKNS,'href'),
                (XLINKNS,'type'),
                (XLINKNS,'show'),
        ),
        (METANS,'creation-date'):(
        ),
        (METANS,'date-string'):(
        ),
        (METANS,'document-statistic'):(
                (METANS,'non-whitespace-character-count'),
                (METANS,'ole-object-count'),
                (METANS,'table-count'),
                (METANS,'row-count'),
                (METANS,'character-count'),
                (METANS,'sentence-count'),
                (METANS,'draw-count'),
                (METANS,'paragraph-count'),
                (METANS,'word-count'),
                (METANS,'object-count'),
                (METANS,'syllable-count'),
                (METANS,'image-count'),
                (METANS,'page-count'),
                (METANS,'frame-count'),
                (METANS,'cell-count'),
        ),
        (METANS,'editing-cycles'):(
        ),
        (METANS,'editing-duration'):(
        ),
        (METANS,'generator'):(
        ),
# allowed_attributes
        (METANS,'hyperlink-behaviour'):(
                (OFFICENS,'target-frame-name'),
                (XLINKNS,'show'),
        ),
        (METANS,'initial-creator'):(
        ),
        (METANS,'keyword'):(
        ),
        (METANS,'print-date'):(
        ),
        (METANS,'printed-by'):(
        ),
        (METANS,'template'):(
                (METANS,'date'),
                (XLINKNS,'actuate'),
                (XLINKNS,'href'),
                (XLINKNS,'type'),
                (XLINKNS,'title'),
        ),
        (METANS,'user-defined'):(
                (METANS,'name'),
                (METANS,'value-type'),
        ),
        (OFFICENS,'annotation'):(
                (DRAWNS,'layer'),
                (SVGNS,'height'),
                (TEXTNS,'anchor-page-number'),
                (TABLENS,'table-background'),
                (TABLENS,'end-cell-address'),
                (DRAWNS,'transform'),
                (DRAWNS,'id'),
                (SVGNS,'width'),
                (DRAWNS,'class-names'),
                (DRAWNS,'style-name'),
                (PRESENTATIONNS,'class-names'),
                (TABLENS,'end-x'),
                (DRAWNS,'text-style-name'),
                (DRAWNS,'z-index'),
                (PRESENTATIONNS,'style-name'),
                (TEXTNS,'anchor-type'),
                (DRAWNS,'name'),
                (DRAWNS,'caption-point-y'),
                (DRAWNS,'caption-point-x'),
                (DRAWNS,'corner-radius'),
                (SVGNS,'y'),
                (SVGNS,'x'),
                (TABLENS,'end-y'),
                (OFFICENS,'display'),
        ),
        (OFFICENS,'automatic-styles'):(
        ),
        (OFFICENS,'binary-data'):(
        ),
        (OFFICENS,'body'):(
        ),
        (OFFICENS,'change-info'):(
        ),
        (OFFICENS,'chart'):(
        ),
        (OFFICENS,'dde-source'):(
                (OFFICENS,'dde-application'),
                (OFFICENS,'automatic-update'),
                (OFFICENS,'conversion-mode'),
                (OFFICENS,'dde-item'),
                (OFFICENS,'dde-topic'),
                (OFFICENS,'name'),
        ),
        (OFFICENS,'document'):(
                (OFFICENS,'mimetype'),
                (OFFICENS,'version'),
        ),
        (OFFICENS,'document-content'):(
                (OFFICENS,'version'),
        ),
        (OFFICENS,'document-meta'):(
                (OFFICENS,'version'),
        ),
        (OFFICENS,'document-settings'):(
                (OFFICENS,'version'),
        ),
        (OFFICENS,'document-styles'):(
                (OFFICENS,'version'),
        ),
        (OFFICENS,'drawing'):(
        ),
        (OFFICENS,'event-listeners'):(
        ),
        (OFFICENS,'font-face-decls'):(
        ),
        (OFFICENS,'forms'):(
                (FORMNS,'automatic-focus'),
                (FORMNS,'apply-design-mode'),
        ),
        (OFFICENS,'image'):(
        ),
# allowed_attributes
        (OFFICENS,'master-styles'):(
        ),
        (OFFICENS,'meta'):(
        ),
        (OFFICENS,'presentation'):(
        ),
        (OFFICENS,'script'):(
                (SCRIPTNS,'language'),
        ),
        (OFFICENS,'scripts'):(
        ),
        (OFFICENS,'settings'):(
        ),
        (OFFICENS,'spreadsheet'):(
                (TABLENS,'structure-protected'),
                (TABLENS,'protection-key'),
        ),
        (OFFICENS,'styles'):(
        ),
        (OFFICENS,'text'):(
                (TEXTNS,'global'),
                (TEXTNS,'use-soft-page-breaks'),
        ),
        (PRESENTATIONNS,'animation-group'):(
        ),
        (PRESENTATIONNS,'animations'):(
        ),
        (PRESENTATIONNS,'date-time'):(
        ),
        (PRESENTATIONNS,'date-time-decl'):(
                (PRESENTATIONNS,'source'),
                (STYLENS,'data-style-name'),
                (PRESENTATIONNS,'name'),
        ),
        (PRESENTATIONNS,'dim'):(
                (DRAWNS,'color'),
                (DRAWNS,'shape-id'),
        ),
        (PRESENTATIONNS,'event-listener'):(
                (PRESENTATIONNS,'direction'),
                (XLINKNS,'show'),
                (XLINKNS,'type'),
                (XLINKNS,'actuate'),
                (PRESENTATIONNS,'effect'),
                (SCRIPTNS,'event-name'),
                (PRESENTATIONNS,'start-scale'),
                (XLINKNS,'href'),
                (PRESENTATIONNS,'verb'),
                (PRESENTATIONNS,'action'),
                (PRESENTATIONNS,'speed'),
        ),
        (PRESENTATIONNS,'footer'):(
        ),
        (PRESENTATIONNS,'footer-decl'):(
                (PRESENTATIONNS,'name'),
        ),
        (PRESENTATIONNS,'header'):(
        ),
        (PRESENTATIONNS,'header-decl'):(
                (PRESENTATIONNS,'name'),
        ),
        (PRESENTATIONNS,'hide-shape'):(
                (PRESENTATIONNS,'direction'),
                (PRESENTATIONNS,'effect'),
                (PRESENTATIONNS,'delay'),
                (PRESENTATIONNS,'start-scale'),
                (PRESENTATIONNS,'path-id'),
                (PRESENTATIONNS,'speed'),
                (DRAWNS,'shape-id'),
        ),
# allowed_attributes
        (PRESENTATIONNS,'hide-text'):(
                (PRESENTATIONNS,'direction'),
                (PRESENTATIONNS,'effect'),
                (PRESENTATIONNS,'delay'),
                (PRESENTATIONNS,'start-scale'),
                (PRESENTATIONNS,'path-id'),
                (PRESENTATIONNS,'speed'),
                (DRAWNS,'shape-id'),
        ),
        (PRESENTATIONNS,'notes'):(
                (STYLENS,'page-layout-name'),
                (DRAWNS,'style-name'),
                (PRESENTATIONNS,'use-header-name'),
                (PRESENTATIONNS,'use-date-time-name'),
                (PRESENTATIONNS,'use-footer-name'),
        ),
        (PRESENTATIONNS,'placeholder'):(
                (SVGNS,'y'),
                (SVGNS,'x'),
                (SVGNS,'height'),
                (PRESENTATIONNS,'object'),
                (SVGNS,'width'),
        ),
        (PRESENTATIONNS,'play'):(
                (PRESENTATIONNS,'speed'),
                (DRAWNS,'shape-id'),
        ),
# allowed_attributes
        (PRESENTATIONNS,'settings'):(
                (PRESENTATIONNS,'animations'),
                (PRESENTATIONNS,'endless'),
                (PRESENTATIONNS,'force-manual'),
                (PRESENTATIONNS,'full-screen'),
                (PRESENTATIONNS,'mouse-as-pen'),
                (PRESENTATIONNS,'mouse-visible'),
                (PRESENTATIONNS,'pause'),
                (PRESENTATIONNS,'show'),
                (PRESENTATIONNS,'show-end-of-presentation-slide'),
                (PRESENTATIONNS,'show-logo'),
                (PRESENTATIONNS,'start-page'),
                (PRESENTATIONNS,'start-with-navigator'),
                (PRESENTATIONNS,'stay-on-top'),
                (PRESENTATIONNS,'transition-on-click'),
        ),
        (PRESENTATIONNS,'show'):(
                (PRESENTATIONNS,'name'),
                (PRESENTATIONNS,'pages'),
        ),
        (PRESENTATIONNS,'show-shape'):(
                (PRESENTATIONNS,'direction'),
                (PRESENTATIONNS,'effect'),
                (PRESENTATIONNS,'delay'),
                (PRESENTATIONNS,'start-scale'),
                (PRESENTATIONNS,'path-id'),
                (PRESENTATIONNS,'speed'),
                (DRAWNS,'shape-id'),
        ),
        (PRESENTATIONNS,'show-text'):(
                (PRESENTATIONNS,'direction'),
                (PRESENTATIONNS,'effect'),
                (PRESENTATIONNS,'delay'),
                (PRESENTATIONNS,'start-scale'),
                (PRESENTATIONNS,'path-id'),
                (PRESENTATIONNS,'speed'),
                (DRAWNS,'shape-id'),
        ),
        (PRESENTATIONNS,'sound'):(
                (XLINKNS,'actuate'),
                (XLINKNS,'href'),
                (XLINKNS,'type'),
                (PRESENTATIONNS,'play-full'),
                (XLINKNS,'show'),
        ),
# allowed_attributes
        (SCRIPTNS,'event-listener'):(
                (SCRIPTNS,'language'),
                (SCRIPTNS,'macro-name'),
                (XLINKNS,'actuate'),
                (SCRIPTNS,'event-name'),
                (XLINKNS,'href'),
                (XLINKNS,'type'),
        ),
        (STYLENS,'background-image'):(
                (DRAWNS,'opacity'),
                (STYLENS,'repeat'),
                (XLINKNS,'show'),
                (XLINKNS,'actuate'),
                (STYLENS,'filter-name'),
                (XLINKNS,'href'),
                (STYLENS,'position'),
                (XLINKNS,'type'),
        ),
        (STYLENS,'chart-properties'): (
                (CHARTNS,'connect-bars'),
                (CHARTNS,'data-label-number'),
                (CHARTNS,'data-label-symbol'),
                (CHARTNS,'data-label-text'),
                (CHARTNS,'deep'),
                (CHARTNS,'display-label'),
                (CHARTNS,'error-category'),
                (CHARTNS,'error-lower-indicator'),
                (CHARTNS,'error-lower-limit'),
                (CHARTNS,'error-margin'),
                (CHARTNS,'error-percentage'),
                (CHARTNS,'error-upper-indicator'),
                (CHARTNS,'error-upper-limit'),
                (CHARTNS,'gap-width'),
                (CHARTNS,'interpolation'),
                (CHARTNS,'interval-major'),
                (CHARTNS,'interval-minor-divisor'),
                (CHARTNS,'japanese-candle-stick'),
                (CHARTNS,'label-arrangement'),
                (CHARTNS,'lines'),
                (CHARTNS,'link-data-style-to-source'),
                (CHARTNS,'logarithmic'),
                (CHARTNS,'maximum'),
                (CHARTNS,'mean-value'),
                (CHARTNS,'minimum'),
                (CHARTNS,'origin'),
                (CHARTNS,'overlap'),
                (CHARTNS,'percentage'),
                (CHARTNS,'pie-offset'),
                (CHARTNS,'regression-type'),
                (CHARTNS,'scale-text'),
                (CHARTNS,'series-source'),
                (CHARTNS,'solid-type'),
                (CHARTNS,'spline-order'),
                (CHARTNS,'spline-resolution'),
                (CHARTNS,'stacked'),
                (CHARTNS,'symbol-height'),
                (CHARTNS,'symbol-name'),
                (CHARTNS,'symbol-type'),
                (CHARTNS,'symbol-width'),
                (CHARTNS,'text-overlap'),
                (CHARTNS,'three-dimensional'),
                (CHARTNS,'tick-marks-major-inner'),
                (CHARTNS,'tick-marks-major-outer'),
                (CHARTNS,'tick-marks-minor-inner'),
                (CHARTNS,'tick-marks-minor-outer'),
                (CHARTNS,'vertical'),
                (CHARTNS,'visible'),
                (STYLENS,'direction'),
                (STYLENS,'rotation-angle'),
                (TEXTNS,'line-break'),
        ),
        (STYLENS,'column'):(
                (FONS,'end-indent'),
                (FONS,'space-before'),
                (FONS,'start-indent'),
                (FONS,'space-after'),
                (STYLENS,'rel-width'),
        ),
        (STYLENS,'column-sep'):(
                (STYLENS,'color'),
                (STYLENS,'width'),
                (STYLENS,'style'),
                (STYLENS,'vertical-align'),
                (STYLENS,'height'),
        ),
        (STYLENS,'columns'):(
                (FONS,'column-count'),
                (FONS,'column-gap'),
        ),
        (STYLENS,'default-style'):(
                (STYLENS,'family'),
        ),
# allowed_attributes
        (STYLENS,'drawing-page-properties'): (
                (DRAWNS,'fill'),
                (DRAWNS,'fill-color'),
                (DRAWNS,'secondary-fill-color'),
                (DRAWNS,'fill-gradient-name'),
                (DRAWNS,'gradient-step-count'),
                (DRAWNS,'fill-hatch-name'),
                (DRAWNS,'fill-hatch-solid'),
                (DRAWNS,'fill-image-name'),
                (STYLENS,'repeat'),
                (DRAWNS,'fill-image-width'),
                (DRAWNS,'fill-image-height'),
                (DRAWNS,'fill-image-ref-point-x'),
                (DRAWNS,'fill-image-ref-point-y'),
                (DRAWNS,'fill-image-ref-point'),
                (DRAWNS,'tile-repeat-offset'),
                (DRAWNS,'opacity'),
                (DRAWNS,'opacity-name'),
                (SVGNS,'fill-rule'),
                (PRESENTATIONNS,'transition-type'),
                (PRESENTATIONNS,'transition-style'),
                (PRESENTATIONNS,'transition-speed'),
                (SMILNS,'type'),
                (SMILNS,'subtype'),
                (SMILNS,'direction'),
                (SMILNS,'fadeColor'),
                (PRESENTATIONNS,'duration'),
                (PRESENTATIONNS,'visibility'),
                (DRAWNS,'background-size'),
                (PRESENTATIONNS,'background-objects-visible'),
                (PRESENTATIONNS,'background-visible'),
                (PRESENTATIONNS,'display-header'),
                (PRESENTATIONNS,'display-footer'),
                (PRESENTATIONNS,'display-page-number'),
                (PRESENTATIONNS,'display-date-time'),
        ),
        (STYLENS,'drop-cap'):(
                (STYLENS,'distance'),
                (STYLENS,'length'),
                (STYLENS,'style-name'),
                (STYLENS,'lines'),
        ),
# allowed_attributes
        (STYLENS,'font-face'):(
                (STYLENS,'font-adornments'),
                (STYLENS,'font-charset'),
                (STYLENS,'font-family-generic'),
                (STYLENS,'font-pitch'),
                (STYLENS,'name'),
                (SVGNS,'accent-height'),
                (SVGNS,'alphabetic'),
                (SVGNS,'ascent'),
                (SVGNS,'bbox'),
                (SVGNS,'cap-height'),
                (SVGNS,'descent'),
                (SVGNS,'font-family'),
                (SVGNS,'font-size'),
                (SVGNS,'font-stretch'),
                (SVGNS,'font-style'),
                (SVGNS,'font-variant'),
                (SVGNS,'font-weight'),
                (SVGNS,'hanging'),
                (SVGNS,'ideographic'),
                (SVGNS,'mathematical'),
                (SVGNS,'overline-position'),
                (SVGNS,'overline-thickness'),
                (SVGNS,'panose-1'),
                (SVGNS,'slope'),
                (SVGNS,'stemh'),
                (SVGNS,'stemv'),
                (SVGNS,'strikethrough-position'),
                (SVGNS,'strikethrough-thickness'),
                (SVGNS,'underline-position'),
                (SVGNS,'underline-thickness'),
                (SVGNS,'unicode-range'),
                (SVGNS,'units-per-em'),
                (SVGNS,'v-alphabetic'),
                (SVGNS,'v-hanging'),
                (SVGNS,'v-ideographic'),
                (SVGNS,'v-mathematical'),
                (SVGNS,'widths'),
                (SVGNS,'x-height'),
        ),
        (STYLENS,'footer'):(
                (STYLENS,'display'),
        ),
        (STYLENS,'footer-left'):(
                (STYLENS,'display'),
        ),
        (STYLENS,'footer-style'):(
        ),
        (STYLENS,'footnote-sep'):(
                (STYLENS,'distance-after-sep'),
                (STYLENS,'color'),
                (STYLENS,'rel-width'),
                (STYLENS,'width'),
                (STYLENS,'distance-before-sep'),
                (STYLENS,'line-style'),
                (STYLENS,'adjustment'),
        ),
# allowed_attributes
        (STYLENS,'graphic-properties'): (
                (DR3DNS,'ambient-color'),
                (DR3DNS,'back-scale'),
                (DR3DNS,'backface-culling'),
                (DR3DNS,'close-back'),
                (DR3DNS,'close-front'),
                (DR3DNS,'depth'),
                (DR3DNS,'diffuse-color'),
                (DR3DNS,'edge-rounding'),
                (DR3DNS,'edge-rounding-mode'),
                (DR3DNS,'emissive-color'),
                (DR3DNS,'end-angle'),
                (DR3DNS,'horizontal-segments'),
                (DR3DNS,'lighting-mode'),
                (DR3DNS,'normals-direction'),
                (DR3DNS,'normals-kind'),
                (DR3DNS,'shadow'),
                (DR3DNS,'shininess'),
                (DR3DNS,'specular-color'),
                (DR3DNS,'texture-filter'),
                (DR3DNS,'texture-generation-mode-x'),
                (DR3DNS,'texture-generation-mode-y'),
                (DR3DNS,'texture-kind'),
                (DR3DNS,'texture-mode'),
                (DR3DNS,'vertical-segments'),
                (DRAWNS,'auto-grow-height'),
                (DRAWNS,'auto-grow-width'),
                (DRAWNS,'blue'),
                (DRAWNS,'caption-angle'),
                (DRAWNS,'caption-angle-type'),
                (DRAWNS,'caption-escape'),
                (DRAWNS,'caption-escape-direction'),
                (DRAWNS,'caption-fit-line-length'),
                (DRAWNS,'caption-gap'),
                (DRAWNS,'caption-line-length'),
                (DRAWNS,'caption-type'),
                (DRAWNS,'color-inversion'),
                (DRAWNS,'color-mode'),
                (DRAWNS,'contrast'),
                (DRAWNS,'decimal-places'),
                (DRAWNS,'end-guide'),
                (DRAWNS,'end-line-spacing-horizontal'),
                (DRAWNS,'end-line-spacing-vertical'),
                (DRAWNS,'fill'),
                (DRAWNS,'fill-color'),
                (DRAWNS,'fill-gradient-name'),
                (DRAWNS,'fill-hatch-name'),
                (DRAWNS,'fill-hatch-solid'),
                (DRAWNS,'fill-image-height'),
                (DRAWNS,'fill-image-name'),
                (DRAWNS,'fill-image-ref-point'),
                (DRAWNS,'fill-image-ref-point-x'),
                (DRAWNS,'fill-image-ref-point-y'),
                (DRAWNS,'fill-image-width'),
# allowed_attributes
                (DRAWNS,'fit-to-contour'),
                (DRAWNS,'fit-to-size'),
                (DRAWNS,'frame-display-border'),
                (DRAWNS,'frame-display-scrollbar'),
                (DRAWNS,'frame-margin-horizontal'),
                (DRAWNS,'frame-margin-vertical'),
                (DRAWNS,'gamma'),
                (DRAWNS,'gradient-step-count'),
                (DRAWNS,'green'),
                (DRAWNS,'guide-distance'),
                (DRAWNS,'guide-overhang'),
                (DRAWNS,'image-opacity'),
                (DRAWNS,'line-distance'),
                (DRAWNS,'luminance'),
                (DRAWNS,'marker-end'),
                (DRAWNS,'marker-end-center'),
                (DRAWNS,'marker-end-width'),
                (DRAWNS,'marker-start'),
                (DRAWNS,'marker-start-center'),
                (DRAWNS,'marker-start-width'),
                (DRAWNS,'measure-align'),
                (DRAWNS,'measure-vertical-align'),
                (DRAWNS,'ole-draw-aspect'),
                (DRAWNS,'opacity'),
                (DRAWNS,'opacity-name'),
                (DRAWNS,'parallel'),
                (DRAWNS,'placing'),
                (DRAWNS,'red'),
                (DRAWNS,'secondary-fill-color'),
                (DRAWNS,'shadow'),
                (DRAWNS,'shadow-color'),
                (DRAWNS,'shadow-offset-x'),
                (DRAWNS,'shadow-offset-y'),
                (DRAWNS,'shadow-opacity'),
                (DRAWNS,'show-unit'),
                (DRAWNS,'start-guide'),
                (DRAWNS,'start-line-spacing-horizontal'),
                (DRAWNS,'start-line-spacing-vertical'),
                (DRAWNS,'stroke'),
                (DRAWNS,'stroke-dash'),
                (DRAWNS,'stroke-dash-names'),
                (DRAWNS,'stroke-linejoin'),
                (DRAWNS,'symbol-color'),
                (DRAWNS,'textarea-horizontal-align'),
                (DRAWNS,'textarea-vertical-align'),
                (DRAWNS,'tile-repeat-offset'),
                (DRAWNS,'unit'),
                (DRAWNS,'visible-area-height'),
                (DRAWNS,'visible-area-left'),
                (DRAWNS,'visible-area-top'),
                (DRAWNS,'visible-area-width'),
                (DRAWNS,'wrap-influence-on-position'),
# allowed_attributes
                (FONS,'background-color'),
                (FONS,'border'),
                (FONS,'border-bottom'),
                (FONS,'border-left'),
                (FONS,'border-right'),
                (FONS,'border-top'),
                (FONS,'clip'),
                (FONS,'margin'),
                (FONS,'margin-bottom'),
                (FONS,'margin-left'),
                (FONS,'margin-right'),
                (FONS,'margin-top'),
                (FONS,'max-height'),
                (FONS,'max-width'),
                (FONS,'min-height'),
                (FONS,'min-width'),
                (FONS,'padding'),
                (FONS,'padding-bottom'),
                (FONS,'padding-left'),
                (FONS,'padding-right'),
                (FONS,'padding-top'),
                (FONS,'wrap-option'),
                (STYLENS,'border-line-width'),
                (STYLENS,'border-line-width-bottom'),
                (STYLENS,'border-line-width-left'),
                (STYLENS,'border-line-width-right'),
                (STYLENS,'border-line-width-top'),
                (STYLENS,'editable'),
                (STYLENS,'flow-with-text'),
                (STYLENS,'horizontal-pos'),
                (STYLENS,'horizontal-rel'),
                (STYLENS,'mirror'),
                (STYLENS,'number-wrapped-paragraphs'),
                (STYLENS,'overflow-behavior'),
                (STYLENS,'print-content'),
                (STYLENS,'protect'),
                (STYLENS,'rel-height'),
                (STYLENS,'rel-width'),
                (STYLENS,'repeat'),
                (STYLENS,'run-through'),
                (STYLENS,'shadow'),
                (STYLENS,'vertical-pos'),
                (STYLENS,'vertical-rel'),
                (STYLENS,'wrap'),
                (STYLENS,'wrap-contour'),
                (STYLENS,'wrap-contour-mode'),
                (STYLENS,'wrap-dynamic-threshold'),
                (STYLENS,'writing-mode'),
                (SVGNS,'fill-rule'),
                (SVGNS,'height'),
                (SVGNS,'stroke-color'),
                (SVGNS,'stroke-opacity'),
                (SVGNS,'stroke-width'),
                (SVGNS,'width'),
                (SVGNS,'x'),
                (SVGNS,'y'),
                (TEXTNS,'anchor-page-number'),
                (TEXTNS,'anchor-type'),
                (TEXTNS,'animation'),
                (TEXTNS,'animation-delay'),
                (TEXTNS,'animation-direction'),
                (TEXTNS,'animation-repeat'),
                (TEXTNS,'animation-start-inside'),
                (TEXTNS,'animation-steps'),
                (TEXTNS,'animation-stop-inside'),
        ),
        (STYLENS,'handout-master'):(
                (PRESENTATIONNS,'presentation-page-layout-name'),
                (STYLENS,'page-layout-name'),
                (PRESENTATIONNS,'use-footer-name'),
                (DRAWNS,'style-name'),
                (PRESENTATIONNS,'use-header-name'),
                (PRESENTATIONNS,'use-date-time-name'),
        ),
# allowed_attributes
        (STYLENS,'header'):(
                (STYLENS,'display'),
        ),
        (STYLENS,'header-footer-properties'): (
                (FONS,'background-color'),
                (FONS,'border'),
                (FONS,'border-bottom'),
                (FONS,'border-left'),
                (FONS,'border-right'),
                (FONS,'border-top'),
                (FONS,'margin'),
                (FONS,'margin-bottom'),
                (FONS,'margin-left'),
                (FONS,'margin-right'),
                (FONS,'margin-top'),
                (FONS,'min-height'),
                (FONS,'padding'),
                (FONS,'padding-bottom'),
                (FONS,'padding-left'),
                (FONS,'padding-right'),
                (FONS,'padding-top'),
                (STYLENS,'border-line-width'),
                (STYLENS,'border-line-width-bottom'),
                (STYLENS,'border-line-width-left'),
                (STYLENS,'border-line-width-right'),
                (STYLENS,'border-line-width-top'),
                (STYLENS,'dynamic-spacing'),
                (STYLENS,'shadow'),
                (SVGNS,'height'),
        ),
        (STYLENS,'header-left'):(
                (STYLENS,'display'),
        ),
        (STYLENS,'header-style'):(
        ),
# allowed_attributes
        (STYLENS,'list-level-properties'): (
                (FONS,'height'),
                (FONS,'text-align'),
                (FONS,'width'),
                (STYLENS,'font-name'),
                (STYLENS,'vertical-pos'),
                (STYLENS,'vertical-rel'),
                (SVGNS,'y'),
                (TEXTNS,'min-label-distance'),
                (TEXTNS,'min-label-width'),
                (TEXTNS,'space-before'),
        ),
        (STYLENS,'map'):(
                (STYLENS,'apply-style-name'),
                (STYLENS,'base-cell-address'),
                (STYLENS,'condition'),
        ),
        (STYLENS,'master-page'):(
                (STYLENS,'page-layout-name'),
                (STYLENS,'display-name'),
                (DRAWNS,'style-name'),
                (STYLENS,'name'),
                (STYLENS,'next-style-name'),
        ),
        (STYLENS,'page-layout'):(
                (STYLENS,'name'),
                (STYLENS,'page-usage'),
        ),
# allowed_attributes
        (STYLENS,'page-layout-properties'): (
                (FONS,'background-color'),
                (FONS,'border'),
                (FONS,'border-bottom'),
                (FONS,'border-left'),
                (FONS,'border-right'),
                (FONS,'border-top'),
                (FONS,'margin'),
                (FONS,'margin-bottom'),
                (FONS,'margin-left'),
                (FONS,'margin-right'),
                (FONS,'margin-top'),
                (FONS,'padding'),
                (FONS,'padding-bottom'),
                (FONS,'padding-left'),
                (FONS,'padding-right'),
                (FONS,'padding-top'),
                (FONS,'page-height'),
                (FONS,'page-width'),
                (STYLENS,'border-line-width'),
                (STYLENS,'border-line-width-bottom'),
                (STYLENS,'border-line-width-left'),
                (STYLENS,'border-line-width-right'),
                (STYLENS,'border-line-width-top'),
                (STYLENS,'first-page-number'),
                (STYLENS,'footnote-max-height'),
                (STYLENS,'layout-grid-base-height'),
                (STYLENS,'layout-grid-color'),
                (STYLENS,'layout-grid-display'),
                (STYLENS,'layout-grid-lines'),
                (STYLENS,'layout-grid-mode'),
                (STYLENS,'layout-grid-print'),
                (STYLENS,'layout-grid-ruby-below'),
                (STYLENS,'layout-grid-ruby-height'),
                (STYLENS,'num-format'),
                (STYLENS,'num-letter-sync'),
                (STYLENS,'num-prefix'),
                (STYLENS,'num-suffix'),
                (STYLENS,'paper-tray-name'),
                (STYLENS,'print'),
                (STYLENS,'print-orientation'),
                (STYLENS,'print-page-order'),
                (STYLENS,'register-truth-ref-style-name'),
                (STYLENS,'scale-to'),
                (STYLENS,'scale-to-pages'),
                (STYLENS,'shadow'),
                (STYLENS,'table-centering'),
                (STYLENS,'writing-mode'),
        ),
# allowed_attributes
        (STYLENS,'paragraph-properties'): (
                (FONS,'background-color'),
                (FONS,'border'),
                (FONS,'border-bottom'),
                (FONS,'border-left'),
                (FONS,'border-right'),
                (FONS,'border-top'),
                (FONS,'break-after'),
                (FONS,'break-before'),
                (FONS,'hyphenation-keep'),
                (FONS,'hyphenation-ladder-count'),
                (FONS,'keep-together'),
                (FONS,'keep-with-next'),
                (FONS,'line-height'),
                (FONS,'margin'),
                (FONS,'margin-bottom'),
                (FONS,'margin-left'),
                (FONS,'margin-right'),
                (FONS,'margin-top'),
                (FONS,'orphans'),
                (FONS,'padding'),
                (FONS,'padding-bottom'),
                (FONS,'padding-left'),
                (FONS,'padding-right'),
                (FONS,'padding-top'),
                (FONS,'text-align'),
                (FONS,'text-align-last'),
                (FONS,'text-indent'),
                (FONS,'widows'),
                (STYLENS,'auto-text-indent'),
                (STYLENS,'background-transparency'),
                (STYLENS,'border-line-width'),
                (STYLENS,'border-line-width-bottom'),
                (STYLENS,'border-line-width-left'),
                (STYLENS,'border-line-width-right'),
                (STYLENS,'border-line-width-top'),
                (STYLENS,'font-independent-line-spacing'),
                (STYLENS,'justify-single-word'),
                (STYLENS,'line-break'),
                (STYLENS,'line-height-at-least'),
                (STYLENS,'line-spacing'),
                (STYLENS,'page-number'),
                (STYLENS,'punctuation-wrap'),
                (STYLENS,'register-true'),
                (STYLENS,'shadow'),
                (STYLENS,'snap-to-layout-grid'),
                (STYLENS,'tab-stop-distance'),
                (STYLENS,'text-autospace'),
                (STYLENS,'vertical-align'),
                (STYLENS,'writing-mode'),
                (STYLENS,'writing-mode-automatic'),
                (TEXTNS,'line-number'),
                (TEXTNS,'number-lines'),
        ),
        (STYLENS,'presentation-page-layout'):(
                (STYLENS,'display-name'),
                (STYLENS,'name'),
        ),
# allowed_attributes
        (STYLENS,'region-center'):(
        ),
        (STYLENS,'region-left'):(
        ),
        (STYLENS,'region-right'):(
        ),
        (STYLENS,'ruby-properties'): (
                (STYLENS,'ruby-position'),
                (STYLENS,'ruby-align'),
        ),
        (STYLENS,'section-properties'): (
                (FONS,'background-color'),
                (FONS,'margin-left'),
                (FONS,'margin-right'),
                (STYLENS,'protect'),
                (STYLENS,'writing-mode'),
                (TEXTNS,'dont-balance-text-columns'),
        ),
        (STYLENS,'style'):(
                (STYLENS,'family'),
                (STYLENS,'list-style-name'),
                (STYLENS,'name'),
                (STYLENS,'auto-update'),
                (STYLENS,'default-outline-level'),
                (STYLENS,'class'),
                (STYLENS,'next-style-name'),
                (STYLENS,'data-style-name'),
                (STYLENS,'master-page-name'),
                (STYLENS,'display-name'),
                (STYLENS,'parent-style-name'),
        ),
# allowed_attributes
        (STYLENS,'tab-stop'):(
                (STYLENS,'leader-text-style'),
                (STYLENS,'leader-width'),
                (STYLENS,'leader-style'),
                (STYLENS,'char'),
                (STYLENS,'leader-color'),
                (STYLENS,'position'),
                (STYLENS,'leader-text'),
                (STYLENS,'type'),
                (STYLENS,'leader-type'),
        ),
        (STYLENS,'tab-stops'):(
        ),
        (STYLENS,'table-cell-properties'): (
                (FONS,'background-color'),
                (FONS,'border'),
                (FONS,'border-bottom'),
                (FONS,'border-left'),
                (FONS,'border-right'),
                (FONS,'border-top'),
                (FONS,'padding'),
                (FONS,'padding-bottom'),
                (FONS,'padding-left'),
                (FONS,'padding-right'),
                (FONS,'padding-top'),
                (FONS,'wrap-option'),
                (STYLENS,'border-line-width'),
                (STYLENS,'border-line-width-bottom'),
                (STYLENS,'border-line-width-left'),
                (STYLENS,'border-line-width-right'),
                (STYLENS,'border-line-width-top'),
                (STYLENS,'cell-protect'),
                (STYLENS,'decimal-places'),
                (STYLENS,'diagonal-bl-tr'),
                (STYLENS,'diagonal-bl-tr-widths'),
                (STYLENS,'diagonal-tl-br'),
                (STYLENS,'diagonal-tl-br-widths'),
                (STYLENS,'direction'),
                (STYLENS,'glyph-orientation-vertical'),
                (STYLENS,'print-content'),
                (STYLENS,'repeat-content'),
                (STYLENS,'rotation-align'),
                (STYLENS,'rotation-angle'),
                (STYLENS,'shadow'),
                (STYLENS,'shrink-to-fit'),
                (STYLENS,'text-align-source'),
                (STYLENS,'vertical-align'),
        ),
# allowed_attributes
        (STYLENS,'table-column-properties'): (
                (FONS,'break-after'),
                (FONS,'break-before'),
                (STYLENS,'column-width'),
                (STYLENS,'rel-column-width'),
                (STYLENS,'use-optimal-column-width'),
        ),
        (STYLENS,'table-properties'): (
                (FONS,'background-color'),
                (FONS,'break-after'),
                (FONS,'break-before'),
                (FONS,'keep-with-next'),
                (FONS,'margin'),
                (FONS,'margin-bottom'),
                (FONS,'margin-left'),
                (FONS,'margin-right'),
                (FONS,'margin-top'),
                (STYLENS,'may-break-between-rows'),
                (STYLENS,'page-number'),
                (STYLENS,'rel-width'),
                (STYLENS,'shadow'),
                (STYLENS,'width'),
                (STYLENS,'writing-mode'),
                (TABLENS,'align'),
                (TABLENS,'border-model'),
                (TABLENS,'display'),
        ),
        (STYLENS,'table-row-properties'): (
                (FONS,'background-color'),
                (FONS,'break-after'),
                (FONS,'break-before'),
                (FONS,'keep-together'),
                (STYLENS,'min-row-height'),
                (STYLENS,'row-height'),
                (STYLENS,'use-optimal-row-height'),
        ),
# allowed_attributes
        (STYLENS,'text-properties'): (
                (FONS,'background-color'),
                (FONS,'color'),
                (FONS,'country'),
                (FONS,'font-family'),
                (FONS,'font-size'),
                (FONS,'font-style'),
                (FONS,'font-variant'),
                (FONS,'font-weight'),
                (FONS,'hyphenate'),
                (FONS,'hyphenation-push-char-count'),
                (FONS,'hyphenation-remain-char-count'),
                (FONS,'language'),
                (FONS,'letter-spacing'),
                (FONS,'text-shadow'),
                (FONS,'text-transform'),
                (STYLENS,'country-asian'),
                (STYLENS,'country-complex'),
                (STYLENS,'font-charset'),
                (STYLENS,'font-charset-asian'),
                (STYLENS,'font-charset-complex'),
                (STYLENS,'font-family-asian'),
                (STYLENS,'font-family-complex'),
                (STYLENS,'font-family-generic'),
                (STYLENS,'font-family-generic-asian'),
                (STYLENS,'font-family-generic-complex'),
                (STYLENS,'font-name'),
                (STYLENS,'font-name-asian'),
                (STYLENS,'font-name-complex'),
                (STYLENS,'font-pitch'),
                (STYLENS,'font-pitch-asian'),
                (STYLENS,'font-pitch-complex'),
                (STYLENS,'font-relief'),
                (STYLENS,'font-size-asian'),
                (STYLENS,'font-size-complex'),
                (STYLENS,'font-size-rel'),
                (STYLENS,'font-size-rel-asian'),
                (STYLENS,'font-size-rel-complex'),
                (STYLENS,'font-style-asian'),
                (STYLENS,'font-style-complex'),
                (STYLENS,'font-style-name'),
                (STYLENS,'font-style-name-asian'),
                (STYLENS,'font-style-name-complex'),
                (STYLENS,'font-weight-asian'),
                (STYLENS,'font-weight-complex'),
                (STYLENS,'language-asian'),
                (STYLENS,'language-complex'),
                (STYLENS,'letter-kerning'),
                (STYLENS,'script-type'),
                (STYLENS,'text-blinking'),
                (STYLENS,'text-combine'),
                (STYLENS,'text-combine-end-char'),
                (STYLENS,'text-combine-start-char'),
                (STYLENS,'text-emphasize'),
                (STYLENS,'text-line-through-color'),
                (STYLENS,'text-line-through-mode'),
                (STYLENS,'text-line-through-style'),
                (STYLENS,'text-line-through-text'),
                (STYLENS,'text-line-through-text-style'),
                (STYLENS,'text-line-through-type'),
                (STYLENS,'text-line-through-width'),
                (STYLENS,'text-outline'),
                (STYLENS,'text-position'),
                (STYLENS,'text-rotation-angle'),
                (STYLENS,'text-rotation-scale'),
                (STYLENS,'text-scale'),
                (STYLENS,'text-underline-color'),
                (STYLENS,'text-underline-mode'),
                (STYLENS,'text-underline-style'),
                (STYLENS,'text-underline-type'),
                (STYLENS,'text-underline-width'),
                (STYLENS,'use-window-font-color'),
                (TEXTNS,'condition'),
                (TEXTNS,'display'),
        ),
        (SVGNS,'definition-src'):(
                (XLINKNS,'actuate'),
                (XLINKNS,'href'),
                (XLINKNS,'type'),
        ),
        (SVGNS,'desc'):(
        ),
        (SVGNS,'font-face-format'):(
                (SVGNS,'string'),
        ),
# allowed_attributes
        (SVGNS,'font-face-name'):(
                (SVGNS,'name'),
        ),
        (SVGNS,'font-face-src'):(
        ),
        (SVGNS,'font-face-uri'):(
                (XLINKNS,'actuate'),
                (XLINKNS,'href'),
                (XLINKNS,'type'),
        ),
        (SVGNS,'linearGradient'):(
                (SVGNS,'y2'),
                (DRAWNS,'name'),
                (SVGNS,'spreadMethod'),
                (SVGNS,'gradientUnits'),
                (SVGNS,'x2'),
                (SVGNS,'gradientTransform'),
                (SVGNS,'y1'),
                (DRAWNS,'display-name'),
                (SVGNS,'x1'),
        ),
        (SVGNS,'radialGradient'):(
                (DRAWNS,'name'),
                (SVGNS,'fx'),
                (SVGNS,'fy'),
                (SVGNS,'spreadMethod'),
                (SVGNS,'gradientUnits'),
                (SVGNS,'cy'),
                (SVGNS,'cx'),
                (SVGNS,'gradientTransform'),
                (DRAWNS,'display-name'),
                (SVGNS,'r'),
        ),
        (SVGNS,'stop'):(
                (SVGNS,'stop-color'),
                (SVGNS,'stop-opacity'),
                (SVGNS,'offset'),
        ),
        (SVGNS,'title'):(
        ),
# allowed_attributes
        (TABLENS,'body'):(
                (TEXTNS,'paragraph-style-name'),
                (TEXTNS,'style-name'),
        ),
        (TABLENS,'calculation-settings'):(
                (TABLENS,'automatic-find-labels'),
                (TABLENS,'case-sensitive'),
                (TABLENS,'search-criteria-must-apply-to-whole-cell'),
                (TABLENS,'precision-as-shown'),
                (TABLENS,'use-regular-expressions'),
                (TABLENS,'null-year'),
        ),
        (TABLENS,'cell-address'):(
                (TABLENS,'column'),
                (TABLENS,'table'),
                (TABLENS,'row'),
        ),
        (TABLENS,'cell-content-change'):(
                (TABLENS,'id'),
                (TABLENS,'rejecting-change-id'),
                (TABLENS,'acceptance-state'),
        ),
        (TABLENS,'cell-content-deletion'):(
                (TABLENS,'id'),
        ),
        (TABLENS,'cell-range-source'):(
                (TABLENS,'last-row-spanned'),
                (TABLENS,'last-column-spanned'),
                (TABLENS,'name'),
                (TABLENS,'filter-options'),
                (XLINKNS,'actuate'),
                (TABLENS,'filter-name'),
                (XLINKNS,'href'),
                (TABLENS,'refresh-delay'),
                (XLINKNS,'type'),
        ),
        (TABLENS,'change-deletion'):(
                (TABLENS,'id'),
        ),
        (TABLENS,'change-track-table-cell'):(
                (OFFICENS,'string-value'),
                (TABLENS,'cell-address'),
                (TABLENS,'number-matrix-columns-spanned'),
                (TABLENS,'number-matrix-rows-spanned'),
                (TABLENS,'matrix-covered'),
                (OFFICENS,'value-type'),
                (OFFICENS,'boolean-value'),
                (OFFICENS,'currency'),
                (OFFICENS,'date-value'),
                (OFFICENS,'value'),
                (TABLENS,'formula'),
                (OFFICENS,'time-value'),
        ),
        (TABLENS,'consolidation'):(
                (TABLENS,'function'),
                (TABLENS,'source-cell-range-addresses'),
                (TABLENS,'target-cell-address'),
                (TABLENS,'link-to-source-data'),
                (TABLENS,'use-labels'),
        ),
        (TABLENS,'content-validation'):(
                (TABLENS,'base-cell-address'),
                (TABLENS,'display-list'),
                (TABLENS,'allow-empty-cell'),
                (TABLENS,'name'),
                (TABLENS,'condition'),
        ),
        (TABLENS,'content-validations'):(
        ),
# allowed_attributes
        (TABLENS,'covered-table-cell'):(
                (TABLENS,'protect'),
                (OFFICENS,'string-value'),
                (OFFICENS,'value'),
                (OFFICENS,'boolean-value'),
                (OFFICENS,'currency'),
                (OFFICENS,'date-value'),
                (TABLENS,'style-name'),
                (TABLENS,'content-validation-name'),
                (OFFICENS,'value-type'),
                (TABLENS,'number-columns-repeated'),
                (TABLENS,'formula'),
                (OFFICENS,'time-value'),
        ),
        (TABLENS,'cut-offs'):(
        ),
        (TABLENS,'data-pilot-display-info'):(
                (TABLENS,'member-count'),
                (TABLENS,'data-field'),
                (TABLENS,'enabled'),
                (TABLENS,'display-member-mode'),
        ),
        (TABLENS,'data-pilot-field'):(
                (TABLENS,'selected-page'),
                (TABLENS,'function'),
                (TABLENS,'orientation'),
                (TABLENS,'used-hierarchy'),
                (TABLENS,'is-data-layout-field'),
                (TABLENS,'source-field-name'),
        ),
        (TABLENS,'data-pilot-field-reference'):(
                (TABLENS,'member-name'),
                (TABLENS,'field-name'),
                (TABLENS,'member-type'),
                (TABLENS,'type'),
        ),
# allowed_attributes
        (TABLENS,'data-pilot-group'):(
                (TABLENS,'name'),
        ),
        (TABLENS,'data-pilot-group-member'):(
                (TABLENS,'name'),
        ),
        (TABLENS,'data-pilot-groups'):(
                (TABLENS,'date-end'),
                (TABLENS,'end'),
                (TABLENS,'start'),
                (TABLENS,'source-field-name'),
                (TABLENS,'step'),
                (TABLENS,'date-start'),
                (TABLENS,'grouped-by'),
        ),
        (TABLENS,'data-pilot-layout-info'):(
                (TABLENS,'add-empty-lines'),
                (TABLENS,'layout-mode'),
        ),
        (TABLENS,'data-pilot-level'):(
                (TABLENS,'show-empty'),
        ),
# allowed_attributes
        (TABLENS,'data-pilot-member'):(
                (TABLENS,'show-details'),
                (TABLENS,'name'),
                (TABLENS,'display'),
        ),
        (TABLENS,'data-pilot-members'):(
        ),
        (TABLENS,'data-pilot-sort-info'):(
                (TABLENS,'data-field'),
                (TABLENS,'sort-mode'),
                (TABLENS,'order'),
        ),
        (TABLENS,'data-pilot-subtotal'):(
                (TABLENS,'function'),
        ),
        (TABLENS,'data-pilot-subtotals'):(
        ),
        (TABLENS,'data-pilot-table'):(
                (TABLENS,'buttons'),
                (TABLENS,'application-data'),
                (TABLENS,'name'),
                (TABLENS,'drill-down-on-double-click'),
                (TABLENS,'target-range-address'),
                (TABLENS,'ignore-empty-rows'),
                (TABLENS,'identify-categories'),
                (TABLENS,'show-filter-button'),
                (TABLENS,'grand-total'),
        ),
# allowed_attributes
        (TABLENS,'data-pilot-tables'):(
        ),
        (TABLENS,'database-range'):(
                (TABLENS,'orientation'),
                (TABLENS,'target-range-address'),
                (TABLENS,'contains-header'),
                (TABLENS,'on-update-keep-size'),
                (TABLENS,'name'),
                (TABLENS,'is-selection'),
                (TABLENS,'refresh-delay'),
                (TABLENS,'display-filter-buttons'),
                (TABLENS,'has-persistent-data'),
                (TABLENS,'on-update-keep-styles'),
        ),
        (TABLENS,'database-ranges'):(
        ),
        (TABLENS,'database-source-query'):(
                (TABLENS,'query-name'),
                (TABLENS,'database-name'),
        ),
# allowed_attributes
        (TABLENS,'database-source-sql'):(
                (TABLENS,'parse-sql-statement'),
                (TABLENS,'database-name'),
                (TABLENS,'sql-statement'),
        ),
        (TABLENS,'database-source-table'):(
                (TABLENS,'database-table-name'),
                (TABLENS,'database-name'),
        ),
        (TABLENS,'dde-link'):(
        ),
        (TABLENS,'dde-links'):(
        ),
        (TABLENS,'deletion'):(
                (TABLENS,'rejecting-change-id'),
                (TABLENS,'multi-deletion-spanned'),
                (TABLENS,'acceptance-state'),
                (TABLENS,'table'),
                (TABLENS,'position'),
                (TABLENS,'type'),
                (TABLENS,'id'),
        ),
# allowed_attributes
        (TABLENS,'deletions'):(
        ),
        (TABLENS,'dependencies'):(
        ),
        (TABLENS,'dependency'):(
                (TABLENS,'id'),
        ),
        (TABLENS,'detective'):(
        ),
        (TABLENS,'error-macro'):(
                (TABLENS,'execute'),
        ),
        (TABLENS,'error-message'):(
                (TABLENS,'display'),
                (TABLENS,'message-type'),
                (TABLENS,'title'),
        ),
        (TABLENS,'even-columns'):(
                (TEXTNS,'paragraph-style-name'),
                (TEXTNS,'style-name'),
        ),
        (TABLENS,'even-rows'):(
                (TEXTNS,'paragraph-style-name'),
                (TEXTNS,'style-name'),
        ),
# allowed_attributes
        (TABLENS,'filter'):(
                (TABLENS,'target-range-address'),
                (TABLENS,'display-duplicates'),
                (TABLENS,'condition-source-range-address'),
                (TABLENS,'condition-source'),
        ),
        (TABLENS,'filter-and'):(
        ),
        (TABLENS,'filter-condition'):(
                (TABLENS,'operator'),
                (TABLENS,'field-number'),
                (TABLENS,'data-type'),
                (TABLENS,'case-sensitive'),
                (TABLENS,'value'),
        ),
        (TABLENS,'filter-or'):(
        ),
        (TABLENS,'first-column'):(
                (TEXTNS,'paragraph-style-name'),
                (TEXTNS,'style-name'),
        ),
        (TABLENS,'first-row'):(
                (TEXTNS,'paragraph-style-name'),
                (TEXTNS,'style-name'),
        ),
# allowed_attributes
        (TABLENS,'help-message'):(
                (TABLENS,'display'),
                (TABLENS,'title'),
        ),
        (TABLENS,'highlighted-range'):(
                (TABLENS,'contains-error'),
                (TABLENS,'direction'),
                (TABLENS,'marked-invalid'),
                (TABLENS,'cell-range-address'),
        ),
        (TABLENS,'insertion'):(
                (TABLENS,'count'),
                (TABLENS,'rejecting-change-id'),
                (TABLENS,'acceptance-state'),
                (TABLENS,'table'),
                (TABLENS,'position'),
                (TABLENS,'type'),
                (TABLENS,'id'),
        ),
        (TABLENS,'insertion-cut-off'):(
                (TABLENS,'position'),
                (TABLENS,'id'),
        ),
        (TABLENS,'iteration'):(
                (TABLENS,'status'),
                (TABLENS,'maximum-difference'),
                (TABLENS,'steps'),
        ),
# allowed_attributes
        (TABLENS,'label-range'):(
                (TABLENS,'label-cell-range-address'),
                (TABLENS,'data-cell-range-address'),
                (TABLENS,'orientation'),
        ),
        (TABLENS,'label-ranges'):(
        ),
        (TABLENS,'last-column'):(
                (TEXTNS,'paragraph-style-name'),
                (TEXTNS,'style-name'),
        ),
        (TABLENS,'last-row'):(
                (TEXTNS,'paragraph-style-name'),
                (TEXTNS,'style-name'),
        ),
        (TABLENS,'movement'):(
                (TABLENS,'id'),
                (TABLENS,'rejecting-change-id'),
                (TABLENS,'acceptance-state'),
        ),
        (TABLENS,'movement-cut-off'):(
                (TABLENS,'position'),
                (TABLENS,'end-position'),
                (TABLENS,'start-position'),
        ),
        (TABLENS,'named-expression'):(
                (TABLENS,'base-cell-address'),
                (TABLENS,'expression'),
                (TABLENS,'name'),
        ),
        (TABLENS,'named-expressions'):(
        ),
        (TABLENS,'named-range'):(
                (TABLENS,'range-usable-as'),
                (TABLENS,'base-cell-address'),
                (TABLENS,'name'),
                (TABLENS,'cell-range-address'),
        ),
        (TABLENS,'null-date'):(
                (TABLENS,'date-value'),
                (TABLENS,'value-type'),
        ),
        (TABLENS,'odd-columns'):(
                (TEXTNS,'paragraph-style-name'),
                (TEXTNS,'style-name'),
        ),
        (TABLENS,'odd-rows'):(
                (TEXTNS,'paragraph-style-name'),
                (TEXTNS,'style-name'),
        ),
        (TABLENS,'operation'):(
                (TABLENS,'index'),
                (TABLENS,'name'),
        ),
        (TABLENS,'previous'):(
                (TABLENS,'id'),
        ),
        (TABLENS,'scenario'):(
                (TABLENS,'comment'),
                (TABLENS,'border-color'),
                (TABLENS,'copy-back'),
                (TABLENS,'is-active'),
                (TABLENS,'protected'),
                (TABLENS,'copy-formulas'),
                (TABLENS,'copy-styles'),
                (TABLENS,'scenario-ranges'),
                (TABLENS,'display-border'),
        ),
        (TABLENS,'shapes'):(
        ),
        (TABLENS,'sort'):(
                (TABLENS,'case-sensitive'),
                (TABLENS,'algorithm'),
                (TABLENS,'target-range-address'),
                (TABLENS,'country'),
                (TABLENS,'language'),
                (TABLENS,'bind-styles-to-content'),
        ),
        (TABLENS,'sort-by'):(
                (TABLENS,'field-number'),
                (TABLENS,'data-type'),
                (TABLENS,'order'),
        ),
        (TABLENS,'sort-groups'):(
                (TABLENS,'data-type'),
                (TABLENS,'order'),
        ),
        (TABLENS,'source-cell-range'):(
                (TABLENS,'cell-range-address'),
        ),
        (TABLENS,'source-range-address'):(
                (TABLENS,'column'),
                (TABLENS,'end-column'),
                (TABLENS,'start-table'),
                (TABLENS,'end-row'),
                (TABLENS,'table'),
                (TABLENS,'start-row'),
                (TABLENS,'row'),
                (TABLENS,'end-table'),
                (TABLENS,'start-column'),
        ),
# allowed_attributes
        (TABLENS,'source-service'):(
                (TABLENS,'user-name'),
                (TABLENS,'source-name'),
                (TABLENS,'password'),
                (TABLENS,'object-name'),
                (TABLENS,'name'),
        ),
        (TABLENS,'subtotal-field'):(
                (TABLENS,'function'),
                (TABLENS,'field-number'),
        ),
        (TABLENS,'subtotal-rule'):(
                (TABLENS,'group-by-field-number'),
        ),
        (TABLENS,'subtotal-rules'):(
                (TABLENS,'bind-styles-to-content'),
                (TABLENS,'page-breaks-on-group-change'),
                (TABLENS,'case-sensitive'),
        ),
        (TABLENS,'table'):(
                (TABLENS,'name'),
                (TABLENS,'is-sub-table'),
                (TABLENS,'style-name'),
                (TABLENS,'protected'),
                (TABLENS,'print-ranges'),
                (TABLENS,'print'),
                (TABLENS,'protection-key'),
        ),
        (TABLENS,'table-cell'):(
                (TABLENS,'protect'),
                (TABLENS,'number-matrix-rows-spanned'),
                (TABLENS,'number-matrix-columns-spanned'),
                (OFFICENS,'string-value'),
                (TABLENS,'number-columns-spanned'),
                (OFFICENS,'value'),
                (OFFICENS,'boolean-value'),
                (OFFICENS,'currency'),
                (OFFICENS,'date-value'),
                (TABLENS,'style-name'),
                (TABLENS,'content-validation-name'),
                (OFFICENS,'value-type'),
                (TABLENS,'number-rows-spanned'),
                (TABLENS,'number-columns-repeated'),
                (TABLENS,'formula'),
                (OFFICENS,'time-value'),
        ),
# allowed_attributes
        (TABLENS,'table-column'):(
                (TABLENS,'style-name'),
                (TABLENS,'default-cell-style-name'),
                (TABLENS,'visibility'),
                (TABLENS,'number-columns-repeated'),
        ),
        (TABLENS,'table-column-group'):(
                (TABLENS,'display'),
        ),
        (TABLENS,'table-columns'):(
        ),
        (TABLENS,'table-header-columns'):(
        ),
        (TABLENS,'table-header-rows'):(
        ),
        (TABLENS,'table-row'):(
                (TABLENS,'number-rows-repeated'),
                (TABLENS,'style-name'),
                (TABLENS,'visibility'),
                (TABLENS,'default-cell-style-name'),
        ),
        (TABLENS,'table-row-group'):(
                (TABLENS,'display'),
        ),
        (TABLENS,'table-rows'):(
        ),
        (TABLENS,'table-source'):(
                (TABLENS,'filter-options'),
                (XLINKNS,'actuate'),
                (TABLENS,'filter-name'),
                (XLINKNS,'href'),
                (TABLENS,'mode'),
                (TABLENS,'table-name'),
                (XLINKNS,'type'),
                (TABLENS,'refresh-delay'),
        ),
        (TABLENS,'table-template'):(
                (TEXTNS,'last-row-end-column'),
                (TEXTNS,'first-row-end-column'),
                (TEXTNS,'name'),
                (TEXTNS,'last-row-start-column'),
                (TEXTNS,'first-row-start-column'),
        ),
        (TABLENS,'target-range-address'):(
                (TABLENS,'column'),
                (TABLENS,'end-column'),
                (TABLENS,'start-table'),
                (TABLENS,'end-row'),
                (TABLENS,'table'),
                (TABLENS,'start-row'),
                (TABLENS,'row'),
                (TABLENS,'end-table'),
                (TABLENS,'start-column'),
        ),
        (TABLENS,'tracked-changes'):(
                (TABLENS,'track-changes'),
        ),
# allowed_attributes
        (TEXTNS,'a'):(
                (TEXTNS,'visited-style-name'),
                (OFFICENS,'name'),
                (OFFICENS,'title'),
                (XLINKNS,'show'),
                (OFFICENS,'target-frame-name'),
                (XLINKNS,'actuate'),
                (TEXTNS,'style-name'),
                (XLINKNS,'href'),
                (XLINKNS,'type'),
        ),
        (TEXTNS,'alphabetical-index'):(
                (TEXTNS,'protected'),
                (TEXTNS,'style-name'),
                (TEXTNS,'name'),
                (TEXTNS,'protection-key'),
        ),
        (TEXTNS,'alphabetical-index-auto-mark-file'):(
                (XLINKNS,'href'),
                (XLINKNS,'type'),
        ),
        (TEXTNS,'alphabetical-index-entry-template'):(
                (TEXTNS,'style-name'),
                (TEXTNS,'outline-level'),
        ),
        (TEXTNS,'alphabetical-index-mark'):(
                (TEXTNS,'main-entry'),
                (TEXTNS,'key1-phonetic'),
                (TEXTNS,'key2'),
                (TEXTNS,'key1'),
                (TEXTNS,'string-value'),
                (TEXTNS,'key2-phonetic'),
                (TEXTNS,'string-value-phonetic'),
        ),
# allowed_attributes
        (TEXTNS,'alphabetical-index-mark-end'):(
                (TEXTNS,'id'),
        ),
        (TEXTNS,'alphabetical-index-mark-start'):(
                (TEXTNS,'main-entry'),
                (TEXTNS,'key1-phonetic'),
                (TEXTNS,'key2'),
                (TEXTNS,'key1'),
                (TEXTNS,'string-value-phonetic'),
                (TEXTNS,'key2-phonetic'),
                (TEXTNS,'id'),
        ),
        (TEXTNS,'alphabetical-index-source'):(
                (TEXTNS,'capitalize-entries'),
                (FONS,'language'),
                (TEXTNS,'relative-tab-stop-position'),
                (TEXTNS,'alphabetical-separators'),
                (TEXTNS,'combine-entries-with-pp'),
                (TEXTNS,'combine-entries-with-dash'),
                (TEXTNS,'sort-algorithm'),
                (TEXTNS,'ignore-case'),
                (TEXTNS,'combine-entries'),
                (TEXTNS,'comma-separated'),
                (FONS,'country'),
                (TEXTNS,'index-scope'),
                (TEXTNS,'main-entry-style-name'),
                (TEXTNS,'use-keys-as-entries'),
        ),
# allowed_attributes
        (TEXTNS,'author-initials'):(
                (TEXTNS,'fixed'),
        ),
        (TEXTNS,'author-name'):(
                (TEXTNS,'fixed'),
        ),
        (TEXTNS,'bibliography'):(
                (TEXTNS,'protected'),
                (TEXTNS,'style-name'),
                (TEXTNS,'name'),
                (TEXTNS,'protection-key'),
        ),
        (TEXTNS,'bibliography-configuration'):(
                (TEXTNS,'suffix'),
                (FONS,'language'),
                (TEXTNS,'numbered-entries'),
                (FONS,'country'),
                (TEXTNS,'sort-by-position'),
                (TEXTNS,'sort-algorithm'),
                (TEXTNS,'prefix'),
        ),
        (TEXTNS,'bibliography-entry-template'):(
                (TEXTNS,'style-name'),
                (TEXTNS,'bibliography-type'),
        ),
# allowed_attributes
        (TEXTNS,'bibliography-mark'):(
                (TEXTNS,'address'),
                (TEXTNS,'annote'),
                (TEXTNS,'author'),
                (TEXTNS,'bibliography-type'),
                (TEXTNS,'booktitle'),
                (TEXTNS,'chapter'),
                (TEXTNS,'custom1'),
                (TEXTNS,'custom2'),
                (TEXTNS,'custom3'),
                (TEXTNS,'custom4'),
                (TEXTNS,'custom5'),
                (TEXTNS,'edition'),
                (TEXTNS,'editor'),
                (TEXTNS,'howpublished'),
                (TEXTNS,'identifier'),
                (TEXTNS,'institution'),
                (TEXTNS,'isbn'),
                (TEXTNS,'issn'),
                (TEXTNS,'journal'),
                (TEXTNS,'month'),
                (TEXTNS,'note'),
                (TEXTNS,'number'),
                (TEXTNS,'organizations'),
                (TEXTNS,'pages'),
                (TEXTNS,'publisher'),
                (TEXTNS,'report-type'),
                (TEXTNS,'school'),
                (TEXTNS,'series'),
                (TEXTNS,'title'),
                (TEXTNS,'url'),
                (TEXTNS,'volume'),
                (TEXTNS,'year'),
        ),
        (TEXTNS,'bibliography-source'):(
        ),
        (TEXTNS,'bookmark'):(
                (TEXTNS,'name'),
        ),
        (TEXTNS,'bookmark-end'):(
                (TEXTNS,'name'),
        ),
        (TEXTNS,'bookmark-ref'):(
                (TEXTNS,'ref-name'),
                (TEXTNS,'reference-format'),
        ),
        (TEXTNS,'bookmark-start'):(
                (TEXTNS,'name'),
        ),
# allowed_attributes
        (TEXTNS,'change'):(
                (TEXTNS,'change-id'),
        ),
        (TEXTNS,'change-end'):(
                (TEXTNS,'change-id'),
        ),
        (TEXTNS,'change-start'):(
                (TEXTNS,'change-id'),
        ),
        (TEXTNS,'changed-region'):(
                (TEXTNS,'id'),
        ),
        (TEXTNS,'chapter'):(
                (TEXTNS,'display'),
                (TEXTNS,'outline-level'),
        ),
        (TEXTNS,'conditional-text'):(
                (TEXTNS,'string-value-if-true'),
                (TEXTNS,'current-value'),
                (TEXTNS,'string-value-if-false'),
                (TEXTNS,'condition'),
        ),
        (TEXTNS,'creation-date'):(
                (TEXTNS,'date-value'),
                (TEXTNS,'fixed'),
                (STYLENS,'data-style-name'),
        ),
        (TEXTNS,'creation-time'):(
                (TEXTNS,'fixed'),
                (TEXTNS,'time-value'),
                (STYLENS,'data-style-name'),
        ),
        (TEXTNS,'creator'):(
                (TEXTNS,'fixed'),
        ),
        (TEXTNS,'database-display'):(
                (TEXTNS,'column-name'),
                (TEXTNS,'table-name'),
                (TEXTNS,'table-type'),
                (TEXTNS,'database-name'),
                (STYLENS,'data-style-name'),
        ),
        (TEXTNS,'database-name'):(
                (TEXTNS,'table-name'),
                (TEXTNS,'table-type'),
                (TEXTNS,'database-name'),
        ),
        (TEXTNS,'database-next'):(
                (TEXTNS,'table-name'),
                (TEXTNS,'table-type'),
                (TEXTNS,'database-name'),
                (TEXTNS,'condition'),
        ),
        (TEXTNS,'database-row-number'):(
                (STYLENS,'num-format'),
                (TEXTNS,'database-name'),
                (TEXTNS,'value'),
                (STYLENS,'num-letter-sync'),
                (TEXTNS,'table-name'),
                (TEXTNS,'table-type'),
        ),
        (TEXTNS,'database-row-select'):(
                (TEXTNS,'row-number'),
                (TEXTNS,'table-name'),
                (TEXTNS,'table-type'),
                (TEXTNS,'database-name'),
                (TEXTNS,'condition'),
        ),
# allowed_attributes
        (TEXTNS,'date'):(
                (TEXTNS,'date-value'),
                (TEXTNS,'fixed'),
                (TEXTNS,'date-adjust'),
                (STYLENS,'data-style-name'),
        ),
        (TEXTNS,'dde-connection'):(
                (TEXTNS,'connection-name'),
        ),
        (TEXTNS,'dde-connection-decl'):(
                (OFFICENS,'automatic-update'),
                (OFFICENS,'dde-topic'),
                (OFFICENS,'dde-application'),
                (OFFICENS,'name'),
                (OFFICENS,'dde-item'),
        ),
        (TEXTNS,'dde-connection-decls'):(
        ),
        (TEXTNS,'deletion'):(
        ),
        (TEXTNS,'description'):(
                (TEXTNS,'fixed'),
        ),
        (TEXTNS,'editing-cycles'):(
                (TEXTNS,'fixed'),
        ),
        (TEXTNS,'editing-duration'):(
                (TEXTNS,'duration'),
                (TEXTNS,'fixed'),
                (STYLENS,'data-style-name'),
        ),
        (TEXTNS,'execute-macro'):(
                (TEXTNS,'name'),
        ),
        (TEXTNS,'expression'):(
                (TEXTNS,'display'),
                (OFFICENS,'string-value'),
                (OFFICENS,'value'),
                (OFFICENS,'boolean-value'),
                (OFFICENS,'currency'),
                (OFFICENS,'date-value'),
                (STYLENS,'data-style-name'),
                (OFFICENS,'value-type'),
                (TEXTNS,'formula'),
                (OFFICENS,'time-value'),
        ),
        (TEXTNS,'file-name'):(
                (TEXTNS,'fixed'),
                (TEXTNS,'display'),
        ),
# allowed_attributes
        (TEXTNS,'format-change'):(
        ),
        (TEXTNS,'h'):(
                (TEXTNS,'restart-numbering'),
                (TEXTNS,'cond-style-name'),
                (TEXTNS,'is-list-header'),
                (TEXTNS,'style-name'),
                (TEXTNS,'class-names'),
                (TEXTNS,'start-value'),
                (TEXTNS,'id'),
                (TEXTNS,'outline-level'),
        ),
        (TEXTNS,'hidden-paragraph'):(
                (TEXTNS,'is-hidden'),
                (TEXTNS,'condition'),
        ),
        (TEXTNS,'hidden-text'):(
                (TEXTNS,'string-value'),
                (TEXTNS,'is-hidden'),
                (TEXTNS,'condition'),
        ),
        (TEXTNS,'illustration-index'):(
                (TEXTNS,'protected'),
                (TEXTNS,'style-name'),
                (TEXTNS,'name'),
                (TEXTNS,'protection-key'),
        ),
        (TEXTNS,'illustration-index-entry-template'):(
                (TEXTNS,'style-name'),
        ),
        (TEXTNS,'illustration-index-source'):(
                (TEXTNS,'index-scope'),
                (TEXTNS,'caption-sequence-name'),
                (TEXTNS,'use-caption'),
                (TEXTNS,'caption-sequence-format'),
                (TEXTNS,'relative-tab-stop-position'),
        ),
        (TEXTNS,'index-body'):(
        ),
        (TEXTNS,'index-entry-bibliography'):(
                (TEXTNS,'bibliography-data-field'),
                (TEXTNS,'style-name'),
        ),
        (TEXTNS,'index-entry-chapter'):(
                (TEXTNS,'style-name'),
                (TEXTNS,'display'),
        ),
# allowed_attributes
        (TEXTNS,'index-entry-link-end'):(
                (TEXTNS,'style-name'),
        ),
        (TEXTNS,'index-entry-link-start'):(
                (TEXTNS,'style-name'),
        ),
        (TEXTNS,'index-entry-page-number'):(
                (TEXTNS,'style-name'),
        ),
        (TEXTNS,'index-entry-span'):(
                (TEXTNS,'style-name'),
        ),
        (TEXTNS,'index-entry-tab-stop'):(
                (STYLENS,'position'),
                (TEXTNS,'style-name'),
                (STYLENS,'type'),
                (STYLENS,'leader-char'),
        ),
        (TEXTNS,'index-entry-text'):(
                (TEXTNS,'style-name'),
        ),
        (TEXTNS,'index-source-style'):(
                (TEXTNS,'style-name'),
        ),
        (TEXTNS,'index-source-styles'):(
                (TEXTNS,'outline-level'),
        ),
        (TEXTNS,'index-title'):(
                (TEXTNS,'protected'),
                (TEXTNS,'style-name'),
                (TEXTNS,'name'),
                (TEXTNS,'protection-key'),
        ),
        (TEXTNS,'index-title-template'):(
                (TEXTNS,'style-name'),
        ),
        (TEXTNS,'initial-creator'):(
                (TEXTNS,'fixed'),
        ),
        (TEXTNS,'insertion'):(
        ),
# allowed_attributes
        (TEXTNS,'keywords'):(
                (TEXTNS,'fixed'),
        ),
        (TEXTNS,'line-break'):(
        ),
        (TEXTNS,'linenumbering-configuration'):(
                (TEXTNS,'number-position'),
                (TEXTNS,'number-lines'),
                (STYLENS,'num-format'),
                (TEXTNS,'count-empty-lines'),
                (TEXTNS,'count-in-text-boxes'),
                (TEXTNS,'style-name'),
                (STYLENS,'num-letter-sync'),
                (TEXTNS,'increment'),
                (TEXTNS,'offset'),
                (TEXTNS,'restart-on-page'),
        ),
        (TEXTNS,'linenumbering-separator'):(
                (TEXTNS,'increment'),
        ),
        (TEXTNS,'list'):(
                (TEXTNS,'style-name'),
                (TEXTNS,'continue-numbering'),
        ),
        (TEXTNS,'list-header'):(
        ),
        (TEXTNS,'list-item'):(
                (TEXTNS,'start-value'),
        ),
        (TEXTNS,'list-level-style-bullet'):(
                (TEXTNS,'level'),
                (STYLENS,'num-prefix'),
                (STYLENS,'num-suffix'),
                (TEXTNS,'bullet-relative-size'),
                (TEXTNS,'style-name'),
                (TEXTNS,'bullet-char'),
        ),
        (TEXTNS,'list-level-style-image'):(
                (XLINKNS,'show'),
                (XLINKNS,'actuate'),
                (XLINKNS,'href'),
                (XLINKNS,'type'),
                (TEXTNS,'level'),
        ),
        (TEXTNS,'list-level-style-number'):(
                (TEXTNS,'level'),
                (TEXTNS,'display-levels'),
                (STYLENS,'num-format'),
                (STYLENS,'num-suffix'),
                (TEXTNS,'style-name'),
                (STYLENS,'num-prefix'),
                (STYLENS,'num-letter-sync'),
                (TEXTNS,'start-value'),
        ),
# allowed_attributes
        (TEXTNS,'list-style'):(
                (TEXTNS,'consecutive-numbering'),
                (STYLENS,'display-name'),
                (STYLENS,'name'),
        ),
        (TEXTNS,'measure'):(
                (TEXTNS,'kind'),
        ),
        (TEXTNS,'modification-date'):(
                (TEXTNS,'date-value'),
                (TEXTNS,'fixed'),
                (STYLENS,'data-style-name'),
        ),
        (TEXTNS,'modification-time'):(
                (TEXTNS,'fixed'),
                (TEXTNS,'time-value'),
                (STYLENS,'data-style-name'),
        ),
        (TEXTNS,'note'):(
                (TEXTNS,'note-class'),
                (TEXTNS,'id'),
        ),
        (TEXTNS,'note-body'):(
        ),
        (TEXTNS,'note-citation'):(
                (TEXTNS,'label'),
        ),
        (TEXTNS,'note-continuation-notice-backward'):(
        ),
        (TEXTNS,'note-continuation-notice-forward'):(
        ),
        (TEXTNS,'note-ref'):(
                (TEXTNS,'ref-name'),
                (TEXTNS,'note-class'),
                (TEXTNS,'reference-format'),
        ),
        (TEXTNS,'notes-configuration'):(
                (TEXTNS,'citation-body-style-name'),
                (STYLENS,'num-format'),
                (TEXTNS,'default-style-name'),
                (STYLENS,'num-suffix'),
                (TEXTNS,'start-numbering-at'),
                (STYLENS,'num-prefix'),
                (STYLENS,'num-letter-sync'),
                (TEXTNS,'citation-style-name'),
                (TEXTNS,'footnotes-position'),
                (TEXTNS,'master-page-name'),
                (TEXTNS,'start-value'),
                (TEXTNS,'note-class'),
        ),
        (TEXTNS,'number'):(
        ),
        (TEXTNS,'numbered-paragraph'):(
                (TEXTNS,'continue-numbering'),
                (TEXTNS,'style-name'),
                (TEXTNS,'start-value'),
                (TEXTNS,'level'),
        ),
        (TEXTNS,'object-count'):(
                (STYLENS,'num-format'),
                (STYLENS,'num-letter-sync'),
        ),
        (TEXTNS,'object-index'):(
                (TEXTNS,'protected'),
                (TEXTNS,'style-name'),
                (TEXTNS,'name'),
                (TEXTNS,'protection-key'),
        ),
# allowed_attributes
        (TEXTNS,'object-index-entry-template'):(
                (TEXTNS,'style-name'),
        ),
        (TEXTNS,'object-index-source'):(
                (TEXTNS,'use-draw-objects'),
                (TEXTNS,'use-math-objects'),
                (TEXTNS,'relative-tab-stop-position'),
                (TEXTNS,'use-chart-objects'),
                (TEXTNS,'index-scope'),
                (TEXTNS,'use-spreadsheet-objects'),
                (TEXTNS,'use-other-objects'),
        ),
        (TEXTNS,'outline-level-style'):(
                (TEXTNS,'level'),
                (TEXTNS,'display-levels'),
                (STYLENS,'num-format'),
                (STYLENS,'num-suffix'),
                (TEXTNS,'style-name'),
                (STYLENS,'num-prefix'),
                (STYLENS,'num-letter-sync'),
                (TEXTNS,'start-value'),
        ),
        (TEXTNS,'outline-style'):(
        ),
        (TEXTNS,'p'):(
                (TEXTNS,'cond-style-name'),
                (TEXTNS,'style-name'),
                (TEXTNS,'class-names'),
                (TEXTNS,'id'),
        ),
        (TEXTNS,'page'):(
                (TEXTNS,'master-page-name'),
        ),
        (TEXTNS,'page-continuation'):(
                (TEXTNS,'string-value'),
                (TEXTNS,'select-page'),
        ),
        (TEXTNS,'page-number'):(
                (TEXTNS,'page-adjust'),
                (STYLENS,'num-format'),
                (TEXTNS,'fixed'),
                (STYLENS,'num-letter-sync'),
                (TEXTNS,'select-page'),
        ),
        (TEXTNS,'page-sequence'):(
        ),
        (TEXTNS,'page-variable-get'):(
                (STYLENS,'num-format'),
                (STYLENS,'num-letter-sync'),
        ),
        (TEXTNS,'page-variable-set'):(
                (TEXTNS,'active'),
                (TEXTNS,'page-adjust'),
        ),
        (TEXTNS,'placeholder'):(
                (TEXTNS,'placeholder-type'),
                (TEXTNS,'description'),
        ),
        (TEXTNS,'print-date'):(
                (TEXTNS,'date-value'),
                (TEXTNS,'fixed'),
                (STYLENS,'data-style-name'),
        ),
        (TEXTNS,'print-time'):(
                (TEXTNS,'fixed'),
                (TEXTNS,'time-value'),
                (STYLENS,'data-style-name'),
        ),
        (TEXTNS,'printed-by'):(
                (TEXTNS,'fixed'),
        ),
        (TEXTNS,'reference-mark'):(
                (TEXTNS,'name'),
        ),
        (TEXTNS,'reference-mark-end'):(
                (TEXTNS,'name'),
        ),
        (TEXTNS,'reference-mark-start'):(
                (TEXTNS,'name'),
        ),
        (TEXTNS,'ruby'):(
                (TEXTNS,'style-name'),
        ),
        (TEXTNS,'ruby-base'):(
        ),
        (TEXTNS,'ruby-text'):(
                (TEXTNS,'style-name'),
        ),
        (TEXTNS,'s'):(
                (TEXTNS,'c'),
        ),
        (TEXTNS,'script'):(
                (XLINKNS,'href'),
                (XLINKNS,'type'),
                (SCRIPTNS,'language'),
        ),
        (TEXTNS,'section'):(
                (TEXTNS,'name'),
                (TEXTNS,'protection-key'),
                (TEXTNS,'style-name'),
                (TEXTNS,'protected'),
                (TEXTNS,'display'),
                (TEXTNS,'condition'),
        ),
        (TEXTNS,'section-source'):(
                (TEXTNS,'filter-name'),
                (XLINKNS,'href'),
                (XLINKNS,'type'),
                (TEXTNS,'section-name'),
                (XLINKNS,'show'),
        ),
        (TEXTNS,'sender-city'):(
                (TEXTNS,'fixed'),
        ),
        (TEXTNS,'sender-company'):(
                (TEXTNS,'fixed'),
        ),
        (TEXTNS,'sender-country'):(
                (TEXTNS,'fixed'),
        ),
# allowed_attributes
        (TEXTNS,'sender-email'):(
                (TEXTNS,'fixed'),
        ),
        (TEXTNS,'sender-fax'):(
                (TEXTNS,'fixed'),
        ),
        (TEXTNS,'sender-firstname'):(
                (TEXTNS,'fixed'),
        ),
        (TEXTNS,'sender-initials'):(
                (TEXTNS,'fixed'),
        ),
        (TEXTNS,'sender-lastname'):(
                (TEXTNS,'fixed'),
        ),
        (TEXTNS,'sender-phone-private'):(
                (TEXTNS,'fixed'),
        ),
        (TEXTNS,'sender-phone-work'):(
                (TEXTNS,'fixed'),
        ),
        (TEXTNS,'sender-position'):(
                (TEXTNS,'fixed'),
        ),
        (TEXTNS,'sender-postal-code'):(
                (TEXTNS,'fixed'),
        ),
        (TEXTNS,'sender-state-or-province'):(
                (TEXTNS,'fixed'),
        ),
        (TEXTNS,'sender-street'):(
                (TEXTNS,'fixed'),
        ),
        (TEXTNS,'sender-title'):(
                (TEXTNS,'fixed'),
        ),
        (TEXTNS,'sequence'):(
                (TEXTNS,'formula'),
                (STYLENS,'num-format'),
                (STYLENS,'num-letter-sync'),
                (TEXTNS,'name'),
                (TEXTNS,'ref-name'),
        ),
        (TEXTNS,'sequence-decl'):(
                (TEXTNS,'separation-character'),
                (TEXTNS,'display-outline-level'),
                (TEXTNS,'name'),
        ),
        (TEXTNS,'sequence-decls'):(
        ),
        (TEXTNS,'sequence-ref'):(
                (TEXTNS,'ref-name'),
                (TEXTNS,'reference-format'),
        ),
        (TEXTNS,'sheet-name'):(
        ),
        (TEXTNS,'soft-page-break'):(
        ),
        (TEXTNS,'sort-key'):(
                (TEXTNS,'sort-ascending'),
                (TEXTNS,'key'),
        ),
# allowed_attributes
        (TEXTNS,'span'):(
                (TEXTNS,'style-name'),
                (TEXTNS,'class-names'),
        ),
        (TEXTNS,'subject'):(
                (TEXTNS,'fixed'),
        ),
        (TEXTNS,'tab'):(
                (TEXTNS,'tab-ref'),
        ),
        (TEXTNS,'table-formula'):(
                (TEXTNS,'formula'),
                (STYLENS,'data-style-name'),
                (TEXTNS,'display'),
        ),
        (TEXTNS,'table-index'):(
                (TEXTNS,'protected'),
                (TEXTNS,'style-name'),
                (TEXTNS,'name'),
                (TEXTNS,'protection-key'),
        ),
        (TEXTNS,'table-index-entry-template'):(
                (TEXTNS,'style-name'),
        ),
        (TEXTNS,'table-index-source'):(
                (TEXTNS,'index-scope'),
                (TEXTNS,'caption-sequence-name'),
                (TEXTNS,'use-caption'),
                (TEXTNS,'caption-sequence-format'),
                (TEXTNS,'relative-tab-stop-position'),
        ),
# allowed_attributes
        (TEXTNS,'table-of-content'):(
                (TEXTNS,'protected'),
                (TEXTNS,'style-name'),
                (TEXTNS,'name'),
                (TEXTNS,'protection-key'),
        ),
        (TEXTNS,'table-of-content-entry-template'):(
                (TEXTNS,'style-name'),
                (TEXTNS,'outline-level'),
        ),
        (TEXTNS,'table-of-content-source'):(
                (TEXTNS,'index-scope'),
                (TEXTNS,'outline-level'),
                (TEXTNS,'relative-tab-stop-position'),
                (TEXTNS,'use-index-marks'),
                (TEXTNS,'use-outline-level'),
                (TEXTNS,'use-index-source-styles'),
        ),
        (TEXTNS,'template-name'):(
                (TEXTNS,'display'),
        ),
        (TEXTNS,'text-input'):(
                (TEXTNS,'description'),
        ),
        (TEXTNS,'time'):(
                (TEXTNS,'time-adjust'),
                (TEXTNS,'fixed'),
                (TEXTNS,'time-value'),
                (STYLENS,'data-style-name'),
        ),
        (TEXTNS,'title'):(
                (TEXTNS,'fixed'),
        ),
        (TEXTNS,'toc-mark'):(
                (TEXTNS,'string-value'),
                (TEXTNS,'outline-level'),
        ),
        (TEXTNS,'toc-mark-end'):(
                (TEXTNS,'id'),
        ),
        (TEXTNS,'toc-mark-start'):(
                (TEXTNS,'id'),
                (TEXTNS,'outline-level'),
        ),
        (TEXTNS,'tracked-changes'):(
                (TEXTNS,'track-changes'),
        ),
        (TEXTNS,'user-defined'):(
                (TEXTNS,'name'),
                (OFFICENS,'string-value'),
                (OFFICENS,'value'),
                (OFFICENS,'boolean-value'),
                (OFFICENS,'date-value'),
                (STYLENS,'data-style-name'),
                (TEXTNS,'fixed'),
                (OFFICENS,'time-value'),
        ),
        (TEXTNS,'user-field-decl'):(
                (TEXTNS,'name'),
                (OFFICENS,'string-value'),
                (OFFICENS,'value'),
                (OFFICENS,'boolean-value'),
                (OFFICENS,'currency'),
                (OFFICENS,'date-value'),
                (OFFICENS,'value-type'),
                (TEXTNS,'formula'),
                (OFFICENS,'time-value'),
        ),
        (TEXTNS,'user-field-decls'):(
        ),
        (TEXTNS,'user-field-get'):(
                (STYLENS,'data-style-name'),
                (TEXTNS,'name'),
                (TEXTNS,'display'),
        ),
# allowed_attributes
        (TEXTNS,'user-field-input'):(
                (STYLENS,'data-style-name'),
                (TEXTNS,'name'),
                (TEXTNS,'description'),
        ),
        (TEXTNS,'user-index'):(
                (TEXTNS,'protected'),
                (TEXTNS,'style-name'),
                (TEXTNS,'name'),
                (TEXTNS,'protection-key'),
        ),
        (TEXTNS,'user-index-entry-template'):(
                (TEXTNS,'style-name'),
                (TEXTNS,'outline-level'),
        ),
        (TEXTNS,'user-index-mark'):(
                (TEXTNS,'index-name'),
                (TEXTNS,'string-value'),
                (TEXTNS,'outline-level'),
        ),
        (TEXTNS,'user-index-mark-end'):(
                (TEXTNS,'id'),
                (TEXTNS,'outline-level'),
        ),
        (TEXTNS,'user-index-mark-start'):(
                (TEXTNS,'index-name'),
                (TEXTNS,'id'),
                (TEXTNS,'outline-level'),
        ),
# allowed_attributes
        (TEXTNS,'user-index-source'):(
                (TEXTNS,'copy-outline-levels'),
                (TEXTNS,'index-name'),
                (TEXTNS,'index-scope'),
                (TEXTNS,'relative-tab-stop-position'),
                (TEXTNS,'use-floating-frames'),
                (TEXTNS,'use-graphics'),
                (TEXTNS,'use-index-marks'),
                (TEXTNS,'use-objects'),
                (TEXTNS,'use-tables'),
        ),
        (TEXTNS,'variable-decl'):(
                (TEXTNS,'name'),
                (OFFICENS,'value-type'),
        ),
        (TEXTNS,'variable-decls'):(
        ),
        (TEXTNS,'variable-get'):(
                (STYLENS,'data-style-name'),
                (TEXTNS,'name'),
                (TEXTNS,'display'),
        ),
        (TEXTNS,'variable-input'):(
                (STYLENS,'data-style-name'),
                (TEXTNS,'display'),
                (TEXTNS,'name'),
                (OFFICENS,'value-type'),
                (TEXTNS,'description'),
        ),
        (TEXTNS,'variable-set'):(
                (TEXTNS,'name'),
                (TEXTNS,'display'),
                (OFFICENS,'string-value'),
                (OFFICENS,'value'),
                (OFFICENS,'boolean-value'),
                (OFFICENS,'currency'),
                (OFFICENS,'date-value'),
                (STYLENS,'data-style-name'),
                (OFFICENS,'value-type'),
                (TEXTNS,'formula'),
                (OFFICENS,'time-value'),
        ),
# allowed_attributes
}
