/*
 * Decompiled with CFR 0.152.
 */
package liquibase.command.core;

import java.util.List;
import liquibase.Scope;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.CountChangeSetFilter;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.core.AbstractRollbackCommandStep;
import liquibase.database.Database;

public class RollbackCountCommandStep
extends AbstractRollbackCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"rollbackCount"};
    public static final CommandArgumentDefinition<Integer> COUNT_ARG;

    @Override
    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        CommandScope commandScope = resultsBuilder.getCommandScope();
        Integer changesToRollback = commandScope.getArgumentValue(COUNT_ARG);
        Scope.getCurrentScope().addMdcValue("rollbackCount", String.valueOf(changesToRollback));
        Database database = (Database)commandScope.getDependency(Database.class);
        List<RanChangeSet> ranChangeSetList = database.getRanChangeSetList();
        this.doRollback(resultsBuilder, ranChangeSetList, new CountChangeSetFilter(changesToRollback));
    }

    @Override
    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        commandDefinition.setShortDescription("Rollback the specified number of changes made to the database");
    }

    static {
        CommandBuilder builder = new CommandBuilder(new String[][]{COMMAND_NAME});
        COUNT_ARG = builder.argument("count", Integer.class).required().description("The number of changes to rollback").build();
        builder.addArgument(AbstractRollbackCommandStep.ROLLBACK_SCRIPT_ARG).build();
    }
}

