/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.ontology.imports.missing;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.annotation.Nonnull;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.MissingImportHandler;
import org.protege.editor.owl.model.library.OntologyCatalogManager;
import org.protege.editor.owl.ui.UIHelper;
import org.protege.xmlcatalog.CatalogUtilities;
import org.protege.xmlcatalog.XmlBaseContext;
import org.protege.xmlcatalog.entry.UriEntry;
import org.semanticweb.owlapi.model.IRI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MissingImportHandlerUI
implements MissingImportHandler {
    private static final String RESOLVE_MISSING_IMPORT_TITLE = "Resolve missing import?";
    private static final String MISSING_IMPORT_MSG = "<html><body>The system couldn't locate the ontology<br><br><b>%s</b><br><br>Would you like to attempt to resolve the missing import?</body></html>";
    private static final Logger logger = LoggerFactory.getLogger(MissingImportHandlerUI.class);
    private final OWLEditorKit owlEditorKit;
    private boolean noToAll = false;

    public MissingImportHandlerUI(OWLEditorKit owlEditorKit) {
        this.owlEditorKit = owlEditorKit;
    }

    @Override
    public void reset() {
        this.noToAll = false;
    }

    public IRI getDocumentIRI(@Nonnull IRI ontologyIRI) {
        FutureTask<IRI> futureTask = new FutureTask<IRI>(() -> {
            if (this.noToAll) {
                return null;
            }
            String msg = String.format(MISSING_IMPORT_MSG, ontologyIRI);
            String resolveOption = "Yes";
            String doNotResolveOption = "No";
            String doNotResolveAnyOption = "No to all";
            Object[] options = new Object[]{resolveOption, doNotResolveOption, doNotResolveAnyOption};
            JOptionPane optionPane = new JOptionPane(msg, 2, 0, null, options, resolveOption);
            JDialog dlg = optionPane.createDialog(RESOLVE_MISSING_IMPORT_TITLE);
            dlg.setVisible(true);
            Object choice = optionPane.getValue();
            if (choice.equals(doNotResolveAnyOption)) {
                this.noToAll = true;
                return null;
            }
            if (choice.equals(doNotResolveOption)) {
                return null;
            }
            UIHelper helper = new UIHelper(this.owlEditorKit);
            File file = helper.chooseOWLFile("Please select an ontology file");
            if (file == null) {
                return ontologyIRI;
            }
            this.updateActiveCatalog(ontologyIRI, file);
            return IRI.create((File)file);
        });
        SwingUtilities.invokeLater(futureTask);
        try {
            return futureTask.get();
        }
        catch (InterruptedException e) {
            logger.debug("Resolve import task interrupted");
            return null;
        }
        catch (ExecutionException e) {
            logger.error("An exception was thrown whilst the user was resolving a missing import: {}", (Object)e.getCause().getMessage());
            return null;
        }
    }

    private void updateActiveCatalog(IRI ontologyIRI, File file) {
        OntologyCatalogManager catalogManager = this.owlEditorKit.getOWLModelManager().getOntologyCatalogManager();
        catalogManager.getCurrentCatalog().ifPresent(catalog -> {
            URI relativeFile = CatalogUtilities.relativize(file.toURI(), catalog);
            catalog.addEntry(0, new UriEntry("User Entered Import Resolution", (XmlBaseContext)catalog, ontologyIRI.toString(), relativeFile, null));
            File catalogLocation = new File(catalog.getXmlBaseContext().getXmlBase());
            try {
                CatalogUtilities.save(catalog, catalogLocation);
            }
            catch (IOException e) {
                logger.error("Could not save user supplied import redirection to catalog.", (Throwable)e);
            }
        });
    }
}

