/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.explanation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.protege.editor.core.ui.preferences.PreferencesLayoutPanel;
import org.protege.editor.owl.ui.explanation.ExplanationPreferences;
import org.protege.editor.owl.ui.explanation.ExplanationService;
import org.protege.editor.owl.ui.explanation.SortedPluginsTableModel;
import org.protege.editor.owl.ui.preferences.OWLPreferencesPanel;

public class ExplanationPreferencesGeneralPanel
extends OWLPreferencesPanel {
    private static final long serialVersionUID = -3354987384223578780L;
    private JCheckBox checkRecentlyUsed;
    private SortedPluginsTableModel tableModel;
    private ExplanationPreferences preferences;

    public void initialise() throws Exception {
        this.setLayout(new BorderLayout());
        PreferencesLayoutPanel panel = new PreferencesLayoutPanel();
        this.add((Component)panel, "North");
        this.addInstalledExplanationServicesComponent(panel);
        this.addDefaultExplanationServiceComponent(panel);
        this.preferences = ExplanationPreferences.create().load();
        this.loadFrom(this.preferences);
    }

    public void dispose() throws Exception {
        this.getOWLEditorKit().getModelManager().getExplanationManager().reload();
    }

    public void applyChanges() {
        this.saveTo(this.preferences);
        this.preferences.save();
    }

    private void loadFrom(ExplanationPreferences prefs) {
        this.checkRecentlyUsed.setSelected(prefs.useLastExplanationService);
        this.tableModel.setPluginIds(prefs.explanationServicesList);
        this.tableModel.setDisabledIds(prefs.disabledExplanationServices);
    }

    private void saveTo(ExplanationPreferences prefs) {
        prefs.useLastExplanationService = this.checkRecentlyUsed.isSelected();
        prefs.explanationServicesList = this.tableModel.getPluginIds();
        prefs.disabledExplanationServices = this.tableModel.getDisabledIds();
    }

    private void addDefaultExplanationServiceComponent(PreferencesLayoutPanel panel) {
        this.checkRecentlyUsed = new JCheckBox("Try using the most recently used explanation service first");
        this.checkRecentlyUsed.setToolTipText("Use the most recently used explanation service, if it can provide an explanation for the chosen axiom; otherwise, use the first available service from the list above");
        panel.addGroupComponent((JComponent)this.checkRecentlyUsed);
    }

    private void addInstalledExplanationServicesComponent(PreferencesLayoutPanel panel) {
        panel.addGroup("Installed explanation services");
        Collection<ExplanationService> services = this.getOWLEditorKit().getOWLModelManager().getExplanationManager().getExplainers();
        HashMap<String, String> nameMap = new HashMap<String, String>();
        for (ExplanationService service : services) {
            nameMap.put(service.getPluginId(), service.getName());
        }
        this.tableModel = new SortedPluginsTableModel(nameMap);
        JTable pluginTable = new JTable(this.tableModel);
        pluginTable.setToolTipText("Plugins that provide explanation facilities. Prot\u00e9g\u00e9 will use the first enabled service on the list that can provide an explanation for the chosen axiom.");
        pluginTable.setRowSelectionAllowed(true);
        pluginTable.setColumnSelectionAllowed(false);
        pluginTable.getSelectionModel().setSelectionMode(0);
        pluginTable.getColumnModel().getColumn(0).setMaxWidth(20);
        pluginTable.getColumnModel().getColumn(1).setMaxWidth(50);
        pluginTable.getColumnModel().getColumn(2).setMinWidth(300);
        pluginTable.setAutoResizeMode(0);
        JScrollPane pluginTableScrollPane = new JScrollPane(pluginTable);
        pluginTableScrollPane.setPreferredSize(new Dimension(400, 100));
        panel.addGroupComponent((JComponent)pluginTableScrollPane);
        this.addUpDownButtons(panel, pluginTable);
    }

    private void addUpDownButtons(PreferencesLayoutPanel panel, JTable pluginTable) {
        JButton buttonUp = new JButton("\u2191 Move up");
        buttonUp.setToolTipText("Move the selected explanation service towards the top of the list");
        buttonUp.addActionListener(e -> {
            int rowIndex = pluginTable.getSelectedRow();
            if (rowIndex > 0) {
                this.tableModel.swap(rowIndex - 1, rowIndex);
            }
            pluginTable.setRowSelectionInterval(rowIndex - 1, rowIndex - 1);
        });
        buttonUp.setEnabled(pluginTable.getSelectedRow() != -1);
        JButton buttonDown = new JButton("\u2193 Move down\ufe0e");
        buttonDown.setToolTipText("Move the selected explanation service towards the bottom of the list");
        buttonDown.addActionListener(e -> {
            int rowIndex = pluginTable.getSelectedRow();
            if (rowIndex < pluginTable.getRowCount() - 1) {
                this.tableModel.swap(rowIndex, rowIndex + 1);
            }
            pluginTable.setRowSelectionInterval(rowIndex + 1, rowIndex + 1);
        });
        buttonDown.setEnabled(pluginTable.getSelectedRow() != -1);
        JPanel buttonsUpDown = new JPanel();
        buttonsUpDown.add(new JLabel("Change priority"));
        buttonsUpDown.add(buttonUp);
        buttonsUpDown.add(buttonDown);
        panel.addGroupComponent((JComponent)buttonsUpDown);
        pluginTable.getSelectionModel().addListSelectionListener(e -> {
            int rowIndex = pluginTable.getSelectedRow();
            if (rowIndex == -1) {
                buttonUp.setEnabled(false);
                buttonDown.setEnabled(false);
            } else {
                buttonUp.setEnabled(rowIndex > 0);
                buttonDown.setEnabled(rowIndex < pluginTable.getRowCount() - 1);
            }
        });
    }
}

