/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.search.Searcher;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class OWLObjectPropertyManager {
    @Nonnull
    private final OWLOntologyManager man;
    @Nonnull
    private final OWLOntology ontology;
    @Nonnull
    private final Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> hierarchy = new HashMap<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>>();
    @Nonnull
    private final Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> reflexiveTransitiveClosure = new HashMap<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>>();
    @Nonnull
    private final Set<OWLObjectPropertyExpression> compositeProperties = new HashSet<OWLObjectPropertyExpression>();
    @Nonnull
    private final Set<OWLObjectPropertyExpression> nonSimpleProperties = new HashSet<OWLObjectPropertyExpression>();
    @Nonnull
    private final Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> partialOrdering = new HashMap<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>>();
    private boolean compositeDirty;
    private boolean hierarchyDirty;
    private boolean reflexiveTransitiveClosureDirty;
    private boolean simpleDirty;
    private boolean partialOrderingDirty;

    public OWLObjectPropertyManager(@Nonnull OWLOntologyManager manager, @Nonnull OWLOntology ont) {
        this.man = OWLAPIPreconditions.checkNotNull(manager, "manager cannot be null");
        this.ontology = OWLAPIPreconditions.checkNotNull(ont, "ontology cannot be null");
        this.reset();
    }

    private void reset() {
        this.compositeDirty = true;
        this.hierarchyDirty = true;
        this.reflexiveTransitiveClosureDirty = true;
        this.simpleDirty = true;
        this.partialOrderingDirty = true;
    }

    public void dispose() {
    }

    @Nonnull
    protected Set<OWLOntology> getOntologies() {
        return this.man.getImportsClosure(this.ontology);
    }

    public boolean isComposite(@Nonnull OWLObjectPropertyExpression expression) {
        OWLAPIPreconditions.checkNotNull(expression, "expression cannot be null");
        return this.getCompositeProperties().contains(expression);
    }

    @Nonnull
    public Set<OWLObjectPropertyExpression> getCompositeProperties() {
        if (this.compositeDirty) {
            this.compositeProperties.clear();
            this.compositeProperties.add(this.man.getOWLDataFactory().getOWLTopObjectProperty());
            this.compositeProperties.add(this.man.getOWLDataFactory().getOWLBottomObjectProperty());
            for (OWLOntology ont : this.getOntologies()) {
                for (OWLTransitiveObjectPropertyAxiom oWLTransitiveObjectPropertyAxiom : ont.getAxioms(AxiomType.TRANSITIVE_OBJECT_PROPERTY)) {
                    this.markComposite((OWLObjectPropertyExpression)oWLTransitiveObjectPropertyAxiom.getProperty());
                    for (OWLObjectPropertyExpression namedInv : Searcher.inverse(this.ontology.getInverseObjectPropertyAxioms((OWLObjectPropertyExpression)oWLTransitiveObjectPropertyAxiom.getProperty()), (OWLObjectPropertyExpression)oWLTransitiveObjectPropertyAxiom.getProperty())) {
                        assert (namedInv != null);
                        this.markComposite(namedInv);
                    }
                }
                for (OWLSubPropertyChainOfAxiom oWLSubPropertyChainOfAxiom : ont.getAxioms(AxiomType.SUB_PROPERTY_CHAIN_OF)) {
                    this.markComposite(oWLSubPropertyChainOfAxiom.getSuperProperty());
                    for (OWLObjectPropertyExpression namedInv : Searcher.inverse(this.ontology.getInverseObjectPropertyAxioms(oWLSubPropertyChainOfAxiom.getSuperProperty()), oWLSubPropertyChainOfAxiom.getSuperProperty())) {
                        assert (namedInv != null);
                        this.markComposite(namedInv);
                    }
                }
            }
            this.compositeDirty = false;
        }
        return this.compositeProperties;
    }

    private void markComposite(@Nonnull OWLObjectPropertyExpression prop) {
        OWLAPIPreconditions.checkNotNull(prop, "prop cannot be null");
        this.compositeProperties.add(prop);
        this.compositeProperties.add(prop.getInverseProperty());
    }

    @Nonnull
    public Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> getPropertyHierarchy() {
        if (this.hierarchyDirty) {
            HashMap<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> map = new HashMap<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>>();
            for (OWLOntology ont : this.getOntologies()) {
                for (OWLSubObjectPropertyOfAxiom oWLSubObjectPropertyOfAxiom : ont.getAxioms(AxiomType.SUB_OBJECT_PROPERTY)) {
                    OWLObjectPropertyManager.getKeyValue((OWLObjectPropertyExpression)oWLSubObjectPropertyOfAxiom.getSubProperty(), map).add((OWLObjectPropertyExpression)oWLSubObjectPropertyOfAxiom.getSuperProperty());
                    OWLObjectPropertyManager.getKeyValue(((OWLObjectPropertyExpression)oWLSubObjectPropertyOfAxiom.getSubProperty()).getInverseProperty(), map).add(((OWLObjectPropertyExpression)oWLSubObjectPropertyOfAxiom.getSuperProperty()).getInverseProperty());
                }
                for (OWLEquivalentObjectPropertiesAxiom oWLEquivalentObjectPropertiesAxiom : ont.getAxioms(AxiomType.EQUIVALENT_OBJECT_PROPERTIES)) {
                    for (OWLObjectPropertyExpression propA : oWLEquivalentObjectPropertiesAxiom.getProperties()) {
                        for (OWLObjectPropertyExpression propB : oWLEquivalentObjectPropertiesAxiom.getProperties()) {
                            if (propA.equals(propB)) continue;
                            OWLObjectPropertyManager.getKeyValue(propA, map).add(propB);
                            OWLObjectPropertyManager.getKeyValue(propB, map).add(propA);
                            OWLObjectPropertyManager.getKeyValue(propA.getInverseProperty(), map).add(propB.getInverseProperty());
                            OWLObjectPropertyManager.getKeyValue(propB.getInverseProperty(), map).add(propA.getInverseProperty());
                        }
                    }
                }
                for (OWLInverseObjectPropertiesAxiom oWLInverseObjectPropertiesAxiom : ont.getAxioms(AxiomType.INVERSE_OBJECT_PROPERTIES)) {
                    OWLObjectPropertyManager.getKeyValue(oWLInverseObjectPropertiesAxiom.getFirstProperty(), map).add(oWLInverseObjectPropertiesAxiom.getSecondProperty().getInverseProperty());
                    OWLObjectPropertyManager.getKeyValue(oWLInverseObjectPropertiesAxiom.getSecondProperty().getInverseProperty(), map).add(oWLInverseObjectPropertiesAxiom.getFirstProperty());
                    OWLObjectPropertyManager.getKeyValue(oWLInverseObjectPropertiesAxiom.getFirstProperty().getInverseProperty(), map).add(oWLInverseObjectPropertiesAxiom.getSecondProperty());
                    OWLObjectPropertyManager.getKeyValue(oWLInverseObjectPropertiesAxiom.getSecondProperty(), map).add(oWLInverseObjectPropertiesAxiom.getFirstProperty().getInverseProperty());
                }
                for (OWLSymmetricObjectPropertyAxiom oWLSymmetricObjectPropertyAxiom : ont.getAxioms(AxiomType.SYMMETRIC_OBJECT_PROPERTY)) {
                    OWLObjectPropertyManager.getKeyValue((OWLObjectPropertyExpression)oWLSymmetricObjectPropertyAxiom.getProperty(), map).add(((OWLObjectPropertyExpression)oWLSymmetricObjectPropertyAxiom.getProperty()).getInverseProperty());
                    OWLObjectPropertyManager.getKeyValue(((OWLObjectPropertyExpression)oWLSymmetricObjectPropertyAxiom.getProperty()).getInverseProperty(), map).add((OWLObjectPropertyExpression)oWLSymmetricObjectPropertyAxiom.getProperty());
                }
            }
            this.hierarchy.clear();
            this.hierarchy.putAll(map);
            this.hierarchyDirty = false;
        }
        return this.hierarchy;
    }

    @Nonnull
    public Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> getHierarchyReflexiveTransitiveClosure() {
        if (this.reflexiveTransitiveClosureDirty) {
            HashMap<OWLObjectPropertyExpression, HashSet<OWLObjectPropertyExpression>> rtcMap = new HashMap<OWLObjectPropertyExpression, HashSet<OWLObjectPropertyExpression>>();
            Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> propertyHierarchy = this.getPropertyHierarchy();
            for (OWLObjectPropertyExpression prop : this.getReferencedProperties()) {
                assert (prop != null);
                HashSet<OWLObjectPropertyExpression> processed = new HashSet<OWLObjectPropertyExpression>();
                HashSet<OWLObjectPropertyExpression> rtc = new HashSet<OWLObjectPropertyExpression>();
                OWLObjectPropertyManager.getReflexiveTransitiveClosure(prop, propertyHierarchy, rtc, processed);
                rtcMap.put(prop, rtc);
            }
            this.reflexiveTransitiveClosure.clear();
            this.reflexiveTransitiveClosure.putAll(rtcMap);
            this.reflexiveTransitiveClosureDirty = false;
        }
        return this.reflexiveTransitiveClosure;
    }

    public boolean isSubPropertyOf(@Nonnull OWLObjectPropertyExpression sub, @Nonnull OWLObjectPropertyExpression sup) {
        OWLAPIPreconditions.checkNotNull(sub, "sub cannot be null");
        OWLAPIPreconditions.checkNotNull(sup, "sup cannot be null");
        Set<OWLObjectPropertyExpression> supers = this.getHierarchyReflexiveTransitiveClosure().get(sub);
        if (supers == null) {
            return false;
        }
        return supers.contains(sup);
    }

    public boolean isNonSimple(@Nonnull OWLObjectPropertyExpression expression) {
        OWLAPIPreconditions.checkNotNull(expression, "expression cannot be null");
        return this.getNonSimpleProperties().contains(expression);
    }

    @Nonnull
    public Set<OWLObjectPropertyExpression> getNonSimpleProperties() {
        if (this.simpleDirty) {
            this.nonSimpleProperties.clear();
            Set<OWLObjectPropertyExpression> props = this.getReferencedProperties();
            Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> reflexiveTransitiveClosureMap = this.getHierarchyReflexiveTransitiveClosure();
            for (OWLObjectPropertyExpression prop : this.getReferencedProperties()) {
                assert (prop != null);
                if (!this.isComposite(prop)) continue;
                Set<OWLObjectPropertyExpression> rtc = reflexiveTransitiveClosureMap.get(prop);
                props.removeAll(rtc);
                this.nonSimpleProperties.add(prop);
                this.nonSimpleProperties.addAll(rtc);
            }
            for (OWLObjectPropertyExpression prop : new ArrayList<OWLObjectPropertyExpression>(this.nonSimpleProperties)) {
                this.nonSimpleProperties.add(prop.getInverseProperty());
            }
            this.simpleDirty = false;
        }
        return this.nonSimpleProperties;
    }

    @Nonnull
    public Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> getPropertyPartialOrdering() {
        if (this.partialOrderingDirty) {
            this.partialOrdering.clear();
            HashMap<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> map = new HashMap<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>>(this.getPropertyHierarchy());
            for (OWLOntology ont : this.getOntologies()) {
                for (OWLSubPropertyChainOfAxiom ax : ont.getAxioms(AxiomType.SUB_PROPERTY_CHAIN_OF)) {
                    for (OWLObjectPropertyExpression prop : ax.getPropertyChain()) {
                        HashSet<OWLObjectPropertyExpression> sups = (HashSet<OWLObjectPropertyExpression>)map.get(prop);
                        if (sups == null) {
                            sups = new HashSet<OWLObjectPropertyExpression>();
                            map.put(prop, sups);
                        }
                        sups.add(ax.getSuperProperty());
                        HashSet<OWLObjectPropertyExpression> supsInv = (HashSet<OWLObjectPropertyExpression>)map.get(prop.getInverseProperty());
                        if (supsInv == null) {
                            supsInv = new HashSet<OWLObjectPropertyExpression>();
                            map.put(prop.getInverseProperty(), supsInv);
                        }
                        supsInv.add(ax.getSuperProperty().getInverseProperty());
                    }
                }
            }
            HashMap<OWLObjectPropertyExpression, HashSet<OWLObjectPropertyExpression>> ordering = new HashMap<OWLObjectPropertyExpression, HashSet<OWLObjectPropertyExpression>>();
            for (OWLObjectPropertyExpression prop : this.getReferencedProperties()) {
                assert (prop != null);
                HashSet<OWLObjectPropertyExpression> processed = new HashSet<OWLObjectPropertyExpression>();
                HashSet<OWLObjectPropertyExpression> rtc = new HashSet<OWLObjectPropertyExpression>();
                OWLObjectPropertyManager.getReflexiveTransitiveClosure(prop, map, rtc, processed);
                ordering.put(prop, rtc);
            }
            this.partialOrdering.putAll(ordering);
            this.partialOrderingDirty = false;
        }
        return this.partialOrdering;
    }

    public boolean isLessThan(@Nonnull OWLObjectPropertyExpression propA, @Nonnull OWLObjectPropertyExpression propB) {
        OWLAPIPreconditions.checkNotNull(propA, "propA cannot be null");
        OWLAPIPreconditions.checkNotNull(propB, "propB cannot be null");
        Set<OWLObjectPropertyExpression> props = this.getPropertyPartialOrdering().get(propA);
        if (props == null) {
            return false;
        }
        return props.contains(propB);
    }

    @Nonnull
    private Set<OWLObjectPropertyExpression> getReferencedProperties() {
        HashSet<OWLObjectPropertyExpression> props = new HashSet<OWLObjectPropertyExpression>();
        for (OWLOntology ont : this.getOntologies()) {
            for (OWLObjectPropertyExpression oWLObjectPropertyExpression : ont.getObjectPropertiesInSignature()) {
                props.add(oWLObjectPropertyExpression);
            }
        }
        return props;
    }

    /*
     * WARNING - void declaration
     */
    @Nonnull
    public static Collection<Set<OWLObjectPropertyExpression>> getEquivalentObjectProperties(@Nonnull Set<OWLOntology> ontologies) {
        void var5_9;
        OWLAPIPreconditions.checkNotNull(ontologies, "ontologies cannot be null");
        HashSet<Set<OWLObjectPropertyExpression>> result = new HashSet<Set<OWLObjectPropertyExpression>>();
        HashSet<OWLObjectPropertyExpression> processed = new HashSet<OWLObjectPropertyExpression>();
        HashSet<OWLObjectProperty> properties = new HashSet<OWLObjectProperty>();
        for (OWLOntology oWLOntology : ontologies) {
            properties.addAll(oWLOntology.getObjectPropertiesInSignature());
        }
        for (OWLObjectPropertyExpression oWLObjectPropertyExpression : properties) {
            assert (oWLObjectPropertyExpression != null);
            if (processed.contains(oWLObjectPropertyExpression)) continue;
            OWLObjectPropertyManager.tarjan(ontologies, oWLObjectPropertyExpression, 0, new Stack<OWLObjectPropertyExpression>(), new HashMap<OWLObjectPropertyExpression, Integer>(), new HashMap<OWLObjectPropertyExpression, Integer>(), result, processed, new HashSet<OWLObjectPropertyExpression>());
        }
        ArrayList<Set<OWLObjectPropertyExpression>> equivs = new ArrayList<Set<OWLObjectPropertyExpression>>(result);
        Collections.sort(equivs, new SetSizeComparator());
        boolean bl = false;
        while (var5_9 < equivs.size()) {
            Set first = (Set)equivs.get((int)var5_9);
            for (void j = var5_9; j < equivs.size(); ++j) {
                Set second = (Set)equivs.get((int)j);
                if (second.size() <= first.size() || !second.containsAll(first)) continue;
                equivs.remove((int)var5_9);
                break;
            }
            ++var5_9;
        }
        return equivs;
    }

    @Nonnull
    public Collection<Set<OWLObjectPropertyExpression>> getEquivalentObjectProperties() {
        return OWLObjectPropertyManager.getEquivalentObjectProperties(this.getOntologies());
    }

    public static void tarjan(@Nonnull Set<OWLOntology> ontologies, @Nonnull OWLObjectPropertyExpression prop, int index, @Nonnull Stack<OWLObjectPropertyExpression> stack, @Nonnull Map<OWLObjectPropertyExpression, Integer> indexMap, @Nonnull Map<OWLObjectPropertyExpression, Integer> lowlinkMap, @Nonnull Set<Set<OWLObjectPropertyExpression>> result, @Nonnull Set<OWLObjectPropertyExpression> processed, @Nonnull Set<OWLObjectPropertyExpression> stackProps) {
        OWLAPIPreconditions.checkNotNull(ontologies, "ontologies cannot be null");
        OWLAPIPreconditions.checkNotNull(prop, "prop cannot be null");
        OWLAPIPreconditions.checkNotNull(stack, "stack cannot be null");
        OWLAPIPreconditions.checkNotNull(indexMap, "indexMap cannot be null");
        OWLAPIPreconditions.checkNotNull(lowlinkMap, "lowlinkMap cannot be null");
        OWLAPIPreconditions.checkNotNull(result, "result cannot be null");
        OWLAPIPreconditions.checkNotNull(processed, "processed cannot be null");
        OWLAPIPreconditions.checkNotNull(stackProps, "stackProps cannot be null");
        processed.add(prop);
        indexMap.put(prop, index);
        lowlinkMap.put(prop, index);
        stack.push(prop);
        stackProps.add(prop);
        for (OWLOntology ont : ontologies) {
            for (OWLSubObjectPropertyOfAxiom ax : ont.getObjectSubPropertyAxiomsForSubProperty(prop)) {
                if (!((OWLObjectPropertyExpression)ax.getSubProperty()).equals(prop)) continue;
                OWLObjectPropertyExpression supProp = (OWLObjectPropertyExpression)ax.getSuperProperty();
                if (!indexMap.containsKey(supProp)) {
                    OWLObjectPropertyManager.tarjan(ontologies, supProp, index + 1, stack, indexMap, lowlinkMap, result, processed, stackProps);
                    lowlinkMap.put(prop, Math.min(lowlinkMap.get(prop), lowlinkMap.get(supProp)));
                    continue;
                }
                if (!stackProps.contains(supProp)) continue;
                lowlinkMap.put(prop, Math.min(lowlinkMap.get(prop), indexMap.get(supProp)));
            }
        }
        if (lowlinkMap.get(prop).equals(indexMap.get(prop))) {
            OWLObjectPropertyExpression propPrime;
            HashSet<OWLObjectPropertyExpression> scc = new HashSet<OWLObjectPropertyExpression>();
            do {
                propPrime = stack.pop();
                stackProps.remove(propPrime);
                scc.add(propPrime);
            } while (!propPrime.equals(prop));
            if (scc.size() > 1) {
                result.add(scc);
            }
        }
    }

    private static void getReflexiveTransitiveClosure(@Nonnull OWLObjectPropertyExpression prop, @Nonnull Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> map, @Nonnull Set<OWLObjectPropertyExpression> rtc, @Nonnull Set<OWLObjectPropertyExpression> processed) {
        OWLAPIPreconditions.checkNotNull(prop, "prop cannot be null");
        OWLAPIPreconditions.checkNotNull(map, "map cannot be null");
        OWLAPIPreconditions.checkNotNull(rtc, "rtc cannot be null");
        OWLAPIPreconditions.checkNotNull(processed, "processed cannot be null");
        if (processed.contains(prop)) {
            return;
        }
        rtc.add(prop);
        processed.add(prop);
        Set<OWLObjectPropertyExpression> supers = map.get(prop);
        if (supers == null) {
            return;
        }
        for (OWLObjectPropertyExpression sup : supers) {
            assert (sup != null);
            OWLObjectPropertyManager.getReflexiveTransitiveClosure(sup, map, rtc, processed);
        }
    }

    @Nonnull
    private static Set<OWLObjectPropertyExpression> getKeyValue(@Nonnull OWLObjectPropertyExpression key, @Nonnull Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> map) {
        OWLAPIPreconditions.checkNotNull(key, "key cannot be null");
        OWLAPIPreconditions.checkNotNull(map, "map cannot be null");
        Set<OWLObjectPropertyExpression> vals = map.get(key);
        if (vals == null) {
            vals = new HashSet<OWLObjectPropertyExpression>(4);
            map.put(key, vals);
        }
        return vals;
    }

    static class SetSizeComparator
    implements Comparator<Set<OWLObjectPropertyExpression>>,
    Serializable {
        private static final long serialVersionUID = 40000L;

        SetSizeComparator() {
        }

        @Override
        public int compare(Set<OWLObjectPropertyExpression> o1, Set<OWLObjectPropertyExpression> o2) {
            return o1.size() - o2.size();
        }
    }
}

