/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jaas.callback;

import java.io.IOException;
import java.util.Arrays;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.eclipse.jetty.jaas.callback.AbstractCallbackHandler;
import org.eclipse.jetty.jaas.callback.ObjectCallback;
import org.eclipse.jetty.jaas.callback.RequestParameterCallback;
import org.eclipse.jetty.jaas.callback.ServletRequestCallback;
import org.eclipse.jetty.server.Request;

public class DefaultCallbackHandler
extends AbstractCallbackHandler {
    private Request _request;

    public void setRequest(Request request) {
        this._request = request;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(this.getUserName());
                continue;
            }
            if (callback instanceof ObjectCallback) {
                ((ObjectCallback)callback).setObject(this.getCredential());
                continue;
            }
            if (callback instanceof PasswordCallback) {
                ((PasswordCallback)callback).setPassword(this.getCredential().toString().toCharArray());
                continue;
            }
            if (callback instanceof RequestParameterCallback) {
                if (this._request == null) continue;
                RequestParameterCallback rpc = (RequestParameterCallback)callback;
                rpc.setParameterValues(Arrays.asList(this._request.getParameterValues(rpc.getParameterName())));
                continue;
            }
            if (callback instanceof ServletRequestCallback) {
                ((ServletRequestCallback)callback).setRequest(this._request);
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }
}

