/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.registries;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.schema.DitStructureRule;
import org.apache.directory.api.ldap.model.schema.SchemaObject;
import org.apache.directory.api.ldap.model.schema.SchemaObjectType;
import org.apache.directory.api.ldap.model.schema.registries.DefaultSchemaObjectRegistry;
import org.apache.directory.api.ldap.model.schema.registries.DitStructureRuleRegistry;
import org.apache.directory.api.ldap.model.schema.registries.OidRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDitStructureRuleRegistry
extends DefaultSchemaObjectRegistry<DitStructureRule>
implements DitStructureRuleRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDitStructureRuleRegistry.class);
    protected Map<Integer, DitStructureRule> byRuleId = new HashMap<Integer, DitStructureRule>();

    public DefaultDitStructureRuleRegistry() {
        super(SchemaObjectType.DIT_STRUCTURE_RULE, new OidRegistry());
    }

    @Override
    public boolean contains(int ruleId) {
        return this.byRuleId.containsKey(ruleId);
    }

    @Override
    public Iterator<DitStructureRule> iterator() {
        return this.byRuleId.values().iterator();
    }

    @Override
    public Iterator<Integer> ruleIdIterator() {
        return this.byRuleId.keySet().iterator();
    }

    @Override
    public String getSchemaName(int ruleId) throws LdapException {
        DitStructureRule ditStructureRule = this.byRuleId.get(ruleId);
        if (ditStructureRule != null) {
            return ditStructureRule.getSchemaName();
        }
        String msg = I18n.err(I18n.ERR_13729_RULE_ID_NOT_FOUND, ruleId);
        if (LOG.isWarnEnabled()) {
            LOG.warn(msg);
        }
        throw new LdapException(msg);
    }

    @Override
    public void register(DitStructureRule ditStructureRule) throws LdapException {
        int ruleId = ditStructureRule.getRuleId();
        if (this.byRuleId.containsKey(ruleId)) {
            String msg = I18n.err(I18n.ERR_13730_DIT_STRUCTURE_RULE_ALREADY_REGISTRED, ruleId);
            if (LOG.isWarnEnabled()) {
                LOG.warn(msg);
            }
            throw new LdapException(msg);
        }
        this.byRuleId.put(ruleId, ditStructureRule);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_13731_REGISTRED_FOR_OID, ditStructureRule, ruleId));
        }
    }

    @Override
    public DitStructureRule lookup(int ruleId) throws LdapException {
        DitStructureRule ditStructureRule = this.byRuleId.get(ruleId);
        if (ditStructureRule == null) {
            String msg = I18n.err(I18n.ERR_13731_DIT_STRUCTURE_RULE_DOES_NOT_EXIST, ruleId);
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new LdapException(msg);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_13724_FOUND_WITH_RULE_ID, ditStructureRule, ruleId));
        }
        return ditStructureRule;
    }

    @Override
    public void unregister(int ruleId) throws LdapException {
        DitStructureRule ditStructureRule = this.byRuleId.remove(ruleId);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_13721_REMOVED_WITH_RULE_ID, ditStructureRule, ruleId));
        }
    }

    @Override
    public void unregisterSchemaElements(String schemaName) {
        if (schemaName == null) {
            return;
        }
        for (DitStructureRule ditStructureRule : this) {
            if (!schemaName.equalsIgnoreCase(ditStructureRule.getSchemaName())) continue;
            int ruleId = ditStructureRule.getRuleId();
            SchemaObject removed = this.byRuleId.remove(ruleId);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug(I18n.msg(I18n.MSG_13721_REMOVED_WITH_RULE_ID, removed, ruleId));
        }
    }

    @Override
    public void renameSchema(String originalSchemaName, String newSchemaName) {
        for (DitStructureRule ditStructureRule : this) {
            if (!originalSchemaName.equalsIgnoreCase(ditStructureRule.getSchemaName())) continue;
            ditStructureRule.setSchemaName(newSchemaName);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug(I18n.msg(I18n.MSG_13722_RENAMED_SCHEMA_NAME_TO, ditStructureRule, newSchemaName));
        }
    }

    @Override
    public DefaultDitStructureRuleRegistry copy() {
        DefaultDitStructureRuleRegistry copy = new DefaultDitStructureRuleRegistry();
        copy.copy(this);
        return copy;
    }
}

