/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.message.extended;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.message.DeleteResponseImpl;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.util.Strings;

public final class DeleteNoDResponse
extends DeleteResponseImpl {
    public static final String EXTENSION_OID = "1.3.6.1.4.1.1466.20036";
    public static final DeleteNoDResponse UNAVAILABLE = new DeleteNoDResponse(ResultCodeEnum.UNAVAILABLE);
    public static final DeleteNoDResponse PROTOCOLERROR = new DeleteNoDResponse(ResultCodeEnum.PROTOCOL_ERROR);
    public static final DeleteNoDResponse STRONGAUTHREQUIRED = new DeleteNoDResponse(ResultCodeEnum.STRONG_AUTH_REQUIRED);

    private DeleteNoDResponse(ResultCodeEnum rcode) {
        switch (rcode) {
            case UNAVAILABLE: {
                break;
            }
            case PROTOCOL_ERROR: {
                break;
            }
            case STRONG_AUTH_REQUIRED: {
                break;
            }
            default: {
                throw new IllegalArgumentException(I18n.err(I18n.ERR_13503_RESULT_CODE_SHOULD_BE_IN, new Object[]{ResultCodeEnum.UNAVAILABLE, ResultCodeEnum.PROTOCOL_ERROR, ResultCodeEnum.STRONG_AUTH_REQUIRED}));
            }
        }
        super.getLdapResult().setDiagnosticMessage(rcode.toString() + ": The server will disconnect!");
        super.getLdapResult().setMatchedDn(null);
        super.getLdapResult().setResultCode(rcode);
    }

    public byte[] getResponse() {
        return Strings.EMPTY_BYTES;
    }

    public String getResponseName() {
        return EXTENSION_OID;
    }
}

