/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.message;

import org.apache.directory.api.ldap.model.message.AbstractRequest;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.ExtendedRequest;
import org.apache.directory.api.ldap.model.message.ExtendedResponse;
import org.apache.directory.api.ldap.model.message.MessageTypeEnum;

public abstract class AbstractExtendedRequest
extends AbstractRequest
implements ExtendedRequest {
    static final long serialVersionUID = 7916990159044177480L;
    protected String oid;
    private ExtendedResponse response;

    public AbstractExtendedRequest() {
        super(-1, MessageTypeEnum.EXTENDED_REQUEST, true);
    }

    public AbstractExtendedRequest(int id) {
        super(id, MessageTypeEnum.EXTENDED_REQUEST, true);
    }

    @Override
    public String getRequestName() {
        return this.oid;
    }

    @Override
    public ExtendedRequest setRequestName(String newOid) {
        this.oid = newOid;
        return this;
    }

    @Override
    public ExtendedRequest setMessageId(int messageId) {
        super.setMessageId(messageId);
        return this;
    }

    @Override
    public ExtendedRequest addControl(Control control) {
        return (ExtendedRequest)super.addControl(control);
    }

    @Override
    public ExtendedRequest addAllControls(Control[] controls) {
        return (ExtendedRequest)super.addAllControls(controls);
    }

    @Override
    public ExtendedRequest removeControl(Control control) {
        return (ExtendedRequest)super.removeControl(control);
    }

    @Override
    public MessageTypeEnum getResponseType() {
        return MessageTypeEnum.EXTENDED_RESPONSE;
    }

    @Override
    public abstract ExtendedResponse getResultResponse();

    public ExtendedResponse getResponse() {
        return this.response;
    }

    public void setResponse(ExtendedResponse response) {
        this.response = response;
    }

    @Override
    public int hashCode() {
        int hash = 37;
        if (this.oid != null) {
            hash = hash * 17 + this.oid.hashCode();
        }
        hash = hash * 17 + super.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ExtendedRequest)) {
            return false;
        }
        ExtendedRequest req = (ExtendedRequest)obj;
        String requestName = req.getRequestName();
        if (this.oid == null) {
            if (requestName != null) {
                return false;
            }
        } else {
            if (requestName == null) {
                return false;
            }
            if (!this.oid.equals(requestName)) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    Extended request\n");
        sb.append("        Request name : '").append(this.oid).append("'\n");
        sb.append(super.toString());
        return super.toString(sb.toString());
    }
}

