/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.cache.decorators;

import java.util.concurrent.locks.ReentrantLock;
import org.apache.ibatis.cache.Cache;

public class SynchronizedCache
implements Cache {
    private final ReentrantLock lock = new ReentrantLock();
    private final Cache delegate;

    public SynchronizedCache(Cache delegate) {
        this.delegate = delegate;
    }

    @Override
    public String getId() {
        return this.delegate.getId();
    }

    @Override
    public int getSize() {
        this.lock.lock();
        try {
            int n = this.delegate.getSize();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void putObject(Object key, Object object) {
        this.lock.lock();
        try {
            this.delegate.putObject(key, object);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Object getObject(Object key) {
        this.lock.lock();
        try {
            Object object = this.delegate.getObject(key);
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Object removeObject(Object key) {
        this.lock.lock();
        try {
            Object object = this.delegate.removeObject(key);
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            this.delegate.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }
}

