/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util.lockingfile;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantLock;
import net.sourceforge.jnlp.runtime.JNLPRuntime;

public class LockedFile {
    private RandomAccessFile randomAccessFile;
    private FileChannel fileChannel;
    private File file;
    private FileLock processLock = null;
    private ReentrantLock threadLock = new ReentrantLock();
    private boolean readOnly;
    private static final Map<File, LockedFile> instanceCache = new WeakHashMap<File, LockedFile>();

    private LockedFile(File file) {
        this.file = file;
        try {
            this.file.createNewFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.file.isFile() && file.getParentFile() != null && !file.getParentFile().canWrite()) {
            this.readOnly = true;
        } else {
            boolean bl = this.readOnly = !file.canWrite();
            if (!this.readOnly && file.getParentFile() != null && !file.getParentFile().canWrite()) {
                this.readOnly = true;
            }
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public static synchronized LockedFile getInstance(File file) {
        if (!instanceCache.containsKey(file)) {
            LockedFile l = JNLPRuntime.isWindows() ? new WindowsLockedFile(file) : new LockedFile(file);
            instanceCache.put(file, l);
        }
        return instanceCache.get(file);
    }

    public File getFile() {
        return this.file;
    }

    public void lock() throws IOException {
        if (!this.isReadOnly()) {
            this.file.createNewFile();
        }
        this.threadLock.lock();
        this.lockProcess();
    }

    public boolean tryLock() throws IOException {
        if (this.threadLock.tryLock()) {
            this.lockProcess();
            return true;
        }
        return false;
    }

    private void lockProcess() throws IOException {
        if (this.processLock != null) {
            return;
        }
        if (this.file.exists()) {
            this.randomAccessFile = new RandomAccessFile(this.file, this.isReadOnly() ? "r" : "rws");
            this.fileChannel = this.randomAccessFile.getChannel();
            if (!this.isReadOnly()) {
                this.processLock = this.fileChannel.lock();
            }
        }
    }

    public void unlock() throws IOException {
        if (!this.threadLock.isHeldByCurrentThread()) {
            return;
        }
        boolean releaseProcessLock = this.threadLock.getHoldCount() == 1;
        this.unlockImpl(releaseProcessLock);
    }

    protected void unlockImpl(boolean releaseProcessLock) throws IOException {
        try {
            if (releaseProcessLock) {
                if (this.processLock != null) {
                    this.processLock.release();
                }
                this.processLock = null;
                if (this.randomAccessFile != null) {
                    this.randomAccessFile.close();
                }
                if (this.fileChannel != null) {
                    this.fileChannel.close();
                }
            }
        }
        finally {
            this.threadLock.unlock();
        }
    }

    public boolean isHeldByCurrentThread() {
        return this.threadLock.isHeldByCurrentThread();
    }

    private static class WindowsLockedFile
    extends LockedFile {
        public WindowsLockedFile(File file) {
            super(file);
        }

        @Override
        public void lock() throws IOException {
            if (!this.isReadOnly()) {
                ((LockedFile)this).file.createNewFile();
            }
            ((LockedFile)this).threadLock.lock();
        }

        @Override
        public void unlock() throws IOException {
            if (!((LockedFile)this).threadLock.isHeldByCurrentThread()) {
                return;
            }
            this.unlockImpl(false);
        }
    }
}

