/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.JarClassLoader;
import org.netbeans.ProxyURLStreamHandlerFactory;
import org.netbeans.Stamps;
import org.netbeans.Util;
import org.netbeans.core.startup.CLIOptions;
import org.netbeans.core.startup.CoreBridge;
import org.netbeans.core.startup.InstalledFileLocatorImpl;
import org.netbeans.core.startup.ModuleSystem;
import org.netbeans.core.startup.NbRepository;
import org.netbeans.core.startup.RunLevel;
import org.netbeans.core.startup.Splash;
import org.netbeans.core.startup.StartLog;
import org.netbeans.core.startup.TopLogging;
import org.netbeans.core.startup.TopThreadGroup;
import org.netbeans.core.startup.layers.SystemFileSystem;
import org.openide.LifecycleManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;

public final class Main {
    private static final Logger LOG = Logger.getLogger(Main.class.getName());
    private static ModuleSystem moduleSystem;
    private static boolean moduleSystemInitialized;

    public static void setStatusText(String msg) {
        Splash.getInstance().print(msg);
        if (moduleSystemInitialized) {
            CoreBridge.getDefault().setStatusText(msg);
        }
    }

    public static void main(String[] argv) throws Exception {
        TopThreadGroup tg = new TopThreadGroup("IDE Main", argv);
        StartLog.logStart("Forwarding to topThreadGroup");
        tg.start();
        StartLog.logProgress("Main.main finished");
    }

    public static void initializeURLFactory() {
        ProxyURLStreamHandlerFactory.register();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initUICustomizations() {
        block13: {
            if (!CLIOptions.isGui() && CLIOptions.uiClassName == null) {
                return;
            }
            Class<?> uiClass = CLIOptions.uiClass;
            if (CLIOptions.uiClassName != null && CLIOptions.uiClass == null) {
                ClassLoader loader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                try {
                    CLIOptions.uiClass = uiClass = loader.loadClass(CLIOptions.uiClassName);
                }
                catch (ClassNotFoundException ex) {
                    System.err.println(NbBundle.getMessage(Main.class, (String)"ERR_UINotFound", (Object)CLIOptions.uiClassName));
                    if (CLIOptions.isGui()) break block13;
                    return;
                }
            }
        }
        URL themeURL = null;
        boolean wantTheme = Boolean.getBoolean("netbeans.useTheme") || CLIOptions.uiClass != null && CLIOptions.uiClass.getName().indexOf("MetalLookAndFeel") >= 0;
        try {
            if (wantTheme) {
                FileObject fo = FileUtil.getConfigFile((String)"themes.xml");
                if (fo == null) {
                    try {
                        themeURL = new URL("nbresloc:/org/netbeans/core/startup/resources/themes.xml");
                        themeURL.openStream().close();
                    }
                    catch (IOException ex) {
                        themeURL = null;
                    }
                } else {
                    themeURL = fo.toURL();
                }
            }
        }
        finally {
            CoreBridge.getDefault().initializePlaf(CLIOptions.uiClass, CLIOptions.getFontSize(), themeURL);
        }
        if (CLIOptions.getFontSize() > 0 && "GTK".equals(UIManager.getLookAndFeel().getID())) {
            Util.err.warning(NbBundle.getMessage(Main.class, (String)"GTK_FONTSIZE_UNSUPPORTED"));
        }
        StartLog.logProgress("Fonts updated");
    }

    public static ModuleSystem getModuleSystem() {
        return Main.getModuleSystem(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleSystem getModuleSystem(boolean init) {
        Class<Main> clazz = Main.class;
        synchronized (Main.class) {
            if (moduleSystem != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return moduleSystem;
            }
            if (!init) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            StartLog.logStart("Modules initialization");
            try {
                moduleSystem = new ModuleSystem();
                moduleSystem.init(FileUtil.getConfigRoot().getFileSystem());
                SystemFileSystem.registerMutex((Mutex)moduleSystem.getManager().mutex());
            }
            catch (IOException ioe) {
                throw (IllegalStateException)new IllegalStateException("Module system cannot be created").initCause(ioe);
            }
            StartLog.logProgress("ModuleSystem created");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            moduleSystem.loadBootModules();
            moduleSystem.readList();
            moduleSystem.restore();
            StartLog.logEnd("Modules initialization");
            moduleSystemInitialized = true;
            return moduleSystem;
        }
    }

    public static boolean isInitialized() {
        return moduleSystemInitialized;
    }

    static void start(String[] args) throws SecurityException {
        StartLog.logEnd("Forwarding to topThreadGroup");
        StartLog.logStart("Preparation");
        System.setProperty("org.openide.specification.version", "6.2");
        System.setProperty("org.openide.version", "deprecated");
        System.setProperty("org.openide.major.version", "IDE/1");
        String jdkHome = System.getProperty("jdk.home");
        if (jdkHome == null) {
            File binDir;
            jdkHome = System.getProperty("java.home");
            if (!BaseUtilities.isMac() && (binDir = new File(new File(new File(jdkHome), ".."), "bin")).exists()) {
                jdkHome = jdkHome + File.separator + "..";
            }
            System.setProperty("jdk.home", jdkHome);
        }
        Main.initializeURLFactory();
        CLIOptions.initialize();
        StartLog.logProgress("Command line parsed");
        if (CLIOptions.isGui()) {
            try {
                GraphicsEnvironment.getLocalGraphicsEnvironment();
            }
            catch (InternalError exc) {
                String s = NbBundle.getMessage(Main.class, (String)"EXC_GraphicsStartFails1", (Object)exc.getMessage());
                System.out.println(s);
                s = NbBundle.getMessage(Main.class, (String)"EXC_GraphicsStartFails2", (Object)(CLIOptions.getUserDir() + "/var/log/messages.log"));
                System.out.println(s);
                throw exc;
            }
        }
        InstalledFileLocatorImpl.prepareCache();
        try {
            if (!Boolean.getBoolean("netbeans.full.hack") && !Boolean.getBoolean("netbeans.close")) {
                if (!Main.handleLicenseCheck()) {
                    File userdir = new File(CLIOptions.getUserDir());
                    Main.deleteRec(new File(userdir, "var/cache"));
                    Main.deleteRec(new File(userdir, "var/log"));
                    Main.rm(new File(userdir, "var"));
                    Main.rm(new File(userdir, "config"));
                    Main.rm(userdir);
                    TopLogging.exit(0);
                }
                if (!Main.handleImportOfUserDir()) {
                    TopLogging.exit(0);
                }
            }
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        StartLog.logProgress("License check performed and upgrade wizard consulted");
        Splash.getInstance().setRunning(true);
        Splash.getInstance().print(NbBundle.getMessage(Main.class, (String)"MSG_IDEInit"));
        assert (Repository.getDefault() instanceof NbRepository) : "Has to be NbRepository: " + Repository.getDefault();
        Main.getModuleSystem();
        CoreBridge.getDefault().registerPropertyEditors();
        StartLog.logProgress("PropertyEditors registered");
        InstalledFileLocatorImpl.discardCache();
        org.netbeans.Main.finishInitialization();
        StartLog.logProgress("Ran any delayed command-line options");
        for (RunLevel level : Lookup.getDefault().lookupAll(RunLevel.class)) {
            level.run();
        }
        Splash.getInstance().setRunning(false);
        Splash.getInstance().dispose();
        StartLog.logProgress("Splash hidden");
        StartLog.logEnd("Preparation");
        Main.updateAllResources();
        Stamps.getModulesJARs().flush(15000);
        LifecycleManager.getDefault();
    }

    private static void deleteRec(File f) throws IOException {
        if (f.isDirectory()) {
            File[] kids = f.listFiles();
            if (kids == null) {
                Logger.getLogger(Main.class.getName()).log(Level.WARNING, "Could not list: {0}", f);
            } else {
                for (File kid : kids) {
                    Main.deleteRec(kid);
                }
            }
        }
        Main.rm(f);
    }

    private static void rm(File f) {
        if (f.exists() && !f.delete()) {
            Logger.getLogger(Main.class.getName()).log(Level.WARNING, "Failed to delete {0}", f);
        }
    }

    private static final Class getKlass(String cls) {
        try {
            ModuleSystem ms = moduleSystem;
            ClassLoader loader = ms != null ? ms.getManager().getClassLoader() : Main.class.getClassLoader();
            return Class.forName(cls, false, loader);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getLocalizedMessage());
        }
    }

    static boolean handleImportOfUserDir() {
        class ImportHandler
        implements Runnable {
            private File installed = new File(new File(CLIOptions.getUserDir(), "var"), "imported");
            private String classname;
            private boolean executedOk;

            ImportHandler() {
            }

            public boolean shouldDoAnImport() {
                this.classname = System.getProperty("netbeans.importclass");
                return this.classname != null && !this.installed.exists();
            }

            @Override
            public void run() {
                try {
                    Class clazz = Main.getKlass(this.classname);
                    Method showMethod = clazz.getMethod("main", String[].class);
                    showMethod.invoke(null, new Object[]{new String[0]});
                    this.executedOk = true;
                }
                catch (InvocationTargetException ex) {
                    if (ex.getTargetException() instanceof UserCancelException) {
                        this.executedOk = true;
                    } else {
                        LOG.log(Level.WARNING, null, ex);
                    }
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, null, e);
                }
                catch (LinkageError e) {
                    LOG.log(Level.WARNING, null, e);
                }
            }

            public boolean canContinue() {
                if (this.shouldDoAnImport()) {
                    try {
                        SwingUtilities.invokeAndWait(this);
                        if (this.executedOk) {
                            this.installed.getParentFile().mkdirs();
                            this.installed.createNewFile();
                            return true;
                        }
                        return false;
                    }
                    catch (IOException ex) {
                        LOG.log(Level.WARNING, null, ex);
                        return true;
                    }
                    catch (InvocationTargetException ex) {
                        return false;
                    }
                    catch (InterruptedException ex) {
                        LOG.log(Level.WARNING, null, ex);
                        return false;
                    }
                }
                return true;
            }
        }
        ImportHandler handler = new ImportHandler();
        return handler.canContinue();
    }

    static boolean handleLicenseCheck() {
        class LicenseHandler
        implements Runnable {
            private String classname;
            private boolean executedOk;

            LicenseHandler() {
            }

            public boolean shouldDisplayLicense() {
                if (this.licenseFileExists()) {
                    return false;
                }
                this.classname = System.getProperty("netbeans.accept_license_class");
                return this.classname != null;
            }

            @Override
            public void run() {
                block9: {
                    try {
                        Class clazz = Main.getKlass(this.classname);
                        Method showMethod = clazz.getMethod("showLicensePanel", new Class[0]);
                        showMethod.invoke(null, new Object[0]);
                        this.executedOk = true;
                        File f = new File(new File(CLIOptions.getUserDir(), "var"), "license_accepted");
                        if (f.exists()) break block9;
                        f.getParentFile().mkdirs();
                        try {
                            f.createNewFile();
                            if (!this.licenseFileExists()) {
                                throw new IOException("InstalledFileLocator can't find " + f);
                            }
                        }
                        catch (IOException exc) {
                            LOG.log(Level.WARNING, null, exc);
                        }
                    }
                    catch (InvocationTargetException ex) {
                        if (ex.getTargetException() instanceof UserCancelException) {
                            this.executedOk = false;
                        } else {
                            LOG.log(Level.WARNING, null, ex);
                        }
                    }
                    catch (Exception ex) {
                        LOG.log(Level.WARNING, null, ex);
                    }
                    catch (LinkageError ex) {
                        LOG.log(Level.WARNING, null, ex);
                    }
                }
            }

            public boolean canContinue() {
                if (this.shouldDisplayLicense()) {
                    try {
                        SwingUtilities.invokeAndWait(this);
                        return this.executedOk;
                    }
                    catch (InvocationTargetException ex) {
                        return false;
                    }
                    catch (InterruptedException ex) {
                        LOG.log(Level.WARNING, null, ex);
                        return false;
                    }
                }
                return true;
            }

            private boolean licenseFileExists() {
                for (File cluster : InstalledFileLocatorImpl.computeDirs()) {
                    File f = new File(new File(cluster, "var"), "license_accepted");
                    if (!f.exists()) continue;
                    return true;
                }
                return false;
            }
        }
        LicenseHandler handler = new LicenseHandler();
        return handler.canContinue();
    }

    static boolean updateAllResources() {
        String value = System.getProperty("org.netbeans.core.update.all.resources", "always");
        if (!"never".equals(value)) {
            if ("missing".equals(value)) {
                if (!JarClassLoader.isArchivePopulated()) {
                    JarClassLoader.saveArchive();
                    return true;
                }
            } else {
                assert ("always".equals(value));
                JarClassLoader.saveArchive();
                return true;
            }
        }
        return false;
    }
}

