/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.os;

import com.jogamp.common.os.Platform;
import jogamp.common.os.PlatformPropsImpl;

public class MachineDataInfo {
    private static final int[] size_arm_mips_32 = new int[]{4, 4, 4, 8, 8, 4, 4096};
    private static final int[] size_x86_32_unix = new int[]{4, 4, 4, 8, 12, 4, 4096};
    private static final int[] size_x86_32_android = new int[]{4, 4, 4, 8, 8, 4, 4096};
    private static final int[] size_x86_32_macos = new int[]{4, 4, 4, 8, 16, 4, 4096};
    private static final int[] size_ppc_32_unix = new int[]{4, 4, 4, 8, 16, 4, 4096};
    private static final int[] size_sparc_32_sunos = new int[]{4, 4, 4, 8, 16, 4, 8192};
    private static final int[] size_x86_32_windows = new int[]{4, 4, 4, 8, 12, 4, 4096};
    private static final int[] size_lp64_unix = new int[]{4, 8, 4, 8, 16, 8, 4096};
    private static final int[] size_x86_64_windows = new int[]{4, 4, 4, 8, 16, 8, 4096};
    private static final int[] size_arm64_ios = new int[]{4, 8, 4, 8, 8, 8, 8192};
    private static final int[] align_arm_mips_32 = new int[]{1, 2, 4, 8, 4, 4, 4, 8, 8, 4};
    private static final int[] align_x86_32_unix = new int[]{1, 2, 4, 4, 4, 4, 4, 4, 4, 4};
    private static final int[] align_x86_32_macos = new int[]{1, 2, 4, 4, 4, 4, 4, 4, 16, 4};
    private static final int[] align_ppc_32_unix = new int[]{1, 2, 4, 8, 4, 4, 4, 8, 16, 4};
    private static final int[] align_sparc_32_sunos = new int[]{1, 2, 4, 8, 4, 4, 4, 8, 8, 4};
    private static final int[] align_x86_32_windows = new int[]{1, 2, 4, 8, 4, 4, 4, 8, 4, 4};
    private static final int[] align_lp64_unix = new int[]{1, 2, 4, 8, 4, 8, 4, 8, 16, 8};
    private static final int[] align_x86_64_windows = new int[]{1, 2, 4, 8, 4, 4, 4, 8, 16, 8};
    private static final int[] align_arm64_ios = new int[]{1, 2, 4, 8, 4, 8, 4, 8, 8, 8};
    private final boolean runtimeValidated;
    private final int int8SizeInBytes = 1;
    private final int int16SizeInBytes = 2;
    private final int int32SizeInBytes = 4;
    private final int int64SizeInBytes = 8;
    private final int intSizeInBytes;
    private final int longSizeInBytes;
    private final int floatSizeInBytes;
    private final int doubleSizeInBytes;
    private final int ldoubleSizeInBytes;
    private final int pointerSizeInBytes;
    private final int pageSizeInBytes;
    private final int int8AlignmentInBytes;
    private final int int16AlignmentInBytes;
    private final int int32AlignmentInBytes;
    private final int int64AlignmentInBytes;
    private final int intAlignmentInBytes;
    private final int longAlignmentInBytes;
    private final int floatAlignmentInBytes;
    private final int doubleAlignmentInBytes;
    private final int ldoubleAlignmentInBytes;
    private final int pointerAlignmentInBytes;

    public MachineDataInfo(boolean bl, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17) {
        this.runtimeValidated = bl;
        this.intSizeInBytes = n;
        this.longSizeInBytes = n2;
        this.floatSizeInBytes = n3;
        this.doubleSizeInBytes = n4;
        this.ldoubleSizeInBytes = n5;
        this.pointerSizeInBytes = n6;
        this.pageSizeInBytes = n7;
        this.int8AlignmentInBytes = n8;
        this.int16AlignmentInBytes = n9;
        this.int32AlignmentInBytes = n10;
        this.int64AlignmentInBytes = n11;
        this.intAlignmentInBytes = n12;
        this.longAlignmentInBytes = n13;
        this.floatAlignmentInBytes = n14;
        this.doubleAlignmentInBytes = n15;
        this.ldoubleAlignmentInBytes = n16;
        this.pointerAlignmentInBytes = n17;
    }

    public final boolean isRuntimeValidated() {
        return this.runtimeValidated;
    }

    public final int intSizeInBytes() {
        return this.intSizeInBytes;
    }

    public final int longSizeInBytes() {
        return this.longSizeInBytes;
    }

    public final int int8SizeInBytes() {
        return 1;
    }

    public final int int16SizeInBytes() {
        return 2;
    }

    public final int int32SizeInBytes() {
        return 4;
    }

    public final int int64SizeInBytes() {
        return 8;
    }

    public final int floatSizeInBytes() {
        return this.floatSizeInBytes;
    }

    public final int doubleSizeInBytes() {
        return this.doubleSizeInBytes;
    }

    public final int ldoubleSizeInBytes() {
        return this.ldoubleSizeInBytes;
    }

    public final int pointerSizeInBytes() {
        return this.pointerSizeInBytes;
    }

    public final int pageSizeInBytes() {
        return this.pageSizeInBytes;
    }

    public final int intAlignmentInBytes() {
        return this.intAlignmentInBytes;
    }

    public final int longAlignmentInBytes() {
        return this.longAlignmentInBytes;
    }

    public final int int8AlignmentInBytes() {
        return this.int8AlignmentInBytes;
    }

    public final int int16AlignmentInBytes() {
        return this.int16AlignmentInBytes;
    }

    public final int int32AlignmentInBytes() {
        return this.int32AlignmentInBytes;
    }

    public final int int64AlignmentInBytes() {
        return this.int64AlignmentInBytes;
    }

    public final int floatAlignmentInBytes() {
        return this.floatAlignmentInBytes;
    }

    public final int doubleAlignmentInBytes() {
        return this.doubleAlignmentInBytes;
    }

    public final int ldoubleAlignmentInBytes() {
        return this.ldoubleAlignmentInBytes;
    }

    public final int pointerAlignmentInBytes() {
        return this.pointerAlignmentInBytes;
    }

    public int pageCount(int n) {
        return (n + (this.pageSizeInBytes - 1)) / this.pageSizeInBytes;
    }

    public int pageAlignedSize(int n) {
        return this.pageCount(n) * this.pageSizeInBytes;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MachineDataInfo)) {
            return false;
        }
        MachineDataInfo machineDataInfo = (MachineDataInfo)object;
        return this.pageSizeInBytes == machineDataInfo.pageSizeInBytes && this.compatible(machineDataInfo);
    }

    public final boolean compatible(MachineDataInfo machineDataInfo) {
        return this.intSizeInBytes == machineDataInfo.intSizeInBytes && this.longSizeInBytes == machineDataInfo.longSizeInBytes && this.floatSizeInBytes == machineDataInfo.floatSizeInBytes && this.doubleSizeInBytes == machineDataInfo.doubleSizeInBytes && this.ldoubleSizeInBytes == machineDataInfo.ldoubleSizeInBytes && this.pointerSizeInBytes == machineDataInfo.pointerSizeInBytes && this.int8AlignmentInBytes == machineDataInfo.int8AlignmentInBytes && this.int16AlignmentInBytes == machineDataInfo.int16AlignmentInBytes && this.int32AlignmentInBytes == machineDataInfo.int32AlignmentInBytes && this.int64AlignmentInBytes == machineDataInfo.int64AlignmentInBytes && this.intAlignmentInBytes == machineDataInfo.intAlignmentInBytes && this.longAlignmentInBytes == machineDataInfo.longAlignmentInBytes && this.floatAlignmentInBytes == machineDataInfo.floatAlignmentInBytes && this.doubleAlignmentInBytes == machineDataInfo.doubleAlignmentInBytes && this.ldoubleAlignmentInBytes == machineDataInfo.ldoubleAlignmentInBytes && this.pointerAlignmentInBytes == machineDataInfo.pointerAlignmentInBytes;
    }

    public StringBuilder toString(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("MachineDataInfo: runtimeValidated ").append(this.isRuntimeValidated()).append(", 32Bit ").append(4 == this.pointerAlignmentInBytes).append(", primitive size / alignment:").append(PlatformPropsImpl.NEWLINE);
        stringBuilder.append("  int8    ").append(1).append(" / ").append(this.int8AlignmentInBytes);
        stringBuilder.append(", int16   ").append(2).append(" / ").append(this.int16AlignmentInBytes).append(Platform.getNewline());
        stringBuilder.append("  int     ").append(this.intSizeInBytes).append(" / ").append(this.intAlignmentInBytes);
        stringBuilder.append(", long    ").append(this.longSizeInBytes).append(" / ").append(this.longAlignmentInBytes).append(Platform.getNewline());
        stringBuilder.append("  int32   ").append(4).append(" / ").append(this.int32AlignmentInBytes);
        stringBuilder.append(", int64   ").append(8).append(" / ").append(this.int64AlignmentInBytes).append(Platform.getNewline());
        stringBuilder.append("  float   ").append(this.floatSizeInBytes).append(" / ").append(this.floatAlignmentInBytes);
        stringBuilder.append(", double  ").append(this.doubleSizeInBytes).append(" / ").append(this.doubleAlignmentInBytes);
        stringBuilder.append(", ldouble ").append(this.ldoubleSizeInBytes).append(" / ").append(this.ldoubleAlignmentInBytes).append(Platform.getNewline());
        stringBuilder.append("  pointer ").append(this.pointerSizeInBytes).append(" / ").append(this.pointerAlignmentInBytes);
        stringBuilder.append(", page    ").append(this.pageSizeInBytes);
        return stringBuilder;
    }

    public String toString() {
        return this.toString(null).toString();
    }

    static /* synthetic */ int[] access$000() {
        return size_arm_mips_32;
    }

    static /* synthetic */ int[] access$100() {
        return align_arm_mips_32;
    }

    static /* synthetic */ int[] access$200() {
        return size_x86_32_unix;
    }

    static /* synthetic */ int[] access$300() {
        return align_x86_32_unix;
    }

    static /* synthetic */ int[] access$400() {
        return size_x86_32_android;
    }

    static /* synthetic */ int[] access$500() {
        return size_x86_32_macos;
    }

    static /* synthetic */ int[] access$600() {
        return align_x86_32_macos;
    }

    static /* synthetic */ int[] access$700() {
        return size_ppc_32_unix;
    }

    static /* synthetic */ int[] access$800() {
        return align_ppc_32_unix;
    }

    static /* synthetic */ int[] access$900() {
        return size_sparc_32_sunos;
    }

    static /* synthetic */ int[] access$1000() {
        return align_sparc_32_sunos;
    }

    static /* synthetic */ int[] access$1100() {
        return size_x86_32_windows;
    }

    static /* synthetic */ int[] access$1200() {
        return align_x86_32_windows;
    }

    static /* synthetic */ int[] access$1300() {
        return size_lp64_unix;
    }

    static /* synthetic */ int[] access$1400() {
        return align_lp64_unix;
    }

    static /* synthetic */ int[] access$1500() {
        return size_x86_64_windows;
    }

    static /* synthetic */ int[] access$1600() {
        return align_x86_64_windows;
    }

    static /* synthetic */ int[] access$1700() {
        return size_arm64_ios;
    }

    static /* synthetic */ int[] access$1800() {
        return align_arm64_ios;
    }

    public static enum StaticConfig {
        ARM_MIPS_32(MachineDataInfo.access$000(), MachineDataInfo.access$100()),
        X86_32_UNIX(MachineDataInfo.access$200(), MachineDataInfo.access$300()),
        X86_32_ANDROID(MachineDataInfo.access$400(), MachineDataInfo.access$300()),
        X86_32_MACOS(MachineDataInfo.access$500(), MachineDataInfo.access$600()),
        PPC_32_UNIX(MachineDataInfo.access$700(), MachineDataInfo.access$800()),
        SPARC_32_SUNOS(MachineDataInfo.access$900(), MachineDataInfo.access$1000()),
        X86_32_WINDOWS(MachineDataInfo.access$1100(), MachineDataInfo.access$1200()),
        LP64_UNIX(MachineDataInfo.access$1300(), MachineDataInfo.access$1400()),
        X86_64_WINDOWS(MachineDataInfo.access$1500(), MachineDataInfo.access$1600()),
        ARM64_IOS(MachineDataInfo.access$1700(), MachineDataInfo.access$1800());

        public final MachineDataInfo md;

        private StaticConfig(int[] nArray, int[] nArray2) {
            int n2 = 0;
            int n3 = 0;
            this.md = new MachineDataInfo(false, nArray[n2++], nArray[n2++], nArray[n2++], nArray[n2++], nArray[n2++], nArray[n2++], nArray[n2++], nArray2[n3++], nArray2[n3++], nArray2[n3++], nArray2[n3++], nArray2[n3++], nArray2[n3++], nArray2[n3++], nArray2[n3++], nArray2[n3++], nArray2[n3++]);
        }

        public final StringBuilder toString(StringBuilder stringBuilder) {
            if (null == stringBuilder) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append("MachineDataInfoStatic: ").append(this.name()).append("(").append(this.ordinal()).append("): ");
            this.md.toString(stringBuilder);
            return stringBuilder;
        }

        public final String toShortString() {
            return this.name() + "(" + this.ordinal() + ")";
        }

        public String toString() {
            return this.toString(null).toString();
        }

        public static final void validateUniqueMachineDataInfo() {
            StaticConfig[] staticConfigArray = StaticConfig.values();
            for (int i = staticConfigArray.length - 1; i >= 0; --i) {
                StaticConfig staticConfig = staticConfigArray[i];
                for (int j = staticConfigArray.length - 1; j >= 0; --j) {
                    if (i == j) continue;
                    StaticConfig staticConfig2 = staticConfigArray[j];
                    if (!staticConfig.md.compatible(staticConfig2.md)) continue;
                    String string = "Duplicate/Compatible MachineDataInfo in StaticConfigs: Elements [" + i + ": " + staticConfig.toShortString() + "] and [" + j + ": " + staticConfig2.toShortString() + "]";
                    System.err.println(string);
                    System.err.println((Object)staticConfig);
                    System.err.println((Object)staticConfig2);
                    throw new InternalError(string);
                }
            }
        }

        public static final StaticConfig findCompatible(MachineDataInfo machineDataInfo) {
            StaticConfig[] staticConfigArray = StaticConfig.values();
            for (int i = staticConfigArray.length - 1; i >= 0; --i) {
                StaticConfig staticConfig = staticConfigArray[i];
                if (!staticConfig.md.compatible(machineDataInfo)) continue;
                return staticConfig;
            }
            return null;
        }
    }
}

