/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview.plugin.builders;

import org.gephi.graph.api.DirectedGraph;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.preview.api.Item;
import org.gephi.preview.plugin.items.EdgeItem;
import org.gephi.preview.spi.ItemBuilder;

public class EdgeBuilder
implements ItemBuilder {
    public Item[] getItems(Graph graph) {
        Item[] items = new EdgeItem[graph.getEdgeCount()];
        int i = 0;
        for (Edge e : graph.getEdges()) {
            EdgeItem item = new EdgeItem(e);
            item.setData("weight", e.getWeight(graph.getView()));
            item.setData("directed", e.isDirected());
            if (graph.isDirected(e)) {
                item.setData("mutual", ((DirectedGraph)graph).getMutualEdge(e) != null);
            }
            item.setData("self_loop", e.isSelfLoop());
            item.setData("color", e.alpha() == 0.0f ? null : e.getColor());
            items[i++] = item;
        }
        return items;
    }

    public String getType() {
        return "edge";
    }
}

