/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.components.splineeditor.equation;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import org.gephi.ui.components.splineeditor.equation.AbstractEquation;
import org.gephi.ui.utils.UIUtils;

public class EquationDisplay
extends JComponent
implements PropertyChangeListener {
    private final Color colorBackground;
    private final Color colorMajorGrid;
    private final Color colorMinorGrid;
    private final Color colorAxis;
    private static final float STROKE_AXIS = 1.2f;
    private static final float STROKE_GRID = 1.0f;
    private static final float COEFF_ZOOM = 1.1f;
    protected double minX;
    protected double maxX;
    protected double minY;
    protected double maxY;
    private final List<DrawableEquation> equations;
    private final double originX;
    private final double originY;
    private final double majorX;
    private final int minorX;
    private final double majorY;
    private final int minorY;
    private boolean drawText = true;
    private Point dragStart;
    private final NumberFormat formatter;
    private final ZoomHandler zoomHandler;
    private final PanMotionHandler panMotionHandler;
    private final PanHandler panHandler;

    public EquationDisplay(double originX, double originY, double minX, double maxX, double minY, double maxY, double majorX, int minorX, double majorY, int minorY) {
        if (minX >= maxX) {
            throw new IllegalArgumentException("minX must be < to maxX");
        }
        if (originX < minX || originX > maxX) {
            throw new IllegalArgumentException("originX must be between minX and maxX");
        }
        if (minY >= maxY) {
            throw new IllegalArgumentException("minY must be < to maxY");
        }
        if (originY < minY || originY > maxY) {
            throw new IllegalArgumentException("originY must be between minY and maxY");
        }
        if (minorX <= 0) {
            throw new IllegalArgumentException("minorX must be > 0");
        }
        if (minorY <= 0) {
            throw new IllegalArgumentException("minorY must be > 0");
        }
        if (majorX <= 0.0) {
            throw new IllegalArgumentException("majorX must be > 0.0");
        }
        if (majorY <= 0.0) {
            throw new IllegalArgumentException("majorY must be > 0.0");
        }
        this.originX = originX;
        this.originY = originY;
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        this.majorX = majorX;
        this.minorX = minorX;
        this.majorY = majorY;
        this.minorY = minorY;
        this.equations = new LinkedList<DrawableEquation>();
        this.formatter = NumberFormat.getInstance();
        this.formatter.setMaximumFractionDigits(2);
        if (UIUtils.isDarkLookAndFeel()) {
            this.colorBackground = new Color(43, 43, 43);
            this.colorMajorGrid = new Color(80, 80, 80);
            this.colorMinorGrid = new Color(60, 60, 60);
            this.colorAxis = Color.GRAY;
        } else {
            this.colorBackground = Color.WHITE;
            this.colorMajorGrid = Color.GRAY.brighter();
            this.colorMinorGrid = new Color(220, 220, 220);
            this.colorAxis = Color.BLACK;
        }
        this.panHandler = new PanHandler();
        this.addMouseListener(this.panHandler);
        this.panMotionHandler = new PanMotionHandler();
        this.addMouseMotionListener(this.panMotionHandler);
        this.zoomHandler = new ZoomHandler();
        this.addMouseWheelListener(this.zoomHandler);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.isEnabled() != enabled) {
            if (enabled) {
                this.addMouseListener(this.panHandler);
                this.addMouseMotionListener(this.panMotionHandler);
                this.addMouseWheelListener(this.zoomHandler);
            } else {
                this.removeMouseListener(this.panHandler);
                this.removeMouseMotionListener(this.panMotionHandler);
                this.removeMouseWheelListener(this.zoomHandler);
            }
        }
    }

    public boolean isDrawText() {
        return this.drawText;
    }

    public void setDrawText(boolean drawText) {
        this.drawText = drawText;
    }

    public void addEquation(AbstractEquation equation, Color color) {
        if (equation != null && !this.equations.contains(equation)) {
            equation.addPropertyChangeListener(this);
            this.equations.add(new DrawableEquation(equation, color));
            this.repaint();
        }
    }

    public void removeEquation(AbstractEquation equation) {
        if (equation != null) {
            DrawableEquation toRemove = null;
            for (DrawableEquation drawable : this.equations) {
                if (drawable.getEquation() != equation) continue;
                toRemove = drawable;
                break;
            }
            if (toRemove != null) {
                equation.removePropertyChangeListener(this);
                this.equations.remove(toRemove);
                this.repaint();
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(400, 400);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.repaint();
    }

    protected double yPositionToPixel(double position) {
        double height = this.getHeight();
        return height - (position - this.minY) * height / (this.maxY - this.minY);
    }

    protected double xPositionToPixel(double position) {
        return (position - this.minX) * (double)this.getWidth() / (this.maxX - this.minX);
    }

    protected double xPixelToPosition(double pixel) {
        double axisV = this.xPositionToPixel(this.originX);
        return (pixel - axisV) * (this.maxX - this.minX) / (double)this.getWidth();
    }

    protected double yPixelToPosition(double pixel) {
        double axisH = this.yPositionToPixel(this.originY);
        return ((double)this.getHeight() - pixel - axisH) * (this.maxY - this.minY) / (double)this.getHeight();
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (!this.isVisible()) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        this.setupGraphics(g2);
        this.paintBackground(g2);
        this.drawGrid(g2);
        this.drawAxis(g2);
        this.drawEquations(g2);
        this.paintInformation(g2);
    }

    protected void paintInformation(Graphics2D g2) {
    }

    private void drawEquations(Graphics2D g2) {
        for (DrawableEquation drawable : this.equations) {
            g2.setColor(drawable.getColor());
            this.drawEquation(g2, drawable.getEquation());
        }
    }

    private void drawEquation(Graphics2D g2, AbstractEquation equation) {
        float x = 0.0f;
        float y = (float)this.yPositionToPixel(equation.compute(this.xPixelToPosition(0.0)));
        GeneralPath path = new GeneralPath();
        path.moveTo(x, y);
        for (x = 0.0f; x < (float)this.getWidth(); x += 1.0f) {
            double position = this.xPixelToPosition(x);
            y = (float)this.yPositionToPixel(equation.compute(position));
            path.lineTo(x, y);
        }
        g2.draw(path);
    }

    private void drawGrid(Graphics2D g2) {
        Stroke stroke = g2.getStroke();
        this.drawVerticalGrid(g2);
        this.drawHorizontalGrid(g2);
        if (this.drawText) {
            this.drawVerticalLabels(g2);
            this.drawHorizontalLabels(g2);
        }
        g2.setStroke(stroke);
    }

    private void drawHorizontalLabels(Graphics2D g2) {
        int position;
        double y;
        double axisV = this.xPositionToPixel(this.originX);
        g2.setColor(this.colorAxis);
        for (y = this.originY + this.majorY; y < this.maxY + this.majorY; y += this.majorY) {
            position = (int)this.yPositionToPixel(y);
            g2.drawString(this.formatter.format(y), (int)axisV + 5, position);
        }
        for (y = this.originY - this.majorY; y > this.minY - this.majorY; y -= this.majorY) {
            position = (int)this.yPositionToPixel(y);
            g2.drawString(this.formatter.format(y), (int)axisV + 5, position);
        }
    }

    private void drawHorizontalGrid(Graphics2D g2) {
        int position;
        int position2;
        int i;
        double y;
        double minorSpacing = this.majorY / (double)this.minorY;
        double axisV = this.xPositionToPixel(this.originX);
        BasicStroke gridStroke = new BasicStroke(1.0f);
        BasicStroke axisStroke = new BasicStroke(1.2f);
        for (y = this.originY + this.majorY; y < this.maxY + this.majorY; y += this.majorY) {
            g2.setStroke(gridStroke);
            g2.setColor(this.colorMinorGrid);
            for (i = 0; i < this.minorY; ++i) {
                position2 = (int)this.yPositionToPixel(y - (double)i * minorSpacing);
                g2.drawLine(0, position2, this.getWidth(), position2);
            }
            position = (int)this.yPositionToPixel(y);
            g2.setColor(this.colorMajorGrid);
            g2.drawLine(0, position, this.getWidth(), position);
            g2.setStroke(axisStroke);
            g2.setColor(this.colorAxis);
            g2.drawLine((int)axisV - 3, position, (int)axisV + 3, position);
        }
        for (y = this.originY - this.majorY; y > this.minY - this.majorY; y -= this.majorY) {
            g2.setStroke(gridStroke);
            g2.setColor(this.colorMinorGrid);
            for (i = 0; i < this.minorY; ++i) {
                position2 = (int)this.yPositionToPixel(y + (double)i * minorSpacing);
                g2.drawLine(0, position2, this.getWidth(), position2);
            }
            position = (int)this.yPositionToPixel(y);
            g2.setColor(this.colorMajorGrid);
            g2.drawLine(0, position, this.getWidth(), position);
            g2.setStroke(axisStroke);
            g2.setColor(this.colorAxis);
            g2.drawLine((int)axisV - 3, position, (int)axisV + 3, position);
        }
    }

    private void drawVerticalLabels(Graphics2D g2) {
        int position;
        double x;
        double axisH = this.yPositionToPixel(this.originY);
        FontMetrics metrics = g2.getFontMetrics();
        g2.setColor(this.colorAxis);
        for (x = this.originX + this.majorX; x < this.maxX + this.majorX; x += this.majorX) {
            position = (int)this.xPositionToPixel(x);
            g2.drawString(this.formatter.format(x), position, (int)axisH + metrics.getHeight());
        }
        for (x = this.originX - this.majorX; x > this.minX - this.majorX; x -= this.majorX) {
            position = (int)this.xPositionToPixel(x);
            g2.drawString(this.formatter.format(x), position, (int)axisH + metrics.getHeight());
        }
    }

    private void drawVerticalGrid(Graphics2D g2) {
        int position;
        int position2;
        int i;
        double x;
        double minorSpacing = this.majorX / (double)this.minorX;
        double axisH = this.yPositionToPixel(this.originY);
        BasicStroke gridStroke = new BasicStroke(1.0f);
        BasicStroke axisStroke = new BasicStroke(1.2f);
        for (x = this.originX + this.majorX; x < this.maxX + this.majorX; x += this.majorX) {
            g2.setStroke(gridStroke);
            g2.setColor(this.colorMinorGrid);
            for (i = 0; i < this.minorX; ++i) {
                position2 = (int)this.xPositionToPixel(x - (double)i * minorSpacing);
                g2.drawLine(position2, 0, position2, this.getHeight());
            }
            position = (int)this.xPositionToPixel(x);
            g2.setColor(this.colorMajorGrid);
            g2.drawLine(position, 0, position, this.getHeight());
            g2.setStroke(axisStroke);
            g2.setColor(this.colorAxis);
            g2.drawLine(position, (int)axisH - 3, position, (int)axisH + 3);
        }
        for (x = this.originX - this.majorX; x > this.minX - this.majorX; x -= this.majorX) {
            g2.setStroke(gridStroke);
            g2.setColor(this.colorMinorGrid);
            for (i = 0; i < this.minorX; ++i) {
                position2 = (int)this.xPositionToPixel(x + (double)i * minorSpacing);
                g2.drawLine(position2, 0, position2, this.getHeight());
            }
            position = (int)this.xPositionToPixel(x);
            g2.setColor(this.colorMajorGrid);
            g2.drawLine(position, 0, position, this.getHeight());
            g2.setStroke(axisStroke);
            g2.setColor(this.colorAxis);
            g2.drawLine(position, (int)axisH - 3, position, (int)axisH + 3);
        }
    }

    private void drawAxis(Graphics2D g2) {
        double axisH = this.yPositionToPixel(this.originY);
        double axisV = this.xPositionToPixel(this.originX);
        g2.setColor(this.colorAxis);
        Stroke stroke = g2.getStroke();
        g2.setStroke(new BasicStroke(1.2f));
        g2.drawLine(0, (int)axisH, this.getWidth(), (int)axisH);
        g2.drawLine((int)axisV, 0, (int)axisV, this.getHeight());
        FontMetrics metrics = g2.getFontMetrics();
        g2.drawString(this.formatter.format(0.0), (int)axisV + 5, (int)axisH + metrics.getHeight());
        g2.setStroke(stroke);
    }

    protected void setupGraphics(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    protected void paintBackground(Graphics2D g2) {
        g2.setColor(this.colorBackground);
        g2.fill(g2.getClipBounds());
    }

    public List<DrawableEquation> getEquations() {
        return this.equations;
    }

    private class PanMotionHandler
    extends MouseMotionAdapter {
        private PanMotionHandler() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Point dragEnd = e.getPoint();
            double distance = EquationDisplay.this.xPixelToPosition(dragEnd.getX()) - EquationDisplay.this.xPixelToPosition(EquationDisplay.this.dragStart.getX());
            EquationDisplay.this.minX -= distance;
            EquationDisplay.this.maxX -= distance;
            distance = EquationDisplay.this.yPixelToPosition(dragEnd.getY()) - EquationDisplay.this.yPixelToPosition(EquationDisplay.this.dragStart.getY());
            EquationDisplay.this.minY -= distance;
            EquationDisplay.this.maxY -= distance;
            EquationDisplay.this.repaint();
            EquationDisplay.this.dragStart = dragEnd;
        }
    }

    private class PanHandler
    extends MouseAdapter {
        private PanHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            EquationDisplay.this.dragStart = e.getPoint();
        }
    }

    private class ZoomHandler
    implements MouseWheelListener {
        private ZoomHandler() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            double distanceX = EquationDisplay.this.maxX - EquationDisplay.this.minX;
            double distanceY = EquationDisplay.this.maxY - EquationDisplay.this.minY;
            double cursorX = EquationDisplay.this.minX + distanceX / 2.0;
            double cursorY = EquationDisplay.this.minY + distanceY / 2.0;
            int rotation = e.getWheelRotation();
            if (rotation < 0) {
                distanceX /= (double)1.1f;
                distanceY /= (double)1.1f;
            } else {
                distanceX *= (double)1.1f;
                distanceY *= (double)1.1f;
            }
            EquationDisplay.this.minX = cursorX - distanceX / 2.0;
            EquationDisplay.this.maxX = cursorX + distanceX / 2.0;
            EquationDisplay.this.minY = cursorY - distanceY / 2.0;
            EquationDisplay.this.maxY = cursorY + distanceY / 2.0;
            EquationDisplay.this.repaint();
        }
    }

    private class DrawableEquation {
        private final AbstractEquation equation;
        private final Color color;

        DrawableEquation(AbstractEquation equation, Color color) {
            this.equation = equation;
            this.color = color;
        }

        AbstractEquation getEquation() {
            return this.equation;
        }

        Color getColor() {
            return this.color;
        }
    }
}

