/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.processor.plugin;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.Color;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.Origin;
import org.gephi.graph.api.Table;
import org.gephi.graph.api.TimeRepresentation;
import org.gephi.graph.api.types.IntervalDoubleMap;
import org.gephi.graph.api.types.IntervalMap;
import org.gephi.graph.api.types.IntervalSet;
import org.gephi.graph.api.types.TimeMap;
import org.gephi.graph.api.types.TimeSet;
import org.gephi.graph.api.types.TimestampDoubleMap;
import org.gephi.graph.api.types.TimestampSet;
import org.gephi.io.importer.api.ColumnDraft;
import org.gephi.io.importer.api.ContainerUnloader;
import org.gephi.io.importer.api.EdgeDraft;
import org.gephi.io.importer.api.EdgeMergeStrategy;
import org.gephi.io.importer.api.ElementDraft;
import org.gephi.io.importer.api.Issue;
import org.gephi.io.importer.api.NodeDraft;
import org.gephi.io.importer.api.Report;
import org.gephi.io.processor.spi.Processor;
import org.gephi.project.api.Workspace;
import org.gephi.utils.Attributes;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.NbBundle;

public abstract class AbstractProcessor
implements Processor,
LongTask {
    private final Set<Column> columnsTypeMismatchAlreadyWarned = new HashSet<Column>();
    private final Object2IntOpenHashMap<Edge> edgeCountForAverage = new Object2IntOpenHashMap();
    protected ProgressTicket progressTicket;
    protected Workspace workspace;
    protected ContainerUnloader[] containers;
    protected GraphModel graphModel;
    protected Report report = new Report();

    protected void clean() {
        this.workspace = null;
        this.graphModel = null;
        this.containers = null;
        this.progressTicket = null;
        this.columnsTypeMismatchAlreadyWarned.clear();
        this.edgeCountForAverage.clear();
    }

    protected int calculateWorkUnits() {
        return Arrays.stream(this.containers).map(c -> c.getNodeCount() + c.getEdgeCount()).reduce(0, Integer::sum);
    }

    protected void flushColumns(ContainerUnloader container) {
        this.addColumnsToTable(container, this.graphModel.getNodeTable(), container.getNodeColumns());
        this.addColumnsToTable(container, this.graphModel.getEdgeTable(), container.getEdgeColumns());
    }

    private void addColumnsToTable(ContainerUnloader container, Table table, Iterable<ColumnDraft> columns) {
        TimeRepresentation timeRepresentation = container.getTimeRepresentation();
        for (ColumnDraft col : columns) {
            if (table.hasColumn(col.getId())) continue;
            Class typeClass = col.getResolvedTypeClass(container);
            if (Attributes.isTypeAvailable((Class)typeClass, (TimeRepresentation)timeRepresentation)) {
                Object defaultValue = col.getResolvedDefaultValue(container);
                if (defaultValue != null && !typeClass.isAssignableFrom(defaultValue.getClass())) {
                    String error = NbBundle.getMessage(AbstractProcessor.class, (String)"AbstractProcessor.error.columnDefaultValueTypeMismatch", (Object)col.getId(), (Object)defaultValue.toString(), (Object)defaultValue.getClass().getSimpleName(), (Object)typeClass.getSimpleName(), (Object[])new Object[0]);
                    this.report.logIssue(new Issue(error, Issue.Level.SEVERE));
                    defaultValue = null;
                }
                table.addColumn(col.getId(), col.getTitle(), typeClass, Origin.DATA, defaultValue, true);
                continue;
            }
            String error = NbBundle.getMessage(AbstractProcessor.class, (String)"AbstractProcessor.error.unavailableColumnType", (Object)typeClass.getSimpleName(), (Object)timeRepresentation.name(), (Object)col.getId());
            this.report.logIssue(new Issue(error, Issue.Level.SEVERE));
        }
    }

    protected void flushLabel(ElementDraft elementDraft, Element element) {
        if (!(elementDraft.getLabel() == null || element.getLabel() != null && elementDraft.getLabel().equals(elementDraft.getId()))) {
            element.setLabel(elementDraft.getLabel());
        }
    }

    protected void flushToNode(ContainerUnloader container, NodeDraft nodeDraft, Node node) {
        if (nodeDraft.getColor() != null) {
            node.setColor(nodeDraft.getColor());
        }
        this.flushLabel((ElementDraft)nodeDraft, (Element)node);
        if (node.getTextProperties() != null) {
            node.getTextProperties().setVisible(nodeDraft.isLabelVisible());
        }
        if (nodeDraft.getLabelColor() != null && node.getTextProperties() != null) {
            Color labelColor = nodeDraft.getLabelColor();
            node.getTextProperties().setColor(labelColor);
        } else {
            node.getTextProperties().setColor(new Color(0, 0, 0, 0));
        }
        if (nodeDraft.getLabelSize() != -1.0f && node.getTextProperties() != null) {
            node.getTextProperties().setSize(nodeDraft.getLabelSize());
        }
        if ((nodeDraft.getX() != 0.0f || nodeDraft.getY() != 0.0f || nodeDraft.getZ() != 0.0f) && node.x() == 0.0f && node.y() == 0.0f && node.z() == 0.0f) {
            node.setX(nodeDraft.getX());
            node.setY(nodeDraft.getY());
            node.setZ(nodeDraft.getZ());
        }
        if (nodeDraft.getSize() != 0.0f && !Float.isNaN(nodeDraft.getSize())) {
            node.setSize(nodeDraft.getSize());
        } else if (node.size() == 0.0f) {
            node.setSize(10.0f);
        }
        if (nodeDraft.getTimeSet() != null) {
            this.flushTimeSet(nodeDraft.getTimeSet(), (Element)node);
        }
        if (nodeDraft.getGraphTimestamp() != null) {
            node.addTimestamp(nodeDraft.getGraphTimestamp().doubleValue());
        } else if (nodeDraft.getGraphInterval() != null) {
            node.addInterval(nodeDraft.getGraphInterval());
        }
        this.flushToElementAttributes(container, (ElementDraft)nodeDraft, (Element)node);
    }

    protected void flushToElementAttributes(ContainerUnloader container, ElementDraft elementDraft, Element element) {
        for (ColumnDraft columnDraft : elementDraft.getColumns()) {
            if (elementDraft instanceof EdgeDraft && columnDraft.getId().equalsIgnoreCase("weight")) continue;
            Object val = elementDraft.getValue(columnDraft.getId());
            Column column = element.getTable().getColumn(columnDraft.getId());
            if (column == null || column.isReadOnly()) continue;
            Class columnDraftTypeClass = columnDraft.getResolvedTypeClass(container);
            if (!column.getTypeClass().equals(columnDraftTypeClass)) {
                if (this.columnsTypeMismatchAlreadyWarned.contains(column)) continue;
                this.columnsTypeMismatchAlreadyWarned.add(column);
                String error = NbBundle.getMessage(AbstractProcessor.class, (String)"AbstractProcessor.error.columnTypeMismatch", (Object)column.getId(), (Object)column.getTypeClass().getSimpleName(), (Object)columnDraftTypeClass.getSimpleName());
                this.report.logIssue(new Issue(error, Issue.Level.SEVERE));
                continue;
            }
            if (val == null) continue;
            Object processedNewValue = val;
            Object existingValue = element.getAttribute(columnDraft.getId());
            if (columnDraft.isDynamic() && existingValue != null) {
                if (TimeMap.class.isAssignableFrom(columnDraftTypeClass)) {
                    TimeMap existingMap = (TimeMap)existingValue;
                    if (!existingMap.isEmpty()) {
                        TimeMap valMap = (TimeMap)val;
                        TimeMap newMap = existingMap;
                        Object[] keys = valMap.toKeysArray();
                        Object[] vals = valMap.toValuesArray();
                        for (int i = 0; i < keys.length; ++i) {
                            try {
                                newMap.put(keys[i], vals[i]);
                                continue;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                        }
                        processedNewValue = newMap;
                    }
                } else if (TimeSet.class.isAssignableFrom(columnDraftTypeClass)) {
                    TimeSet existingTimeSet = (TimeSet)existingValue;
                    processedNewValue = this.mergeTimeSets(existingTimeSet, (TimeSet)val);
                }
            }
            element.setAttribute(columnDraft.getId(), processedNewValue);
        }
    }

    protected void flushToEdge(ContainerUnloader container, EdgeDraft edgeDraft, Edge edge, boolean newEdge) {
        this.flushEdgeWeight(container, edgeDraft, edge, newEdge);
        EdgeMergeStrategy edgesMergeStrategy = this.containers[0].getEdgesMergeStrategy();
        if (newEdge || edgesMergeStrategy != EdgeMergeStrategy.FIRST) {
            if (edgeDraft.getColor() != null) {
                edge.setColor(edgeDraft.getColor());
            } else {
                edge.setR(0.0f);
                edge.setG(0.0f);
                edge.setB(0.0f);
                edge.setAlpha(0.0f);
            }
            this.flushLabel((ElementDraft)edgeDraft, (Element)edge);
            if (edge.getTextProperties() != null) {
                edge.getTextProperties().setVisible(edgeDraft.isLabelVisible());
            }
            if (edgeDraft.getLabelSize() != -1.0f && edge.getTextProperties() != null) {
                edge.getTextProperties().setSize(edgeDraft.getLabelSize());
            }
            if (edgeDraft.getLabelColor() != null && edge.getTextProperties() != null) {
                Color labelColor = edgeDraft.getLabelColor();
                edge.getTextProperties().setColor(labelColor);
            } else {
                edge.getTextProperties().setColor(new Color(0, 0, 0, 0));
            }
            this.flushToElementAttributes(container, (ElementDraft)edgeDraft, (Element)edge);
        }
        if (edgeDraft.getTimeSet() != null) {
            this.flushTimeSet(edgeDraft.getTimeSet(), (Element)edge);
        }
        if (edgeDraft.getGraphTimestamp() != null) {
            edge.addTimestamp(edgeDraft.getGraphTimestamp().doubleValue());
        } else if (edgeDraft.getGraphInterval() != null) {
            edge.addInterval(edgeDraft.getGraphInterval());
        }
    }

    protected void flushEdgeWeight(ContainerUnloader container, EdgeDraft edgeDraft, Edge edge, boolean newEdge) {
        boolean weightColumnDraftIsDynamic;
        Column weightColumn = this.graphModel.getEdgeTable().getColumn("weight");
        ColumnDraft weightColumnDraft = container.getEdgeColumn("weight");
        boolean bl = weightColumnDraftIsDynamic = weightColumnDraft != null && weightColumnDraft.isDynamic();
        if (weightColumn.isDynamic() != weightColumnDraftIsDynamic) {
            Class weightColumnDraftTypeClass;
            Class clazz = weightColumnDraftTypeClass = weightColumnDraft != null ? weightColumnDraft.getResolvedTypeClass(container) : Double.class;
            if (!this.columnsTypeMismatchAlreadyWarned.contains(weightColumn)) {
                this.columnsTypeMismatchAlreadyWarned.add(weightColumn);
                String error = NbBundle.getMessage(AbstractProcessor.class, (String)"AbstractProcessor.error.columnTypeMismatch", (Object)weightColumn.getId(), (Object)weightColumn.getTypeClass().getSimpleName(), (Object)weightColumnDraftTypeClass.getSimpleName());
                this.report.logIssue(new Issue(error, Issue.Level.SEVERE));
            }
            return;
        }
        if (weightColumn.isDynamic()) {
            TimeMap valMap;
            Object val = edgeDraft.getValue("weight");
            if (val instanceof TimeMap && Number.class.isAssignableFrom((valMap = (TimeMap)val).getTypeClass())) {
                int i;
                Object newMap = val instanceof IntervalMap ? new IntervalDoubleMap() : new TimestampDoubleMap();
                TimeMap existingMap = (TimeMap)edge.getAttribute("weight");
                if (existingMap != null) {
                    Object[] keys2 = existingMap.toKeysArray();
                    Object[] vals2 = existingMap.toValuesArray();
                    for (i = 0; i < keys2.length; ++i) {
                        newMap.put(keys2[i], (Object)((Number)vals2[i]).doubleValue());
                    }
                }
                Object[] keys1 = valMap.toKeysArray();
                Object[] vals1 = valMap.toValuesArray();
                for (i = 0; i < keys1.length; ++i) {
                    try {
                        newMap.put(keys1[i], (Object)((Number)vals1[i]).doubleValue());
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                edge.setAttribute("weight", newMap);
            }
        } else if (!newEdge) {
            double result = edge.getWeight();
            this.edgeCountForAverage.addTo((Object)edge, 1);
            int edgeCount = this.edgeCountForAverage.getInt((Object)edge);
            switch (this.containers[0].getEdgesMergeStrategy()) {
                case AVG: {
                    result = (edge.getWeight() * (double)edgeCount + edgeDraft.getWeight()) / (double)(edgeCount + 1);
                    break;
                }
                case MAX: {
                    result = Math.max(edgeDraft.getWeight(), edge.getWeight());
                    break;
                }
                case MIN: {
                    result = Math.min(edgeDraft.getWeight(), edge.getWeight());
                    break;
                }
                case SUM: {
                    result = edgeDraft.getWeight() + edge.getWeight();
                    break;
                }
                case FIRST: {
                    result = edge.getWeight();
                    break;
                }
                case LAST: {
                    result = edgeDraft.getWeight();
                    break;
                }
            }
            edge.setWeight(result);
        }
    }

    protected void flushTimeSet(TimeSet timeSet, Element element) {
        TimeSet existingTimeSet = (TimeSet)element.getAttribute("timeset");
        element.setAttribute("timeset", (Object)this.mergeTimeSets(existingTimeSet, timeSet));
    }

    protected TimeSet mergeTimeSets(TimeSet set1, TimeSet set2) {
        if (set1 instanceof IntervalSet) {
            return this.mergeIntervalSets((IntervalSet)set1, (IntervalSet)set2);
        }
        if (set1 instanceof TimestampSet) {
            return this.mergeTimestampSets((TimestampSet)set1, (TimestampSet)set2);
        }
        return set2;
    }

    protected IntervalSet mergeIntervalSets(IntervalSet set1, IntervalSet set2) {
        IntervalSet merged = new IntervalSet();
        for (Interval i : set1.toArray()) {
            merged.add(i);
        }
        boolean overlappingIntervals = false;
        for (Interval i : set2.toArray()) {
            try {
                merged.add(i);
            }
            catch (IllegalArgumentException e) {
                overlappingIntervals = true;
            }
        }
        if (overlappingIntervals) {
            String warning = NbBundle.getMessage(AbstractProcessor.class, (String)"AbstractProcessor.warning.overlappingIntervals", (Object)set1.toString(this.graphModel.getTimeFormat(), this.graphModel.getTimeZone()), (Object)set2.toString(this.graphModel.getTimeFormat(), this.graphModel.getTimeZone()), (Object)merged.toString(this.graphModel.getTimeFormat(), this.graphModel.getTimeZone()));
            this.report.logIssue(new Issue(warning, Issue.Level.WARNING));
        }
        return merged;
    }

    protected TimestampSet mergeTimestampSets(TimestampSet set1, TimestampSet set2) {
        TimestampSet merged = new TimestampSet();
        for (Double t : set1.toArray()) {
            merged.add(t);
        }
        for (Double t : set2.toArray()) {
            merged.add(t);
        }
        return merged;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public void setContainers(ContainerUnloader[] containers) {
        this.containers = containers;
        this.report = new Report();
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progressTicket = progressTicket;
    }

    public Report getReport() {
        return this.report;
    }

    public boolean cancel() {
        return false;
    }
}

